/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.ant;

import org.apache.woden.ant.CmBaseWriter;
import org.apache.woden.ant.NamespaceWriter;
import org.apache.woden.ant.XMLWriter;
import org.apache.woden.wsdl20.extensions.rpc.Argument;
import org.apache.woden.wsdl20.extensions.rpc.Direction;
import org.apache.woden.wsdl20.extensions.rpc.RPCInterfaceOperationExtensions;

public class CmRpcWriter
extends NamespaceWriter {
    public static final String NS = "http://www.w3.org/2002/ws/desc/wsdl/component-rpc";
    public static final String PREFIX = "cmrpc";
    public static final String RPC_INTERFACE_OPERATION_EXTENSION = "cmrpc:rpcInterfaceOperationExtension";
    public static final String RPC_SIGNATURE = "cmrpc:rpcSignature";

    public CmRpcWriter(XMLWriter out) {
        super(out, NS, PREFIX);
    }

    public void rpcInterfaceOperationExtension(RPCInterfaceOperationExtensions rpcExtensions) {
        if (rpcExtensions == null) {
            return;
        }
        this.out.beginElement(RPC_INTERFACE_OPERATION_EXTENSION);
        this.write(RPC_SIGNATURE, rpcExtensions.getRPCSignature());
        this.out.endElement();
    }

    private void write(String tag, Argument[] rpcSignature) {
        this.out.beginElement(tag);
        for (int i = 0; i < rpcSignature.length; ++i) {
            this.write("cmrpc:argument", rpcSignature[i]);
        }
        this.out.endElement();
    }

    private void write(String tag, Argument argument) {
        CmBaseWriter cmbase = (CmBaseWriter)this.out.lookup("http://www.w3.org/2002/ws/desc/wsdl/component-base");
        this.out.beginElement(tag);
        cmbase.write("cmrpc:name", argument.getName());
        this.write("cmrpc:direction", argument.getDirection());
        this.out.endElement();
    }

    private void write(String tag, Direction direction) {
        this.out.element(tag, direction.toString());
    }
}

