/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.ant;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.woden.ErrorHandler;
import org.apache.woden.WSDLException;
import org.apache.woden.WSDLFactory;
import org.apache.woden.WSDLReader;
import org.apache.woden.ant.CmBaseWriter;
import org.apache.woden.ant.CmExtensionsWriter;
import org.apache.woden.ant.CmHttpWriter;
import org.apache.woden.ant.CmRpcWriter;
import org.apache.woden.ant.CmSoapWriter;
import org.apache.woden.ant.CmWriter;
import org.apache.woden.ant.Report;
import org.apache.woden.ant.XMLWriter;
import org.apache.woden.wsdl20.Description;

public class WsdlCm
extends XMLWriter {
    private CmWriter cm;
    private static final Log logger = LogFactory.getLog(WsdlCm.class);

    public WsdlCm(PrintWriter out) {
        super(out);
        new CmBaseWriter(this);
        new CmExtensionsWriter(this);
        new CmRpcWriter(this);
        new CmHttpWriter(this);
        new CmSoapWriter(this);
        this.cm = new CmWriter(this);
    }

    public void write(Description descComp) {
        this.cm.write(descComp);
    }

    public static void main(String[] args) {
        String wsdlLoc = "file:///D:/workspaces/WSD2/woden/ant-test/test.wsdl";
        String wsdlCmLoc = "D:\\workspaces\\WSD2\\woden\\ant-test\\test.xml";
        String reportLoc = "D:\\workspaces\\WSD2\\woden\\ant-test\\report.xml";
        if (args.length > 0) {
            wsdlLoc = args[0];
        }
        if (args.length > 1) {
            wsdlCmLoc = args[1];
        }
        if (args.length > 2) {
            reportLoc = args[2];
        }
        logger.info((Object)("Starting: " + wsdlLoc));
        Report reportWriter = Report.openReport(new File(reportLoc));
        reportWriter.beginWsdl(wsdlLoc);
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader reader = factory.newWSDLReader();
            reader.setFeature("http://ws.apache.org/woden/features/validation", true);
            reader.getErrorReporter().setErrorHandler((ErrorHandler)reportWriter);
            Description descComp = reader.readWSDL(wsdlLoc);
            File xml = new File(wsdlCmLoc);
            FileOutputStream fos = new FileOutputStream(xml);
            PrintWriter out = new PrintWriter(fos);
            WsdlCm wsdlCm = new WsdlCm(out);
            wsdlCm.write(descComp);
            out.flush();
        }
        catch (WSDLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        reportWriter.endWsdl();
        reportWriter.closeReport();
        logger.info((Object)"Finished.");
    }
}

