/*
 * ServerProcess.java
 *
 * Brazil project web application toolkit,
 * export version: 2.1 
 * Copyright (c) 1999-2004 Sun Microsystems, Inc.
 *
 * Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License Version 
 * 1.0 (the "License"). You may not use this file except in compliance with 
 * the License. A copy of the License is included as the file "license.terms",
 * and also available at http://www.sun.com/
 * 
 * The Original Code is from:
 *    Brazil project web application toolkit release 2.1.
 * The Initial Developer of the Original Code is: suhler.
 * Portions created by suhler are Copyright (C) Sun Microsystems, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s): suhler.
 *
 * Version:  2.2
 * Created by suhler on 99/11/15
 * Last modified by suhler on 04/11/30 15:19:43
 */

package com.sun.server;

/**
 * This is a wrapper around the native code used by the Java Web Server
 * to set the effective user and group id's on Solaris.
 * It expects the "server.so" file used by the
 * <a href=http://www.sun.com/software/jwebserver>Java Webserver 2.0</a>.
 * Make sure you rename the file <code>server.so</code>
 * in the distribution to lib<code>com_sun_server_ServerProcess.so</code>, and
 * put it where it will be found by <b>System.loadLibrary</b>.
 *
 * @author		Colin Stevens
 * @version		2.2
 */

public class ServerProcess {
    static {
        System.loadLibrary("com_sun_server_ServerProcess");
    }

    public native static boolean setUser(String userName);
    public native static boolean setGroup(String groupName);
}
