/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XMLSchemaException;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.XSModelGroupImpl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.util.SimpleLocator;

class XS10Constraints
extends XSConstraints {
    private static final Comparator ELEMENT_PARTICLE_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            XSParticleDecl xSParticleDecl = (XSParticleDecl)object;
            XSParticleDecl xSParticleDecl2 = (XSParticleDecl)object2;
            XSElementDecl xSElementDecl = (XSElementDecl)xSParticleDecl.fValue;
            XSElementDecl xSElementDecl2 = (XSElementDecl)xSParticleDecl2.fValue;
            String string = xSElementDecl.getNamespace();
            String string2 = xSElementDecl2.getNamespace();
            String string3 = xSElementDecl.getName();
            String string4 = xSElementDecl2.getName();
            boolean bl = string == string2;
            int n = 0;
            if (!bl) {
                n = string != null ? (string2 != null ? string.compareTo(string2) : 1) : -1;
            }
            return n != 0 ? n : string3.compareTo(string4);
        }
    };

    public XS10Constraints(short s) {
        super(SchemaGrammar.getXSAnyType(s), s);
    }

    @Override
    public boolean overlapUPA(XSElementDecl xSElementDecl, XSWildcardDecl xSWildcardDecl, SubstitutionGroupHandler substitutionGroupHandler) {
        if (xSWildcardDecl.allowNamespace(xSElementDecl.fTargetNamespace)) {
            return true;
        }
        XSElementDecl[] xSElementDeclArray = substitutionGroupHandler.getSubstitutionGroup(xSElementDecl, this.fSchemaVersion);
        for (int i = xSElementDeclArray.length - 1; i >= 0; --i) {
            if (!xSWildcardDecl.allowNamespace(xSElementDeclArray[i].fTargetNamespace)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSubsetOf(XSWildcardDecl xSWildcardDecl, XSWildcardDecl xSWildcardDecl2) {
        if (xSWildcardDecl2 == null) {
            return false;
        }
        if (xSWildcardDecl2.fType == 1) {
            return true;
        }
        if (xSWildcardDecl.fType == 2 && xSWildcardDecl2.fType == 2 && xSWildcardDecl.fNamespaceList[0] == xSWildcardDecl2.fNamespaceList[0]) {
            return true;
        }
        if (xSWildcardDecl.fType == 3) {
            if (xSWildcardDecl2.fType == 3 && this.subset2sets(xSWildcardDecl.fNamespaceList, xSWildcardDecl2.fNamespaceList)) {
                return true;
            }
            if (xSWildcardDecl2.fType == 2 && !this.elementInSet(xSWildcardDecl2.fNamespaceList[0], xSWildcardDecl.fNamespaceList) && !this.elementInSet(XSWildcardDecl.ABSENT, xSWildcardDecl.fNamespaceList)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public XSWildcardDecl performUnionWith(XSWildcardDecl xSWildcardDecl, XSWildcardDecl xSWildcardDecl2, short s) {
        if (xSWildcardDecl2 == null) {
            return null;
        }
        XSWildcardDecl xSWildcardDecl3 = new XSWildcardDecl();
        xSWildcardDecl3.fProcessContents = s;
        if (this.areSame(xSWildcardDecl, xSWildcardDecl2)) {
            xSWildcardDecl3.fType = xSWildcardDecl.fType;
            xSWildcardDecl3.fNamespaceList = xSWildcardDecl.fNamespaceList;
        } else if (xSWildcardDecl.fType == 1 || xSWildcardDecl2.fType == 1) {
            xSWildcardDecl3.fType = 1;
        } else if (xSWildcardDecl.fType == 3 && xSWildcardDecl2.fType == 3) {
            xSWildcardDecl3.fType = (short)3;
            xSWildcardDecl3.fNamespaceList = this.union2sets(xSWildcardDecl.fNamespaceList, xSWildcardDecl2.fNamespaceList);
        } else if (xSWildcardDecl.fType == 2 && xSWildcardDecl2.fType == 2) {
            xSWildcardDecl3.fType = (short)2;
            xSWildcardDecl3.fNamespaceList = new String[2];
            xSWildcardDecl3.fNamespaceList[0] = XSWildcardDecl.ABSENT;
            xSWildcardDecl3.fNamespaceList[1] = XSWildcardDecl.ABSENT;
        } else if (xSWildcardDecl.fType == 2 && xSWildcardDecl2.fType == 3 || xSWildcardDecl.fType == 3 && xSWildcardDecl2.fType == 2) {
            String[] stringArray = null;
            String[] stringArray2 = null;
            if (xSWildcardDecl.fType == 2) {
                stringArray = xSWildcardDecl.fNamespaceList;
                stringArray2 = xSWildcardDecl2.fNamespaceList;
            } else {
                stringArray = xSWildcardDecl2.fNamespaceList;
                stringArray2 = xSWildcardDecl.fNamespaceList;
            }
            boolean bl = this.elementInSet(XSWildcardDecl.ABSENT, stringArray2);
            if (stringArray[0] != XSWildcardDecl.ABSENT) {
                boolean bl2 = this.elementInSet(stringArray[0], stringArray2);
                if (bl2 && bl) {
                    xSWildcardDecl3.fType = 1;
                } else if (bl2 && !bl) {
                    xSWildcardDecl3.fType = (short)2;
                    xSWildcardDecl3.fNamespaceList = new String[2];
                    xSWildcardDecl3.fNamespaceList[0] = XSWildcardDecl.ABSENT;
                    xSWildcardDecl3.fNamespaceList[1] = XSWildcardDecl.ABSENT;
                } else {
                    if (!bl2 && bl) {
                        return null;
                    }
                    xSWildcardDecl3.fType = (short)2;
                    xSWildcardDecl3.fNamespaceList = stringArray;
                }
            } else if (bl) {
                xSWildcardDecl3.fType = 1;
            } else {
                xSWildcardDecl3.fType = (short)2;
                xSWildcardDecl3.fNamespaceList = stringArray;
            }
        }
        return xSWildcardDecl3;
    }

    @Override
    public XSWildcardDecl performIntersectionWith(XSWildcardDecl xSWildcardDecl, XSWildcardDecl xSWildcardDecl2, short s) {
        if (xSWildcardDecl2 == null) {
            return null;
        }
        XSWildcardDecl xSWildcardDecl3 = new XSWildcardDecl();
        xSWildcardDecl3.fProcessContents = s;
        if (this.areSame(xSWildcardDecl, xSWildcardDecl2)) {
            xSWildcardDecl3.fType = xSWildcardDecl.fType;
            xSWildcardDecl3.fNamespaceList = xSWildcardDecl.fNamespaceList;
        } else if (xSWildcardDecl.fType == 1 || xSWildcardDecl2.fType == 1) {
            XSWildcardDecl xSWildcardDecl4 = xSWildcardDecl;
            if (xSWildcardDecl.fType == 1) {
                xSWildcardDecl4 = xSWildcardDecl2;
            }
            xSWildcardDecl3.fType = xSWildcardDecl4.fType;
            xSWildcardDecl3.fNamespaceList = xSWildcardDecl4.fNamespaceList;
        } else if (xSWildcardDecl.fType == 2 && xSWildcardDecl2.fType == 3 || xSWildcardDecl.fType == 3 && xSWildcardDecl2.fType == 2) {
            String[] stringArray = null;
            String[] stringArray2 = null;
            if (xSWildcardDecl.fType == 2) {
                stringArray2 = xSWildcardDecl.fNamespaceList;
                stringArray = xSWildcardDecl2.fNamespaceList;
            } else {
                stringArray2 = xSWildcardDecl2.fNamespaceList;
                stringArray = xSWildcardDecl.fNamespaceList;
            }
            int n = stringArray.length;
            String[] stringArray3 = new String[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (stringArray[i] == stringArray2[0] || stringArray[i] == XSWildcardDecl.ABSENT) continue;
                stringArray3[n2++] = stringArray[i];
            }
            xSWildcardDecl3.fType = (short)3;
            xSWildcardDecl3.fNamespaceList = new String[n2];
            System.arraycopy(stringArray3, 0, xSWildcardDecl3.fNamespaceList, 0, n2);
        } else if (xSWildcardDecl.fType == 3 && xSWildcardDecl2.fType == 3) {
            xSWildcardDecl3.fType = (short)3;
            xSWildcardDecl3.fNamespaceList = this.intersect2sets(xSWildcardDecl.fNamespaceList, xSWildcardDecl2.fNamespaceList);
        } else if (xSWildcardDecl.fType == 2 && xSWildcardDecl2.fType == 2) {
            if (xSWildcardDecl.fNamespaceList[0] != XSWildcardDecl.ABSENT && xSWildcardDecl2.fNamespaceList[0] != XSWildcardDecl.ABSENT) {
                return null;
            }
            XSWildcardDecl xSWildcardDecl5 = xSWildcardDecl;
            if (xSWildcardDecl.fNamespaceList[0] == XSWildcardDecl.ABSENT) {
                xSWildcardDecl5 = xSWildcardDecl2;
            }
            xSWildcardDecl3.fType = xSWildcardDecl5.fType;
            xSWildcardDecl3.fNamespaceList = xSWildcardDecl5.fNamespaceList;
        }
        return xSWildcardDecl3;
    }

    @Override
    protected void groupSubsumption(XSParticleDecl xSParticleDecl, XSParticleDecl xSParticleDecl2, XSGrammarBucket xSGrammarBucket, SubstitutionGroupHandler substitutionGroupHandler, CMBuilder cMBuilder, XMLErrorReporter xMLErrorReporter, String string, SimpleLocator simpleLocator) {
        try {
            this.particleValidRestriction(xSParticleDecl, substitutionGroupHandler, xSParticleDecl2, substitutionGroupHandler);
        }
        catch (XMLSchemaException xMLSchemaException) {
            String string2 = xMLSchemaException.getKey();
            this.reportSchemaError(xMLErrorReporter, simpleLocator, string2, xMLSchemaException.getArgs());
            this.reportSchemaError(xMLErrorReporter, simpleLocator, "src-redefine.6.2.2", new Object[]{string, string2});
        }
    }

    @Override
    protected void typeSubsumption(XSComplexTypeDecl xSComplexTypeDecl, XSComplexTypeDecl xSComplexTypeDecl2, XSGrammarBucket xSGrammarBucket, SubstitutionGroupHandler substitutionGroupHandler, CMBuilder cMBuilder, XMLErrorReporter xMLErrorReporter, SimpleLocator simpleLocator) {
        try {
            this.particleValidRestriction(xSComplexTypeDecl.fParticle, substitutionGroupHandler, xSComplexTypeDecl2.fParticle, substitutionGroupHandler);
        }
        catch (XMLSchemaException xMLSchemaException) {
            this.reportSchemaError(xMLErrorReporter, simpleLocator, xMLSchemaException.getKey(), xMLSchemaException.getArgs());
            this.reportSchemaError(xMLErrorReporter, simpleLocator, "derivation-ok-restriction.5.4.2", new Object[]{xSComplexTypeDecl.fName});
        }
    }

    private boolean particleValidRestriction(XSParticleDecl xSParticleDecl, SubstitutionGroupHandler substitutionGroupHandler, XSParticleDecl xSParticleDecl2, SubstitutionGroupHandler substitutionGroupHandler2) throws XMLSchemaException {
        return this.particleValidRestriction(xSParticleDecl, substitutionGroupHandler, xSParticleDecl2, substitutionGroupHandler2, true);
    }

    private boolean particleValidRestriction(XSParticleDecl xSParticleDecl, SubstitutionGroupHandler substitutionGroupHandler, XSParticleDecl xSElementDeclArray, SubstitutionGroupHandler substitutionGroupHandler2, boolean bl) throws XMLSchemaException {
        int n;
        int n2;
        XSElementDecl[] xSElementDeclArray2;
        Vector<XSParticleDecl> vector = null;
        Vector vector2 = null;
        int n3 = -2;
        int n4 = -2;
        boolean bl2 = false;
        if (xSParticleDecl.isEmpty() && !xSElementDeclArray.emptiable()) {
            throw new XMLSchemaException("cos-particle-restrict.a", null);
        }
        if (!xSParticleDecl.isEmpty() && xSElementDeclArray.isEmpty()) {
            throw new XMLSchemaException("cos-particle-restrict.b", null);
        }
        int n5 = xSParticleDecl.fType;
        if (n5 == 3) {
            n5 = ((XSModelGroupImpl)xSParticleDecl.fValue).fCompositor;
            XSParticleDecl xSParticleDecl2 = this.getNonUnaryGroup(xSParticleDecl);
            if (xSParticleDecl2 != xSParticleDecl) {
                xSParticleDecl = xSParticleDecl2;
                n5 = xSParticleDecl.fType;
                if (n5 == 3) {
                    n5 = ((XSModelGroupImpl)xSParticleDecl.fValue).fCompositor;
                }
            }
            vector = XS10Constraints.removePointlessChildren(xSParticleDecl);
        }
        int n6 = xSParticleDecl.fMinOccurs;
        int n7 = xSParticleDecl.fMaxOccurs;
        if (substitutionGroupHandler != null && n5 == 1) {
            XSElementDecl xSElementDecl = (XSElementDecl)xSParticleDecl.fValue;
            if (xSElementDecl.fScope == 1 && (xSElementDeclArray2 = substitutionGroupHandler.getSubstitutionGroup(xSElementDecl, this.fSchemaVersion)).length > 0) {
                n5 = 101;
                n3 = n6;
                n4 = n7;
                vector = new Vector(xSElementDeclArray2.length + 1);
                for (n2 = 0; n2 < xSElementDeclArray2.length; ++n2) {
                    this.addElementToParticleVector(vector, xSElementDeclArray2[n2]);
                }
                this.addElementToParticleVector(vector, xSElementDecl);
                Collections.sort(vector, ELEMENT_PARTICLE_COMPARATOR);
                substitutionGroupHandler = null;
            }
        }
        if ((n = xSElementDeclArray.fType) == 3) {
            n = ((XSModelGroupImpl)xSElementDeclArray.fValue).fCompositor;
            xSElementDeclArray2 = this.getNonUnaryGroup((XSParticleDecl)xSElementDeclArray);
            if (xSElementDeclArray2 != xSElementDeclArray) {
                xSElementDeclArray = xSElementDeclArray2;
                n = xSElementDeclArray.fType;
                if (n == 3) {
                    n = ((XSModelGroupImpl)xSElementDeclArray.fValue).fCompositor;
                }
            }
            vector2 = XS10Constraints.removePointlessChildren((XSParticleDecl)xSElementDeclArray);
        }
        int n8 = xSElementDeclArray.fMinOccurs;
        n2 = xSElementDeclArray.fMaxOccurs;
        if (substitutionGroupHandler2 != null && n == 1) {
            XSElementDecl[] xSElementDeclArray3;
            XSElementDecl xSElementDecl = (XSElementDecl)xSElementDeclArray.fValue;
            if (xSElementDecl.fScope == 1 && (xSElementDeclArray3 = substitutionGroupHandler2.getSubstitutionGroup(xSElementDecl, this.fSchemaVersion)).length > 0) {
                n = 101;
                vector2 = new Vector(xSElementDeclArray3.length + 1);
                for (int i = 0; i < xSElementDeclArray3.length; ++i) {
                    this.addElementToParticleVector(vector2, xSElementDeclArray3[i]);
                }
                this.addElementToParticleVector(vector2, xSElementDecl);
                Collections.sort(vector2, ELEMENT_PARTICLE_COMPARATOR);
                substitutionGroupHandler2 = null;
                bl2 = true;
            }
        }
        switch (n5) {
            case 1: {
                switch (n) {
                    case 1: {
                        this.checkNameAndTypeOK((XSElementDecl)xSParticleDecl.fValue, n6, n7, (XSElementDecl)xSElementDeclArray.fValue, n8, n2);
                        return bl2;
                    }
                    case 2: {
                        this.checkNSCompat((XSElementDecl)xSParticleDecl.fValue, n6, n7, (XSWildcardDecl)xSElementDeclArray.fValue, n8, n2, bl);
                        return bl2;
                    }
                    case 101: {
                        vector = new Vector<XSParticleDecl>();
                        vector.addElement(xSParticleDecl);
                        this.checkRecurseLax(vector, 1, 1, substitutionGroupHandler, vector2, n8, n2, substitutionGroupHandler2);
                        return bl2;
                    }
                    case 102: 
                    case 103: {
                        vector = new Vector();
                        vector.addElement(xSParticleDecl);
                        this.checkRecurse(vector, 1, 1, substitutionGroupHandler, vector2, n8, n2, substitutionGroupHandler2);
                        return bl2;
                    }
                }
                throw new XMLSchemaException("Internal-Error", new Object[]{"in particleValidRestriction"});
            }
            case 2: {
                switch (n) {
                    case 2: {
                        this.checkNSSubset((XSWildcardDecl)xSParticleDecl.fValue, n6, n7, (XSWildcardDecl)xSElementDeclArray.fValue, n8, n2);
                        return bl2;
                    }
                    case 1: 
                    case 101: 
                    case 102: 
                    case 103: {
                        throw new XMLSchemaException("cos-particle-restrict.2", new Object[]{"any:choice,sequence,all,elt"});
                    }
                }
                throw new XMLSchemaException("Internal-Error", new Object[]{"in particleValidRestriction"});
            }
            case 103: {
                switch (n) {
                    case 2: {
                        if (n3 == -2) {
                            n3 = xSParticleDecl.minEffectiveTotalRange();
                        }
                        if (n4 == -2) {
                            n4 = xSParticleDecl.maxEffectiveTotalRange();
                        }
                        this.checkNSRecurseCheckCardinality(vector, n3, n4, substitutionGroupHandler, (XSParticleDecl)xSElementDeclArray, n8, n2, bl);
                        return bl2;
                    }
                    case 103: {
                        this.checkRecurse(vector, n6, n7, substitutionGroupHandler, vector2, n8, n2, substitutionGroupHandler2);
                        return bl2;
                    }
                    case 1: 
                    case 101: 
                    case 102: {
                        throw new XMLSchemaException("cos-particle-restrict.2", new Object[]{"all:choice,sequence,elt"});
                    }
                }
                throw new XMLSchemaException("Internal-Error", new Object[]{"in particleValidRestriction"});
            }
            case 101: {
                switch (n) {
                    case 2: {
                        if (n3 == -2) {
                            n3 = xSParticleDecl.minEffectiveTotalRange();
                        }
                        if (n4 == -2) {
                            n4 = xSParticleDecl.maxEffectiveTotalRange();
                        }
                        this.checkNSRecurseCheckCardinality(vector, n3, n4, substitutionGroupHandler, (XSParticleDecl)xSElementDeclArray, n8, n2, bl);
                        return bl2;
                    }
                    case 101: {
                        this.checkRecurseLax(vector, n6, n7, substitutionGroupHandler, vector2, n8, n2, substitutionGroupHandler2);
                        return bl2;
                    }
                    case 1: 
                    case 102: 
                    case 103: {
                        throw new XMLSchemaException("cos-particle-restrict.2", new Object[]{"choice:all,sequence,elt"});
                    }
                }
                throw new XMLSchemaException("Internal-Error", new Object[]{"in particleValidRestriction"});
            }
            case 102: {
                switch (n) {
                    case 2: {
                        if (n3 == -2) {
                            n3 = xSParticleDecl.minEffectiveTotalRange();
                        }
                        if (n4 == -2) {
                            n4 = xSParticleDecl.maxEffectiveTotalRange();
                        }
                        this.checkNSRecurseCheckCardinality(vector, n3, n4, substitutionGroupHandler, (XSParticleDecl)xSElementDeclArray, n8, n2, bl);
                        return bl2;
                    }
                    case 103: {
                        this.checkRecurseUnordered(vector, n6, n7, substitutionGroupHandler, vector2, n8, n2, substitutionGroupHandler2);
                        return bl2;
                    }
                    case 102: {
                        this.checkRecurse(vector, n6, n7, substitutionGroupHandler, vector2, n8, n2, substitutionGroupHandler2);
                        return bl2;
                    }
                    case 101: {
                        int n9 = n6 * vector.size();
                        int n10 = n7 == -1 ? n7 : n7 * vector.size();
                        this.checkMapAndSum(vector, n9, n10, substitutionGroupHandler, vector2, n8, n2, substitutionGroupHandler2);
                        return bl2;
                    }
                    case 1: {
                        throw new XMLSchemaException("cos-particle-restrict.2", new Object[]{"seq:elt"});
                    }
                }
                throw new XMLSchemaException("Internal-Error", new Object[]{"in particleValidRestriction"});
            }
        }
        return bl2;
    }

    private void addElementToParticleVector(Vector vector, XSElementDecl xSElementDecl) {
        XSParticleDecl xSParticleDecl = new XSParticleDecl();
        xSParticleDecl.fValue = xSElementDecl;
        xSParticleDecl.fType = 1;
        vector.addElement(xSParticleDecl);
    }

    private XSParticleDecl getNonUnaryGroup(XSParticleDecl xSParticleDecl) {
        if (xSParticleDecl.fType == 1 || xSParticleDecl.fType == 2) {
            return xSParticleDecl;
        }
        if (xSParticleDecl.fMinOccurs == 1 && xSParticleDecl.fMaxOccurs == 1 && xSParticleDecl.fValue != null && ((XSModelGroupImpl)xSParticleDecl.fValue).fParticleCount == 1) {
            return this.getNonUnaryGroup(((XSModelGroupImpl)xSParticleDecl.fValue).fParticles[0]);
        }
        return xSParticleDecl;
    }

    private static Vector removePointlessChildren(XSParticleDecl xSParticleDecl) {
        if (xSParticleDecl.fType == 1 || xSParticleDecl.fType == 2) {
            return null;
        }
        Vector vector = new Vector();
        XSModelGroupImpl xSModelGroupImpl = (XSModelGroupImpl)xSParticleDecl.fValue;
        for (int i = 0; i < xSModelGroupImpl.fParticleCount; ++i) {
            XS10Constraints.gatherChildren(xSModelGroupImpl.fCompositor, xSModelGroupImpl.fParticles[i], vector);
        }
        return vector;
    }

    private static void gatherChildren(int n, XSParticleDecl xSParticleDecl, Vector vector) {
        int n2 = xSParticleDecl.fMinOccurs;
        int n3 = xSParticleDecl.fMaxOccurs;
        short s = xSParticleDecl.fType;
        if (s == 3) {
            s = ((XSModelGroupImpl)xSParticleDecl.fValue).fCompositor;
        }
        if (s == 1 || s == 2) {
            vector.addElement(xSParticleDecl);
            return;
        }
        if (n2 != 1 || n3 != 1) {
            vector.addElement(xSParticleDecl);
        } else if (n == s) {
            XSModelGroupImpl xSModelGroupImpl = (XSModelGroupImpl)xSParticleDecl.fValue;
            for (int i = 0; i < xSModelGroupImpl.fParticleCount; ++i) {
                XS10Constraints.gatherChildren(s, xSModelGroupImpl.fParticles[i], vector);
            }
        } else if (!xSParticleDecl.isEmpty()) {
            vector.addElement(xSParticleDecl);
        }
    }

    private void checkNameAndTypeOK(XSElementDecl xSElementDecl, int n, int n2, XSElementDecl xSElementDecl2, int n3, int n4) throws XMLSchemaException {
        short s;
        if (xSElementDecl.fName != xSElementDecl2.fName || xSElementDecl.fTargetNamespace != xSElementDecl2.fTargetNamespace) {
            throw new XMLSchemaException("rcase-NameAndTypeOK.1", new Object[]{xSElementDecl.fName, xSElementDecl.fTargetNamespace, xSElementDecl2.fName, xSElementDecl2.fTargetNamespace});
        }
        if (!xSElementDecl2.getNillable() && xSElementDecl.getNillable()) {
            throw new XMLSchemaException("rcase-NameAndTypeOK.2", new Object[]{xSElementDecl.fName});
        }
        if (!this.checkOccurrenceRange(n, n2, n3, n4)) {
            throw new XMLSchemaException("rcase-NameAndTypeOK.3", new Object[]{xSElementDecl.fName, Integer.toString(n), n2 == -1 ? "unbounded" : Integer.toString(n2), Integer.toString(n3), n4 == -1 ? "unbounded" : Integer.toString(n4)});
        }
        if (xSElementDecl2.getConstraintType() == 2) {
            if (xSElementDecl.getConstraintType() != 2) {
                throw new XMLSchemaException("rcase-NameAndTypeOK.4.a", new Object[]{xSElementDecl.fName, xSElementDecl2.fDefault.stringValue()});
            }
            s = 0;
            if (xSElementDecl.fType.getTypeCategory() == 16 || ((XSComplexTypeDecl)xSElementDecl.fType).fContentType == 1) {
                s = 1;
            }
            if (s == 0 && !xSElementDecl2.fDefault.normalizedValue.equals(xSElementDecl.fDefault.normalizedValue) || s != 0 && !xSElementDecl2.fDefault.actualValue.equals(xSElementDecl.fDefault.actualValue)) {
                throw new XMLSchemaException("rcase-NameAndTypeOK.4.b", new Object[]{xSElementDecl.fName, xSElementDecl.fDefault.stringValue(), xSElementDecl2.fDefault.stringValue()});
            }
        }
        this.checkIDConstraintRestriction(xSElementDecl, xSElementDecl2);
        s = xSElementDecl.fBlock;
        short s2 = xSElementDecl2.fBlock;
        if ((s & s2) != s2 || s == 0 && s2 != 0) {
            throw new XMLSchemaException("rcase-NameAndTypeOK.6", new Object[]{xSElementDecl.fName});
        }
        if (!this.checkTypeDerivationOk(xSElementDecl.fType, xSElementDecl2.fType, (short)25)) {
            throw new XMLSchemaException("rcase-NameAndTypeOK.7", new Object[]{xSElementDecl.fName, xSElementDecl.fType.getName(), xSElementDecl2.fType.getName()});
        }
    }

    private void checkIDConstraintRestriction(XSElementDecl xSElementDecl, XSElementDecl xSElementDecl2) throws XMLSchemaException {
    }

    private boolean checkOccurrenceRange(int n, int n2, int n3, int n4) {
        return n >= n3 && (n4 == -1 || n2 != -1 && n2 <= n4);
    }

    private void checkNSCompat(XSElementDecl xSElementDecl, int n, int n2, XSWildcardDecl xSWildcardDecl, int n3, int n4, boolean bl) throws XMLSchemaException {
        if (bl && !this.checkOccurrenceRange(n, n2, n3, n4)) {
            throw new XMLSchemaException("rcase-NSCompat.2", new Object[]{xSElementDecl.fName, Integer.toString(n), n2 == -1 ? "unbounded" : Integer.toString(n2), Integer.toString(n3), n4 == -1 ? "unbounded" : Integer.toString(n4)});
        }
        if (!xSWildcardDecl.allowNamespace(xSElementDecl.fTargetNamespace)) {
            throw new XMLSchemaException("rcase-NSCompat.1", new Object[]{xSElementDecl.fName, xSElementDecl.fTargetNamespace});
        }
    }

    private void checkNSSubset(XSWildcardDecl xSWildcardDecl, int n, int n2, XSWildcardDecl xSWildcardDecl2, int n3, int n4) throws XMLSchemaException {
        if (!this.checkOccurrenceRange(n, n2, n3, n4)) {
            throw new XMLSchemaException("rcase-NSSubset.2", new Object[]{Integer.toString(n), n2 == -1 ? "unbounded" : Integer.toString(n2), Integer.toString(n3), n4 == -1 ? "unbounded" : Integer.toString(n4)});
        }
        if (!this.isSubsetOf(xSWildcardDecl, xSWildcardDecl2)) {
            throw new XMLSchemaException("rcase-NSSubset.1", null);
        }
        if (xSWildcardDecl.weakerProcessContents(xSWildcardDecl2)) {
            throw new XMLSchemaException("rcase-NSSubset.3", new Object[]{xSWildcardDecl.getProcessContentsAsString(), xSWildcardDecl2.getProcessContentsAsString()});
        }
    }

    private void checkNSRecurseCheckCardinality(Vector vector, int n, int n2, SubstitutionGroupHandler substitutionGroupHandler, XSParticleDecl xSParticleDecl, int n3, int n4, boolean bl) throws XMLSchemaException {
        if (bl && !this.checkOccurrenceRange(n, n2, n3, n4)) {
            throw new XMLSchemaException("rcase-NSRecurseCheckCardinality.2", new Object[]{Integer.toString(n), n2 == -1 ? "unbounded" : Integer.toString(n2), Integer.toString(n3), n4 == -1 ? "unbounded" : Integer.toString(n4)});
        }
        int n5 = vector.size();
        try {
            for (int i = 0; i < n5; ++i) {
                XSParticleDecl xSParticleDecl2 = (XSParticleDecl)vector.elementAt(i);
                this.particleValidRestriction(xSParticleDecl2, substitutionGroupHandler, xSParticleDecl, null, false);
            }
        }
        catch (XMLSchemaException xMLSchemaException) {
            throw new XMLSchemaException("rcase-NSRecurseCheckCardinality.1", null);
        }
    }

    private void checkRecurse(Vector vector, int n, int n2, SubstitutionGroupHandler substitutionGroupHandler, Vector vector2, int n3, int n4, SubstitutionGroupHandler substitutionGroupHandler2) throws XMLSchemaException {
        XSParticleDecl xSParticleDecl;
        int n5;
        if (!this.checkOccurrenceRange(n, n2, n3, n4)) {
            throw new XMLSchemaException("rcase-Recurse.1", new Object[]{Integer.toString(n), n2 == -1 ? "unbounded" : Integer.toString(n2), Integer.toString(n3), n4 == -1 ? "unbounded" : Integer.toString(n4)});
        }
        int n6 = vector.size();
        int n7 = vector2.size();
        int n8 = 0;
        block2: for (n5 = 0; n5 < n6; ++n5) {
            xSParticleDecl = (XSParticleDecl)vector.elementAt(n5);
            for (int i = n8; i < n7; ++i) {
                XSParticleDecl xSParticleDecl2 = (XSParticleDecl)vector2.elementAt(i);
                ++n8;
                try {
                    this.particleValidRestriction(xSParticleDecl, substitutionGroupHandler, xSParticleDecl2, substitutionGroupHandler2);
                    continue block2;
                }
                catch (XMLSchemaException xMLSchemaException) {
                    if (xSParticleDecl2.emptiable()) continue;
                    throw new XMLSchemaException("rcase-Recurse.2", null);
                }
            }
            throw new XMLSchemaException("rcase-Recurse.2", null);
        }
        for (n5 = n8; n5 < n7; ++n5) {
            xSParticleDecl = (XSParticleDecl)vector2.elementAt(n5);
            if (xSParticleDecl.emptiable()) continue;
            throw new XMLSchemaException("rcase-Recurse.2", null);
        }
    }

    private void checkRecurseUnordered(Vector vector, int n, int n2, SubstitutionGroupHandler substitutionGroupHandler, Vector vector2, int n3, int n4, SubstitutionGroupHandler substitutionGroupHandler2) throws XMLSchemaException {
        XSParticleDecl xSParticleDecl;
        int n5;
        if (!this.checkOccurrenceRange(n, n2, n3, n4)) {
            throw new XMLSchemaException("rcase-RecurseUnordered.1", new Object[]{Integer.toString(n), n2 == -1 ? "unbounded" : Integer.toString(n2), Integer.toString(n3), n4 == -1 ? "unbounded" : Integer.toString(n4)});
        }
        int n6 = vector.size();
        int n7 = vector2.size();
        boolean[] blArray = new boolean[n7];
        block2: for (n5 = 0; n5 < n6; ++n5) {
            xSParticleDecl = (XSParticleDecl)vector.elementAt(n5);
            for (int i = 0; i < n7; ++i) {
                XSParticleDecl xSParticleDecl2 = (XSParticleDecl)vector2.elementAt(i);
                try {
                    this.particleValidRestriction(xSParticleDecl, substitutionGroupHandler, xSParticleDecl2, substitutionGroupHandler2);
                    if (blArray[i]) {
                        throw new XMLSchemaException("rcase-RecurseUnordered.2", null);
                    }
                    blArray[i] = true;
                    continue block2;
                }
                catch (XMLSchemaException xMLSchemaException) {
                    continue;
                }
            }
            throw new XMLSchemaException("rcase-RecurseUnordered.2", null);
        }
        for (n5 = 0; n5 < n7; ++n5) {
            xSParticleDecl = (XSParticleDecl)vector2.elementAt(n5);
            if (blArray[n5] || xSParticleDecl.emptiable()) continue;
            throw new XMLSchemaException("rcase-RecurseUnordered.2", null);
        }
    }

    private void checkRecurseLax(Vector vector, int n, int n2, SubstitutionGroupHandler substitutionGroupHandler, Vector vector2, int n3, int n4, SubstitutionGroupHandler substitutionGroupHandler2) throws XMLSchemaException {
        if (!this.checkOccurrenceRange(n, n2, n3, n4)) {
            throw new XMLSchemaException("rcase-RecurseLax.1", new Object[]{Integer.toString(n), n2 == -1 ? "unbounded" : Integer.toString(n2), Integer.toString(n3), n4 == -1 ? "unbounded" : Integer.toString(n4)});
        }
        int n5 = vector.size();
        int n6 = vector2.size();
        int n7 = 0;
        block2: for (int i = 0; i < n5; ++i) {
            XSParticleDecl xSParticleDecl = (XSParticleDecl)vector.elementAt(i);
            for (int j = n7; j < n6; ++j) {
                XSParticleDecl xSParticleDecl2 = (XSParticleDecl)vector2.elementAt(j);
                ++n7;
                try {
                    if (!this.particleValidRestriction(xSParticleDecl, substitutionGroupHandler, xSParticleDecl2, substitutionGroupHandler2)) continue block2;
                    --n7;
                    continue block2;
                }
                catch (XMLSchemaException xMLSchemaException) {
                    continue;
                }
            }
            throw new XMLSchemaException("rcase-RecurseLax.2", null);
        }
    }

    private void checkMapAndSum(Vector vector, int n, int n2, SubstitutionGroupHandler substitutionGroupHandler, Vector vector2, int n3, int n4, SubstitutionGroupHandler substitutionGroupHandler2) throws XMLSchemaException {
        if (!this.checkOccurrenceRange(n, n2, n3, n4)) {
            throw new XMLSchemaException("rcase-MapAndSum.2", new Object[]{Integer.toString(n), n2 == -1 ? "unbounded" : Integer.toString(n2), Integer.toString(n3), n4 == -1 ? "unbounded" : Integer.toString(n4)});
        }
        int n5 = vector.size();
        int n6 = vector2.size();
        block2: for (int i = 0; i < n5; ++i) {
            XSParticleDecl xSParticleDecl = (XSParticleDecl)vector.elementAt(i);
            for (int j = 0; j < n6; ++j) {
                XSParticleDecl xSParticleDecl2 = (XSParticleDecl)vector2.elementAt(j);
                try {
                    this.particleValidRestriction(xSParticleDecl, substitutionGroupHandler, xSParticleDecl2, substitutionGroupHandler2);
                    continue block2;
                }
                catch (XMLSchemaException xMLSchemaException) {
                    continue;
                }
            }
            throw new XMLSchemaException("rcase-MapAndSum.1", null);
        }
    }

    @Override
    protected final boolean checkEmptyFacets(XSSimpleType xSSimpleType) {
        return true;
    }
}

