// MPEGdlg.cpp : implementation file
//

#include "stdafx.h"
#include "avi2mpg.h"
#include "MPEGdlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg message handlers

BOOL CAboutDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CenterWindow();
	
	// TODO: Add extra about dlg initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}








/////////////////////////////////////////////////////////////////////////////
// CAvi2mpgDlg dialog

CAvi2mpgDlg::CAvi2mpgDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAvi2mpgDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAvi2mpgDlg)
	m_audio_br = 7;
	m_avi = _T("");
	m_avi_error = TRUE;
	m_bitrate = 1200;
	m_byterate = 150;
	m_crop = FALSE;
	m_crop_x = 0;
	m_crop_y = 0;
	m_force_fr = FALSE;
	m_frame_rate = -1;
	m_joint = FALSE;
	m_layer = 1;
	m_motion = 0;
	m_mpg = _T("");
	m_param = FALSE;
	m_param_file = _T("");
	m_vbv = 20;
	m_video_cd = FALSE;
	m_video_only = FALSE;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAvi2mpgDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAvi2mpgDlg)
	DDX_CBIndex(pDX, IDC_AUDIO_BR, m_audio_br);
	DDX_Text(pDX, IDC_AVI, m_avi);
	DDX_Check(pDX, IDC_AVI_ERROR, m_avi_error);
	DDX_Text(pDX, IDC_BITRATE, m_bitrate);
	DDX_Text(pDX, IDC_BYTERATE, m_byterate);
	DDX_Check(pDX, IDC_CROP, m_crop);
	DDX_Text(pDX, IDC_CROP_X, m_crop_x);
	DDV_MinMaxUInt(pDX, m_crop_x, 0, 5000);
	DDX_Text(pDX, IDC_CROP_Y, m_crop_y);
	DDV_MinMaxUInt(pDX, m_crop_y, 0, 5000);
	DDX_Check(pDX, IDC_FORCE_FR, m_force_fr);
	DDX_CBIndex(pDX, IDC_FRAME_RATE, m_frame_rate);
	DDX_Check(pDX, IDC_JOINT, m_joint);
	DDX_CBIndex(pDX, IDC_LAYER, m_layer);
	DDX_Text(pDX, IDC_MOTION, m_motion);
	DDV_MinMaxUInt(pDX, m_motion, 0, 4);
	DDX_Text(pDX, IDC_MPG, m_mpg);
	DDX_Check(pDX, IDC_PARAM, m_param);
	DDX_Text(pDX, IDC_PARAM_FILE, m_param_file);
	DDX_Text(pDX, IDC_VBV, m_vbv);
	DDV_MinMaxUInt(pDX, m_vbv, 0, 1000);
	DDX_Check(pDX, IDC_VIDEO_CD, m_video_cd);
	DDX_Check(pDX, IDC_VIDEO_ONLY, m_video_only);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAvi2mpgDlg, CDialog)
	//{{AFX_MSG_MAP(CAvi2mpgDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDABOUT, OnAbout)
	ON_BN_CLICKED(IDC_OPEN, OnOpen)
	ON_BN_CLICKED(IDC_CROP, OnCrop)
	ON_BN_CLICKED(IDC_PARAM, OnParam)
	ON_BN_CLICKED(IDC_VIDEO_ONLY, OnVideoOnly)
	ON_BN_CLICKED(IDC_FORCE_FR, OnForceFrameRate)
	ON_EN_CHANGE(IDC_BITRATE, OnChangeBitrate)
	ON_EN_CHANGE(IDC_BYTERATE, OnChangeByterate)
	ON_BN_CLICKED(IDC_VIDEO_CD, OnVideoCd)
	ON_CBN_SELCHANGE(IDC_LAYER, OnChangeLayer)
	ON_BN_CLICKED(IDSTART, OnStartEncoding)
	ON_BN_CLICKED(ID_DFLT, OnDefault)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAvi2mpgDlg message handlers

BOOL CAvi2mpgDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	VERIFY(m_openPic.SubclassDlgItem(IDC_OPEN, this));
	VERIFY(m_openPic.LoadBitmaps(_T("open"), NULL, NULL));

	CenterWindow();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	CString strAboutMenu;
	strAboutMenu.LoadString(IDS_ABOUTBOX);
	if (!strAboutMenu.IsEmpty())
	{
		pSysMenu->AppendMenu(MF_SEPARATOR);
		pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
	}
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CAvi2mpgDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAvi2mpgDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAvi2mpgDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CAvi2mpgDlg::OnAbout() 
{
	CAboutDlg dlg;
	dlg.DoModal();	
}

void CAvi2mpgDlg::OnDefault() 
{
	m_audio_br = 7;
	m_avi = _T("");
	m_avi_error = TRUE;
	m_bitrate = 1200;
	m_byterate = 150;
	m_crop = FALSE;
	m_crop_x = 0;
	m_crop_y = 0;
	m_force_fr = FALSE;
	m_frame_rate = -1;
	m_joint = FALSE;
	m_layer = 1;
	m_motion = 0;
	m_mpg = _T("");
	m_param = FALSE;
	m_param_file = _T("");
	m_vbv = 20;
	m_video_cd = FALSE;
	m_video_only = FALSE;
	UpdateData(FALSE);
}

void CAvi2mpgDlg::OnOpen() 
{
	CFileDialog dlg(TRUE, NULL, NULL, OFN_HIDEREADONLY, "AVI files|*.avi|All files|*.*||");
	if(dlg.DoModal()==IDOK)
	{
		char buf[100];
		UpdateData();
		m_avi= dlg.GetPathName();
		strcpy(buf, LPCTSTR(m_avi));
		if(strchr(buf, '.')) *strrchr(buf, '.')= '\0';
		strcat(buf, ".mpg");
		m_mpg= buf;
		UpdateData(FALSE);	
	}
}

void CAvi2mpgDlg::OnCrop() 
{
	if(((CButton*)GetDlgItem(IDC_CROP))->GetCheck())
	{
		   GetDlgItem(IDC_CROP_X)->EnableWindow();
		   GetDlgItem(IDC_CROP_Y)->EnableWindow();
	}
	else
	{
		   GetDlgItem(IDC_CROP_X)->EnableWindow(FALSE);
		   GetDlgItem(IDC_CROP_Y)->EnableWindow(FALSE);
	}
}

void CAvi2mpgDlg::OnParam() 
{
	if(((CButton*)GetDlgItem(IDC_PARAM))->GetCheck())
      GetDlgItem(IDC_PARAM_FILE)->EnableWindow();
	else
	  GetDlgItem(IDC_PARAM_FILE)->EnableWindow(FALSE);
}

void CAvi2mpgDlg::OnVideoOnly() 
{
	if(((CButton*)GetDlgItem(IDC_VIDEO_ONLY))->GetCheck())
  {
      GetDlgItem(IDC_FORCE_FR)->EnableWindow();
	    ((CButton*)GetDlgItem(IDC_FORCE_FR))->SetCheck(FALSE);
      GetDlgItem(IDC_FRAME_RATE)->EnableWindow(FALSE);
      GetDlgItem(IDC_LAYER)->EnableWindow(FALSE);
      GetDlgItem(IDC_AUDIO_BR)->EnableWindow(FALSE);
      GetDlgItem(IDC_JOINT)->EnableWindow(FALSE);
	}
	else
	{
	  GetDlgItem(IDC_FORCE_FR)->EnableWindow(FALSE);		
    GetDlgItem(IDC_FRAME_RATE)->EnableWindow(FALSE);
    GetDlgItem(IDC_LAYER)->EnableWindow();
    GetDlgItem(IDC_AUDIO_BR)->EnableWindow();
    GetDlgItem(IDC_JOINT)->EnableWindow();
	}
}

void CAvi2mpgDlg::OnForceFrameRate() 
{
	if(((CButton*)GetDlgItem(IDC_FORCE_FR))->GetCheck())
      GetDlgItem(IDC_FRAME_RATE)->EnableWindow();
	else
	  GetDlgItem(IDC_FRAME_RATE)->EnableWindow(FALSE);		
}

void CAvi2mpgDlg::OnChangeBitrate() 
{
    UpdateData();
	m_byterate= m_bitrate / 8;
	UpdateData(FALSE);
}

void CAvi2mpgDlg::OnChangeByterate() 
{
    UpdateData();
	m_bitrate= m_byterate * 8;
	UpdateData(FALSE);
}

void CAvi2mpgDlg::OnVideoCd() 
{
	if(((CButton*)GetDlgItem(IDC_VIDEO_CD))->GetCheck())
	{
      GetDlgItem(IDC_FRAME_RATE)->EnableWindow(FALSE);
      GetDlgItem(IDC_BITRATE)->EnableWindow(FALSE);
      GetDlgItem(IDC_BYTERATE)->EnableWindow(FALSE);
      GetDlgItem(IDC_AUDIO_BR)->EnableWindow(FALSE);
      GetDlgItem(IDC_LAYER)->EnableWindow(FALSE);
      GetDlgItem(IDC_VIDEO_ONLY)->EnableWindow(FALSE);
      GetDlgItem(IDC_CROP)->EnableWindow(FALSE);
      GetDlgItem(IDC_CROP_X)->EnableWindow(FALSE);
      GetDlgItem(IDC_CROP_Y)->EnableWindow(FALSE);
      GetDlgItem(IDC_VBV)->EnableWindow(FALSE);
      GetDlgItem(IDC_FORCE_FR)->EnableWindow(FALSE);
      GetDlgItem(IDC_JOINT)->EnableWindow(FALSE);
	}
	else
	{
      GetDlgItem(IDC_BITRATE)->EnableWindow();
      GetDlgItem(IDC_BYTERATE)->EnableWindow();
      GetDlgItem(IDC_AUDIO_BR)->EnableWindow();
      GetDlgItem(IDC_LAYER)->EnableWindow();
      GetDlgItem(IDC_VIDEO_ONLY)->EnableWindow();
      GetDlgItem(IDC_CROP)->EnableWindow();
      GetDlgItem(IDC_VBV)->EnableWindow();
      GetDlgItem(IDC_JOINT)->EnableWindow();
	}
}

void CAvi2mpgDlg::OnChangeLayer() 
{
	int layer= ((CComboBox*)GetDlgItem(IDC_LAYER))->GetCurSel();
	char buf[10];

	((CComboBox*)GetDlgItem(IDC_AUDIO_BR))->ResetContent();
	for(int i= 0; i<=13; i++)
	{
	  sprintf(buf, "%i", layers[layer][i]);
	  ((CComboBox*)GetDlgItem(IDC_AUDIO_BR))->AddString(buf);
    }
    UpdateData();
	m_audio_br= 5;
	UpdateData(FALSE);
}

void CAvi2mpgDlg::OnStartEncoding() 
{
	UpdateData();
	if(m_bitrate < 80 || m_bitrate > 4000)
	{
		AfxMessageBox("Bitrate bust be in range 80 - 4000.", MB_ICONEXCLAMATION | MB_OK);
		return;
	}

	if(m_avi.IsEmpty())
	{
		AfxMessageBox("Input AVI filename must be specified.", MB_ICONEXCLAMATION | MB_OK);
		return;
	}
	
	// now create the command line
	char  cmdline[1000]= "avi2mpg1 ", tmp[50];
	
	if(m_avi_error) strcat(cmdline, "-e ");

	if(m_param)
	{
	 	sprintf(tmp, "-p %s ", m_param_file);
		strcat(cmdline, tmp);
	}

	if(!m_video_only && m_joint) strcat(cmdline, "-j ");

	sprintf(tmp, "-m %i ", m_motion);
	strcat(cmdline, tmp);
	
	if(m_video_cd)
		strcat(cmdline, "-v ");
	else // not video CD
	{
		sprintf(tmp, "-s %i ", m_bitrate);
		strcat(cmdline, tmp);

		sprintf(tmp, "-y %i ", m_vbv);
		strcat(cmdline, tmp);

		if(m_crop)
		{
			sprintf(tmp, "-c %i %i ", m_crop_x, m_crop_y);
			strcat(cmdline, tmp);
		}

		if(m_video_only)
		{
			strcat(cmdline, "-n ");

			if(m_force_fr)
			{
				sprintf(tmp, "-f %i ", m_frame_rate+1);
				strcat(cmdline, tmp);
			}
		}
		else // not video only
		{
			sprintf(tmp, "-l %i ", m_layer+1);
			strcat(cmdline, tmp);

			sprintf(tmp, "-a %i ", layers[m_layer][m_audio_br]);
			strcat(cmdline, tmp);
		}
	}

	strcat(cmdline, LPCTSTR(m_avi));
	strcat(cmdline, " ");
	strcat(cmdline, LPCTSTR(m_mpg));

	AfxMessageBox(cmdline);
	UINT ret= WinExec(cmdline, SW_SHOW);
  if(ret > 31) return;
  switch(ret)
  {
    case ERROR_BAD_FORMAT      : AfxMessageBox("Bad format of executable \"avi2mpg1.exe\"");
                                 break;
    case ERROR_PATH_NOT_FOUND  :	
    case ERROR_FILE_NOT_FOUND	 : AfxMessageBox("The encoding executable \"avi2mpg1.exe\" not found.");
                                 break;
    default:                     AfxMessageBox("Cannot exec \"avi2mpg1.exe\"");
         
  }
}
