/************************************************************************/
/*  File name : GnuPGModule.h                                           */
/************************************************************************/
/*  Contents  : GnuPG W[bsO                        */
/*                                                                      */
/*  Auther    : Yasuhiro ARAKAWA    Version 0.00    2000.09.12          */
/*                                  Version 0.01    2000.09.14          */
/*                                  Version 0.10    2000.09.27          */
/*                                  Version 0.20    2000.10.03          */
/*                                  Version 0.21    2000.10.04          */
/*                                  Version 0.30    2000.10.06          */
/*                                  Version 0.32    2000.10.26          */
/*                                  Version 1.0.0   2000.11.08          */
/*  Modified  : Yasuhiro ARAKAWA, Canalian, hex                         */
/*                                  Version 1.0.4   2003.05.01          */
/************************************************************************/
#ifndef _GNUPGMODULE_H_
#define _GNUPGMODULE_H_

/**** Incude Files ****/
#include <windows.h>

#include <string>
#include <vector>


/**** Global Macro ****/


/**** Typedef ****/


/**** External Declarelation ****/


/**** Prototyping ****/


/*----------------------------------------------------------------------*/
/* Class Name : CGnuPGModule                                            */
/* Purpose    : GnuPG W[bsONX                  */
/*----------------------------------------------------------------------*/
class CGnuPGModule
{
// oCX^X
private:
    //萔`
    static const DWORD m_PipeSize; //pCṽobt@TCY
    static const char* const m_DefaultModuleName; //ftHg̃W[
    static const char* const m_DefaultOption; //ftHgIvV
    static const char* const m_SignPGPOption; //pPGPΉIvV
    static const char* const m_OpenPGPOption; //OpenPGPΉIvV
    static const char* const m_ThrowKeyIDOption; //MґΉIvV
    static const char* const m_RFC1991Option; //NApPGPΉIvV
    static const char* const m_MdMD5Option; //bZ[W_CWFXgMD5gIvV
    static const char* const m_MdSHA1Option; //bZ[W_CWFXgSHA-1gIvV
    //ϐ
    //o̓_CNg
    HANDLE m_hStdoutRead;       //Wo͓ǂݍ݃pCv
    HANDLE m_hStdoutWrite;      //Wo͏݃pCv
    HANDLE m_hStderrRead;       //WG[o͓ǂݍ݃pCv
    HANDLE m_hStderrWrite;      //WG[o͏݃pCv
    HANDLE m_hStdinRead;        //W͓ǂݍ݃pCv
    HANDLE m_hStdinWrite;       //W͏݃pCv
    //peϐ
    HANDLE m_hProcess;          //vZXւ̃nh
    std::string m_ModuleName;   //W[
    std::string m_OptionStr;    //NIvV
    std::string m_CommandStr;   //NR}h
    std::string m_StdoutBuffer; //Wo̓obt@ (\p)
    std::string m_StderrBuffer; //WG[o̓obt@ (\p)
    //IvV
    std::string m_DefUserID; //ftHg[UID
    bool m_bPGPMIME; //PGP/MIMEΉ
    bool m_bPGPCompatible; //PGP݊̏EÍs (m_bOpenPGP, m_ThrowKey ͖ɂȂ)
    bool m_bOpenPGP; //OpenPGPɏÍs (m_bPGPCompatible D)
    bool m_bThrowKeyID; //M҂𓽖ɂ (m_bPGPMIME==true ł͖)
    bool m_bRFC1991; //RFC1991ɏ] (m_bPGPCompatible==true ł̂ݗL)
    bool m_bMD5; //bZ[W_CWFXgMD5gp
    bool m_bTextModeSig; //̍ۂɃeLXg[hŏ
public:
    //萔`
    enum EMODE {    // 샂[h
        Null = 0,       //`
        Encrypt,        //Í
        Sign,           //
        EncryptSign,    //Í
        ExpPubKey,      //J̃GNX|[g
        Decript,        //
        Verify,         //̌
        ImpPubKey       //J̃C|[g
    };
    enum CHARSET {  //GnuPGo̓LN^Zbg
        DEFAULT = 0,    //ftHg(Shift-JIS)
        ISO_2022_IP,    //iso-2022-jp (JIS)
        EUC_JP,         // EUC-JP
        UTF_8           // UTF-8
    };

// o\bh
private:
    //֐
    void Copy(const CGnuPGModule& org); //CX^X̃Rs[
    bool Execute(void); //vZXN
    std::string& Quotation(std::string& str); //񂪋󔒕܂ޏꍇ̓_uNH[eVň͂
    std::string& Dequotation(std::string& str); //_uNH[eV݂̈͂O
    void Terminate(void); //vZXI
    bool IsActive(DWORD tout=0); //vZX͉ғ?
    void WaitforTerminate(void); //vZXI܂ő҂
    bool Write(std::string& inpMsg); //W͂ւ̓
    bool Read(std::string& outpMsg, bool bBlock); //Wo͂̃bZ[W
public:
    //RXgN^EfXgN^
    CGnuPGModule(const char* moduleName=NULL); //ftHgRXgN^
    CGnuPGModule(const CGnuPGModule& org) { Copy(org); } //Rs[RXgN^
    virtual ~CGnuPGModule() { Terminate(); } //fXgN^
    //Zq
    CGnuPGModule& operator=(const CGnuPGModule& org) { Copy(org); return *this; } //Zq
    //C^tF[X֐
    bool ExecEncrypt(const char* ascPath, const char* txtPath, std::vector<std::string>& addrList); //Í
    bool ExecSign(const char* ascPath, const char* txtPath, const char* userID, const char* passPhrase, bool UseAgent); //
    bool ExecEncryptSign(const char* ascPath, const char* txtPath, const char* userID, std::vector<std::string>& addrList, const char* passPhrase, bool UseAgent); //ÍƏ
    bool ExecDecrypt(const char* ascPath, const char* txtPath, const char* passPhrase, bool UseAgent); //
    bool ExecVerify(const char* ascPath, const char* txtPath); //̌
    bool ExecImport(const char* ascPath); //J̃C|[g
    bool ExecExport(const char* ascPath, const char* userID); //J̃GNX|[g
    inline const char* GetOutputMsg(void) { return m_StderrBuffer.c_str(); }
    inline const char* GetStatusMsg(void) { return m_StdoutBuffer.c_str(); }
    inline static const char* GetDefModuleName(void) { return m_DefaultModuleName; } //W[擾
    inline const char* GetModuleName(void) const { return m_ModuleName.c_str(); } //W[擾
    inline void SetModuleName(const char* moduleName) { m_ModuleName = moduleName; Quotation(m_ModuleName); return; } //W[ݒ肷
    inline const char* GetDefUserID(void) const { return m_DefUserID.c_str(); } //ftHg[UID擾
    inline void SetDefUserID(const char* userID) { m_DefUserID = userID; return; } //ftHg[UIDݒ肷
    inline bool IsPGPMIME(void) const { return m_bPGPMIME; } //PGP/MIME Ή?
    inline void SetOptPGPMIME(const bool bPGPMIME) { m_bPGPMIME = bPGPMIME; return; } //PGP/MIME Ήݒ
    inline bool IsPGPCompatible(void) const { return m_bPGPCompatible; }  //PGP݊?
    inline void SetOptPGPCompatible(const bool bPGPCompatible) { m_bPGPCompatible = bPGPCompatible; return; } //PGP݊ݒ
    inline bool IsOpenPGP(void) const { return m_bOpenPGP; }  //OpenPGP?
    inline void SetOptOpenPGP(const bool bOpenPGP) { m_bOpenPGP = bOpenPGP; return; } //OpenPGPݒ
    inline bool IsThrowKeyID(void) const { return m_bThrowKeyID; }  //M҂Ɠɂ?
    inline void SetOptThrowKeyID(const bool bThrowKeyID) { m_bThrowKeyID = bThrowKeyID; return; } //Mҏݒ
    inline bool IsRFC1991(void) const { return m_bRFC1991; }  //RFC1991ɏ]?
    inline void SetOptRFC1991(const bool bRFC1991) { m_bRFC1991 = bRFC1991; return; } //RFC1991ݒ
    inline bool IsMD5(void) const { return m_bMD5; }  //bZ[W_CWFXgMD5gp
    inline void SetOptMD5(const bool bMD5) { m_bMD5 = bMD5; return; } //MD5ݒ
    inline bool IsTextModeSig(void) const { return m_bTextModeSig; }  //̍ۂɃeLXg[hŏ
    inline void SetOptTextModeSig(const bool bTextModeSig) { m_bTextModeSig = bTextModeSig; return; } //ݒ
    //C^tF[X֐ (static)
    static std::string GetGPGHomeDir(void); //GnuPG̃z[fBNg擾
    static std::string GetGPGModuleName(void); //GnuPG̃vO擾 (by Canalian)

};


#endif // _GNUPGMODULE_H_
/* Copyright (C) Yasuhiro ARAKAWA  **************************************/
