/************************************************************************/
/*  File name : MIMEMessage.h                                           */
/************************************************************************/
/*  Contents  : MIME [bZ[W                                   */
/*                                                                      */
/*  Auther    : Yasuhiro ARAKAWA    Version 0.20    2000.10.02          */
/*                                  Version 0.30    2000.10.08          */
/*                                  Version 1.0.0   2000.11.08          */
/************************************************************************/
#ifndef _MIMEMESSAGE_H_
#define _MIMEMESSAGE_H_

/**** Incude Files ****/
#include <string>
#include <vector>


/**** Global Macro ****/


/**** Typedef ****/


/**** External Declarelation ****/


/**** Prototyping ****/


/*----------------------------------------------------------------------*/
/* Class Name : CBigBuffer                                              */
/* Purpose    : 啶obt@NX                            */
/*                                                                      */
/*  ̊mۂ CBeckyAPI::Alloc gp̂Ŏ舵        */
/*----------------------------------------------------------------------*/
class CBigBuffer
{
// oCX^X
private:
    //萔`
    static const int m_Capacity; //obt@̃ubNP
    //ϐ
    bool m_bBkAPI; // Becky! API gǂ
    char* m_Buffer; //obt@ւ̃|C^
    int m_nBlock; //q[ṽubN
    int m_nSize; //TCY
public:
    //萔`

// o\bh
private:
    //CX^X̃Rs[点Ȃ߂̑[u
    CBigBuffer(const CBigBuffer& org); //Rs[RXgN^
    CBigBuffer& operator=(const CBigBuffer& org); //Zq
    //֐
    inline void Init(void) { m_Buffer=NULL; m_nBlock=0; m_nSize=0; } //Ԃ̏
public:
    //RXgN^EfXgN^
    CBigBuffer(bool bBkAPI=true) : m_Buffer(NULL), m_nBlock(0), m_nSize(0), m_bBkAPI(bBkAPI) {} //ftHgRXgN^
    virtual ~CBigBuffer() { Reset(); } //fXgN^
    //Zq
    //C^tF[X֐
    void Reset(bool bBkAPI=true); //obt@
    void AddStr(const char* str); //obt@ɕǉ
    void RollBack(void); //̉sR[h폜
    const char* Reference(void) const { return m_Buffer; } //obt@̕\(Ȃ)
    char* Export(void); //obt@̃GNX|[g
};

/*----------------------------------------------------------------------*/
/* Class Name : CMIMEMessage                                            */
/* Purpose    : MIME [bZ[WNX                             */
/*----------------------------------------------------------------------*/
class CMIMEMessage
{
// oCX^X
private:
    //萔`
    //ϐ
    //֘A郁bZ[W
    CMIMEMessage* m_pNext; //MIMEbZ[W
    CMIMEMessage* m_pChild; //JvZꂽqMIMEbZ[W
    //wb_
    std::string m_Type;
    std::string m_SubType;
    std::string m_Boundary;
    std::vector<std::string> m_lstHeaders;
    //std::vector<std::string> m_lstBody;
    //std::vector<std::string> m_lstTrail;
    CBigBuffer m_Body;
    CBigBuffer m_Trail;
public:
    //萔`

// o\bh
private:
    //֐
    void Init(void); //
    void Copy(const CMIMEMessage& org); //CX^X̃Rs[
    const char* GetLine(const char* src, std::string& lineBuf); //s̕擾
    std::string& GetOptValue(std::string& option, std::string& opt, std::string& val); // 񂩂 opt=val ̏𔲂o
    inline void ClearBody(void) { m_Body.Reset(); }
    inline void ClearNext(void) { delete m_pNext; m_pNext=NULL; }
    void SetNext(const CMIMEMessage& next);
    inline void ClearChild(void) { delete m_pChild; m_pChild=NULL; }
    void SetChild(const CMIMEMessage& child);
public:
    //RXgN^EfXgN^
    CMIMEMessage() : m_pNext(NULL), m_pChild(NULL) { Init(); } //ftHgRXgN^
    CMIMEMessage(const CMIMEMessage& org) : m_pNext(NULL), m_pChild(NULL) { Copy(org); } //Rs[RXgN^
    virtual ~CMIMEMessage() { Init(); } //fXgN^
    //Zq
    CMIMEMessage& operator=(const CMIMEMessage& org) { Copy(org); return *this; } //Zq
    //C^tF[X֐
    inline const std::string& GetType(void) const { return m_Type; }
    inline const std::string& SetType(const std::string& szType) { return m_Type = szType; }
    inline const std::string& GetSubType(void) const { return m_SubType; }
    inline const std::string& SetSubType(const std::string& szSubType) { return m_SubType = szSubType; }
    inline const std::string& GetBoundary(void) const { return m_Boundary; }
    inline const std::string& SetBoundary(const std::string& szBoundary) { return m_Boundary = szBoundary; }
    CMIMEMessage& GetBody(CMIMEMessage& item); //Body֘Ȁ(Header܂)𔲂o
    inline void AddBody(const std::string& body) { m_Body.AddStr(body.c_str()); }
    inline CMIMEMessage* GetNext(void) const { return m_pNext; }
    inline CMIMEMessage* GetChild(void) const { return m_pChild; }
    void AddChild(const CMIMEMessage& child);
    void OverWrite(CMIMEMessage& item); //MIMEbZ[W㏑Rs[
    const char* FromString(const char* src, const char* boundParent=NULL);
    char* ToString(void);
    std::string& GetHeader(const char* header, std::string& dataBuf);
    bool SetHeader(const char* header, const char* data);
    CMIMEMessage* FindCMIMEMessage(const char* type, const char* subType);
};


#endif // _MIMEMESSAGE_H_
/* Copyright (C) Yasuhiro ARAKAWA  **************************************/
