//---------------------------------------------------------------------------
//
// Ruby/Becky!  RubyC^v^֘A
//
// Copyright(c) 2000,2001 T.Shimomura/netlife.gr.jp , All rights reserved.
// $Id: RubyItpr.cpp,v 1.28 2002/01/28 16:24:49 redbug Exp $
//

//---------------------------------------------------------------------------
#include <windows.h>					// Windows SDK

#include <vcl.h>						// Borland's Visual Component Library

#define USE_WIN32_DYNAMIC_LINK
#include "ruby/ruby.h"					// Ruby API

#include "b2pinsdk/BeckyAPI.h"			// Becky! Plug-in SDK
#include "b2pinsdk/BkCommon.h"			// Becky! Plug-in SDK

#pragma hdrstop

#include "BeckyLib.h"
#include "RubyItpr.h"
#include "Edit.h"
#include "Manager.h"
#include "version.h"

#include "extern.h"

#pragma package(smart_init)
//---------------------------------------------------------------------------

// ӁFقȂXbhL VCL ̃\bh/֐/vpeB
//		 ʂ̃Xbh̒爵ꍇCr̖肪܂B
//
//		 CXbh̏LIuWFNgɑ΂Ă Synchronize
//		 \bhgł܂B̃IuWFNgQƂ邽
//		 ̃\bhXbhNXɒǉCSynchronize \bh
//		 Ƃēn܂B
//
//		 Ƃ UpdateCaption ȉ̂悤ɒ`A
//
//			void __fastcall Unit1::UpdateCaption()
//			{
//			  Form1->Caption = "Xbh珑܂";
//			}
//
//		 Execute \bh̒ Synchronize \bhɓnƂŃC
//		 XbhL Form1  Caption vpeBSɕ
//		 Xł܂B
//
//			Synchronize(UpdateCaption);
//
//---------------------------------------------------------------------------

extern TEditForm *EditForm;

extern VALUE CallBackObject[];

VALUE console_write( VALUE self , VALUE str );


__fastcall RubyItpr::RubyItpr(bool CreateSuspended)
		: TThread(CreateSuspended)
{
}
//---------------------------------------------------------------------------
void __fastcall RubyItpr::Execute()
{
	MSG msg;
	int i;
	VALUE ret;
	VALUE RubyPlatform;

	// Xbh̗Dxグ
	{
		Priority = tpTimeCritical;
		Status = ITPR_STS_INIT;
	}

	DEBUG_OUT( DBG_RUBY_1, "Ruby C^v^sXbhN" );
	DEBUG_OUT( DBG_RUBY_1, "Ruby C^v^Jn" );

	// Ruby C^v^̏
	{
		VALUE RubyVersion;

		ruby_init();
		RubyVersion = rb_eval_string( "VERSION" );
		RubyPlatform = rb_eval_string( "RUBY_PLATFORM" );
		VersionForm->Label4->Caption = VersionForm->Label4->Caption+RSTRING(RubyVersion)->ptr;
		VersionForm->Label4->Caption = VersionForm->Label4->Caption+" ("+RSTRING(RubyPlatform)->ptr+")";

		DEBUG_OUT( DBG_RUBY_3, "Ruby Version : %s", RSTRING(RubyVersion)->ptr );
		DEBUG_OUT( DBG_RUBY_3, "Ruby Platform : %s", RSTRING(RubyPlatform)->ptr );
	}

	// Ruby CupX̐ݒ
	{
		AnsiString libpath;

		libpath = RubyBeckyIni.LibPath;
		ruby_incpush( libpath.c_str() );
		ruby_incpush( (libpath+"\\cgi").c_str() );
		ruby_incpush( (libpath+"\\irb").c_str() );
		ruby_incpush( (libpath+"\\net").c_str() );
		ruby_incpush( (libpath+"\\shell").c_str() );
		ruby_incpush( (libpath+"\\"+RSTRING(RubyPlatform)->ptr).c_str() );
		ruby_incpush( RubyBeckyIni.BeckyLibPath.c_str() );
	}

	// WóEWG[o͂
	{
		VALUE console_out;

		console_out = rb_define_class( "RB_CONSOLE" , NULL );
		rb_define_method( console_out , "write" , (VALUE(*)(void))console_write , 1 );
		rb_eval_string( "$> = RB_CONSOLE.new" );
		rb_eval_string( "STDOUT = $>" );
		rb_eval_string( "STDERR = $>" );
	}

	rb_eval_string( "$KCODE='SJIS'" );

	// 풓XNvg
	for ( i=0; i != CALLBACKOBJECT_MAX; i++ ) {
		CallBackObject[i] = Qnil;
	}

	// Becky ֘ÅgNXAW[Ȃǂ Ruby ɓo^
	BeckyLib_initialize();
	rb_require( "becky" );

	DEBUG_OUT( DBG_RUBY_1, "Ruby C^v^I" );

	DEBUG_OUT( DBG_RUBY_1, "NɎsXNvg̕]Jn" );
	// NɎsXNvg]
	for ( i = 0 ; i < ManagerForm->ListBox1->Items->Count ; i++ ) {
		ManagerForm->Memo1->Lines->LoadFromFile( ManagerForm->ListBox1->Items->Strings[i] );
		Eval( ManagerForm->Memo1->Text.c_str() );
	}
	DEBUG_OUT( DBG_RUBY_1, "NɎsXNvg̕]I" );

	DEBUG_OUT( DBG_RUBY_1, "bZ[W҂[v˓" );

	// bZ[W҂[v
	for(;;) {
		Status = ITPR_STS_NOTWORK;
		GetMessage( &msg, NULL, 0, 0 );
		// GfB^̃XNvgs
		if ( msg.message == RubyBeckyMsg_ScriptCall ) {
			Status = ITPR_STS_EVAL;
			DEBUG_OUT( DBG_RUBY_1, "Message:RubyBeckyMsg_ScriptCall" );
			if ( msg.wParam ) {
				Eval( (char *)(msg.wParam) );
			}
			else {
				Eval( EditForm->EditorEx1->Lines->Text.c_str() );
			}
		}
		// Becky! ł̃CxgɑΉXNvgs
		else if ( msg.message == RubyBeckyMsg_EventCall ) {
			Status = ITPR_STS_CALLBACK;
			DEBUG_OUT( DBG_RUBY_1, "Message:RubyBeckyMsg_EventCall" );
			CallBack( msg.wParam, msg.lParam );
		}
		else if ( msg.message == RubyBeckyMsg_InterfaceCall ) {
			DEBUG_OUT( DBG_RUBY_1, "Message:RubyBeckyMsg_InterfaceCall" );
			Eval( (char *)msg.wParam );
			// lParam ɂĕԂľ^ϊ
		}
		else {
			DEBUG_OUT( DBG_RUBY_0, "Message:unknown" );
		}
		DEBUG_OUT( DBG_RUBY_1, "} Message" );
	}
}

// Ruby/Becky! XNvgsi]j
VALUE __fastcall RubyItpr::Eval( char *str )
{
	VALUE ret;
	int state;

	DEBUG_OUT( DBG_RUBY_1, "Eval" );
	// ҏW̃eLXgs
	ret = rb_eval_string_protect( str , &state );

	// Ruby C^v^ŗO
	if( state != 0x00 ) {					// eval.c  TAG_RAISE
		// OWo͂
		rb_eval_string( "print '\n'+$!.type.inspect+' : '+$!+'\n'" );
		DEBUG_OUT( DBG_RUBY_0, "Eval : Exception" );
		return( 0 );
	}

	return ret;

//	EditForm->ActiveControl = EditForm->Editor1;
}

bool __fastcall RubyItpr::CallBack( long wParam, long lParam )
{
	int i;
	ID func_id;
	int state;
	bool doexec = false;

	DEBUG_OUT( DBG_RUBY_1, "Eval CallBack" );
	switch ( wParam ) {
		case BKCALLBACK_START:
			{
				char tmp[1024];

				DEBUG_OUT( DBG_RUBY_2, "CallBack:BKCALLBACK_START" );

				for ( i=0; i != CALLBACKOBJECT_MAX; i++ ) {
					if ( CallBackObject[i] == Qnil ) {
						break;
					}
					sprintf( tmp, "Becky.registered_obj[%d].OnStart if Becky.registered_obj[%d].respond_to?('OnStart')",i,i );
					rb_eval_string_protect( tmp , &state );
					doexec = true;
				}
			}
			break;
		case BKCALLBACK_EXIT:
			{
				char tmp[1024];

				DEBUG_OUT( DBG_RUBY_2, "CallBack:BKCALLBACK_EXIT" );

				for ( i=0; i != CALLBACKOBJECT_MAX; i++ ) {
					if ( CallBackObject[i] == Qnil ) {
						break;
					}
					sprintf( tmp, "Becky.registered_obj[%d].OnExit if Becky.registered_obj[%d].respond_to?('OnExit')",i,i );
					rb_eval_string_protect( tmp , &state );
					doexec = true;
				}
			}
			break;
		case BKCALLBACK_OPENFOLDER:
			{
				char tmp[1024];

				DEBUG_OUT( DBG_RUBY_2, "CallBack:BKCALLBACK_OPENFOLDER" );

				for ( i=0; i != CALLBACKOBJECT_MAX; i++ ) {
					if ( CallBackObject[i] == Qnil ) {
						break;
					}
					sprintf( tmp, "Becky.registered_obj[%d].OnOpenFolder( BkFolder.new ) if Becky.registered_obj[%d].respond_to?('OnOpenFolder')",i,i );
					rb_eval_string_protect( tmp , &state );
					doexec = true;
				}
			}
			break;
		case BKCALLBACK_OPENMAIL:
			{
				char tmp[1024];

				DEBUG_OUT( DBG_RUBY_2, "CallBack:BKCALLBACK_OPENMAIL" );

				for ( i=0; i != CALLBACKOBJECT_MAX; i++ ) {
					if ( CallBackObject[i] == Qnil ) {
						break;
					}
					sprintf( tmp, "Becky.registered_obj[%d].OnOpenMail( BkMail.new ) if Becky.registered_obj[%d].respond_to?('OnOpenMail')",i,i );
					rb_eval_string_protect( tmp , &state );
					doexec = true;
				}
			}
			break;
		case BKCALLBACK_MINUTE:
			{
				char tmp[1024];

				DEBUG_OUT( DBG_RUBY_2, "CallBack:BKCALLBACK_MINUTE" );

				for ( i=0; i != CALLBACKOBJECT_MAX; i++ ) {
					if ( CallBackObject[i] == Qnil ) {
						break;
					}
					sprintf( tmp, "Becky.registered_obj[%d].OnEveryMinute if Becky.registered_obj[%d].respond_to?('OnEveryMinute')",i,i );
					rb_eval_string_protect( tmp , &state );
					doexec = true;
				}
			}
			break;
		case BKCALLBACK_COMPOSE:
			{
				char tmp[1024];

				DEBUG_OUT( DBG_RUBY_2, "CallBack:BKCALLBACK_COMPOSE" );

				for ( i=0; i != CALLBACKOBJECT_MAX; i++ ) {
					if ( CallBackObject[i] == Qnil ) {
						break;
					}
					sprintf( tmp, "Becky.registered_obj[%d].OnOpenCompose(BkComposeMail.new(BkComposeAPI.new.SetWindowHandle(%d)),%d) if Becky.registered_obj[%d].respond_to?('OnOpenCompose')",
							 i, ((BkCallBack_Compose_t *)lParam)->hWnd, ((BkCallBack_Compose_t *)lParam)->nMode, i );
					rb_eval_string_protect( tmp , &state );
					doexec = true;
				}
			}
			break;
		case BKCALLBACK_OUTGOING:
			{
				char tmp[1024];

				DEBUG_OUT( DBG_RUBY_2, "CallBack:BKCALLBACK_OUTGOING" );

				for ( i=0; i != CALLBACKOBJECT_MAX; i++ ) {
					if ( CallBackObject[i] == Qnil ) {
						break;
					}
					sprintf( tmp, "Becky.registered_obj[%d].OnOutgoing(BkComposeMail.new(BkComposeAPI.new.SetWindowHandle(%d)),%d) if Becky.registered_obj[%d].respond_to?('OnOutgoing')",
							 i, ((BkCallBack_Compose_t *)lParam)->hWnd, ((BkCallBack_Compose_t *)lParam)->nMode, i );
					rb_eval_string_protect( tmp , &state );
					doexec = true;
				}
			}
			break;
		case BKCALLBACK_KEYDISPATCH:
			{
				char tmp[1024];

				DEBUG_OUT( DBG_RUBY_2, "CallBack:BKCALLBACK_KEYDISPATCH" );

				for ( i=0; i != CALLBACKOBJECT_MAX; i++ ) {
					if ( CallBackObject[i] == Qnil ) {
						break;
					}
					if ( ((BkCallBack_Keydispatch_t *)lParam)->hWnd == hMainWnd ) {
						sprintf( tmp, "Becky.registered_obj[%d].OnKeyDispatch(%d,%d) if Becky.registered_obj[%d].respond_to?('OnKeyDispatch')",
								 i,
								 (int)(((BkCallBack_Keydispatch_t *)lParam)->nKey),
								 (int)(((BkCallBack_Keydispatch_t *)lParam)->nShift),
								 i );
					}
					else {
						/* EChEnhɂƂ̂͂ */
						sprintf( tmp, "Becky.registered_obj[%d].OnKeyDispatchCompose(%d,%d,%d) if Becky.registered_obj[%d].respond_to?('OnKeyDispatch')",
								 i,
								 (int)(((BkCallBack_Keydispatch_t *)lParam)->hWnd),
								 (int)(((BkCallBack_Keydispatch_t *)lParam)->nKey),
								 (int)(((BkCallBack_Keydispatch_t *)lParam)->nShift),
								 i );
					}
					rb_eval_string_protect( tmp , &state );
					doexec = true;
				}
			}
			break;
		case BKCALLBACK_RETRIEVE:
			{
				char *tmp;

				DEBUG_OUT( DBG_RUBY_2, "CallBack:BKCALLBACK_RETRIEVE" );

				tmp = (char *)malloc( 1024+strlen( (const char *)lParam ) );

				for ( i=0; i != CALLBACKOBJECT_MAX; i++ ) {
					if ( CallBackObject[i] == Qnil ) {
						break;
					}
					sprintf( tmp, "Becky.registered_obj[%d].OnRetrieve(BkMail.new('%s')) if Becky.registered_obj[%d].respond_to?('OnRetrieve')",i,(char *)lParam,i );
					rb_eval_string_protect( tmp , &state );
					doexec = true;
				}
				free( tmp );
			}
			break;
		case BKCALLBACK_SEND:
			{
				char *tmp;

				DEBUG_OUT( DBG_RUBY_2, "CallBack:BKCALLBACK_SEND" );

				tmp = (char *)malloc( 1024+strlen( (const char *)lParam ) );

				for ( i=0; i != CALLBACKOBJECT_MAX; i++ ) {
					if ( CallBackObject[i] == Qnil ) {
						break;
					}
					/* A'%s' Ƃ܂ */
					sprintf( tmp, "__rbecky_1__ = '%s'" ,(char *)lParam );
					rb_eval_string( tmp );
					sprintf( tmp, "Becky.registered_obj[%d].OnSend(__rbecky_1__) if Becky.registered_obj[%d].respond_to?('OnSend')",i,i );
					rb_eval_string_protect( tmp , &state );
					doexec = true;
				}
				free( tmp );
			}
			break;
		case BKCALLBACK_FINISHRETRIEVE:
			{
				char tmp[1024];

				DEBUG_OUT( DBG_RUBY_2, "CallBack:BKCALLBACK_FINISHRETRIEVE" );

				for ( i=0; i != CALLBACKOBJECT_MAX; i++ ) {
					if ( CallBackObject[i] == Qnil ) {
						break;
					}
					sprintf( tmp, "Becky.registered_obj[%d].OnFinishRetrieve(%d) if Becky.registered_obj[%d].respond_to?('OnFinishRetrieve')",i,(long)lParam,i );
					rb_eval_string_protect( tmp , &state );
					doexec = true;
				}
			}
			break;
	}

	// Ruby C^v^ŗO
	if( state != 0x00 && doexec ) {					// eval.c  TAG_RAISE
		// OWo͂
//		rb_eval_string( "print '\n[CallBack Error]\n'+$!.type.inspect+' : '+$!+'\n'" );
		DEBUG_OUT( DBG_RUBY_0, "CallBack : Exception" );
	}
	DEBUG_OUT( DBG_RUBY_1, "} CallBack : End" );

	return true;
}


int RubyItpr::GetStatus( void )
{
	return Status;
}


//---------------------------------------------------------------------------
// R\[ւ̏o
VALUE console_write( VALUE self , VALUE str )
{
	AnsiString txt;

	// łȂΕɕϊ
	if( TYPE(str) != T_STRING ) {
		str = rb_obj_as_string(str);
	}
	if( RSTRING(str)->len == 0 ) {
		return INT2FIX(0);
	}

	txt = AnsiString(RSTRING(str)->ptr);

/*
	ݗLɂȂĂR[h𖳌ɂƁAprint 邽тɉsB
*/
#if 0
	if ( *(txt.AnsiLastChar()) == '\n' ) {
		txt = txt.SetLength( txt.Length()-1 );
	}

	EditForm->RichEdit2->Lines->Add( txt );
#else
	EditForm->RichEdit2->Text = EditForm->RichEdit2->Text+txt;
#endif

	return( INT2FIX(txt.Length()) );
}


