// rc4.c
#include <windows.h>
#include "rc4.h"

static BYTE xyzzy_tmpc;

#define SWAP_BYTE(a,b) xyzzy_tmpc=a; a=b; b=xyzzy_tmpc

void
rc4Setup (LPBYTE keyDataPtr, int keyDataLen, rc4Key *key)
{
    BYTE	index1;
    BYTE	index2;
    LPBYTE	state;
    int		counter;

    state = &key->state[0];
    for (counter = 0; counter < 256; counter++)
        state[counter] = (BYTE)counter;
    key->x = 0;
    key->y = 0;
    index1 = 0;
    index2 = 0;
    for (counter = 0; counter < 256; counter++)
    {
        index2 = (BYTE)(keyDataPtr[index1] + state[counter] + index2);
        SWAP_BYTE(state[counter], state[index2]);
        index1 = (BYTE)(index1 + 1) % keyDataLen;
    }
}

void
rc4 (LPBYTE bufferPtr, int bufferLen, rc4Key *key)
{
	BYTE x;
	BYTE y;
	LPBYTE state;
	int counter;

	x = key->x;
	y = key->y;

	state = &key->state[0];
	for (counter = 0; counter < bufferLen; counter++)
	{
		x++;
		y += state[x];
		SWAP_BYTE(state[x], state[y]);
		bufferPtr[counter] ^= state[(state[x] + state[y]) & 255];
	}
	key->x = x;
	key->y = y;
}

