@ECHO OFF

rem  This script cleans IDA's map file of all unknowns,nullsubs,...
rem  and loads cleaned map into SIce.
rem
rem  CAUTION! You must include paths to SoftIce and SoftIce\Util16
rem  into autoexec.bat .
rem  And if you want you can put this file into SoftIce\Util16 directory.
rem  
rem  USE:  make [mapname] [attributes] [begining_of_the_string_to_clean (if attribute=U)]
rem              mapname is without the extensions (just the name)
rem
rem  attributes: A        is  D & L & LR & O & S & UK  (all)
rem              AU       is  A & U (all + user defined)
rem              D        cleans your map file of all 'dword_...','word_...','byte_...' addresses
rem              L        cleans your map file of all 'loc_...' addresses
rem              LR       cleans your map file of all 'locret_...' addresses
rem              O        cleans your map file of all 'off_...' addresses
rem              S        cleans your map file of all 'sub_...' addresses
rem              U        cleans your map file of all USER defined string addresses
rem              UK       cleans your map file of all 'unknown_libname_...','unk_...' addresses
rem              
rem  IF you forget the attribute or you write unknown one the script will assume your choice is A.
rem  IF everything is all right the DOS window will close when finished.
rem
rem  If something is missing or you are not pleased you can write to
rem  mostekaccess@mailcity.com
rem
rem
rem  P.S. If something is bothering you, try to do it your self and if it doesn't work
rem       than you know why I didn't make it so. :)
echo %1
IF NOT EXIST %1.map GOTO ERROR

REM >}1{.map
IF "%2"=="" GOTO A
IF "%2"=="a" GOTO A
IF "%2"=="A" GOTO A
IF "%2"=="au" GOTO UA
IF "%2"=="AU" GOTO UA
IF "%2"=="d" GOTO D
IF "%2"=="D" GOTO D
IF "%2"=="l" GOTO L
IF "%2"=="L" GOTO L
IF "%2"=="lr" GOTO LR
IF "%2"=="LR" GOTO LR
IF "%2"=="o" GOTO O
IF "%2"=="O" GOTO O
IF "%2"=="s" GOTO S
IF "%2"=="S" GOTO S
IF "%2"=="u" GOTO UA
IF "%2"=="U" GOTO UA
IF "%2"=="uk" GOTO UK
IF "%2"=="UK" GOTO UK


:A
FIND /V "dword_" %1.map | FIND /V "word_" | FIND /V "byte_" | FIND /V "loc_" | FIND /V "locret_" | FIND /V "off_" | FIND /V "sub_" |FIND /V "unknown_lib" | FIND /V "unk_" | FIND /V "----" >> }1{.map
GOTO SOFTICE

:D
FIND /V "dword_" %1.map | FIND /V "word_" | FIND /V "byte_" | FIND /V "----" >> }1{.map
GOTO SOFTICE

:L
FIND /V "loc_" %1.map | FIND /V "----" >> }1{.map
GOTO SOFTICE

:LR
FIND /V "locret_" %1.map | FIND /V "----" >> }1{.map
GOTO SOFTICE

:O
FIND /V "off_" %1.map | FIND /V "----" >> }1{.map
GOTO SOFTICE

:S
FIND /V "sub_" %1.map | FIND /V "----" >> }1{.map
GOTO SOFTICE

:UK
FIND /V "unknown_lib" %1.map | FIND /V "unk_" | FIND /V "----" >> }1{.map
GOTO SOFTICE

:UA
IF "%3"=="" GOTO ERROR
IF "%2"=="U" GOTO U
FIND /V "dword_" %1.map | FIND /V "word_" | FIND /V "byte_" | FIND /V "loc_" | FIND /V "locret_" | FIND /V "off_" | FIND /V "sub_" |FIND /V "unknown_lib" | FIND /V "unk_" | FIND /V "----" >> }1{.map
GOTO SOFTICE
:U
FIND /V "%3" %1.map | FIND /V "----" >> }1{.map

:SOFTICE
DEL %1.map
RENAME }1{.map %1.map
msym.exe %1.map
nmsym.exe %1.sym
nmsym.exe /SYM:%1.nms
DEL %1.sym
DEL %1.nms
EXIT
GOTO END

:ERROR
IF EXIST }1{.map DEL }1{.map
ECHO.
ECHO  Hmm, yep.    Error!
ECHO.
ECHO  Only two things: You misspell the map name or
ECHO                   forgot to type the "userstring".
ECHO.
:END



