#TITLE=Adams 9.1
#INFO
EditPlus Cliptext Library v1.0 written by Magnus Ahlbck, ABB Robotics AB.
This is some of the commands used during macrowriting in Adams.
#SORT=n

#T=Marker create  
marker create  &
   marker_name = $model_name.^! &
   location =  &
   orientation = 

#T=Marker create parm 
marker create  &
   marker_name = $model_name.^! &
   location = (LOC_RELATIVE_TO({0,0,0},$model_name.)) &
   orientation = (LOC_RELATIVE_TO({0d,0d,0d},$model_name.))

#T=Marker modify 
marker modify &
   marker_name = $model_name.^! &
   location =  &
   orientation = 

#T=Marker modify parm
marker modify &
   marker_name = $model_name.^! &
   location = (LOC_RELATIVE_TO({0,0,0},.$model_name.)) &
   orientation = (ORI_RELATIVE_TO({0,0,0},.$model_name.))

#T=Part Create
part create rigid_body name &
  part=$model_name.^! &
  location =   &
  orientation =

#T=Variable set real
variable set  &
   variable_name = $model_name.^!  &
   real_value = 

#T=Variable set string
variable set &
   variable_name = $model_name.^! &
   string_value = "^!"

#T=Variable set integer
variable set &
   variable_name = $model_name.^! &
   integer_value = ^!

#T=Variable set object
variable set &
   variable_name = $model_name.^! &
   object_value = ^!

#T=Request on
output_control attributes request &
   request_name = $model_name.^! &
   active = on

#T=Request off
output_control attributes request &
   request_name = $model_name.^! &
   active = off

#T=File write
file text write &
   file = $filename &
   format = "%-25s%-10s%-30s%g" &
   values = "^!","","", &
            (eval($model_name.)) &
   newline = yes

#T=If condition
if condition = ($model_name.^! == "")
  
else
  
end

#T=For
for variable=^!
  
end

#T=Entity off
entity attributes &
   entity_name = $model_name.^! &
   active = off &
   dependents_active = off

#T=Constraint off
constraint attributes &
   constraint_name = $model_name.^! &
   active = on &
   visibility = off &
   name_visibility = off 

#T=Entity on
entity attributes &
   entity_name = .$model_name.^! &
   active = on &
   dependendts_active = on

#T=MENU1   
   MENU1 ^!
     NAME=
     HELP=

#T=MENU2 
     MENU2  ^!
          NAME=
          HELP=

#T=MENU3
          MENU3  ^!
               NAME=
               HELP=

#T=BUTTON2
     BUTTON2  ^!
            NAME=
            HELP=
            CMD=interface dialog display dialog=.gui.

#T=BUTTON3
            BUTTON3  ^!
                 NAME=
                 HELP
                 CMD=interface dialog display dialog=.gui.

#T=BUTTON4
	       BUTTON4  ^!
                      NAME=
                      HELP=
                      CMD=interface dialog display dialog=.gui.

#T=SEPARATOR2
          SEPARATOR2
#T=SEPARATOR3
          SEPARATOR3
