#TITLE=PHP 4.0 Function Ref
#SORT=Y
#INFO

PHP  4.0 Function Reference with syntax.


#T=ada_afetch
ada_afetch(^!)
#T=ada_autocommit
ada_autocommit(^!)
#T=ada_close
ada_close(^!)
#T=ada_commit
ada_commit(^!)
#T=ada_connect
ada_connect(^!)
#T=ada_exec
ada_exec(^!)
#T=ada_fetchrow
ada_fetchrow(^!)
#T=ada_fieldname
ada_fieldname(^!)
#T=ada_fieldnum
#T=ada_fieldtype
#T=ada_freeresult
#T=ada_numfields
#T=ada_numrows
#T=ada_result
#T=ada_resultall
#T=ada_rollback
#T=apache_lookup_uri
class apache_lookup_uri(^!)
#T=apache_note
string apache_note(string note_ string [note_value]^!)
#T=getallheaders
array getallheaders(void^!)
#T=virtual
int virtual(string file^!)
#T=array
array array(...^!)
#T=array_push
int array_push(array array, mixed var, [...]^!)
#T=array_pop
mixed array_pop(array array^!)
#T=array_unshift
int array_unshift(array array, mixed var, [...]^!)
#T=array_shift
mixed array_shift(array array^!)
#T=array_slice
array array_slice(array array, int offset, int [length] ^!)
#T=array_splice*
array array_splice(array input, int offset, int [length] , array [replacement]^!)
#T=array_merge*
array array_merge(array array1, array array2, [ ...] ^!)
#T=array_keys*
array array_keys(array input^!)
#T=array_values*
array array_values(array input^!)
#T=array_walk
int array_walk(array arr, string func, mixed userdata^!)
#T=arsort
void arsort(array array^!)
#T=asort
void asort(array array^!)
#T=compact*
array compact(string varname | array varnames, [...]^!)
#T=count
int count(mixed var^!)
#T=current
mixed current(array array^!)
#T=each
array each(array array^!)
#T=end
end(array array^!)
#T=extract
void extract(array var_array, int [extract_type], string [prefix]^!)
#T=in_array*
bool in_array(mixed needle, array haystack^!)
#T=key
mixed key(array array^!)
#T=ksort
int ksort(array array^!)
#T=list
void list(...^!)
#T=next
mixed next(array array^!)
#T=pos
mixed pos(array array^!)
#T=prev
mixed prev(array array^!)
#T=range
array range(int low, int high^!)
#T=reset
mixed reset(array array^!)
#T=rsort
void rsort(array array^!)
#T=shuffle
void shuffle(array array^!)
#T=sizeof
int sizeof(array array^!)
#T=sort
void sort(array array^!)
#T=uasort
void uasort(array array, function cmp_function^!)
#T=uksort
void uksort(array array, function cmp_function^!)
#T=usort
void usort(array array, function cmp_function^!)
#T=aspell_new
int aspell_new(string master, string personal^!)
#T=aspell_check
boolean aspell_check(int dictionary_link, string word^!)
#T=aspell_check-raw
boolean aspell_check_raw(int dictionary_link, string word^!)
#T=aspell_suggest
array aspell_suggest(int dictionary_link, string word^!)
#T=bcadd
string bcadd(string left operand, string right operand, int [scale]^!)
#T=bccomp
int bccomp(string left operand, string right operand, int [scale]^!)
#T=bcdiv
string bcdiv(string left operand, string right operand, int [scale]^!)
#T=bcmod
string bcmod(string left operand, string modulus^!)
#T=bcmul
string bcmul(string left operand, string right operand, int [scale]^!)
#T=bcpow
string bcpow(string x, string y, int [scale]^!)
#T=bcscale
string bcscale(int scale^!)
#T=bcsqrt
string bcsqrt(string operand, int scale^!)
#T=bcsub
string bcsub(string left operand, string right operand, int [scale]^!)
#T=JDToGregorian
string jdtogregorian(int julianday^!)
#T=GregorianToJD
int gregoriantojd(int month, int day, int year^!)
#T=JDToJulian
string jdtojulian(int julianday^!)
#T=JulianToJD
int juliantojd(int month, int day, int year^!)
#T=JDToJewish
string jdtojewish(int julianday^!)
#T=JewishToJD
int jewishtojd(int month, int day, int year^!)
#T=JDToFrench
string jdtofrench(int month, int day, int year^!)
#T=FrenchToJD
int frenchtojd(int month, int day, int year^!)
#T=JDMonthName
string jdmonthname(int julianday, int mode^!)
#T=JDDayOfWeek
mixed jddayofweek(int julianday, int mode^!)
#T=easter_date
int easter_date(int year^!)
#T=easter_days
int easter_days(int year^!)
#T=cpdf_set_creator
void cpdf_set_creator(string creator^!)
#T=cpdf_set_title
void cpdf_set_title(string title^!)
#T=cpdf_set_subject
void cpdf_set_subject(string subject^!)
#T=cpdf_set_keywords
void cpdf_set_keywords(string keywords^!)
#T=cpdf_open
int cpdf_open(int compression, string filename^!)
#T=cpdf_close
void cpdf_close(int pdf document^!)
#T=cpdf_page_init
void cpdf_page_init(int pdf document, int page number, int orientation, double height, double width, double unit^!)
#T=cpdf_finalize_page
void cpdf_finalize_page(int pdf document, int page number^!)
#T=cpdf_finalize
void cpdf_finalize(int pdf document^!)
#T=cpdf_output_buffer
void cpdf_output_buffer(int pdf document^!)
#T=cpdf_save_to_file
void cpdf_save_to_file(int pdf document, string filename^!)
#T=cpdf_set_current_page
void cpdf_set_current_page(int pdf document, int page number^!)
#T=cpdf_begin_text
void cpdf_begin_text(int pdf document^!)
#T=cpdf_end_text
void cpdf_end_text(int pdf document^!)
#T=cpdf_show
void cpdf_show(int pdf document, string text^!)
#T=cpdf_show_xy
void cpdf_show_xy(int pdf document, string text, double x-koor, double y-koor, int mode^!)
#T=cpdf_text
void cpdf_text(int pdf document, string text, double x-koor, double y-koor, int mode, double orientation, int alignmode^!)
#T=cpdf_set_font
void cpdf_set_font(int pdf document, string font name, double size, int encoding^!)
#T=cpdf_set_leading
void cpdf_set leading(int pdf document, double distance^!)
#T=cpdf_set_text_rendering
void cpdf_set_text_rendering(int pdf document, int mode^!)
#T=cpdf_set_horiz_scaling
void cpdf_set_horiz_scaling(int pdf document, double scale^!)
#T=cpdf_set_text_rise
void cpdf_set_text_rise(int pdf document, double value^!)
#T=cpdf_set_text_matrix
void cpdf_set_text_matrix(int pdf document, array matrix^!)
#T=cpdf_set_text_pos
void cpdf_set_text_pos(int pdf document, double x-koor, double y-koor, int mode^!)
#T=cpdf_set_char_spacing
void cpdf_set_char_spacing(int pdf document, double space^!)
#T=cpdf_set_word_spacing
void cpdf_set_word_spacing(int pdf document, double space^!)
#T=cpdf_continue_text
void cpdf_continue_text(int pdf document, string text^!)
#T=cpdf_stringwidth
double cpdf_stringwidth(int pdf document, string text^!)
#T=cpdf_save
void cpdf_save(int pdf document^!)
#T=cpdf_restore
void cpdf_restore(int pdf document^!)
#T=cpdf_translate
void cpdf_translate(int pdf document, double x-koor, double y-koor, int mode^!)
#T=cpdf_scale
void cpdf_scale(int pdf document, double x-scale, double y-scale^!)
#T=cpdf_rotate
void cpdf_rotate(int pdf document, double angle^!)
#T=cpdf_setflat
void cpdf_setflat(int pdf document, double value^!)
#T=cpdf_setlinejoin
void cpdf_setlinejoin(int pdf document, long value^!)
#T=cpdf_setlinecap
void cpdf_setlinecap(int pdf document, int value^!)
#T=cpdf_setmiterlimit
void cpdf_setmiterlimit(int pdf document, double value^!)
#T=cpdf_setlinewidth
void cpdf_setlinewidth(int pdf document, double width^!)
#T=cpdf_setdash
void cpdf_setdash(int pdf document, double white, double black^!)
#T=cpdf_moveto
void cpdf_moveto(int pdf document, double x-koor, double y-koor, int mode^!)
#T=cpdf_rmoveto
void cpdf_rmoveto(int pdf document, double x-koor, double y-koor, int mode^!)
#T=cpdf_curveto
void cpdf_curveto(int pdf document, double x1, double y1, double x2, double y2, double x3, double y3, int mode^!)
#T=cpdf_lineto
void cpdf_lineto(int pdf document, double x-koor, double y-koor, int mode^!)
#T=cpdf_rlineto
void cpdf_rlineto(int pdf document, double x-koor, double y-koor, int mode^!)
#T=cpdf_circle
void cpdf_circle(int pdf document, double x-koor, double y-koor, double radius, int mode^!)
#T=cpdf_arc
void cpdf_arc(int pdf document, double x-koor, double y-koor, double radius, double start, double end, int mode^!)
#T=cpdf_rect
void cpdf_rect(int pdf document, double x-koor, double y-koor, double width, double height, int mode^!)
#T=cpdf_closepath
void cpdf_closepath(int pdf document^!)
#T=cpdf_stroke
void cpdf_stroke(int pdf document^!)
#T=cpdf_closepath_stroke
void cpdf_closepath_stroke(int pdf document^!)
#T=cpdf_fill
void cpdf_fill(int pdf document^!)
#T=cpdf_fill_stroke
void cpdf_fill_stroke(int pdf document^!)
#T=cpdf_closepath_fill_stroke
void cpdf_closepath_fill_stroke(int pdf document^!)
#T=cpdf_clip
void cpdf_clip(int pdf document^!)
#T=cpdf_setgray_fill
void cpdf_setgray_fill(int pdf document, double value^!)
#T=cpdf_setgray_stroke
void cpdf_setgray_stroke(int pdf document, double gray value^!)
#T=cpdf_setgray
void cpdf_setgray(int pdf document, double gray value^!)
#T=cpdf_setrgbcolor_fill
void cpdf_setrgbcolor_fill(int pdf document, double red value, double green value, double blue value^!)
#T=cpdf_setrgbcolor_stroke
void cpdf_setrgbcolor_stroke(int pdf document, double red value, double green value, double blue value^!)
#T=cpdf_setrgbcolor
void cpdf_setrgbcolor(int pdf document, double red value, double green value, double blue value^!)
#T=cpdf_add_outline
void cpdf_add_outline(int pdf document, string text^!)
#T=cpdf_set_page_animation
void cpdf_set_page_animation(int pdf document, int transition, double duration^!)
#T=cpdf_import_jpeg
int cpdf_open_jpeg(int pdf document, string file name, double x-koor, double y-koor, double angle, double width, double height, double x-scale, double y-scale, int mode^!)
#T=cpdf_place_inline_image
void cpdf_place_inline_image(int pdf document, int image, double x-koor, double y-koor, double angle, double width, double height, int mode^!)
#T=cpdf_add_annotation
void cpdf_add_annotation(int pdf document, double llx, double lly, double urx, double ury, string title, string content, int mode^!)
#T=checkdate
int checkdate(int month, int day, int year^!)
#T=date
string date(string format, int [timestamp] ^!)
#T=strftime
string strftime(string format, int timestamp^!)
#T=gmstrftime
string gmstrftime(string format, int timestamp^!)
#T=getdate
array getdate(int timestamp^!)
#T=gettimeofday
array gettimeofday(void^!)
#T=gmdate
string gmdate(string format, int timestamp^!)
#T=mktime
int mktime(int hour, int minute, int second, int month, int day, int year, int [is_dst]^!)
#T=gmmktime
int gmmktime(int hour, int minute, int second, int month, int day, int year, int [is_dst]^!)
#T=time
int time(void^!)
#T=microtime
string microtime(void^!)
#T=dba_close
void dba_close(int handle^!)
#T=dba_delete
string dba_delete(string key, int handle^!)
#T=dba_exists
bool dba_exists(string key, int handle^!)
#T=dba_fetch
string dba_fetch(string key, int handle^!)
#T=dba_firstkey
string dba_firstkey(int handle^!)
#T=dba_insert
bool dba_insert(string key, string value, int handle^!)
#T=dba_nextkey
string dba_nextkey(int handle^!)
#T=dba_popen
int dba_popen(string path, string mode, string handler, [...]^!)
#T=dba_open
int dba_open(string path, string mode, string handler, [...]^!)
#T=dba_optimize
bool dba_optimize(int handle^!)
#T=dba_replace
bool dba_replace(string key, string value, int handle^!)
#T=dba_sync
bool dba_sync(int handle^!)
#T=dbase_create
int dbase_create(string filename, array fields^!)
#T=dbase_open
int dbase_open(string filename, int flags^!)
#T=dbase_close
bool dbase_close(int dbase_identifier^!)
#T=dbase_pack
bool dbase_pack(int dbase_identifier^!)
#T=dbase_add_record
bool dbase_add_record(int dbase_identifier, array record^!)
#T=dbase_replace_record
bool dbase_replace_record(int dbase_identifier, array record, int dbase_record_number^!)
#T=dbase_delete_record
bool dbase_delete_record(int dbase_identifier, int record^!)
#T=dbase_get_record
array dbase_get_record(int dbase_identifier, int record^!)
#T=dbase_get_record_with_names
array dbase_get_record_with_names(int dbase_identifier, int record^!)
#T=dbase_numfields
int dbase_numfields(int dbase_identifier^!)
#T=dbase_numrecords
int dbase_numrecords(int dbase_identifier^!)
#T=dbmopen
int dbmopen(string filename, string flags^!)
#T=dbmclose
bool dbmclose(int dbm_identifier^!)
#T=dbmexists
bool dbmexists(int dbm_identifier, string key^!)
#T=dbmfetch
string dbmfetch(int dbm_identifier, string key^!)
#T=dbminsert
int dbminsert(int dbm_identifier, string key, string value^!)
#T=dbmreplace
bool dbmreplace(int dbm_identifier, string key, string value^!)
#T=dbmdelete
bool dbmdelete(int dbm_identifier, string key^!)
#T=dbmfirstkey
string dbmfirstkey(int dbm_identifier^!)
#T=dbmnextkey
string dbmnextkey(int dbm_identifier, string key^!)
#T=dblist
string dblist(void^!)
#T=chdir
int chdir(string directory^!)
#T=dir
new dir(string directory^!)
#T=closedir
void closedir(int dir_handle^!)
#T=opendir
int opendir(string path^!)
#T=readdir
string readdir(int dir_handle^!)
#T=rewinddir
void rewinddir(int dir_handle^!)
#T=dl
int dl(string library^!)
#T=escapeshellcmd
string escapeshellcmd(string command^!)
#T=exec
string exec(string command, string [array], int [return_var]^!)
#T=system
string system(string command, int [return_var]^!)
#T=passthru
string passthru(string command, int [return_var]^!)
#T=fdf_open
int fdf_open(string filename^!)
#T=fdf_close
void fdf_close(int fdf_document^!)
#T=fdf_create
int fdf_create(void ^!)
#T=fdf_save
int fdf_save(string filename^!)
#T=fdf_get_value
string fdf_get_value(int fdf_document, string fieldname^!)
#T=fdf_set_value
void fdf_set_value(int fdf_document, string fieldname, string value, int isName^!)
#T=fdf_next_field_name
string fdf_next_field_name(int fdf_document, string fieldname^!)
#T=fdf_set_ap
void fdf_set_ap(int fdf_document, string field_name, int face, string filename, int page_number^!)
#T=fdf_set_status
void fdf_set_status(int fdf_document, string status^!)
#T=fdf_get_status
string fdf_get_status(int fdf_document^!)
#T=fdf_set_file
void fdf_set_file(int fdf_document, string filename^!)
#T=fdf_get_file
string fdf_get_file(int fdf_document^!)
#T=filepro
bool filepro(string directory^!)
#T=filepro_fieldname
string filepro_fieldname(int field_number^!)
#T=filepro_fieldtype
string filepro_fieldtype(int field_number^!)
#T=filepro_fieldwidth
int filepro_fieldwidth(int field_number^!)
#T=filepro_retrieve
string filepro_retrieve(int row_number, int field_number^!)
#T=filepro_fieldcount
int filepro_fieldcount(void^!)
#T=filepro_rowcount
int filepro_rowcount(void^!)
#T=basename
string basename(string path^!)
#T=chgrp
int chgrp(string filename, mixed group^!)
#T=chmod
int chmod(string filename, int mode^!)
#T=chown
int chown(string filename, mixed user^!)
#T=clearstatcache
void clearstatcache(void^!)
#T=copy
int copy(string source, string dest^!)
#T=delete
void delete(string file^!)
#T=dirname
string dirname(string path^!)
#T=diskfreespace
float diskfreespace(string directory^!)
#T=fclose
int fclose(int fp^!)
#T=feof
int feof(int fp^!)
#T=fgetc
string fgetc(int fp^!)
#T=fgetcsv
array fgetcsv(int fp, int length, string [delimiter]^!)
#T=fgets
string fgets(int fp, int length^!)
#T=fgetss
string fgetss(int fp, int length^!)
#T=file
array file(string filename^!)
#T=file_exists
int file_exists(string filename^!)
#T=fileatime
int fileatime(string filename^!)
#T=filectime
int filectime(string filename^!)
#T=filegroup
int filegroup(string filename^!)
#T=fileinode
int fileinode(string filename^!)
#T=filemtime
int filemtime(string filename^!)
#T=fileowner
int fileowner(string filename^!)
#T=fileperms
int fileperms(string filename^!)
#T=filesize
int filesize(string filename^!)
#T=filetype
string filetype(string filename^!)
#T=flock
bool flock(int fp, int operation^!)
#T=fopen
int fopen(string filename, string mode^!)
#T=fpassthru
int fpassthru(int fp^!)
#T=fputs
int fputs(int fp, string str, int [length]^!)
#T=fread
string fread(int fp, int length^!)
#T=fseek
int fseek(int fp, int offset^!)
#T=ftell
int ftell(int fp^!)
#T=fwrite
int fwrite(int fp, string string, int [length]^!)
#T=set_file_buffer
int fwrite(int fp, int buffer^!)
#T=is_dir
bool is_dir(string filename^!)
#T=is_executable
bool is_executable(string filename^!)
#T=is_file
bool is_file(string filename^!)
#T=is_link
bool is_link(string filename^!)
#T=is_readable
bool is_readable(string filename^!)
#T=is_writeable
bool is_writeable(string filename^!)
#T=link
int link(string target, string link^!)
#T=linkinfo
int linkinfo(string path^!)
#T=mkdir
int mkdir(string pathname, int mode^!)
#T=pclose
int pclose(int fp^!)
#T=popen
int popen(string command, string mode^!)
#T=readfile
int readfile(string filename^!)
#T=readlink
string readlink(string path^!)
#T=rename
int rename(string oldname, string newname^!)
#T=rewind
int rewind(int fp^!)
#T=rmdir
int rmdir(string dirname^!)
#T=stat
array stat(string filename^!)
#T=lstat
array lstat(string filename^!)
#T=symlink
int symlink(string target, string link^!)
#T=tempnam
string tempnam(string dir, string prefix^!)
#T=touch
int touch(string filename, int time^!)
#T=umask
int umask(int mask^!)
#T=unlink
int unlink(string filename^!)
#T=header
int header(string string^!)
#T=setcookie
int setcookie(string name, string value, int expire, string path, string domain, int secure^!)
#T=hw_Children
array hw_children(int connection, int objectID^!)
#T=hw_ChildrenObj
array hw_childrenobj(int connection, int objectID^!)
#T=hw_Close
int hw_close(int connection^!)
#T=hw_Connect
int hw_connect(string host, int port, string username, string password^!)
#T=hw_Cp
int hw_cp(int connection, array object_id_array, int destination id^!)
#T=hw_Deleteobject
int hw_deleteobject(int connection, int object_to_delete^!)
#T=hw_DocByAnchor
int hw_docbyanchor(int connection, int anchorID^!)
#T=hw_DocByAnchorObj
string hw_docbyanchorobj(int connection, int anchorID^!)
#T=hw_DocumentAttributes
string hw_documentattributes(int hw_document^!)
#T=hw_DocumentBodyTag
string hw_documentbodytag(int hw_document^!)
#T=hw_DocumentContent
string hw_documentcontent(int hw_document^!)
#T=hw_DocumentSetContent
string hw_documentsetcontent(int hw_document, string content^!)
#T=hw_DocumentSize
int hw_documentsize(int hw_document^!)
#T=hw_ErrorMsg
string hw_errormsg(int connection^!)
#T=hw_EditText
int hw_edittext(int connection, int hw_document^!)
#T=hw_Error
int hw_error(int connection^!)
#T=hw_Free_Document
int hw_free_document(int hw_document^!)
#T=hw_GetParents
array hw_getparentsobj(int connection, int objectID^!)
#T=hw_GetParentsObj
array hw_getparentsobj(int connection, int objectID^!)
#T=hw_GetChildColl
array hw_getchildcoll(int connection, int objectID^!)
#T=hw_GetChildCollObj
array hw_getchildcollobj(int connection, int objectID^!)
#T=hw_GetRemote
int hw_getremote(int connection, int objectID^!)
#T=hw_GetRemoteChildren
int hw_getremotechildren(int connection, string object record^!)
#T=hw_GetSrcByDestObj
array hw_getsrcbydestobj(int connection, int objectID^!)
#T=hw_GetObject
array hw_getobject(int connection, [int|array] objectID, string query^!)
#T=hw_GetAndLock
string hw_getandlock(int connection, int objectID^!)
#T=hw_GetText
int hw_gettext(int connection, int objectID, mixed [rootID/prefix] ^!)
#T=hw_GetObjectByQuery
array hw_getobjectbyquery(int connection, string query, int max_hits^!)
#T=hw_GetObjectByQueryObj
array hw_getobjectbyqueryobj(int connection, string query, int max_hits^!)
#T=hw_GetObjectByQueryColl
array hw_getobjectbyquerycoll(int connection, int objectID, string query, int max_hits^!)
#T=hw_GetObjectByQueryCollObj
array hw_getobjectbyquerycollobj(int connection, int objectID, string query, int max_hits^!)
#T=hw_GetChildDocColl
array hw_getchilddoccoll(int connection, int objectID^!)
#T=hw_GetChildDocCollObj
array hw_getchilddoccollobj(int connection, int objectID^!)
#T=hw_GetAnchors
array hw_getanchors(int connection, int objectID^!)
#T=hw_GetAnchorsObj
array hw_getanchorsobj(int connection, int objectID^!)
#T=hw_Mv
int hw_mv(int connection, array object id array, int source id, int destination id^!)
#T=hw_Identify
int hw_identify(string username, string password^!)
#T=hw_InCollections
array hw_incollections(int connection, array object_id_array, array collection_id_array, int return_collections^!)
#T=hw_Info
string hw_info(int connection^!)
#T=hw_InsColl
int hw_inscoll(int connection, int objectID, array object_array^!)
#T=hw_InsDoc
int hw_insdoc(int connection, int parentID, string object_record, string text^!)
#T=hw_InsertDocument
int hw_insertdocument(int connection, int parent_id, int hw_document^!)
#T=hw_InsertObject
int hw_insertobject(int connection, string object rec, string parameter^!)
#T=hw_Modifyobject
int hw_modifyobject(int connection, int object_to_change, array remove, array add, int mode^!)
#T=hw_New_Document
int hw_new_document(string object_record, string document_data, int document_size^!)
#T=hw_Objrec2Array
array hw_objrec2array(string object_record^!)
#T=hw_OutputDocument
int hw_outputdocument(int hw_document^!)
#T=hw_pConnect
int hw_pconnect(string host, int port, string username, string password^!)
#T=hw_PipeDocument
int hw_pipedocument(int connection, int objectID^!)
#T=hw_Root
int hw_root(^!)
#T=hw_Unlock
int hw_unlock(int connection, int objectID^!)
#T=hw_Who
int hw_who(int connection^!)
#T=hw_Username
string hw_getusername(int connection^!)
#T=icap_open
stream icap_open(stringcalendar, stringusername, stringpassword, stringoptions^!)
#T=icap_close
int icap_close(int icap_stream, int flags^!)
#T=icap_fetch_event
objecticap_fetch_event(streamicap_stream, idevent id, optionsoptions^!)
#T=icap_list_events
array icap_list_events(stream icap_stream, datetime begin_date, datetime end_date^!)
#T=icap_store_event
int icap_store_event(int icap_stream, object event^!)
#T=icap_delete_event
int icap_delete_event(int uid^!)
#T=icap_snooze
int icap_snooze(int uid^!)
#T=icap_list_alarms
array icap_list_alarms(stream icap_stream, datetime alarm_date^!)
#T=GetImageSize
array getimagesize(string filename, array [imageinfo]^!)
#T=ImageArc
int imagearc(int im, int cx, int cy, int w, int h, int s, int e, int col^!)
#T=ImageChar
int imagechar(int im, int font, int x, int y, string c, int col^!)
#T=ImageCharUp
int imagecharup(int im, int font, int x, int y, string c, int col^!)
#T=ImageColorAllocate
int imagecolorallocate(int im, int red, int green, int blue^!)
#T=ImageColorTransparent
int imagecolortransparent(int im, int [col]^!)
#T=ImageCopyResized
int imagecopyresized(int dst_im, int src_im, int dstX, int dstY, int srcX, int srcY, int dstW, int dstH, int srcW, int srcH^!)
#T=ImageCreate
int imagecreate(int x_size, int y_size^!)
#T=ImageCreateFromGif
int imagecreatefromgif(string filename^!)
#T=ImageDashedLine
int imagedashedline(int im, int x1, int y1, int x2, int y2, int col^!)
#T=ImageDestroy
int imagedestroy(int im^!)
#T=ImageFill
int imagefill(int im, int x, int y, int col^!)
#T=ImageFilledPolygon
int imagefilledpolygon(int im, array points, int num_points, int col^!)
#T=ImageFilledRectangle
int imagefilledrectangle(int im, int x1, int y1, int x2, int y2, int col^!)
#T=ImageFillToBorder
int imagefilltoborder(int im, int x, int y, int border, int col^!)
#T=ImageFontHeight
int imagefontheight(int font^!)
#T=ImageFontWidth
int imagefontwidth(int font^!)
#T=ImageGif
int imagegif(int im, string filename^!)
#T=ImageInterlace
int imageinterlace(int im, int [interlace]^!)
#T=ImageLine
int imageline(int im, int x1, int y1, int x2, int y2, int col^!)
#T=ImageLoadFont
int imageloadfont(string file^!)
#T=ImagePolygon
int imagepolygon(int im, array points, int num_points, int col^!)
#T=ImageRectangle
int imagerectangle(int im, int x1, int y1, int x2, int y2, int col^!)
#T=ImageSetPixel
int imagesetpixel(int im, int x, int y, int col^!)
#T=ImageString
int imagestring(int im, int font, int x, int y, string s, int col^!)
#T=ImageStringUp
int imagestringup(int im, int font, int x, int y, string s, int col^!)
#T=ImageSX
int imagesx(int im^!)
#T=ImageSY
int imagesy(int im^!)
#T=ImageTTFBBox
array ImageTTFBBox(int size, int angle, string fontfile, string text^!)
#T=ImageTTFText
array ImageTTFText(int im, int size, int angle, int x, int y, int col, string fontfile, string text^!)
#T=ImageColorAt
int imagecolorat(int im, int x, int y^!)
#T=ImageColorClosest
int imagecolorclosest(int im, int red, int green, int blue^!)
#T=ImageColorExact
int imagecolorexact(int im, int red, int green, int blue^!)
#T=ImageColorResolve
int imagecolorresolve(int im, int red, int green, int blue^!)
#T=ImageColorSet
bool imagecolorset(int im, int index, int red, int green, int blue^!)
#T=ImageColorsForIndex
array imagecolorsforindex(int im, int index^!)
#T=ImageColorsTotal
int imagecolorstotal(int im^!)
#T=ImagePSLoadFont
int imagepsloadfont(string filename^!)
#T=ImagePSFreeFont
void imagepsfreefont(int fontindex^!)
#T=ImagePSEncodeFont
int imagepsencodefont(string encodingfile^!)
#T=ImagePSText
ImagePSText - to draw a text string over an image using PostScript Type1 fonts
#T=ImagePSBBox
array imagepsbbox(string text, int font, int size, int space, int width, float angle^!)
#T=imap_append
int imap_append(int imap_stream, string mbox, string message, stringflags^!)
#T=imap_base64
string imap_base64(string text^!)
#T=imap_body
string imap_body(int imap_stream, int msg_number, int flags^!)
#T=imap_check
array imap_check(int imap_stream^!)
#T=imap_close
int imap_close(int imap_stream, int flags^!)
#T=imap_createmailbox
int imap_createmailbox(int imap_stream, string mbox^!)
#T=imap_delete
int imap_delete(int imap_stream, int msg_number^!)
#T=imap_deletemailbox
int imap_deletemailbox(int imap_stream, string mbox^!)
#T=imap_expunge
int imap_expunge(int imap_stream^!)
#T=imap_fetchbody
string imap_fetchbody(int imap_stream, int msg_number, string part_number, flags flags^!)
#T=imap_fetchstructure
array imap_fetchstructure(int imap_stream, int msg_number^!)
#T=imap_header
object imap_header(int imap_stream, int msg_number, int fromlength, int subjectlength, int defaulthost^!)
#T=imap_headers
array imap_headers(int imap_stream^!)
#T=imap_listmailbox
array imap_listmailbox(int imap_stream, string ref, string pat^!)
#T=imap_getmailboxes
array imap_getmailboxes(int imap_stream, string ref, string pat^!)
#T=imap_listsubscribed
array imap_listsubscribed(int imap_stream, string ref, string pattern^!)
#T=imap_getsubscribed
array imap_getsubscribed(int imap_stream, string ref, string pattern^!)
#T=imap_mail_copy
int imap_mail_copy(int imap_stream, string msglist, string mbox, int flags^!)
#T=imap_mail_move
int imap_mail_move(int imap_stream, string msglist, string mbox^!)
#T=imap_num_msg
int imap_num_msg(int stream_id^!)
#T=imap_num_recent
int imap_num_recent(int imap_stream^!)
#T=imap_open
int imap_open(string mailbox, string username, string password, int flags^!)
#T=imap_ping
int imap_ping(int imap_stream^!)
#T=imap_renamemailbox
int imap_renamemailbox(int imap_stream, string old_mbox, string new_mbox^!)
#T=imap_reopen
int imap_reopen(string imap_stream, string mailbox, string [flags]^!)
#T=imap_subscribe
int imap_subscribe(int imap_stream, string mbox^!)
#T=imap_undelete
int imap_undelete(int imap_stream, int msg_number^!)
#T=imap_unsubscribe
int imap_unsubscribe(int imap_stream, string mbox^!)
#T=imap_qprint
string imap_qprint(string string^!)
#T=imap_8bit
string imap_8bit(string string^!)
#T=imap_binary
string imap_binary(string string^!)
#T=imap_scanmailbox
array imap_scanmailbox(int imap_stream, string string^!)
#T=imap_mailboxmsginfo
array imap_mailboxmsginfo(int imap_stream^!)
#T=imap_rfc822_write_address
string imap_rfc822_write_address(string mailbox, string host, string personal^!)
#T=imap_rfc822_parse_adrlist
string imap_rfc822_parse_adrlist(string address, string default_host^!)
#T=imap_setflag_full
string imap_setflag_full(int stream, string sequence, string flag, string options^!)
#T=imap_clearflag_full
string imap_clearflag_full(int stream, string sequence, string flag, string options^!)
#T=imap_sort
string imap_sort(int stream, int criteria, int reverse, int options^!)
#T=imap_fetchheader
stringimap_fetchheader(int imap_stream, int msgno, int flags^!)
#T=imap_uid
int imap_uid(int imap_stream, int msgno^!)
#T=imap_msgno
int imap_msgno(int imap_stream, int uid^!)
#T=imap_search
array imap_search(int imap_stream, string criteria, int flags^!)
#T=imap_last_error
string imap_last_error(void ^!)
#T=imap_errors
array imap_errors(void ^!)
#T=imap_alerts
array imap_alerts(void ^!)
#T=imap_status
object imap_status(int imap_stream, string mailbox, int options^!)
#T=error_log
int error_log(string message, int message_type, string [destination], string [extra_headers]^!)
#T=error_reporting
int error_reporting(int [level]^!)
#T=getenv
string getenv(string varname^!)
#T=get_cfg_var
string get_cfg_var(string varname^!)
#T=get_current_user
string get_current_user(void^!)
#T=get_magic_quotes_gpc
long get_magic_quotes_gpc(void^!)
#T=get_magic_quotes_runtime
long get_magic_quotes_runtime(void^!)
#T=getlastmod
int getlastmod(void^!)
#T=getmyinode
int getmyinode(void^!)
#T=getmypid
int getmypid(void^!)
#T=getmyuid
int getmyuid(void^!)
#T=getrusage
array getrusage(int [who]^!)
#T=phpinfo
int phpinfo(void^!)
#T=phpversion
string phpversion(void^!)
#T=extension_loaded
bool extension_loaded(string name^!)
#T=putenv
void putenv(string setting^!)
#T=set_magic_quotes_runtime
long set_magic_quotes_runtime(int new_setting^!)
#T=set_time_limit
void set_time_limit(int seconds^!)
#T=ifx_connect
int ifx_connect(string [database] , string [userid] , string [password] ^!)
#T=ifx_pconnect
int ifx_pconnect(string [database] , string [userid] , string [password] ^!)
#T=ifx_close
int ifx_close(int [link_identifier] ^!)
#T=ifx_query
int ifx_query(string query, int [link_identifier] , int [cursor_type] , mixed [blobidarray] ^!)
#T=ifx_prepare
int ifx_prepare(string query, int conn_id, int [cursor_def], mixed blobidarray^!)
#T=ifx_do
int ifx_do(int result_id^!)
#T=ifx_error
string ifx_error(void^!)
#T=ifx_errormsg
string ifx_errormsg(int [errorcode]^!)
#T=ifx_affected_rows
int ifx_affected_rows(int result_id^!)
#T=ifx_getsqlca
array ifx_getsqlca(int result_id^!)
#T=ifx_fetch_row
array ifx_fetch_row(int result_id, mixed [position] ^!)
#T=ifx_htmltbl_result
int ifx_htmltbl_result(int result_id, string [html_table_options]^!)
#T=ifx_fieldtypes
array ifx_fieldtypes(int result_id^!)
#T=ifx_fieldproperties
array ifx_fieldproperties(int result_id^!)
#T=ifx_num_fields
int ifx_num_fields(int result_id^!)
#T=ifx_num_rows
int ifx_num_rows(int result_id^!)
#T=ifx_free_result
int ifx_free_result(int result_id^!)
#T=ifx_create_char
int ifx_create_char(string param^!)
#T=ifx_free_char
int ifx_free_char(int bid^!)
#T=ifx_update_char
int ifx_update_char(int bid, string content^!)
#T=ifx_get_char
int ifx_get_char(int bid^!)
#T=ifx_create_blob
int ifx_create_blob(int type, int mode, string param^!)
#T=ifx_copy_blob
int ifx_copy_blob(int bid^!)
#T=ifx_free_blob
int ifx_free_blob(int bid^!)
#T=ifx_get_blob
int ifx_get_blob(int bid^!)
#T=ifx_update_blob
ifx_update_blob(int bid, string content^!)
#T=ifx_blobinfile_mode
void ifx_blobinfile_mode(int mode^!)
#T=ifx_textasvarchar
void ifx_textasvarchar(int mode^!)
#T=ifx_byteasvarchar
void ifx_byteasvarchar(int mode^!)
#T=ifx_nullformat
void ifx_nullformat(int mode^!)
#T=ifxus_create_slob
int ifxus_create_slob(int mode^!)
#T=ifx_free_slob
int ifxus_free_slob(int bid^!)
#T=ifxus_close_slob
int ifxus_close_slob(int bid^!)
#T=ifxus_open_slob
int ifxus_open_slob(long bid, int mode^!)
#T=ifxus_tell_slob
int ifxus_tell_slob(long bid^!)
#T=ifxus_seek_slob
int ifxus_seek_blob(long bid, int mode, long offset^!)
#T=ifxus_read_slob
int ifxus_read_slob(long bid, long nbytes^!)
#T=ifxus_write_slob
int ifxus_write_slob(long bid, string content^!)
#T=ibase_connect
#T=ibase_pconnect
#T=ibase_close
#T=ibase_query
#T=ibase_fetch_row
#T=ibase_free_result
#T=ibase_prepare
#T=ibase_bind
#T=ibase_execute
#T=ibase_free_query
#T=ibase_timefmt
#T=ldap_add
int ldap_add(int link_identifier, string dn, array entry^!)
#T=ldap_mod_add
int ldap_mod_add(int link_identifier, string dn, array entry^!)
#T=ldap_mod_del
int ldap_mod_del(int link_identifier, string dn, array entry^!)
#T=ldap_mod_replace
int ldap_mod_replace(int link_identifier, string dn, array entry^!)
#T=ldap_bind
int ldap_bind(int link_identifier, string [bind_rdn], string [bind_password]^!)
#T=ldap_close
int ldap_close(int link_identifier^!)
#T=ldap_connect
int ldap_connect(string [hostname], int [port]^!)
#T=ldap_count_entries
int ldap_count_entries(int link_identifier, int result_identifier^!)
#T=ldap_delete
int ldap_delete(int link_identifier, string dn^!)
#T=ldap_dn2ufn
string ldap_dn2ufn(string dn^!)
#T=ldap_explode_dn
array ldap_explode_dn(string dn, int with_attrib^!)
#T=ldap_first_attribute
string ldap_first_attribute(int link_identifier, int result_entry_identifier, int ber_identifier^!)
#T=ldap_first_entry
int ldap_first_entry(int link_identifier, int result_identifier^!)
#T=ldap_free_result
int ldap_free_result(int result_identifier^!)
#T=ldap_get_attributes
array ldap_get_attributes(int link_identifier, int result_entry_identifier^!)
#T=ldap_get_dn
string ldap_get_dn(int link_identifier, int result_entry_identifier^!)
#T=ldap_get_entries
array ldap_get_entries(int link_identifier, int result_identifier^!)
#T=ldap_get_values
array ldap_get_values(int link_identifier, int result_entry_identifier, string attribute^!)
#T=ldap_list
int ldap_list(int link_identifier, string base_dn, string filter, array [attributes]^!)
#T=ldap_modify
int ldap_modify(int link_identifier, string dn, array entry^!)
#T=ldap_next_attribute
string ldap_next_attribute(int link_identifier, int result_entry_identifier, int ber_identifier^!)
#T=ldap_next_entry
int ldap_next_entry(int link_identifier, int result_entry_identifier^!)
#T=ldap_read
int ldap_read(int link_identifier, string base_dn, string filter, array [attributes]^!)
#T=ldap_search
int ldap_search(int link_identifier, string base_dn, string filter, array [attributes]^!)
#T=ldap_unbind
int ldap_unbind(int link_identifier^!)
#T=mail
bool mail(string to, string subject, string message, string [additional_headers]^!)
#T=Abs
mixed abs(mixed number^!)
#T=Acos
float acos(float arg^!)
#T=Asin
float asin(float arg^!)
#T=Atan
float atan(float arg^!)
#T=Atan2
float atan2(float y, float x^!)
#T=base_convert
strin base_convert(string number, int frombase, int tobase^!)
#T=BinDec
int bindec(string binary_string^!)
#T=Ceil
int ceil(float number^!)
#T=Cos
float cos(float arg^!)
#T=DecBin
string decbin(int number^!)
#T=DecHex
string dechex(int number^!)
#T=DecOct
string decoct(int number^!)
#T=Exp
float exp(float arg^!)
#T=Floor
int floor(float number^!)
#T=getrandmax
int getrandmax(void ^!)
#T=HexDec
int hexdec(string hex_string^!)
#T=Log
float log(float arg^!)
#T=Log10
float log10(float arg^!)
#T=max
mixed max(mixed arg1, mixed arg2, mixed argn^!)
#T=min
mixed min(mixed arg1, mixed arg2, mixed argn^!)
#T=mt_rand
int mt_rand([int min], [int max]^!)
#T=mt_srand
void mt_srand(int seed^!)
#T=mt_getrandmax
int mt_getrandmax(void ^!)
#T=number_format
string number_format(float number, int decimals, string dec_point, string thousands_sep^!)
#T=OctDec
int octdec(string octal_string^!)
#T=pi
double pi(void ^!)
#T=pow
float pow(float base, float exp^!)
#T=rand
int rand([int min], [int max]^!)
#T=round
double round(double val^!)
#T=Sin
float sin(float arg^!)
#T=Sqrt
float sqrt(float arg^!)
#T=srand
void srand(int seed^!)
#T=Tan
float tan(float arg^!)
#T=mcrypt_get_cipher_name
string mcrypt_get_cipher_name(int cipher^!)
#T=mcrypt_get_block_size
int mcrypt_get_block_size(int cipher^!)
#T=mcrypt_get_key_size
int mcrypt_get_key_size(int cipher^!)
#T=mcrypt_create_iv
string mcrypt_create_iv(int size, int source^!)
#T=mcrypt_cbc
int mcrypt_cbc(int cipher, string key, string data, int mode, string [iv]^!)
#T=mcrypt_cfb
int mcrypt_cfb(int cipher, string key, string data, int mode, string iv^!)
#T=mcrypt_ecb
int mcrypt_ecb(int cipher, string key, string data, int mode^!)
#T=mcrypt_ofb
int mcrypt_ofb(int cipher, string key, string data, int mode, string iv^!)
#T=mhash_get_hash_name
string mhash_get_hash_name(int hash^!)
#T=mhash_get_block_size
int mhash_get_block_size(int hash^!)
#T=mhash_count
int mhash_count(void ^!)
#T=mhash
string mhash(int hash, string data^!)
#T=connection_aborted
int connection_aborted(void ^!)
#T=connection_status
int connection_status(void ^!)
#T=connection_timeout
int connection_timeout(void ^!)
#T=eval
void eval(string code_str^!)
#T=die
void die(string message^!)
#T=exit
void exit(void^!)
#T=function_exists
int function_exists(string function_name^!)
#T=ignore_user_abort
int ignore_user_abort(int [setting]^!)
#T=iptcparse
array iptcparse(string iptcblock^!)
#T=leak
void leak(int bytes^!)
#T=pack
string pack(string format, mixed [args]...^!)
#T=register_shutdown_function
int register_shutdown_function(string func^!)
#T=serialize
string serialize(mixed value^!)
#T=sleep
void sleep(int seconds^!)
#T=unpack
array unpack(string format, string data^!)
#T=unserialize
mixed unserialize(string str^!)
#T=uniqid
int uniqid(string prefix^!)
#T=usleep
void usleep(int micro_seconds^!)
#T=msql
int msql(string database, string query, int link_identifier^!)
#T=msql_affected_rows
int msql_affected_rows(int query_identifier^!)
#T=msql_close
int msql_close(int link_identifier^!)
#T=msql_connect
int msql_connect(string hostname^!)
#T=msql_create_db
int msql_create_db(string database name, int [link_identifier] ^!)
#T=msql_createdb
int msql_createdb(string database name, int [link_identifier] ^!)
#T=msql_data_seek
int msql_data_seek(int query_identifier, int row_number^!)
#T=msql_dbname
string msql_dbname(int query_identifier, int i^!)
#T=msql_drop_db
int msql_drop_db(string database_name, int link_identifier^!)
#T=msql_dropdb
#T=msql_error
string msql_error( ^!)
#T=msql_fetch_array
int msql_fetch_array(int query_identifier, int [result_type] ^!)
#T=msql_fetch_field
object msql_fetch_field(int query_identifier, int field_offset^!)
#T=msql_fetch_object
int msql_fetch_object(int query_identifier, int [result_type] ^!)
#T=msql_fetch_row
array msql_fetch_row(int query_identifier^!)
#T=msql_fieldname
string msql_fieldname(int query_identifier, int field^!)
#T=msql_field_seek
int msql_field_seek(int query_identifier, int field_offset^!)
#T=msql_fieldtable
int msql_fieldtable(int query_identifier, int field^!)
#T=msql_fieldtype
string msql_fieldtype(int query_identifier, int i^!)
#T=msql_fieldflags
string msql_fieldflags(int query_identifier, int i^!)
#T=msql_fieldlen
int msql_fieldlen(int query_identifier, int i^!)
#T=msql_free_result
int msql_free_result(int query_identifier^!)
#T=msql_freeresult
mysql_freeresult(^!)
#T=msql_list_fields
int msql_list_fields(string database, string tablename^!)
#T=msql_listfields
#T=msql_list_dbs
int msql_list_dbs(void^!)
#T=msql_listdbs
#T=msql_list_tables
int msql_list_tables(string database^!)
#T=msql_listtables
#T=msql_num_fields
int msql_num_fields(int query_identifier^!)
#T=msql_num_rows
int msql_num_rows(int query_identifier^!)
#T=msql_numfields
int msql_numfields(int query_identifier^!)
#T=msql_numrows
int msql_numrows(void^!)
#T=msql_pconnect
int msql_pconnect(string hostname^!)
#T=msql_query
int msql_query(string query, int link_identifier^!)
#T=msql_regcase
#T=msql_result
int msql_result(int query_identifier, int i, mixed field^!)
#T=msql_select_db
int msql_select_db(string database_name, int link_identifier^!)
#T=msql_selectdb
#T=msql_tablename
string msql_tablename(int query_identifier, int field^!)
#T=mssql_close
int mssql_close(int link_identifier^!)
#T=mssql_connect
int mssql_connect(string servername, string username, string password^!)
#T=mssql_data_seek
int mssql_data_seek(int result_identifier, int row_number^!)
#T=mssql_fetch_array
int mssql_fetch_array(int result^!)
#T=mssql_fetch_field
object mssql_fetch_field(int result, int field_offset^!)
#T=mssql_fetch_object
int mssql_fetch_object(int result^!)
#T=mssql_fetch_row
array mssql_fetch_row(int result^!)
#T=mssql_field_seek
int mssql_field_seek(int result, int field_offset^!)
#T=mssql_free_result
int mssql_free_result(int result^!)
#T=mssql_num_fields
int mssql_num_fields(int result^!)
#T=mssql_num_rows
int mssql_num_rows(string result^!)
#T=mssql_pconnect
int mssql_pconnect(string servername, string username, string password^!)
#T=mssql_query
int mssql_query(string query, int link_identifier^!)
#T=mssql_result
int mssql_result(int result, int i, mixed field^!)
#T=mssql_select_db
int mssql_select_db(string database_name, int link_identifier^!)
#T=mysql_affected_rows
int mysql_affected_rows(int [link_identifier] ^!)
#T=mysql_close
int mysql_close(int [link_identifier] ^!)
#T=mysql_connect
int mysql_connect(string [hostname [:port] [:/path/to/socket] ] , string [username] , string [password] ^!)
#T=mysql_create_db
int mysql_create_db(string database name, int [link_identifier] ^!)
#T=mysql_data_seek
int mysql_data_seek(int result_identifier, int row_number^!)
#T=mysql_db_query
int mysql_db_query(string database, string query, int [link_identifier] ^!)
#T=mysql_drop_db
int mysql_drop_db(string database_name, int [link_identifier] ^!)
#T=mysql_errno
int mysql_errno(int [link_identifier] ^!)
#T=mysql_error
string mysql_error(int [link_identifier] ^!)
#T=mysql_fetch_array
array mysql_fetch_array(int result, int [result_type] ^!)
#T=mysql_fetch_field
object mysql_fetch_field(int result, int [field_offset] ^!)
#T=mysql_fetch_lengths
array mysql_fetch_lengths(int result^!)
#T=mysql_fetch_object
object mysql_fetch_object(int result, int [result_typ]^!)
#T=mysql_fetch_row
array mysql_fetch_row(int result^!)
#T=mysql_field_name
string mysql_field_name(int result, int field_index^!)
#T=mysql_field_seek
int mysql_field_seek(int result, int field_offset^!)
#T=mysql_field_table
string mysql_field_table(int result, int field_offset^!)
#T=mysql_field_type
string mysql_field_type(int result, int field_offset^!)
#T=mysql_field_flags
string mysql_field_flags(int result, int field_offset^!)
#T=mysql_field_len
int mysql_field_len(int result, int field_offset^!)
#T=mysql_free_result
int mysql_free_result(int result^!)
#T=mysql_insert_id
int mysql_insert_id(int [link_identifier] ^!)
#T=mysql_list_fields
int mysql_list_fields(string database_name, string table_name, int [link_identifier] ^!)
#T=mysql_list_dbs
int mysql_list_dbs(int [link_identifier] ^!)
#T=mysql_list_tables
int mysql_list_tables(string database, int [link_identifier] ^!)
#T=mysql_num_fields
int mysql_num_fields(int result^!)
#T=mysql_num_rows
int mysql_num_rows(int result^!)
#T=mysql_pconnect
int mysql_pconnect(string [hostname [:port] [:/path/to/socket] ] , string [username] , string [password] ^!)
#T=mysql_query
int mysql_query(string query, int [link_identifier] ^!)
#T=mysql_result
int mysql_result(int result, int row, mixed [field] ^!)
#T=mysql_select_db
int mysql_select_db(string database_name, int [link_identifier] ^!)
#T=mysql_tablename
string mysql_tablename(int result, int i^!)
#T=sybase_affected_rows
int sybase_affected_rows(int [link_identifier] ^!)
#T=sybase_close
int sybase_close(int link_identifier^!)
#T=sybase_connect
int sybase_connect(string servername, string username, string password^!)
#T=sybase_data_seek
int sybase_data_seek(int result_identifier, int row_number^!)
#T=sybase_fetch_array
int sybase_fetch_array(int result^!)
#T=sybase_fetch_field
object sybase_fetch_field(int result, int field_offset^!)
#T=sybase_fetch_object
int sybase_fetch_object(int result^!)
#T=sybase_fetch_row
array sybase_fetch_row(int result^!)
#T=sybase_field_seek
int sybase_field_seek(int result, int field_offset^!)
#T=sybase_free_result
int sybase_free_result(int result^!)
#T=sybase_num_fields
int sybase_num_fields(int result^!)
#T=sybase_num_rows
int sybase_num_rows(string result^!)
#T=sybase_pconnect
int sybase_pconnect(string servername, string username, string password^!)
#T=sybase_query
int sybase_query(string query, int link_identifier^!)
#T=sybase_result
int sybase_result(int result, int i, mixed field^!)
#T=sybase_select_db
int sybase_select_db(string database_name, int link_identifier^!)
#T=fsockopen
int fsockopen(string hostname, int port, int [errno], string [errstr], double [timeout]^!)
#T=pfsockopen
int pfsockopen(string hostname, int port, int [errno], string [errstr], int [timeout]^!)
#T=set_socket_blocking
int set_socket_blocking(int socket descriptor, int mode^!)
#T=gethostbyaddr
string gethostbyaddr(string ip_address^!)
#T=gethostbyname
string gethostbyname(string hostname^!)
#T=gethostbynamel
array gethostbynamel(string hostname^!)
#T=checkdnsrr
int checkdnsrr(string host, string [type]^!)
#T=getmxrr
int getmxrr(string hostname, array mxhosts, array [weight]^!)
#T=openlog
int openlog(string ident, int option, int facility^!)
#T=syslog
int syslog(int priority, string message^!)
#T=closelog
int closelog(void^!)
#T=debugger_on
int debugger_on(string address^!)
#T=debugger_off
int debugger_off(void^!)
#T=yp_get_default_domain
int yp_get_default_domain(void ^!)
#T=yp_order
int yp_order(string domain, string map^!)
#T=yp_master
string yp_master(string domain, string map^!)
#T=yp_match
string yp_match(string domain, string map, string key^!)
#T=yp_first
string[] yp_first(string domain, string map^!)
#T=yp_next
string[] yp_next(string domain, string map, string key^!)
#T=yp_errno
int yp_errno(^!)
#T=yp_err_string
string yp_err_string(void ^!)
#T=odbc_autocommit
int odbc_autocommit(int connection_id, int [OnOff]^!)
#T=odbc_binmode
int odbc_binmode(int result_id, int mode^!)
#T=odbc_close
void odbc_close(int connection_id^!)
#T=odbc_close_all
void odbc_close_all(void^!)
#T=odbc_commit
int odbc_commit(int connection_id^!)
#T=odbc_connect
int odbc_connect(string dsn, string user, string password, int [cursor_type]^!)
#T=odbc_cursor
string odbc_cursor(int result_id^!)
#T=odbc_do
string odbc_do(int conn_id, string query^!)
#T=odbc_exec
int odbc_exec(int connection_id, string query_string^!)
#T=odbc_execute
int odbc_execute(int result_id, array [parameters_array]^!)
#T=odbc_fetch_into
int odbc_fetch_into(int result_id, int [rownumber], array result_array^!)
#T=odbc_fetch_row
int odbc_fetch_row(int result_id, int [row_number]^!)
#T=odbc_field_name
string odbc_fieldname(int result_id, int field_number^!)
#T=odbc_field_type
string odbc_field_type(int result_id, int field_number^!)
#T=odbc_field_len
int odbc_field_len(int result_id, int field_number^!)
#T=odbc_free_result
int odbc_free_result(int result_id^!)
#T=odbc_longreadlen
int odbc_longreadlen(int result_id, int length^!)
#T=odbc_num_fields
int odbc_num_fields(int result_id^!)
#T=odbc_pconnect
int odbc_pconnect(string dsn, string user, string password, int [cursor_type]^!)
#T=odbc_prepare
int odbc_prepare(int connection_id, string query_string^!)
#T=odbc_num_rows
int odbc_num_rows(int result_id^!)
#T=odbc_result
string odbc_result(int result_id, mixed field^!)
#T=odbc_result_all
int odbc_result_all(int result_id, string [format]^!)
#T=odbc_rollback
int odbc_rollback(int connection_id^!)
#T=odbc_setoption
int odbc_setoption(int id, int function, int option, int param^!)
#T=OCIDefineByName
int OCIDefineByName(int stmt, string Column-Name, mixed &variable, int [type]^!)
#T=OCIBindByName
int OCIBindByName(int stmt, string ph_name, mixed &variable, intlength, int [type]^!)
#T=OCILogon
int OCILogon(string username, string password, string [ORACLE_SID]^!)
#T=OCIPLogon
int OCIPLogon(int conn^!)
#T=OCINLogon
int OCINLogon(int conn^!)
#T=OCILogOff
int OCILogOff(int connection^!)
#T=OCIExecute
int OCIExecute(int statement, int [mode]^!)
#T=OCICommit
int OCICommit(int connection^!)
#T=OCIRollback
int OCIRollback(int connection^!)
#T=OCINewDescriptor
string OCINewDescriptor(int connection, int [type]^!)
#T=OCIRowCount
int OCIRowCount(int statement^!)
#T=OCINumCols
int OCINumCols(int stmt^!)
#T=OCIResult
int OCIResult(int statement, mixed column^!)
#T=OCIFetch
int OCIFetch(int statement^!)
#T=OCIFetchInto
int OCIFetchInto(int stmt, array &result, int [mode]^!)
#T=OCIFetchStatement
int OCIFetchStatement(int stmt, array &variable^!)
#T=OCIColumnIsNULL
int OCIColumnIsNULL(int stmt, mixed column^!)
#T=OCIColumnSize
int OCIColumnSize(int stmt, mixed column^!)
#T=OCIServerVersion
string OCIServerVersion(int conn^!)
#T=OCIStatementType
string OCIStatementType(int stmt^!)
#T=OCINewCursor
int OCINewCursor(int conn^!)
#T=OCIFreeStatement
int OCIFreeStatement(int stmt^!)
#T=OCIFreeCursor
int OCIFreeCursor(int stmt^!)
#T=OCIColumnName
string OCIColumnName(int stmt, int col^!)
#T=OCIColumnType
mixed OCIColumnName(int stmt, int col^!)
#T=OCIParse
int OCIParse(int conn, strint query^!)
#T=OCIError
int OCIError(int [stmt|conn]^!)
#T=OCIInternalDebug
void OCIInternalDebug(int onoff^!)
#T=Ora_Bind
int ora_bind(int cursor, string PHP variable name, string SQL parameter name, int length, int [type]^!)
#T=Ora_Close
int ora_close(int cursor^!)
#T=Ora_ColumnName
string Ora_ColumnName(int cursor, int column^!)
#T=Ora_ColumnType
string Ora_ColumnType(int cursor, int column^!)
#T=Ora_Commit
int ora_commit(int conn^!)
Returns true on success, false on error. Details about the error can be retrieved using the ora_error and ora_errorcode functions. This function commits an Oracle transaction. A transaction is defined as all the changes on a given connection since the last commit/rollback, autocommit was turned off or when the connection was established.
#T=Ora_CommitOff
int ora_commitoff(int conn^!)
#T=Ora_CommitOn
int ora_commiton(int conn^!)
#T=Ora_Error
string Ora_Error(int cursor_or_connection^!)
#T=Ora_ErrorCode
int Ora_ErrorCode(int cursor_or_connection^!)
#T=Ora_Exec
int ora_exec(int cursor^!)
#T=Ora_Fetch
int ora_fetch(int cursor^!)
#T=Ora_GetColumn
mixed ora_getcolumn(int cursor, mixed column^!)
#T=Ora_Logoff
int ora_logoff(int connection^!)
#T=Ora_Logon
int ora_logon(string user, string password^!)
#T=Ora_Open
int ora_open(int connection^!)
#T=Ora_Parse
int ora_parse(int cursor_ind, string sql_statement, int defer^!)
#T=Ora_Rollback
int ora_rollback(int connection^!)
#T=preg_match
int preg_match(string pattern, string subject, array [matches]^!)
#T=preg_match_all
int preg_match_all(string pattern, string subject, array matches, int [order]^!)
#T=preg_replace*
mixed preg_replace(mixed pattern, mixed replacement, mixed subject^!)
#T=preg_split
array preg_split(string pattern, string subject, int [limit]^!)
#T=preg_quote
string preg_quote(string str^!)
#T=preg_grep*
array preg_grep(string pattern, array input^!)
#T=PDF_get_info
info pdf_get_info(string filename^!)
#T=PDF_set_info_creator
void pdf_set_info_creator(info info, string creator^!)
#T=PDF_set_info_title
void pdf_set_info_title(info info, string title^!)
#T=PDF_set_info_subject
void pdf_set_info_subject(info info, string subject^!)
#T=PDF_set_info_keywords
void pdf_set_info_keywords(info info, string keywords^!)
#T=PDF_set_info_author
void pdf_set_info_author(info info, string author^!)
#T=PDF_open
int pdf_open(int file, int info^!)
#T=PDF_close
void pdf_close(int pdf document^!)
#T=PDF_begin_page
void pdf_begin_page(int pdf document, double height, double width^!)
#T=PDF_end_page
void pdf_end_page(int pdf document^!)
#T=PDF_show
void pdf_show(int pdf document, string text^!)
#T=PDF_show_xy
void pdf_show_xy(int pdf document, string text, double x-koor, double y-koor^!)
#T=PDF_set_font
void pdf_set_font(int pdf document, string font name, double size, int encoding^!)
#T=PDF_set_leading
void pdf_set leading(int pdf document, double distance^!)
#T=PDF_set_text_rendering
void pdf_set_text_rendering(int pdf document, int mode^!)
#T=PDF_set_horiz_scaling
void pdf_set_horiz_scaling(int pdf document, double scale^!)
#T=PDF_set_text_rise
void pdf_set_text_rise(int pdf document, double value^!)
#T=PDF_set_text_matrix
void pdf_set_text_matrix(int pdf document, array matrix^!)
#T=PDF_set_text_pos
void pdf_set_text_pos(int pdf document, double x-koor, double y-koor^!)
#T=PDF_set_char_spacing
void pdf_set_char_spacing(int pdf document, double space^!)
#T=PDF_set_word_spacing
void pdf_set_word_spacing(int pdf document, double space^!)
#T=PDF_continue_text
void pdf_continue_text(int pdf document, string text^!)
#T=PDF_stringwidth
double pdf_stringwidth(int pdf document, string text^!)
#T=PDF_save
void pdf_save(int pdf document^!)
#T=PDF_restore
void pdf_restore(int pdf document^!)
#T=PDF_translate
void pdf_translate(int pdf document, double x-koor, double y-koor^!)
#T=PDF_scale
void pdf_scale(int pdf document, double x-scale, double y-scale^!)
#T=PDF_rotate
void pdf_rotate(int pdf document, double angle^!)
#T=PDF_setflat
void pdf_setflat(int pdf document, double value^!)
#T=PDF_setlinejoin
void pdf_setlinejoin(int pdf document, long value^!)
#T=PDF_setlinecap
void pdf_setlinecap(int pdf document, int value^!)
#T=PDF_setmiterlimit
void pdf_setmiterlimit(int pdf document, double value^!)
#T=PDF_setlinewidth
void pdf_setlinewidth(int pdf document, double width^!)
#T=PDF_setdash
void pdf_setdash(int pdf document, double white, double black^!)
#T=PDF_moveto
void pdf_moveto(int pdf document, double x-koor, double y-koor^!)
#T=PDF_curveto
void pdf_curveto(int pdf document, double x1, double y1, double x2, double y2, double x3, double y3^!)
#T=PDF_lineto
void pdf_lineto(int pdf document, double x-koor, double y-koor^!)
#T=PDF_circle
void pdf_circle(int pdf document, double x-koor, double y-koor, double radius^!)
#T=PDF_arc
void pdf_arc(int pdf document, double x-koor, double y-koor, double radius, double start, double end^!)
#T=PDF_rect
void pdf_rect(int pdf document, double x-koor, double y-koor, double width, double height^!)
#T=PDF_closepath
void pdf_closepath(int pdf document^!)
#T=PDF_stroke
void pdf_stroke(int pdf document^!)
#T=PDF_closepath_stroke
void pdf_closepath_stroke(int pdf document^!)
#T=PDF_fill
void pdf_fill(int pdf document^!)
#T=PDF_fill_stroke
void pdf_fill_stroke(int pdf document^!)
#T=PDF_closepath_fill_stroke
void pdf_closepath_fill_stroke(int pdf document^!)
#T=PDF_endpath
void pdf_endpath(int pdf document^!)
#T=PDF_clip
void pdf_clip(int pdf document^!)
#T=PDF_setgray_fill
void pdf_setgray_fill(int pdf document, double value^!)
#T=PDF_setgray_stroke
void pdf_setgray_stroke(int pdf document, double gray value^!)
#T=PDF_setgray
void pdf_setgray(int pdf document, double gray value^!)
#T=PDF_setrgbcolor_fill
void pdf_setrgbcolor_fill(int pdf document, double red value, double green value, double blue value^!)
#T=PDF_setrgbcolor_stroke
void pdf_setrgbcolor_stroke(int pdf document, double red value, double green value, double blue value^!)
#T=PDF_setrgbcolor
void pdf_setrgbcolor(int pdf document, double red value, double green value, double blue value^!)
#T=PDF_add_outline
void pdf_add_outline(int pdf document, string text^!)
#T=PDF_set_transition
void pdf_set_transition(int pdf document, int transition^!)
#T=PDF_set_duration
void pdf_set_duration(int pdf document, double duration^!)
#T=PDF_open_gif
int pdf_open_gif(int pdf document, string filename^!)
#T=PDF_open_memory_image
int pdf_open_memory_image(int pdf document, string int image^!)
#T=PDF_open_jpeg
int pdf_open_jpeg(int pdf document, string filename^!)
#T=PDF_close_image
void pdf_close_image(int image^!)
#T=PDF_place_image
void pdf_place_image(int pdf document, int image, double x-koor, double y-koor, double scale^!)
#T=PDF_put_image
void pdf_put_image(int pdf document, int image^!)
#T=PDF_execute_image
void pdf_execute_image(int pdf document, int image, double x-coor, double y-coor, double scale^!)
#T=pdf_add_annotation
void pdf_add_annotation(int pdf document, double llx, double lly, double urx, double ury, string title, string content^!)
#T=pg_Close
bool pg_close(int connection^!)
#T=pg_cmdTuples
int pg_cmdtuples(int result_id^!)
#T=pg_Connect
int pg_connect(string host, string port, string options, string tty, string dbname^!)
#T=pg_DBname
string pg_dbname(int connection^!)
#T=pg_ErrorMessage
string pg_errormessage(int connection^!)
#T=pg_Exec
int pg_exec(int connection, string query^!)
#T=pg_Fetch_Array
array pg_fetch_array(int result, int row, int [result_type] ^!)
#T=pg_Fetch_Object
object pg_fetch_object(int result, int row, int [result_type] ^!)
#T=pg_Fetch_Row
array pg_fetch_row(int result, int row^!)
#T=pg_FieldIsNull
int pg_fieldisnull(int result_id, int row, mixed field^!)
#T=pg_FieldName
string pg_fieldname(int result_id, int field_number^!)
#T=pg_FieldNum
int pg_fieldnum(int result_id, string field_name^!)
#T=pg_FieldPrtLen
int pg_fieldprtlen(int result_id, int row_number, string field_name^!)
#T=pg_FieldSize
int pg_fieldsize(int result_id, int field_number^!)
#T=pg_FieldType
int pg_fieldtype(int result_id, int field_number^!)
#T=pg_FreeResult
int pg_freeresult(int result_id^!)
#T=pg_GetLastOid
int pg_getlastoid(int result_id^!)
#T=pg_Host
string pg_host(int connection_id^!)
#T=pg_loclose
void pg_loclose(int fd^!)
#T=pg_locreate
int pg_locreate(int conn^!)
#T=pg_loopen
int pg_loopen(int conn, int objoid, string mode^!)
#T=pg_loread
string pg_loread(int fd, int len^!)
#T=pg_loreadall
void pg_loreadall(int fd^!)
#T=pg_lounlink
void pg_lounlink(int conn, int lobjid^!)
#T=pg_lowrite
int pg_lowrite(int fd, string buf^!)
#T=pg_NumFields
int pg_numfields(int result_id^!)
#T=pg_NumRows
int pg_numrows(int result_id^!)
#T=pg_Options
string pg_options(int connection_id^!)
#T=pg_pConnect
int pg_pconnect(string host, string port, string options, string tty, string dbname^!)
#T=pg_Port
int pg_port(int connection_id^!)
#T=pg_Result
mixed pg_result(int result_id, int row_number, mixed fieldname^!)
#T=pg_tty
string pg_tty(int connection_id^!)
#T=ereg
int ereg(string pattern, string string, array [regs]^!)
#T=ereg_replace
string ereg_replace(string pattern, string replacement, string string^!)
#T=eregi
int eregi(string pattern, string string, array [regs]^!)
#T=eregi_replace
string eregi_replace(string pattern, string replacement, string string^!)
#T=split
array split(string pattern, string string, int [limit]^!)
#T=sql_regcase
string sql_regcase(string string^!)
#T=sem_get
int sem_get(int key, int [max_acquire] , int [perm] ^!)
#T=sem_acquire
int sem_acquire(int sem_identifier^!)
#T=sem_release
int sem_release(int sem_identifier^!)
#T=shm_attach
int shm_attach(int key, int [memsize], int [perm]^!)
#T=shm_detach
int shm_detach(int shm_identifier^!)
#T=shm_remove
int shm_remove(int shm_identifier^!)
#T=shm_put_var
int shm_put_var(int shm_identifier, int variable_key, mixed variable^!)
#T=shm_get_var
mixed shm_get_var(int id, int variable_key^!)
#T=shm_remove_var
int shm_remove_var(int id, int variable_key^!)
#T=session_start*
bool session_start(void^!)
#T=session_destroy*
bool session_destroy(void^!)
#T=session_name*
string session_name(string [name]^!)
#T=session_module_name*
string session_module_name(string [module]^!)
#T=session_save_path*
string session_save_path(string [path]^!)
#T=session_id*
string session_id(string [id]^!)
#T=session_register*
bool session_register(string name^!)
#T=session_unregister*
bool session_unregister(string name^!)
#T=session_is_registered*
bool session_is_registered(string name^!)
#T=session_decode*
bool session_decode(string data^!)
#T=session_encode*
bool session_encode(void^!)
#T=solid_close
#T=solid_connect
#T=solid_exec
#T=solid_fetchrow
solid_fetchrow - fetch row of data from Solid query
#T=solid_fieldname
#T=solid_fieldnum
#T=solid_freeresult
#T=solid_numfields
#T=solid_numrows
#T=solid_result
#T=snmpget
string snmpget(string hostname, string community, string object_id, int [timeout], int [retries]^!)
#T=snmpset
string snmpget(string hostname, string community, string object_id, string type, mixed value, int [timeout], int [retries]^!)
#T=snmpwalk
array snmpwalk(string hostname, string community, string object_id, int [timeout] , int [retries] ^!)
#T=snmpwalkoid
array snmpwalkoid(string hostname, string community, string object_id, int [timeout] , int [retries] ^!)
#T=snmp_get_quick_print
boolean snmp_get_quick_print(void ^!)
#T=snmp_set_quick_print
void snmp_set_quick_print(boolean quick_print^!)
#T=AddSlashes
string addslashes(string str^!)
#T=bin2hex
string bin2hex(string str^!)
#T=Chop
string chop(string str^!)
#T=Chr
string chr(int ascii^!)
#T=chunk_split
string chunk_split(string string, int [chunklen] , string [end] ^!)
#T=convert_cyr_string
string convert_cyr_string(string str, string from, string to^!)
#T=crypt
string crypt(string str, string [salt]^!)
#T=echo
echo(string arg1, string [argn]...^!)
#T=explode
array explode(string separator, string string^!)
#T=flush
void flush(void^!)
#T=get_meta_tags
array get_meta_tags(string filename, int [use_include_path]^!)
#T=htmlspecialchars
string htmlspecialchars(string string^!)
#T=htmlentities
string htmlentities(string string^!)
#T=implode
string implode(string glue, array pieces^!)
#T=join
string join(string glue, array pieces^!)
#T=ltrim
string ltrim(string str^!)
#T=md5
string md5(string str^!)
#T=nl2br
string nl2br(string string^!)
#T=Ord
int ord(string string^!)
#T=parse_str
void parse_str(string str^!)
#T=print
print(string arg^!)
#T=printf
int printf(string format, mixed [args]...^!)
#T=quoted_printable_decode
string quoted_printable_decode(string str^!)
#T=QuoteMeta
string quotemeta(string str^!)
#T=rawurldecode
string rawurldecode(string str^!)
#T=rawurlencode
string rawurlencode(string str^!)
#T=setlocale
string setlocale(string category, string locale^!)
#T=similar_text
int similar_text(string first, string second, double [percent]^!)
#T=soundex
string soundex(string str^!)
#T=sprintf
sprintf(string format, mixed [args]...^!)
#T=strchr
string strchr(string haystack, string needle^!)
#T=strcmp
int strcmp(string str1, string str2^!)
#T=strcspn
int strcspn(string str1, string str2^!)
#T=strip_tags
string strip_tags(string str^!)
#T=StripSlashes
string stripslashes(string str^!)
#T=strlen
int strlen(string str^!)
#T=strrpos
int strrpos(string haystack, char needle^!)
#T=strpos
int strpos(string haystack, string needle, int [offset]^!)
#T=strrchr
string strrchr(string haystack, string needle^!)
#T=strrev
string strrev(string string^!)
#T=strspn
int strspn(string str1, string str2^!)
#T=strstr
string strstr(string haystack, string needle^!)
#T=strtok
string strtok(string arg1, string arg2^!)
#T=strtolower
string strtolower(string str^!)
#T=strtoupper
string strtoupper(string string^!)
#T=str_replace
string str_replace(string needle, string str, string haystack^!)
#T=strtr
string strtr(string str, string from, string to^!)
#T=substr
string substr(string string, int start, int [length]^!)
#T=trim
string trim(string str^!)
#T=ucfirst
string ucfirst(string str^!)
#T=ucwords
string ucwords(string str^!)
#T=parse_url
array parse_url(string url^!)
#T=urldecode
string urldecode(string str^!)
#T=urlencode
string urlencode(string str^!)
#T=base64_encode
string base64_encode(string data^!)
#T=base64_decode
string base64_decode(string encoded_data^!)
#T=gettype
string gettype(mixed var^!)
#T=intval
int intval(mixed var, int [base]^!)
#T=doubleval
double doubleval(mixed var^!)
#T=empty
int empty(mixed var^!)
#T=is_array
int is_array(mixed var^!)
#T=is_double
int is_double(mixed var^!)
#T=is_float
int is_float(mixed var^!)
#T=is_int
int is_int(mixed var^!)
#T=is_integer
int is_integer(mixed var^!)
#T=is_long
int is_long(mixed var^!)
#T=is_object
int is_object(mixed var^!)
#T=is_real
int is_real(mixed var^!)
#T=is_string
int is_string(mixed var^!)
#T=isset
int isset(mixed var^!)
#T=settype
int settype(string var, string type^!)
#T=strval
string strval(mixed var^!)
#T=unset
int unset(mixed var^!)
#T=vm_adduser
int vm_adduser(string vdomain, string basepwd, string newusername, string newuserpassword^!)
#T=vm_addalias
int vm_addalias(string vdomain, string basepwd, string username, string alias^!)
#T=vm_passwd
int vm_passwd(string vdomain, string username, string password, string newpassword^!)
#T=vm_delalias
int vm_delalias(string vdomain, string basepwd, string alias^!)
#T=vm_deluser
int vm_deluser(string vdomain, string username^!)
#T=wddx_serialize_value
string wddx_serialize_value(mixed var, string [comment]^!)
#T=wddx_serialize_vars
string wddx_serialize_vars(string var_name | array var_names [, ... ] ^!)
#T=wddx_packet_start
int wddx_packet_start(string [comment]^!)
#T=wddx_packet_end
int wddx_packet_end(int packet_id^!)
#T=wddx_add_vars
wddx_add_vars(int packet_id, ...^!)
#T=wddx_deserialize
mixed wddx_deserialize(string packet^!)
#T=gzclose
int gzclose(int zp^!)
#T=gzeof
int gzeof(int zp^!)
#T=gzfile
array gzfile(string filename^!)
#T=gzgetc
string gzgetc(int zp^!)
#T=gzgets
string gzgets(int zp, int length^!)
#T=gzgetss
string gzgetss(int zp, int length^!)
#T=gzopen
int gzopen(string filename, string mode^!)
#T=gzpassthru
int gzpassthru(int zp^!)
#T=gzputs
int gzputs(int zp, string str, int [length]^!)
#T=gzread
string gzread(int zp, int length^!)
#T=gzrewind
int gzrewind(int zp^!)
#T=gzseek
int gzseek(int zp, int offset^!)
#T=gztell
int gztell(int zp^!)
#T=readgzfile
int readgzfile(string filename^!)
#T=gzwrite
int gzwrite(int zp, string string, int [length]^!)
#T=xml_parser_create
int xml_parser_create(string [encoding]^!)
#T=xml_set_element_handler
int xml_set_element_handler(int parser, string startElementHandler, string endElementHandler^!)
#T=xml_set_character_data_handler
int xml_set_character_data_handler(int parser, string handler^!)
#T=xml_set_processing_instruction_handler
int xml_set_processing_instruction_handler(int parser, string handler^!)
#T=xml_set_default_handler
int xml_set_default_handler(int parser, string handler^!)
#T=xml_set_unparsed_entity_decl_handler
int xml_set_unparsed_entity_decl_handler(int parser, string handler^!)
#T=xml_set_notation_decl_handler
int xml_set_notation_decl_handler(int parser, string handler^!)
#T=xml_set_external_entity_ref_handler
int xml_set_external_entity_ref_handler(int parser, string handler^!)
#T=xml_parse
int xml_parse(int parser, string data, int [isFinal]^!)
#T=xml_get_error_code
int xml_get_error_code(int parser^!)
#T=xml_error_string
string xml_error_string(int code^!)
#T=xml_get_current_line_number
int xml_get_current_line_number(int parser^!)
#T=xml_get_current_column_number
int xml_get_current_column_number(int parser^!)
#T=xml_get_current_byte_index
int xml_get_current_byte_index(int parser^!)
#T=xml_parser_free
string xml_parser_free(int parser^!)
#T=xml_parser_set_option
int xml_parser_set_option(int parser, int option, mixed value^!)
#T=xml_parser_get_option
mixed xml_parser_get_option(int parser, int option^!)
#T=utf8_decode
string utf8_decode(string data^!)
#T=utf8_encode
string utf8_encode(string data^!)