'/*****************************************************************************
'*                                                                            *
'* Copyright (c) 1996-1999 Funduc Software Inc.   All rights reserved.        *
'*                                                                            *
'* These programs are the sole property of Funduc Software Inc. and contain   *
'* proprietary information.  These routines should not by used by anyone      *
'* except Funduc Software Inc.'s customers in accoordance with terms of a     *
'* license.  To get one, visit us at http://www.funduc.com                    *
'* or E-MAIL: sales@funduc.com                                                *
'*                                                                            *
'*****************************************************************************/
Global Const PROMPT_ALL As Long = 0        '/* DLL prompts for everything */
Global Const PROMPT_NONE As Long = 1       '/* No prompts, file names passed in are used */
Global Const PROMPT_OVERWRITE As Long = 2  '/* DLL only prompts for overwrites */

Global Const NONE_TYPE As Long = 0         '/* Returned from decoding routine */
Global Const UUE_TYPE As Long = 1          '/* DLL prompts for everything */
Global Const MIME_TYPE As Long = 2         '/* No prompts, file names passed in are used */
Global Const BINHEX_TYPE As Long = 3       '/* BinHex (Macintosh) encoding */
Global Const XXE_TYPE As Long = 4          '/* XXENCODED file */
Global Const TEXT_TYPE As Long = 5         '/* 7-bit or quoted-printable - encoding quoted-printable */

'/* How many files are encoded */
'int WINAPI GetNumFilesToDecode(LPCSTR szInFile);
Declare Function GetNumFilesToDecode Lib "DECENC32.DLL" (ByVal strInFile As String) As Long

'/* 0 relative index into the array of names (see call above) */
'int WINAPI GetEncodedFile(LPSTR szOutFile, int nIndex);
Declare Function GetEncodedFile Lib "DECENC32.DLL" (ByVal strOutFile As String, ByVal nIndex As Long) As Long

'/* If PROMPT_NONE is used for nPrompt, the names of the files to decode are assumed to be in
'   the strOutFile parameter.  That can be accomplished by calling GetNumFilesToDecode()
'   and GetEncodedFile in a loop to get the list of files first. The list of files passed
'   (after modification if needed) must then be delimited by the ';' character */
'/* Return code is one of the Encoding types above */
'int WINAPI DecodeFile(LPCSTR strInFile, LPCSTR szOutFile, int nPrompts);
Declare Function DecodeFile Lib "DECENC32.DLL" (ByVal strInFile As String, ByVal strOutFile As String, ByVal nPrompts As Long) As Long

'/* nAppend should be 0 to overwrite the output file, 1 to append (to encode more than one file
'   for example */
'/* Boundary should be passed in.  It needs to be listed in the message header as:
'    boundary="<your boundary>" */
'int WINAPI EncodeFile(LPCSTR strFileIn, LPCSTR szFileOut, LPCTSTR szBoundary, int nType, BOOL bAppend);
Declare Function EncodeFile Lib "DECENC32.DLL" (ByVal SourceFile As String, ByVal EncodedFile As String, ByVal strBoundary As String, ByVal CodeOption As Long, ByVal xAppend As Long) As Long

'/* Call after all files are encoded to append the final boundary */
'/* You can also append -- and 2 linefeeds to the end of the encoded file or */
'/* send that out with your message */
'void WINAPI FinishAttachments(LPCSTR strFileOut);
Declare Sub FinishAttachments Lib "DECENC32.DLL" (ByVal strFileOut As String)

'/* call with the name of registered application to write that to the encoded file */
'void WINAPI SetEncodingApplication(LPCSTR szInFile);
Declare Sub SetEncodingApplication Lib "DECENC32.DLL" (ByVal strInFile As String)

'/* Utility functions */
'/* This function will return TRUE if the name of the file had to be changed to avoid an overwrite */
'BOOL WINAPI GetUniqueFileName(LPSTR szFileName);
Declare Function GetUniqueFileName Lib "DECENC32.DLL" (ByVal szFileName As String) As Long

'/* This function will concatenate related files into the first one.  All files must
'   be found in the same directory.
'   For example: file1.dat, file2.dat, file3.dat will be concatenated into file1.dat
'   If bDeleteOthers is TRUE, file2.dat and file3.dat are deleted
'   This function returns TRUE when successful, FALSE otherwise
'*/
'BOOL WINAPI ConcatenateRelated(BOOL bDeleteOthers, LPSTR szFileName);
Declare Function ConcatenateRelated Lib "DECENC32.DLL" (ByVal bDeleteOthers As Long, ByVal szFileName As String) As Long

'/* This function will split a file into as many smaller files as necessary
'   For example: file.dat of size 100000 will be split into
'   file1.dat (size 35000), file2.dat(35000), file3.dat(size 30000)
'   if 35000 is used for the lFileSize parameter
'   This function returns TRUE when successful, FALSE otherwise
'*/
'BOOL WINAPI SplitFile(LPSTR szFileName, long lFileSize);
Declare Function SplitFile Lib "DECENC32.DLL" (ByVal szFileName As String, ByVal lFileSize As Long) As Long
