VERSION 5.00
Begin VB.MDIForm frmMain 
   BackColor       =   &H8000000C&
   Caption         =   "vbSample"
   ClientHeight    =   5130
   ClientLeft      =   165
   ClientTop       =   735
   ClientWidth     =   7200
   LinkTopic       =   "MDIForm1"
   StartUpPosition =   3  'Windows Default
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileOpen 
         Caption         =   "&Open..."
         Shortcut        =   ^O
      End
      Begin VB.Menu miFileNotificationMessages 
         Caption         =   "&Notification Messages..."
      End
      Begin VB.Menu mnuFileSeparator 
         Caption         =   "-"
      End
      Begin VB.Menu mnuMRU 
         Caption         =   "(MRU item)"
         Enabled         =   0   'False
      End
   End
   Begin VB.Menu mnuWindow 
      Caption         =   "&Window"
      WindowList      =   -1  'True
      Begin VB.Menu mnuWindowCascade 
         Caption         =   "&Cascade"
      End
      Begin VB.Menu mnuWindowTile 
         Caption         =   "&Tile"
      End
      Begin VB.Menu mnuWindowArrangeIcons 
         Caption         =   "&Arrange Icons"
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      Begin VB.Menu mnuHelpContents 
         Caption         =   "&Contents"
      End
      Begin VB.Menu mnuHelpOptions 
         Caption         =   "&Options..."
      End
      Begin VB.Menu mnuHelpSeparator 
         Caption         =   "-"
      End
      Begin VB.Menu mnuHelpAbout 
         Caption         =   "&About vbSample..."
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Public Enum enumWindowMode
    wmOwned
    wmSibling
    wmChild
End Enum

Public WindowMode As enumWindowMode

Public Function GetHwndCaller() As Long

    ' Determine which window handle to pass for hwndCaller,
    ' depending on the chosen presentation mode
    Dim hwndCaller As Long
    Select Case Me.WindowMode
        Case wmOwned
            hwndCaller = Me.hWnd
        Case wmSibling
            hwndCaller = 0
        Case wmChild
            hwndCaller = frmHelp.hWnd
    End Select
    GetHwndCaller = hwndCaller

End Function

Public Function GetPszFile(strFile As String, strWindow As String) As String

    ' Assemble the name of the compiled file and window type
    If (Me.WindowMode = wmChild) Then
        ' For child mode, override specified window type
        GetPszFile = strFile & ">Embedded"
    Else
        If (strWindow = "") Then
            ' No window type specified
            GetPszFile = strFile
        Else
            ' User has specified a window type
            GetPszFile = strFile & ">" & strWindow
        End If
    End If

End Function

Private Sub MDIForm_Load()

    ' Reset the app's help filename
    App.HelpFile = App.Path & "\vbSample.chm"
    
    ' Make sibling mode the default
    WindowMode = wmSibling
    
    ' Load the embedded help host window
    Load frmHelp
    frmHelp.Hide
    
    ' Create the Embedded window type
    Dim wt As HH_WINTYPE
    wt.cbStruct = Len(wt)
    wt.pszType = "Embedded"
    wt.fsValidMembers = HHWIN_PARAM_STYLES Or HHWIN_PARAM_RECT Or HHWIN_PARAM_PROPERTIES
    wt.dwStyles = WS_CHILD Or WS_VISIBLE
    wt.fsWinProperties = HHWIN_PROP_NOTITLEBAR Or HHWIN_PROP_NODEF_STYLES
    wt.rcWindowPos.Left = 0
    wt.rcWindowPos.Top = 0
    wt.rcWindowPos.Bottom = frmHelp.ScaleHeight
    wt.rcWindowPos.Right = frmHelp.ScaleWidth
    Call HtmlHelp(Me.hWnd, vbNullString, HH_SET_WIN_TYPE, wt)

    ' Crude 1-file MRU list
    Dim strMRU As String
    strMRU = GetSetting("vbSample", "MRU", "1", "")
    If (strMRU <> "") Then
        mnuMRU.Caption = strMRU
        mnuMRU.Enabled = True
    End If

End Sub

Private Sub MDIForm_Unload(Cancel As Integer)

    Call HtmlHelp(0, vbNullString, HH_CLOSE_ALL, ByVal 0&)

End Sub

Private Sub miFileNotificationMessages_Click()

    frmWindow.Show vbModal

End Sub

Private Sub mnuFileOpen_Click()

    ' Make a buffer for the returned filename
    Dim strFile As String
    strFile = String(256, 0)
    
    ' Ask the user to select a file
    Dim ofn As OPENFILENAME
    ofn.lStructSize = Len(ofn)
    ofn.hwndOwner = Me.hWnd
    ofn.lpstrDefExt = "chm"
    ofn.flags = OFN_FILEMUSTEXIST Or OFN_HIDEREADONLY
    ofn.nMaxFile = 256
    ofn.lpstrFile = strFile
    ofn.lpstrFilter = "HTML Help Files (*.chm)" + Chr$(0) + "*.chm" + Chr$(0) + "All Files (*.*)" + Chr$(0) + "*.*" + Chr$(0) + Chr$(0)
    If (GetOpenFileName(ofn)) Then
        ' Display the file
        Call SaveSetting("vbSample", "MRU", "1", ofn.lpstrFile)
        mnuMRU.Caption = ofn.lpstrFile
        mnuMRU.Enabled = True
        Call mnuMRU_Click
    End If

End Sub

Private Sub mnuHelpAbout_Click()

    frmAbout.Show vbModal, Me

End Sub

Private Sub mnuHelpContents_Click()

    Call HtmlHelp(0, App.HelpFile & ">TriPane", HH_DISPLAY_TOPIC, ByVal 0&)

End Sub

Private Sub mnuHelpOptions_Click()

    frmOptions.Show vbModal, Me

End Sub

Private Sub mnuMRU_Click()

    ' Display the file
    Dim frm As New frmFile
    Dim strTitle As String
    strTitle = String$(255, 0)
    If (GetFileTitle(mnuMRU.Caption, strTitle, Len(strTitle)) = 0) Then
        frm.Caption = strTitle
    Else
        frm.Caption = mnuMRU.Caption
    End If
    frm.strHelpFile = mnuMRU.Caption

End Sub

Private Sub mnuWindowArrangeIcons_Click()

    Me.Arrange vbArrangeIcons

End Sub

Private Sub mnuWindowCascade_Click()

    Me.Arrange vbCascade

End Sub

Private Sub mnuWindowTile_Click()

    Me.Arrange vbTileVertical

End Sub
