Attribute VB_Name = "modSubclass"
'
' Code to handle subclassing a form for WM_HELP
'
' WARNING WARNING WARNING WARNING WARNING WARNING
'
' This code is extremely fragile and tends to crash in the
' Visual Basic debugger.
'
' WARNING WARNING WARNING WARNING WARNING WARNING
'
Option Explicit

Private SubclassInfo As New Collection

' A subclassed form must have the following methods:
'Public Sub OnContextMenu(hWndControl As Long)
'Public Sub OnHelp(hWndControl As Long)
'Public Sub OnNavComplete(phhnt As Long)
'Public Sub OnTCard(wParam As Long, lParam As Long)
'Public Sub OnTrack(phhnn As Long)

Function SubclassWndProc(ByVal hWnd As Long, ByVal Msg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long

    ' Find out which form this message is intended for
    Dim si As Object
    For Each si In SubclassInfo
        If (si.hWnd = hWnd) Then
            Exit For
        End If
    Next si

    If (si Is Nothing) Then
        ' Can't find a match - not much more we can do
        Exit Function
    End If

    Select Case (Msg)
        Case WM_CONTEXTMENU
            Call si.frm.OnContextMenu(wParam)
        
        Case WM_HELP
            Dim hi As HELPINFO
            Call CopyMemory(hi, ByVal lParam, Len(hi))
            Call si.frm.OnHelp(hi.hItemHandle)
        
        Case WM_NOTIFY
            Dim nmh As NMHDR
            Call CopyMemory(nmh, ByVal lParam, Len(nmh))
            Select Case (nmh.code)
                Case HHN_TRACK
                    Call si.frm.OnTrack(lParam)

                Case HHN_NAVCOMPLETE
                    Call si.frm.OnNavComplete(lParam)

                Case Else
                    ' Let the superclass handle the message
                    SubclassWndProc = CallWindowProc(si.lpPrevWndFunc, hWnd, Msg, wParam, ByVal lParam)

            End Select
                
        Case WM_TCARD
            Call si.frm.OnTCard(wParam, lParam)
        
        Case Else
            ' Let the superclass handle the message
            SubclassWndProc = CallWindowProc(si.lpPrevWndFunc, hWnd, Msg, wParam, ByVal lParam)
    
    End Select

    If (Msg = WM_NCDESTROY) Then
        ' The window has been destroyed
        ' Remove its info from the subclass collection
        Dim i As Integer
        For i = 1 To SubclassInfo.Count
            If (si Is SubclassInfo(i)) Then
                Call SubclassInfo.Remove(i)
                Exit For
            End If
        Next i
    End If

End Function

Sub Subclass(frm As Object)

    ' Uncomment the following line while debugging
    ' Otherwise VB tends to crash a lot
    'Exit Sub
    
    ' Allocate a new object to track this form
    Dim si As New clsSubclassInfo
    
    ' Assign form attributes to the object
    Set si.frm = frm
    si.hWnd = frm.hWnd
    si.lpPrevWndFunc = GetWindowLong(frm.hWnd, GWL_WNDPROC)
    
    ' Replace the window procedure of the form
    Call SetWindowLong(frm.hWnd, GWL_WNDPROC, AddressOf SubclassWndProc)
    
    ' Put this form into the subclass collection
    SubclassInfo.Add si

End Sub
