// FileView.cpp : implementation file
//

#include "stdafx.h"
#include "vcSample.h"
#include "FileView.h"
#include "SearchDlg.h"
#include "resource.hm"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFileView

#define MYHID(x) x,H##x

static const DWORD dwHelpIds[]= {
	MYHID(IDC_dwData),
	MYHID(IDC_WindowType),
	MYHID(IDC_DisplayTopic),
	MYHID(IDC_HelpContext),
	MYHID(IDC_CallHtmlHelp),
	MYHID(IDC_Search),
	MYHID(IDC_ReturnValue),
	0, 0
};

IMPLEMENT_DYNCREATE(CFileView, CFormView)

CFileView::CFileView()
	: CFormView(CFileView::IDD)
{
	//{{AFX_DATA_INIT(CFileView)
	m_iCommand = 0;
	m_strdwData = _T("");
	m_strWindowType = _T("");
	m_strReturnValue = _T("");
	//}}AFX_DATA_INIT
}

CFileView::~CFileView()
{
}

void CFileView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFileView)
	DDX_Radio(pDX, IDC_DisplayTopic, m_iCommand);
	DDX_Text(pDX, IDC_dwData, m_strdwData);
	DDX_Text(pDX, IDC_WindowType, m_strWindowType);
	DDX_Text(pDX, IDC_ReturnValue, m_strReturnValue);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFileView, CFormView)
	//{{AFX_MSG_MAP(CFileView)
	ON_BN_CLICKED(IDC_CallHtmlHelp, OnCallHtmlHelp)
	ON_BN_CLICKED(IDHELP, OnHelp)
	ON_BN_CLICKED(IDC_Search, OnSearch)
	ON_WM_CONTEXTMENU()
	ON_WM_HELPINFO()
	ON_BN_CLICKED(IDHELP, OnHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFileView diagnostics

#ifdef _DEBUG
void CFileView::AssertValid() const
{
	CFormView::AssertValid();
}

void CFileView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CFileView message handlers

void CFileView::OnInitialUpdate() 
{
	CFormView::OnInitialUpdate();
	
	// Fixed-size view window
	ResizeParentToFit();
}

void CFileView::OnCallHtmlHelp() 
{
	UpdateData();

	UINT uCommand;
	DWORD dwData;
	switch (m_iCommand) {
		case 0: {
			uCommand = HH_DISPLAY_TOPIC;
			if (m_strdwData.IsEmpty()) {
				dwData = 0;
			} else {
				dwData = (DWORD)(LPCSTR)m_strdwData;
			}
			break;
		}
		case 1: {
			uCommand = HH_HELP_CONTEXT;
			dwData = (DWORD)strtoul(m_strdwData,NULL,0);
			break;
		}
	}

	HWND hWndHelp = HtmlHelp(theApp.GetHwndCaller(),
	  theApp.GetPszFile(GetDocument()->GetPathName(),m_strWindowType),
	  uCommand,dwData);

	m_strReturnValue.Format("Return Value: 0x%lx\r\n",hWndHelp);
	UpdateData(FALSE);
}

void CFileView::OnHelp() 
{
	theApp.WinHelp(IDD);
}

void CFileView::OnSearch() 
{
	CSearchDlg dlgSearch(GetDocument()->GetPathName(),this);
	dlgSearch.DoModal();
}

void CFileView::OnContextMenu(CWnd* pWnd, CPoint point) 
{
	CString strFile = theApp.m_pszHelpFilePath;
	strFile += "::/vcSample.txt";
	HtmlHelp(pWnd->GetSafeHwnd(),strFile,HH_TP_HELP_CONTEXTMENU,(DWORD)&dwHelpIds);
}

BOOL CFileView::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	CString strFile = theApp.m_pszHelpFilePath;
	strFile += "::/vcSample.txt";
	HtmlHelp((HWND)pHelpInfo->hItemHandle,strFile,HH_TP_HELP_WM_HELP,(DWORD)&dwHelpIds);
	return(TRUE);
}
