// vcSample.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "vcSample.h"

#include "MainFrm.h"
#include "ChildFrm.h"
#include "vcSampleDoc.h"
#include "FileView.h"
#include "OptionsDlg.h"
#include "WindowDlg.h"
#include "HelpWnd.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CVcSampleApp

BEGIN_MESSAGE_MAP(CVcSampleApp, CWinApp)
	//{{AFX_MSG_MAP(CVcSampleApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_Help_Options, OnHelpOptions)
	ON_COMMAND(IDM_HelpContents, OnHelpContents)
	ON_COMMAND(ID_FILE_NotificationMessages, OnFileNotificationMessages)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVcSampleApp construction

CVcSampleApp::CVcSampleApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
	m_enumWindowMode = wmSibling;
	m_pwndHelp = NULL;
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CVcSampleApp object

CVcSampleApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CVcSampleApp initialization

BOOL CVcSampleApp::InitInstance()
{
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

	// Replace the extension of the help file: hlp -> chm
	CString strHelpFilePath = m_pszHelpFilePath;
	strHelpFilePath = strHelpFilePath.Left(strHelpFilePath.GetLength() - 3) + "chm";
	free((void *)m_pszHelpFilePath);
	m_pszHelpFilePath = _strdup(strHelpFilePath);

	// Change the registry key under which our settings are stored.
	// You should modify this string to be something appropriate
	// such as the name of your company or organization.
	SetRegistryKey(_T("Local AppWizard-Generated Applications"));

	LoadStdProfileSettings(8);  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	CMultiDocTemplate* pDocTemplate;
	pDocTemplate = new CMultiDocTemplate(
		IDR_CHMTYPE,
		RUNTIME_CLASS(CVcSampleDoc),
		RUNTIME_CLASS(CChildFrame), // custom MDI child frame
		RUNTIME_CLASS(CFileView));
	AddDocTemplate(pDocTemplate);

	// create main MDI Frame window
	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;
	m_pMainWnd = pMainFrame;

	// Enable drag/drop open
	m_pMainWnd->DragAcceptFiles();

	// The main window has been initialized, so show and update it.
	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->UpdateWindow();

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CVcSampleApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CVcSampleApp commands

void CVcSampleApp::OnHelpOptions() 
{
	COptionsDlg dlgOptions;
	dlgOptions.m_iWindowMode = m_enumWindowMode;
	if (dlgOptions.DoModal() == IDOK) {
		m_enumWindowMode = (enumWindowMode)dlgOptions.m_iWindowMode;
	}
}

HWND CVcSampleApp::GetHwndCaller()
{
    // Determine which window handle to pass for hwndCaller
    HWND hwndCaller;
    switch (m_enumWindowMode) {
        case wmOwned: {
            hwndCaller = AfxGetMainWnd()->GetSafeHwnd();
			break;
		}
        case wmSibling: {
            hwndCaller = NULL;
			break;
		}
        case wmChild: {
            hwndCaller = GetHelpWindow()->GetSafeHwnd();
			break;
		}
    }

	return(hwndCaller);
}


CHelpWnd *CVcSampleApp::GetHelpWindow()
{
	// Size/position should be changed to default from user preference
	if (!m_pwndHelp) {
		// Create an MDI child window to host help
		m_pwndHelp = new CHelpWnd;
		if (m_pwndHelp) {
			m_pwndHelp->Create(NULL,"Help");
		}
	}
	
	return(m_pwndHelp);
}

CString CVcSampleApp::GetPszFile(const CString &strFile, const CString &strWindow)
{
    // Assemble the name of the compiled file and window type
	CString strpszFile;
    if (m_enumWindowMode == wmChild) {
        strpszFile = strFile + ">Embedded";
    } else {
        if (strWindow.IsEmpty()) {
            strpszFile = strFile;
        } else {
            strpszFile = strFile + ">" + strWindow;
        }
    }
	return(strpszFile);
}

void CVcSampleApp::WinHelp(DWORD dwData, UINT nCmd) 
{
	CString strFile = m_pszHelpFilePath;
	switch (nCmd) {
		case HELP_CONTENTS: {
			// Display the default help topic in a sibling tripane window
			strFile += ">TriPane";
			HtmlHelp(NULL,strFile,HH_DISPLAY_TOPIC,0);
			break;
		}
		case HELP_CONTEXT: {
			// Display this context-sensitive topic in the embedded help window
			strFile += ">Embedded";
			HtmlHelp(GetHelpWindow()->GetSafeHwnd(),strFile,HH_HELP_CONTEXT,dwData);
			break;
		}
		default: {
			TRACE("CVcSampleApp::WinHelp: unhandled help command %ld\r\n",nCmd);
			break;
		}
	}
}

void CVcSampleApp::OnHelpContents() 
{
	WinHelp(0,HELP_CONTENTS);
}

void CVcSampleApp::OnFileNotificationMessages() 
{
	CWindowDlg dlgWindow;
	dlgWindow.DoModal();	
}
