%ifndef INCLUDED_WIN32N_INC
%define INCLUDED_WIN32N_INC


; Win32n.inc
; ===========
;

; ProcDump Task/Handler Structures definitions
;
; ----- Some constants -----
MAX_PATH               EQU	260        ;maximum path length
MAX_MODULE_NAME32 	EQU     256           ;Leave room for the zero and padding

; ----- Module list walking -----
;MODULEENTRY_		EQU    	4+4+4+4+4+4+4+4+MAX_MODULE_NAME32+MAX_PATH
STRUC MODULEENTRY
.me_dwSize 	  	RESD 	1
.me_th32ModuleID   	RESD 	1		; This module
.me_th32ProcessID  	RESD 	1		; owning process
.me_GlblcntUsage   	RESD 	1		; Global usage count on the module
.me_ProccntUsage   	RESD 	1		; Module usage count in th32ProcessID's context
.me_modBaseAddr 	RESD 	1 		; Base address of module in th32ProcessID's context
.me_modBaseSize 	RESD 	1		; Size in bytes of module starting at modBaseAddr
.me_hModule	  	RESD 	1          	; The hModule of this module in th32ProcessID's context
.me_ModuleName 	RESB 	MAX_MODULE_NAME32
.me_ExePath	  	RESB 	MAX_PATH
ENDSTRUC

; ----- Task list walking -----
;TASKENTRY_		EQU	4+4+4+4+4+4+4+4+4+MAX_PATH
STRUC TASKENTRY
.te_dwSize             RESD    1
.te_linkedAPP		RESD	1
.te_hTask              RESD    1
.te_heapID             RESD	1
.te_moduleID     	RESD    1
.te_nbofthread		RESD	1
.te_hOwner             RESD    1
.te_priority           RESD    1
.te_zero		RESD	1
.te_ProcName		RESB	MAX_PATH
ENDSTRUC

; ----- NT PSAPI stuff -----
;NTMODULEINFO_		EQU	4+4+4
STRUC NTMODULEINFO
.mi_BaseModule		RESD	1
.mi_SizeOfImage	RESD	1
.mi_EntryPoint		RESD	1
ENDSTRUC
;==============================================================================
;
;	BASIC TYPES
;
;==============================================================================

%define	ATOM      	DWORD     	;string atom
%define	BOOL      	DWORD     	;boolean variable
%define	COLORREF  	DWORD     	;rgb color
%define	DWORDLONG 	QWORD     	;long double word
%define	HACCEL    	DWORD     	;accelerator handle
%define	HANDLE    	DWORD     	;unspecified handle
%define	HBITMAP   	DWORD     	;bitmap handle
%define	HBRUSH    	DWORD     	;brush handle
%define	HCOLORSPACE	DWORD     	;color space handle
%define	HCURSOR   	DWORD     	;cursor handle
%define	HDC       	DWORD     	;device context handle
%define	HDWP      	DWORD     	;defer win pos handle
%define	HENHMETAFILE	DWORD     	;enh. metafile handle
%define	HFILE     	DWORD     	;file handle
%define	HFONT     	DWORD     	;font handle
%define	HGLOBAL   	DWORD     	;global handle
%define	HHOOK     	DWORD     	;hook handle
%define	HICON     	DWORD     	;icon handle
%define	HINSTANCE 	DWORD     	;instance handle
%define	HINTERNET 	DWORD     	;internet handle
%define	HLOCAL    	DWORD     	;local handle
%define	HMENU     	DWORD     	;menu handle
%define	HMETAFILE 	DWORD     	;metafile handle
%define	HPALETTE  	DWORD     	;palette handle
%define	HPEN      	DWORD     	;pen handle
%define	HRGN      	DWORD     	;region handle
%define	HRSRC     	DWORD     	;resource handle
%define	HSTR      	DWORD     	;string handle
%define	HTASK     	DWORD     	;task handle
%define	HTREEITEM 	DWORD     	;tree view item handle
%define	HWND      	DWORD     	;window handle
%define	INTEGER   	DWORD     	;standard integer
%define	LOCALHANDLE	DWORD     	;local handle
%define	LONG      	DWORD     	;long integer
%define	LONGINT   	DWORD     	;long integer
%define	LPARAM    	DWORD     	;long parameter
%define	LPBOOL    	DWORD     	;long ptr to boolean
%define	LPBYTE    	DWORD     	;long ptr to byte
%define	LPCSTR    	DWORD     	;long ptr to string
%define	LPCTSTR   	DWORD     	;long ptr to string
%define	LPCVOID   	DWORD     	;long ptr to buffer
%define	LPDWORD   	DWORD     	;long ptr to dword
%define	LPFN      	DWORD     	;long ptr to function
%define	LPINT     	DWORD     	;long ptr to integer
%define	LPLONG    	DWORD     	;long ptr to long int
%define	LPSTR     	DWORD     	;long ptr to string
%define	LPTSTR    	DWORD     	;long ptr to string
%define	LPVOID    	DWORD     	;long ptr to buffer
%define	LPWORD    	DWORD     	;long ptr to word
%define	LRESULT   	DWORD     	;long result
%define	LPMSG   	DWORD
%define	LPRECT   	DWORD
%define	POINTER   	DWORD     	;pointer to anything
%define	PVOID     	DWORD     	;pointer to buffer
%define	UINT      	DWORD     	;unsigned integer
%define	WNDPROC   	DWORD     	;window procedure
%define	WPARAM    	DWORD     	;dword parameter


; The following equates allow direct access to the incoming parms from
; stack level 0 of a callback procedure such as a WinProc.
; These textequ are only valid if and when NOTHING has been pushed to
; the stack. This supposes that no "enter" sequence (push EBP/mov EBP,ESP)
; has been executed, and thus that the PROC declaration doesn't mention any
; parm.
; If the PROC does declare parms, you don't need these equates anyway.

%define ESPhWnd    	[esp+04]      ;window handle
%define ESPhDlg     	[esp+04]      ;dialog handle
%define ESPwMsg     	[esp+08]      ;message id
%define ESPwParam    	[esp+12]      ;additional parameter
%define ESPlParam     	[esp+16]      ;additional parameter


;==============================================================================
;
;	BASIC CONSTANTS
;
;==============================================================================


NULL                 EQU	0          ;null
FALSE                EQU	0          ;boolean false
TRUE                 EQU	1          ;boolean true

;------------------------------------------------------------------------------

BUTTON               EQU	0080h      ;button class
EDIT                 EQU	0081h      ;edit class
STATIC               EQU	0082h      ;static class
LISTBOX              EQU	0083h      ;list box class
SCROLLBAR            EQU	0084h      ;scroll bar class
COMBOBOX             EQU	0085h      ;combo box class

;------------------------------------------------------------------------------


OFS_MAXPATHNAME      EQU	128        ;max OFSTRUCT path len

;------------------------------------------------------------------------------

INVALID_HANDLE_VALUE EQU	0FFFFFFFFh ;invalid handle
INVALID_FILE_SIZE    EQU	0FFFFFFFFh ;invalid file size
INVALID_FILE_POINTER EQU	0FFFFFFFFh ;invalid file pointer

;==============================================================================
;
;	WIN32 CONSTANTS
;
;==============================================================================

; ========================
; bitmap compression types
; ========================

BI_RGB               EQU	0
BI_RLE8              EQU	1
BI_RLE4              EQU	2
BI_BITFIELDS         EQU	3

;------------------------------------------------------------------------------

; =======================
; button control messages
; =======================

BM_GETCHECK          EQU	00F0h
BM_SETCHECK          EQU	00F1h
BM_GETSTATE          EQU	00F2h
BM_SETSTATE          EQU	00F3h
BM_SETSTYLE          EQU	00F4h
BM_CLICK             EQU	00F5h
BM_GETIMAGE          EQU	00F6h
BM_SETIMAGE          EQU	00F7h

;------------------------------------------------------------------------------

; ============================
; button control notifications
; ============================

BN_CLICKED           EQU	0000h
BN_PAINT             EQU	0001h
BN_HILITE            EQU	0002h
BN_UNHILITE          EQU	0003h
BN_DISABLE           EQU	0004h
BN_DOUBLECLICKED     EQU	0005h
BN_SETFOCUS          EQU	0006h
BN_KILLFOCUS         EQU	0007h

BN_PUSHED            EQU	BN_HILITE
BN_UNPUSHED          EQU	BN_UNHILITE
BN_DBLCLK            EQU	BN_DOUBLECLICKED


;------------------------------------------------------------------------------
;
; ==================
; combo box messages
; ==================
;
CB_GETEDITSEL        EQU	0140h
CB_LIMITTEXT         EQU	0141h
CB_SETEDITSEL        EQU	0142h
CB_ADDSTRING         EQU	0143h
CB_DELETESTRING      EQU	0144h
CB_DIR               EQU	0145h
CB_GETCOUNT          EQU	0146h
CB_GETCURSEL         EQU	0147h
CB_GETLBTEXT         EQU	0148h
CB_GETLBTEXTLEN      EQU	0149h
CB_INSERTSTRING      EQU	014Ah
CB_RESETCONTENT      EQU	014Bh
CB_FINDSTRING        EQU	014Ch
CB_SELECTSTRING      EQU	014Dh
CB_SETCURSEL         EQU	014Eh
CB_SHOWDROPDOWN      EQU	014Fh
CB_GETITEMDATA       EQU	0150h
CB_SETITEMDATA       EQU	0151h
CB_GETDROPPEDCONTROLRECT EQU	0152h
CB_SETITEMHEIGHT     EQU	0153h
CB_GETITEMHEIGHT     EQU	0154h
CB_SETEXTENDEDUI     EQU	0155h
CB_GETEXTENDEDUI     EQU	0156h
CB_GETDROPPEDSTATE   EQU	0157h
CB_FINDSTRINGEXACT   EQU	0158h
CB_SETLOCALE         EQU	0159h
CB_GETLOCALE         EQU	015Ah
CB_GETTOPINDEX       EQU	015Bh
CB_SETTOPINDEX       EQU	015Ch
CB_GETHORIZONTALEXTENT EQU	015Dh
CB_SETHORIZONTALEXTENT EQU	015Eh
CB_GETDROPPEDWIDTH   EQU	015Fh
CB_SETDROPPEDWIDTH   EQU	0160h
CB_INITSTORAGE       EQU	0161h
CB_MSGMAX            EQU	0162h

;------------------------------------------------------------------------------

; =======================
; combo box return values
; =======================

CB_OKAY              EQU	0
CB_ERR               EQU	-1
CB_ERRSPACE          EQU	-2

;------------------------------------------------------------------------------

; ======================
; CreateDIBitmap() codes
; ======================

CBM_INIT             EQU	4

;------------------------------------------------------------------------------

; ============================
; combo box notification codes
; ============================

CBN_ERRSPACE         EQU	-1
CBN_SELCHANGE        EQU	1
CBN_DBLCLK           EQU	2
CBN_SETFOCUS         EQU	3
CBN_KILLFOCUS        EQU	4
CBN_EDITCHANGE       EQU	5
CBN_EDITUPDATE       EQU	6
CBN_DROPDOWN         EQU	7
CBN_CLOSEUP          EQU	8
CBN_SELENDOK         EQU	9
CBN_SELENDCANCEL     EQU	10

;------------------------------------------------------------------------------

; =================
; clipboard formats
; =================

CF_TEXT              EQU	0001h
CF_BITMAP            EQU	0002h
CF_METAFILEPICT      EQU	0003h
CF_SYLK              EQU	0004h
CF_DIF               EQU	0005h
CF_TIFF              EQU	0006h
CF_OEMTEXT           EQU	0007h
CF_DIB               EQU	0008h
CF_PALETTE           EQU	0009h
CF_PENDATA           EQU	000Ah
CF_RIFF              EQU	000Bh
CF_WAVE              EQU	000Ch
CF_UNICODETEXT       EQU	000Dh
CF_ENHMETAFILE       EQU	000Eh
CF_HDROP             EQU	000Fh
CF_LOCALE            EQU	0010h
CF_MAX               EQU	0011h

CF_OWNERDISPLAY      EQU	0080h
CF_DSPTEXT           EQU	0081h
CF_DSPBITMAP         EQU	0082h
CF_DSPMETAFILEPICT   EQU	0083h
CF_DSPENHMETAFILE    EQU	008Eh

CF_PRIVATEFIRST      EQU	0200h
CF_PRIVATELAST       EQU	02FFh
;
CF_GDIOBJFIRST       EQU	0300h
CF_GDIOBJLAST        EQU	03FFh

;------------------------------------------------------------------------------

; ===========
; color types
; ===========

COLOR_SCROLLBAR      EQU	0
COLOR_BACKGROUND     EQU	1
COLOR_ACTIVECAPTION  EQU	2
COLOR_INACTIVECAPTION EQU	3
COLOR_MENU           EQU	4
COLOR_WINDOW         EQU	5
COLOR_WINDOWFRAME    EQU	6
COLOR_MENUTEXT       EQU	7
COLOR_WINDOWTEXT     EQU	8
COLOR_CAPTIONTEXT    EQU	9
COLOR_ACTIVEBORDER   EQU	10
COLOR_INACTIVEBORDER EQU	11
COLOR_APPWORKSPACE   EQU	12
COLOR_HIGHLIGHT      EQU	13
COLOR_HIGHLIGHTTEXT  EQU	14
COLOR_BTNFACE        EQU	15
COLOR_BTNSHADOW      EQU	16
COLOR_GRAYTEXT       EQU	17
COLOR_BTNTEXT        EQU	18
COLOR_INACTIVECAPTIONTEXT EQU	19
COLOR_BTNHIGHLIGHT   EQU	20
COLOR_3DDKSHADOW     EQU	21
COLOR_3DLIGHT        EQU	22
COLOR_INFOTEXT       EQU	23
COLOR_INFOBK         EQU	24

COLOR_DESKTOP        EQU	COLOR_BACKGROUND
COLOR_3DFACE         EQU	COLOR_BTNFACE
COLOR_3DSHADOW       EQU	COLOR_BTNSHADOW
COLOR_3DHIGHLIGHT    EQU	COLOR_BTNHIGHLIGHT
COLOR_3DHILIGHT      EQU	COLOR_BTNHIGHLIGHT
COLOR_BTNHILIGHT     EQU	COLOR_BTNHIGHLIGHT

;------------------------------------------------------------------------------

; ===================
; network connections
; ===================

CONNECT_UPDATE_PROFILE EQU	00000001h
CONNECT_UPDATE_RECENT EQU	00000002h
CONNECT_TEMPORARY    EQU	00000004h
CONNECT_INTERACTIVE  EQU	00000008h
CONNECT_PROMPT       EQU	00000010h
CONNECT_NEED_DRIVE   EQU	00000020h
CONNECT_REFCOUNT     EQU	00000040h
CONNECT_REDIRECT     EQU	00000080h
CONNECT_LOCALDRIVE   EQU	00000100h
CONNECT_CURRENT_MEDIA EQU	00000200h

NETPROPERTY_PERSISTENT EQU	1

;------------------------------------------------------------------------------

; ====================
; thread context flags
; ====================

CONTEXT_i386         EQU	00010000h
CONTEXT_i486         EQU	00010000h

CONTEXT_CONTROL      EQU	CONTEXT_i386+00000001h
CONTEXT_INTEGER      EQU	CONTEXT_i386+00000002h
CONTEXT_SEGMENTS     EQU	CONTEXT_i386+00000004h
CONTEXT_FLOATING_POINT  EQU	CONTEXT_i386+00000008h
CONTEXT_DEBUG_REGISTERS EQU	CONTEXT_i386+00000010h

CONTEXT_FULL         EQU	CONTEXT_CONTROL+CONTEXT_INTEGER+CONTEXT_SEGMENTS

SIZE_OF_80387_REGISTERS EQU	80

;------------------------------------------------------------------------------

; ==========
; code pages
; ==========

CP_ACP               EQU	0
CP_OEMCP             EQU	1
CP_MACCP             EQU	2

;------------------------------------------------------------------------------

; ============
; class styles
; ============

CS_VREDRAW           EQU	00000001h
CS_HREDRAW           EQU	00000002h
CS_KEYCVTWINDOW      EQU	00000004h
CS_DBLCLKS           EQU	00000008h
CS_OWNDC             EQU	00000020h
CS_CLASSDC           EQU	00000040h
CS_PARENTDC          EQU	00000080h
CS_NOKEYCVT          EQU	00000100h
CS_NOCLOSE           EQU	00000200h
CS_SAVEBITS          EQU	00000800h
CS_BYTEALIGNCLIENT   EQU	00001000h
CS_BYTEALIGNWINDOW   EQU	00002000h
CS_GLOBALCLASS       EQU	00004000h
CS_IME               EQU	00010000h

;------------------------------------------------------------------------------

; ===================
; control color types
; ===================

CTLCOLOR_MSGBOX      EQU	0
CTLCOLOR_EDIT        EQU	1
CTLCOLOR_LISTBOX     EQU	2
CTLCOLOR_BTN         EQU	3
CTLCOLOR_DLG         EQU	4
CTLCOLOR_SCROLLBAR   EQU	5
CTLCOLOR_STATIC      EQU	6
CTLCOLOR_MAX         EQU	7

;------------------------------------------------------------------------------

; =======================
; CreateWindow() commands
; =======================

CW_USEDEFAULT        EQU	80000000h

;------------------------------------------------------------------------------

; ===================
; device capabilities
; ===================

DC_FIELDS            EQU	1
DC_PAPERS            EQU	2
DC_PAPERSIZE         EQU	3
DC_MINEXTENT         EQU	4
DC_MAXEXTENT         EQU	5
DC_BINS              EQU	6
DC_DUPLEX            EQU	7
DC_SIZE              EQU	8
DC_EXTRA             EQU	9
DC_VERSION           EQU	10
DC_DRIVER            EQU	11
DC_BINNAMES          EQU	12
DC_ENUMRESOLUTIONS   EQU	13
DC_FILEDEPENDENCIES  EQU	14
DC_TRUETYPE          EQU	15
DC_PAPERNAMES        EQU	16
DC_ORIENTATION       EQU	17
DC_COPIES            EQU	18

;------------------------------------------------------------------------------

; ====================
; dib color table id's
; ====================

DIB_RGB_COLORS       EQU	0
DIB_PAL_COLORS       EQU	1

DLGWINDOWEXTRA	      EQU	00000001Eh

;------------------------------------------------------------------------------

; ===============================
; DLLEntryPoint fdwReason values.
; ===============================

DLL_PROCESS_DETACH   EQU	0
DLL_PROCESS_ATTACH   EQU	1
DLL_THREAD_ATTACH    EQU	2
DLL_THREAD_DETACH    EQU	3


;------------------------------------------------------------------------------

; ======================
; device mode selections
; ======================

DM_UPDATE            EQU	1
DM_COPY              EQU	2
DM_PROMPT            EQU	4
DM_MODIFY            EQU	8

DM_IN_BUFFER         EQU	DM_MODIFY
DM_IN_PROMPT         EQU	DM_PROMPT
DM_OUT_BUFFER        EQU	DM_COPY
DM_OUT_DEFAULT       EQU	DM_UPDATE

;------------------------------------------------------------------------------

; =======================
; DrawText() format flags
; =======================

DT_TOP               EQU	00000000h
DT_LEFT              EQU	00000000h
DT_CENTER            EQU	00000001h
DT_RIGHT             EQU	00000002h
DT_VCENTER           EQU	00000004h
DT_BOTTOM            EQU	00000008h
DT_WORDBREAK         EQU	00000010h
DT_SINGLELINE        EQU	00000020h
DT_EXPANDTABS        EQU	00000040h
DT_TABSTOP           EQU	00000080h
DT_NOCLIP            EQU	00000100h
DT_EXTERNALLEADING   EQU	00000200h
DT_CALCRECT          EQU	00000400h
DT_NOPREFIX          EQU	00000800h
DT_INTERNAL          EQU	00001000h
DT_EDITCONTROL       EQU	00002000h
DT_PATH_ELLIPSIS     EQU	00004000h
DT_END_ELLIPSIS      EQU	00008000h
DT_MODIFYSTRING      EQU	00010000h
DT_RTLREADING        EQU	00020000h
DT_WORD_ELLIPSIS     EQU	00040000h
;------------------------------------------------------------------------------

; ======================
; setwindowlong messages
; ======================

%define DWL_MSGRESULT   0
%define DWL_DLGPROC     4
%define DWL_USER        8

;------------------------------------------------------------------------------

; =====================
; edit control messages
; =====================

EM_GETSEL            EQU	00B0h
EM_SETSEL            EQU	00B1h
EM_GETRECT           EQU	00B2h
EM_SETRECT           EQU	00B3h
EM_SETRECTNP         EQU	00B4h
EM_SCROLL            EQU	00B5h
EM_LINESCROLL        EQU	00B6h
EM_SCROLLCARET       EQU	00B7h
EM_GETMODIFY         EQU	00B8h
EM_SETMODIFY         EQU	00B9h
EM_GETLINECOUNT      EQU	00BAh
EM_LINEINDEX         EQU	00BBh
EM_SETHANDLE         EQU	00BCh
EM_GETHANDLE         EQU	00BDh
EM_GETTHUMB          EQU	00BEh
EM_LINELENGTH        EQU	00C1h
EM_REPLACESEL        EQU	00C2h
EM_GETLINE           EQU	00C4h
EM_LIMITTEXT         EQU	00C5h
EM_CANUNDO           EQU	00C6h
EM_UNDO              EQU	00C7h
EM_FMTLINES          EQU	00C8h
EM_LINEFROMCHAR      EQU	00C9h
EM_SETTABSTOPS       EQU	00CBh
EM_SETPASSWORDCHAR   EQU	00CCh
EM_EMPTYUNDOBUFFER   EQU	00CDh
EM_GETFIRSTVISIBLELINE EQU	00CEh
EM_SETREADONLY       EQU	00CFh
EM_SETWORDBREAKPROC  EQU	00D0h
EM_GETWORDBREAKPROC  EQU	00D1h
EM_GETPASSWORDCHAR   EQU	00D2h
EM_SETMARGINS        EQU	00D3h
EM_GETMARGINS        EQU	00D4h
EM_GETLIMITTEXT      EQU	00D5h
EM_POSFROMCHAR       EQU	00D6h
EM_CHARFROMPOS       EQU	00D7h

EM_SETLIMITTEXT      EQU	EM_LIMITTEXT
;
;------------------------------------------------------------------------------
;
; ==========================
; edit control notifications
; ==========================
;
EN_SETFOCUS          EQU	0100h
EN_KILLFOCUS         EQU	0200h
EN_CHANGE            EQU	0300h
EN_UPDATE            EQU	0400h
EN_ERRSPACE          EQU	0500h
EN_MAXTEXT           EQU	0501h
EN_HSCROLL           EQU	0601h
EN_VSCROLL           EQU	0602h
;
;------------------------------------------------------------------------------
;
; ===========
; error codes
; ===========
;
ERROR_SUCCESS        EQU	0
NO_ERROR             EQU	0
;
ERROR_INVALID_FUNCTION EQU	1
ERROR_FILE_NOT_FOUND EQU	2
ERROR_PATH_NOT_FOUND EQU	3
ERROR_TOO_MANY_OPEN_FILES EQU	4
ERROR_ACCESS_DENIED  EQU	5
ERROR_INVALID_HANDLE EQU	6
ERROR_ARENA_TRASHED  EQU	7
ERROR_NOT_ENOUGH_MEMORY EQU	8
ERROR_INVALID_BLOCK  EQU	9
ERROR_BAD_ENVIRONMENT EQU	10
ERROR_BAD_FORMAT     EQU	11
ERROR_INVALID_ACCESS EQU	12
ERROR_INVALID_DATA   EQU	13
ERROR_OUTOFMEMORY    EQU	14
ERROR_INVALID_DRIVE  EQU	15
ERROR_CURRENT_DIRECTORY EQU	16
ERROR_NOT_SAME_DEVICE EQU	17
ERROR_NO_MORE_FILES  EQU	18
ERROR_WRITE_PROTECT  EQU	19
ERROR_BAD_UNIT       EQU	20
ERROR_NOT_READY      EQU	21
ERROR_BAD_COMMAND    EQU	22
ERROR_CRC            EQU	23
ERROR_BAD_LENGTH     EQU	24
ERROR_SEEK           EQU	25
ERROR_NOT_DOS_DISK   EQU	26
ERROR_SECTOR_NOT_FOUND EQU	27
ERROR_OUT_OF_PAPER   EQU	28
ERROR_WRITE_FAULT    EQU	29
ERROR_READ_FAULT     EQU	30
ERROR_GEN_FAILURE    EQU	31
ERROR_SHARING_VIOLATION EQU	32
ERROR_LOCK_VIOLATION EQU	33
ERROR_WRONG_DISK     EQU	34
ERROR_SHARING_BUFFER_EXCEEDED EQU	36
ERROR_HANDLE_EOF     EQU	38
ERROR_HANDLE_DISK_FULL EQU	39
ERROR_NOT_SUPPORTED  EQU	50
ERROR_REM_NOT_LIST   EQU	51
ERROR_DUP_NAME       EQU	52
ERROR_BAD_NETPATH    EQU	53
ERROR_NETWORK_BUSY   EQU	54
ERROR_DEV_NOT_EXIST  EQU	55
ERROR_TOO_MANY_CMDS  EQU	56
ERROR_ADAP_HDW_ERR   EQU	57
ERROR_BAD_NET_RESP   EQU	58
ERROR_UNEXP_NET_ERR  EQU	59
ERROR_BAD_REM_ADAP   EQU	60
ERROR_PRINTQ_FULL    EQU	61
ERROR_NO_SPOOL_SPACE EQU	62
ERROR_PRINT_CANCELLED EQU	63
ERROR_NETNAME_DELETED EQU	64
ERROR_NETWORK_ACCESS_DENIED EQU	65
ERROR_BAD_DEV_TYPE   EQU	66
ERROR_BAD_NET_NAME   EQU	67
ERROR_TOO_MANY_NAMES EQU	68
ERROR_TOO_MANY_SESS  EQU	69
ERROR_SHARING_PAUSED EQU	70
ERROR_REQ_NOT_ACCEP  EQU	71
ERROR_REDIR_PAUSED   EQU	72
ERROR_FILE_EXISTS    EQU	80
ERROR_CANNOT_MAKE    EQU	82
ERROR_FAIL_I24       EQU	83
ERROR_OUT_OF_STRUCTURES EQU	84
ERROR_ALREADY_ASSIGNED EQU	85
ERROR_INVALID_PASSWORD EQU	86
ERROR_INVALID_PARAMETER EQU	87
ERROR_NET_WRITE_FAULT EQU	88
ERROR_NO_PROC_SLOTS  EQU	89
ERROR_TOO_MANY_SEMAPHORES EQU	100
ERROR_EXCL_SEM_ALREADY_OWNED EQU	101
ERROR_SEM_IS_SET     EQU	102
ERROR_TOO_MANY_SEM_REQUESTS EQU	103
ERROR_INVALID_AT_INTERRUPT_TIME EQU	104
ERROR_SEM_OWNER_DIED EQU	105
ERROR_SEM_USER_LIMIT EQU	106
ERROR_DISK_CHANGE    EQU	107
ERROR_DRIVE_LOCKED   EQU	108
ERROR_BROKEN_PIPE    EQU	109
ERROR_OPEN_FAILED    EQU	110
ERROR_BUFFER_OVERFLOW EQU	111
ERROR_DISK_FULL      EQU	112
ERROR_NO_MORE_SEARCH_HANDLES EQU	113
ERROR_INVALID_TARGET_HANDLE EQU	114
ERROR_INVALID_CATEGORY EQU	117
ERROR_INVALID_VERIFY_SWITCH EQU	118
ERROR_BAD_DRIVER_LEVEL EQU	119
ERROR_CALL_NOT_IMPLEMENTED EQU	120
ERROR_SEM_TIMEOUT    EQU	121
ERROR_INSUFFICIENT_BUFFER EQU	122
ERROR_INVALID_NAME   EQU	123
ERROR_INVALID_LEVEL  EQU	124
ERROR_NO_VOLUME_LABEL EQU	125
ERROR_MOD_NOT_FOUND  EQU	126
ERROR_PROC_NOT_FOUND EQU	127
ERROR_WAIT_NO_CHILDREN EQU	128
ERROR_CHILD_NOT_COMPLETE EQU	129
ERROR_DIRECT_ACCESS_HANDLE EQU	130
ERROR_NEGATIVE_SEEK  EQU	131
ERROR_SEEK_ON_DEVICE EQU	132
ERROR_IS_JOIN_TARGET EQU	133
ERROR_IS_JOINED      EQU	134
ERROR_IS_SUBSTED     EQU	135
ERROR_NOT_JOINED     EQU	136
ERROR_NOT_SUBSTED    EQU	137
ERROR_JOIN_TO_JOIN   EQU	138
ERROR_SUBST_TO_SUBST EQU	139
ERROR_JOIN_TO_SUBST  EQU	140
ERROR_SUBST_TO_JOIN  EQU	141
ERROR_BUSY_DRIVE     EQU	142
ERROR_SAME_DRIVE     EQU	143
ERROR_DIR_NOT_ROOT   EQU	144
ERROR_DIR_NOT_EMPTY  EQU	145
ERROR_IS_SUBST_PATH  EQU	146
ERROR_IS_JOIN_PATH   EQU	147
ERROR_PATH_BUSY      EQU	148
ERROR_IS_SUBST_TARGET EQU	149
ERROR_SYSTEM_TRACE   EQU	150
ERROR_INVALID_EVENT_COUNT EQU	151
ERROR_TOO_MANY_MUXWAITERS EQU	152
ERROR_INVALID_LIST_FORMAT EQU	153
ERROR_LABEL_TOO_LONG EQU	154
ERROR_TOO_MANY_TCBS  EQU	155
ERROR_SIGNAL_REFUSED EQU	156
ERROR_DISCARDED      EQU	157
ERROR_NOT_LOCKED     EQU	158
ERROR_BAD_THREADID_ADDR EQU	159
ERROR_BAD_ARGUMENTS  EQU	160
ERROR_BAD_PATHNAME   EQU	161
ERROR_SIGNAL_PENDING EQU	162
ERROR_MAX_THRDS_REACHED EQU	164
ERROR_LOCK_FAILED    EQU	167
ERROR_BUSY           EQU	170
ERROR_CANCEL_VIOLATION EQU	173
ERROR_ATOMIC_LOCKS_NOT_SUPPORTED EQU	174
ERROR_INVALID_SEGMENT_NUMBER EQU	180
ERROR_INVALID_ORDINAL EQU	182
ERROR_ALREADY_EXISTS EQU	183
ERROR_INVALID_FLAG_NUMBER EQU	186
ERROR_SEM_NOT_FOUND  EQU	187
ERROR_INVALID_STARTING_CODESEG EQU	188
ERROR_INVALID_STACKSEG EQU	189
ERROR_INVALID_MODULETYPE EQU	190
ERROR_INVALID_EXE_SIGNATURE EQU	191
ERROR_EXE_MARKED_INVALID EQU	192
ERROR_BAD_EXE_FORMAT EQU	193
ERROR_ITERATED_DATA_EXCEEDS_64k EQU	194
ERROR_INVALID_MINALLOCSIZE EQU	195
ERROR_DYNLINK_FROM_INVALID_RING EQU	196
ERROR_IOPL_NOT_ENABLED EQU	197
ERROR_INVALID_SEGDPL EQU	198
ERROR_AUTODATASEG_EXCEEDS_64k EQU	199
ERROR_RING2SEG_MUST_BE_MOVABLE EQU	200
ERROR_RELOC_CHAIN_XEEDS_SEGLIM EQU	201
ERROR_INFLOOP_IN_RELOC_CHAIN EQU	202
ERROR_ENVVAR_NOT_FOUND EQU	203
ERROR_NO_SIGNAL_SENT EQU	205
ERROR_FILENAME_EXCED_RANGE EQU	206
ERROR_RING2_STACK_IN_USE EQU	207
ERROR_META_EXPANSION_TOO_LONG EQU	208
ERROR_INVALID_SIGNAL_NUMBER EQU	209
ERROR_THREAD_1_INACTIVE EQU	210
ERROR_LOCKED         EQU	212
ERROR_TOO_MANY_MODULES EQU	214
ERROR_NESTING_NOT_ALLOWED EQU	215
ERROR_BAD_PIPE       EQU	230
ERROR_PIPE_BUSY      EQU	231
ERROR_NO_DATA        EQU	232
ERROR_PIPE_NOT_CONNECTED EQU	233
ERROR_MORE_DATA      EQU	234
ERROR_VC_DISCONNECTED EQU	240
ERROR_INVALID_EA_NAME EQU	254
ERROR_EA_LIST_INCONSISTENT EQU	255
ERROR_NO_MORE_ITEMS  EQU	259
ERROR_CANNOT_COPY    EQU	266
ERROR_DIRECTORY      EQU	267
ERROR_EAS_DIDNT_FIT  EQU	275
ERROR_EA_FILE_CORRUPT EQU	276
ERROR_EA_TABLE_FULL  EQU	277
ERROR_INVALID_EA_HANDLE EQU	278
ERROR_EAS_NOT_SUPPORTED EQU	282
ERROR_NOT_OWNER      EQU	288
ERROR_TOO_MANY_POSTS EQU	298
ERROR_PARTIAL_COPY   EQU	299
ERROR_MR_MID_NOT_FOUND EQU	317
ERROR_INVALID_ADDRESS EQU	487
ERROR_ARITHMETIC_OVERFLOW EQU	534
ERROR_PIPE_CONNECTED EQU	535
ERROR_PIPE_LISTENING EQU	536
ERROR_EA_ACCESS_DENIED EQU	994
ERROR_OPERATION_ABORTED EQU	995
ERROR_IO_INCOMPLETE  EQU	996
ERROR_IO_PENDING     EQU	997
ERROR_NOACCESS       EQU	998
ERROR_SWAPERROR      EQU	999
ERROR_STACK_OVERFLOW EQU	1001
ERROR_INVALID_MESSAGE EQU	1002
ERROR_CAN_NOT_COMPLETE EQU	1003
ERROR_INVALID_FLAGS  EQU	1004
ERROR_UNRECOGNIZED_VOLUME EQU	1005
ERROR_FILE_INVALID   EQU	1006
ERROR_FULLSCREEN_MODE EQU	1007
ERROR_NO_TOKEN       EQU	1008
ERROR_BADDB          EQU	1009
ERROR_BADKEY         EQU	1010
ERROR_CANTOPEN       EQU	1011
ERROR_CANTREAD       EQU	1012
ERROR_CANTWRITE      EQU	1013
ERROR_REGISTRY_RECOVERED EQU	1014
ERROR_REGISTRY_CORRUPT EQU	1015
ERROR_REGISTRY_IO_FAILED EQU	1016
ERROR_NOT_REGISTRY_FILE EQU	1017
ERROR_KEY_DELETED    EQU	1018
ERROR_NO_LOG_SPACE   EQU	1019
ERROR_KEY_HAS_CHILDREN EQU	1020
ERROR_CHILD_MUST_BE_VOLATILE EQU	1021
ERROR_NOTIFY_ENUM_DIR EQU	1022
ERROR_DEPENDENT_SERVICES_RUNNING EQU	1051
ERROR_INVALID_SERVICE_CONTROL EQU	1052
ERROR_SERVICE_REQUEST_TIMEOUT EQU	1053
ERROR_SERVICE_NO_THREAD EQU	1054
ERROR_SERVICE_DATABASE_LOCKED EQU	1055
ERROR_SERVICE_ALREADY_RUNNING EQU	1056
ERROR_INVALID_SERVICE_ACCOUNT EQU	1057
ERROR_SERVICE_DISABLED EQU	1058
ERROR_CIRCULAR_DEPENDENCY EQU	1059
ERROR_SERVICE_DOES_NOT_EXIST EQU	1060
ERROR_SERVICE_CANNOT_ACCEPT_CTRL EQU	1061
ERROR_SERVICE_NOT_ACTIVE EQU	1062
ERROR_FAILED_SERVICE_CONTROLLER_CONNECT EQU	1063
ERROR_EXCEPTION_IN_SERVICE EQU	1064
ERROR_DATABASE_DOES_NOT_EXIST EQU	1065
ERROR_SERVICE_SPECIFIC_ERROR EQU	1066
ERROR_PROCESS_ABORTED EQU	1067
ERROR_SERVICE_DEPENDENCY_FAIL EQU	1068
ERROR_SERVICE_LOGON_FAILED EQU	1069
ERROR_SERVICE_START_HANG EQU	1070
ERROR_INVALID_SERVICE_LOCK EQU	1071
ERROR_SERVICE_MARKED_FOR_DELETE EQU	1072
ERROR_SERVICE_EXISTS EQU	1073
ERROR_ALREADY_RUNNING_LKG EQU	1074
ERROR_SERVICE_DEPENDENCY_DELETED EQU	1075
ERROR_BOOT_ALREADY_ACCEPTED EQU	1076
ERROR_SERVICE_NEVER_STARTED EQU	1077
ERROR_DUPLICATE_SERVICE_NAME EQU	1078
ERROR_END_OF_MEDIA   EQU	1100
ERROR_FILEMARK_DETECTED EQU	1101
ERROR_BEGINNING_OF_MEDIA EQU	1102
ERROR_SETMARK_DETECTED EQU	1103
ERROR_NO_DATA_DETECTED EQU	1104
ERROR_PARTITION_FAILURE EQU	1105
ERROR_INVALID_BLOCK_LENGTH EQU	1106
ERROR_DEVICE_NOT_PARTITIONED EQU	1107
ERROR_UNABLE_TO_LOCK_MEDIA EQU	1108
ERROR_UNABLE_TO_UNLOAD_MEDIA EQU	1109
ERROR_MEDIA_CHANGED  EQU	1110
ERROR_BUS_RESET      EQU	1111
ERROR_NO_MEDIA_IN_DRIVE EQU	1112
ERROR_NO_UNICODE_TRANSLATION EQU	1113
ERROR_DLL_INIT_FAILED EQU	1114
ERROR_SHUTDOWN_IN_PROGRESS EQU	1115
ERROR_NO_SHUTDOWN_IN_PROGRESS EQU	1116
ERROR_IO_DEVICE      EQU	1117
ERROR_SERIAL_NO_DEVICE EQU	1118
ERROR_IRQ_BUSY       EQU	1119
ERROR_MORE_WRITES    EQU	1120
ERROR_COUNTER_TIMEOUT EQU	1121
ERROR_FLOPPY_ID_MARK_NOT_FOUND EQU	1122
ERROR_FLOPPY_WRONG_CYLINDER EQU	1123
ERROR_FLOPPY_UNKNOWN_ERROR EQU	1124
ERROR_FLOPPY_BAD_REGISTERS EQU	1125
ERROR_DISK_RECALIBRATE_FAILED EQU	1126
ERROR_DISK_OPERATION_FAILED EQU	1127
ERROR_DISK_RESET_FAILED EQU	1128
ERROR_EOM_OVERFLOW   EQU	1129
ERROR_NOT_ENOUGH_SERVER_MEMORY EQU	1130
ERROR_POSSIBLE_DEADLOCK EQU	1131
ERROR_MAPPED_ALIGNMENT EQU	1132
ERROR_SET_POWER_STATE_VETOED EQU	1140
ERROR_SET_POWER_STATE_FAILED EQU	1141
ERROR_OLD_WIN_VERSION EQU	1150
ERROR_APP_WRONG_OS   EQU	1151
ERROR_SINGLE_INSTANCE_APP EQU	1152
ERROR_RMODE_APP      EQU	1153
ERROR_INVALID_DLL    EQU	1154
ERROR_NO_ASSOCIATION EQU	1155
ERROR_DDE_FAIL       EQU	1156
ERROR_DLL_NOT_FOUND  EQU	1157
ERROR_BAD_USERNAME   EQU	2202
ERROR_NOT_CONNECTED  EQU	2250
ERROR_OPEN_FILES     EQU	2401
ERROR_ACTIVE_CONNECTIONS EQU	2402
ERROR_DEVICE_IN_USE  EQU	2404
ERROR_BAD_DEVICE     EQU	1200
ERROR_CONNECTION_UNAVAIL EQU	1201
ERROR_DEVICE_ALREADY_REMEMBERED EQU	1202
ERROR_NO_NET_OR_BAD_PATH EQU	1203
ERROR_BAD_PROVIDER   EQU	1204
ERROR_CANNOT_OPEN_PROFILE EQU	1205
ERROR_BAD_PROFILE    EQU	1206
ERROR_NOT_CONTAINER  EQU	1207
ERROR_EXTENDED_ERROR EQU	1208
ERROR_INVALID_GROUPNAME EQU	1209
ERROR_INVALID_COMPUTERNAME EQU	1210
ERROR_INVALID_EVENTNAME EQU	1211
ERROR_INVALID_DOMAINNAME EQU	1212
ERROR_INVALID_SERVICENAME EQU	1213
ERROR_INVALID_NETNAME EQU	1214
ERROR_INVALID_SHARENAME EQU	1215
ERROR_INVALID_PASSWORDNAME EQU	1216
ERROR_INVALID_MESSAGENAME EQU	1217
ERROR_INVALID_MESSAGEDEST EQU	1218
ERROR_SESSION_CREDENTIAL_CONFLICT EQU	1219
ERROR_REMOTE_SESSION_LIMIT_EXCEEDED EQU	1220
ERROR_DUP_DOMAINNAME EQU	1221
ERROR_NO_NETWORK     EQU	1222
ERROR_CANCELLED      EQU	1223
ERROR_USER_MAPPED_FILE EQU	1224
ERROR_CONNECTION_REFUSED EQU	1225
ERROR_GRACEFUL_DISCONNECT EQU	1226
ERROR_ADDRESS_ALREADY_ASSOCIATED EQU	1227
ERROR_ADDRESS_NOT_ASSOCIATED EQU	1228
ERROR_CONNECTION_INVALID EQU	1229
ERROR_CONNECTION_ACTIVE EQU	1230
ERROR_NETWORK_UNREACHABLE EQU	1231
ERROR_HOST_UNREACHABLE EQU	1232
ERROR_PROTOCOL_UNREACHABLE EQU	1233
ERROR_PORT_UNREACHABLE EQU	1234
ERROR_REQUEST_ABORTED EQU	1235
ERROR_CONNECTION_ABORTED EQU	1236
ERROR_RETRY          EQU	1237
ERROR_CONNECTION_COUNT_LIMIT EQU	1238
ERROR_LOGIN_TIME_RESTRICTION EQU	1239
ERROR_LOGIN_WKSTA_RESTRICTION EQU	1240
ERROR_INCORRECT_ADDRESS EQU	1241
ERROR_ALREADY_REGISTERED EQU	1242
ERROR_SERVICE_NOT_FOUND EQU	1243
ERROR_NOT_AUTHENTICATED EQU	1244
ERROR_NOT_LOGGED_ON  EQU	1245
ERROR_CONTINUE       EQU	1246
ERROR_ALREADY_INITIALIZED EQU	1247
ERROR_NO_MORE_DEVICES EQU	1248
ERROR_NOT_ALL_ASSIGNED EQU	1300
ERROR_SOME_NOT_MAPPED EQU	1301
ERROR_NO_QUOTAS_FOR_ACCOUNT EQU	1302
ERROR_LOCAL_USER_SESSION_KEY EQU	1303
ERROR_NULL_LM_PASSWORD EQU	1304
ERROR_UNKNOWN_REVISION EQU	1305
ERROR_REVISION_MISMATCH EQU	1306
ERROR_INVALID_OWNER  EQU	1307
ERROR_INVALID_PRIMARY_GROUP EQU	1308
ERROR_NO_IMPERSONATION_TOKEN EQU	1309
ERROR_CANT_DISABLE_MANDATORY EQU	1310
ERROR_NO_LOGON_SERVERS EQU	1311
ERROR_NO_SUCH_LOGON_SESSION EQU	1312
ERROR_NO_SUCH_PRIVILEGE EQU	1313
ERROR_PRIVILEGE_NOT_HELD EQU	1314
ERROR_INVALID_ACCOUNT_NAME EQU	1315
ERROR_USER_EXISTS    EQU	1316
ERROR_NO_SUCH_USER   EQU	1317
ERROR_GROUP_EXISTS   EQU	1318
ERROR_NO_SUCH_GROUP  EQU	1319
ERROR_MEMBER_IN_GROUP EQU	1320
ERROR_MEMBER_NOT_IN_GROUP EQU	1321
ERROR_LAST_ADMIN     EQU	1322
ERROR_WRONG_PASSWORD EQU	1323
ERROR_ILL_FORMED_PASSWORD EQU	1324
ERROR_PASSWORD_RESTRICTION EQU	1325
ERROR_LOGON_FAILURE  EQU	1326
ERROR_ACCOUNT_RESTRICTION EQU	1327
ERROR_INVALID_LOGON_HOURS EQU	1328
ERROR_INVALID_WORKSTATION EQU	1329
ERROR_PASSWORD_EXPIRED EQU	1330
ERROR_ACCOUNT_DISABLED EQU	1331
ERROR_NONE_MAPPED    EQU	1332
ERROR_TOO_MANY_LUIDS_REQUESTED EQU	1333
ERROR_LUIDS_EXHAUSTED EQU	1334
ERROR_INVALID_SUB_AUTHORITY EQU	1335
ERROR_INVALID_ACL    EQU	1336
ERROR_INVALID_SID    EQU	1337
ERROR_INVALID_SECURITY_DESCR EQU	1338
ERROR_BAD_INHERITANCE_ACL EQU	1340
ERROR_SERVER_DISABLED EQU	1341
ERROR_SERVER_NOT_DISABLED EQU	1342
ERROR_INVALID_ID_AUTHORITY EQU	1343
ERROR_ALLOTTED_SPACE_EXCEEDED EQU	1344
ERROR_INVALID_GROUP_ATTRIBUTES EQU	1345
ERROR_BAD_IMPERSONATION_LEVEL EQU	1346
ERROR_CANT_OPEN_ANONYMOUS EQU	1347
ERROR_BAD_VALIDATION_CLASS EQU	1348
ERROR_BAD_TOKEN_TYPE EQU	1349
ERROR_NO_SECURITY_ON_OBJECT EQU	1350
ERROR_CANT_ACCESS_DOMAIN_INFO EQU	1351
ERROR_INVALID_SERVER_STATE EQU	1352
ERROR_INVALID_DOMAIN_STATE EQU	1353
ERROR_INVALID_DOMAIN_ROLE EQU	1354
ERROR_NO_SUCH_DOMAIN EQU	1355
ERROR_DOMAIN_EXISTS  EQU	1356
ERROR_DOMAIN_LIMIT_EXCEEDED EQU	1357
ERROR_INTERNAL_DB_CORRUPTION EQU	1358
ERROR_INTERNAL_ERROR EQU	1359
ERROR_GENERIC_NOT_MAPPED EQU	1360
ERROR_BAD_DESCRIPTOR_FORMAT EQU	1361
ERROR_NOT_LOGON_PROCESS EQU	1362
ERROR_LOGON_SESSION_EXISTS EQU	1363
ERROR_NO_SUCH_PACKAGE EQU	1364
ERROR_BAD_LOGON_SESSION_STATE EQU	1365
ERROR_LOGON_SESSION_COLLISION EQU	1366
ERROR_INVALID_LOGON_TYPE EQU	1367
ERROR_CANNOT_IMPERSONATE EQU	1368
ERROR_RXACT_INVALID_STATE EQU	1369
ERROR_RXACT_COMMIT_FAILURE EQU	1370
ERROR_SPECIAL_ACCOUNT EQU	1371
ERROR_SPECIAL_GROUP  EQU	1372
ERROR_SPECIAL_USER   EQU	1373
ERROR_MEMBERS_PRIMARY_GROUP EQU	1374
ERROR_TOKEN_ALREADY_IN_USE EQU	1375
ERROR_NO_SUCH_ALIAS  EQU	1376
ERROR_MEMBER_NOT_IN_ALIAS EQU	1377
ERROR_MEMBER_IN_ALIAS EQU	1378
ERROR_ALIAS_EXISTS   EQU	1379
ERROR_LOGON_NOT_GRANTED EQU	1380
ERROR_TOO_MANY_SECRETS EQU	1381
ERROR_SECRET_TOO_LONG EQU	1382
ERROR_INTERNAL_DB_ERROR EQU	1383
ERROR_TOO_MANY_CONTEXT_IDS EQU	1384
ERROR_LOGON_TYPE_NOT_GRANTED EQU	1385
ERROR_NT_CROSS_ENCRYPTION_REQUIRED EQU	1386
ERROR_NO_SUCH_MEMBER EQU	1387
ERROR_INVALID_MEMBER EQU	1388
ERROR_TOO_MANY_SIDS  EQU	1389
ERROR_LM_CROSS_ENCRYPTION_REQUIRED EQU	1390
ERROR_NO_INHERITANCE EQU	1391
ERROR_FILE_CORRUPT   EQU	1392
ERROR_DISK_CORRUPT   EQU	1393
ERROR_NO_USER_SESSION_KEY EQU	1394
ERROR_LICENSE_QUOTA_EXCEEDED EQU	1395
ERROR_INVALID_WINDOW_HANDLE EQU	1400
ERROR_INVALID_MENU_HANDLE EQU	1401
ERROR_INVALID_CURSOR_HANDLE EQU	1402
ERROR_INVALID_ACCEL_HANDLE EQU	1403
ERROR_INVALID_HOOK_HANDLE EQU	1404
ERROR_INVALID_DWP_HANDLE EQU	1405
ERROR_TLW_WITH_WSCHILD EQU	1406
ERROR_CANNOT_FIND_WND_CLASS EQU	1407
ERROR_WINDOW_OF_OTHER_THREAD EQU	1408
ERROR_HOTKEY_ALREADY_REGISTERED EQU	1409
ERROR_CLASS_ALREADY_EXISTS EQU	1410
ERROR_CLASS_DOES_NOT_EXIST EQU	1411
ERROR_CLASS_HAS_WINDOWS EQU	1412
ERROR_INVALID_INDEX  EQU	1413
ERROR_INVALID_ICON_HANDLE EQU	1414
ERROR_PRIVATE_DIALOG_INDEX EQU	1415
ERROR_LISTBOX_ID_NOT_FOUND EQU	1416
ERROR_NO_WILDCARD_CHARACTERS EQU	1417
ERROR_CLIPBOARD_NOT_OPEN EQU	1418
ERROR_HOTKEY_NOT_REGISTERED EQU	1419
ERROR_WINDOW_NOT_DIALOG EQU	1420
ERROR_CONTROL_ID_NOT_FOUND EQU	1421
ERROR_INVALID_COMBOBOX_MESSAGE EQU	1422
ERROR_WINDOW_NOT_COMBOBOX EQU	1423
ERROR_INVALID_EDIT_HEIGHT EQU	1424
ERROR_DC_NOT_FOUND   EQU	1425
ERROR_INVALID_HOOK_FILTER EQU	1426
ERROR_INVALID_FILTER_PROC EQU	1427
ERROR_HOOK_NEEDS_HMOD EQU	1428
ERROR_GLOBAL_ONLY_HOOK EQU	1429
ERROR_JOURNAL_HOOK_SET EQU	1430
ERROR_HOOK_NOT_INSTALLED EQU	1431
ERROR_INVALID_LB_MESSAGE EQU	1432
ERROR_SETCOUNT_ON_BAD_LB EQU	1433
ERROR_LB_WITHOUT_TABSTOPS EQU	1434
ERROR_DESTROY_OBJECT_OF_OTHER_THREAD EQU	1435
ERROR_CHILD_WINDOW_MENU EQU	1436
ERROR_NO_SYSTEM_MENU EQU	1437
ERROR_INVALID_MSGBOX_STYLE EQU	1438
ERROR_INVALID_SPI_VALUE EQU	1439
ERROR_SCREEN_ALREADY_LOCKED EQU	1440
ERROR_HWNDS_HAVE_DIFF_PARENT EQU	1441
ERROR_NOT_CHILD_WINDOW EQU	1442
ERROR_INVALID_GW_COMMAND EQU	1443
ERROR_INVALID_THREAD_ID EQU	1444
ERROR_NON_MDICHILD_WINDOW EQU	1445
ERROR_POPUP_ALREADY_ACTIVE EQU	1446
ERROR_NO_SCROLLBARS  EQU	1447
ERROR_INVALID_SCROLLBAR_RANGE EQU	1448
ERROR_INVALID_SHOWWIN_COMMAND EQU	1449
ERROR_NO_SYSTEM_RESOURCES EQU	1450
ERROR_NONPAGED_SYSTEM_RESOURCES EQU	1451
ERROR_PAGED_SYSTEM_RESOURCES EQU	1452
ERROR_WORKING_SET_QUOTA EQU	1453
ERROR_PAGEFILE_QUOTA EQU	1454
ERROR_COMMITMENT_LIMIT EQU	1455
ERROR_MENU_ITEM_NOT_FOUND EQU	1456
ERROR_EVENTLOG_FILE_CORRUPT EQU	1500
ERROR_EVENTLOG_CANT_START EQU	1501
ERROR_LOG_FILE_FULL  EQU	1502
ERROR_EVENTLOG_FILE_CHANGED EQU	1503
ERROR_INVALID_USER_BUFFER EQU	1784
ERROR_UNRECOGNIZED_MEDIA EQU	1785
ERROR_NO_TRUST_LSA_SECRET EQU	1786
ERROR_NO_TRUST_SAM_ACCOUNT EQU	1787
ERROR_TRUSTED_DOMAIN_FAILURE EQU	1788
ERROR_TRUSTED_RELATIONSHIP_FAILURE EQU	1789
ERROR_TRUST_FAILURE  EQU	1790
ERROR_NETLOGON_NOT_STARTED EQU	1792
ERROR_ACCOUNT_EXPIRED EQU	1793
ERROR_REDIRECTOR_HAS_OPEN_HANDLES EQU	1794
ERROR_PRINTER_DRIVER_ALREADY_INSTALLED EQU	1795
ERROR_UNKNOWN_PORT   EQU	1796
ERROR_UNKNOWN_PRINTER_DRIVER EQU	1797
ERROR_UNKNOWN_PRINTPROCESSOR EQU	1798
ERROR_INVALID_SEPARATOR_FILE EQU	1799
ERROR_INVALID_PRIORITY EQU	1800
ERROR_INVALID_PRINTER_NAME EQU	1801
ERROR_PRINTER_ALREADY_EXISTS EQU	1802
ERROR_INVALID_PRINTER_COMMAND EQU	1803
ERROR_INVALID_DATATYPE EQU	1804
ERROR_INVALID_ENVIRONMENT EQU	1805
ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT EQU	1807
ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT EQU	1808
ERROR_NOLOGON_SERVER_TRUST_ACCOUNT EQU	1809
ERROR_DOMAIN_TRUST_INCONSISTENT EQU	1810
ERROR_SERVER_HAS_OPEN_HANDLES EQU	1811
ERROR_RESOURCE_DATA_NOT_FOUND EQU	1812
ERROR_RESOURCE_TYPE_NOT_FOUND EQU	1813
ERROR_RESOURCE_NAME_NOT_FOUND EQU	1814
ERROR_RESOURCE_LANG_NOT_FOUND EQU	1815
ERROR_NOT_ENOUGH_QUOTA EQU	1816
ERROR_INVALID_TIME   EQU	1901
ERROR_INVALID_FORM_NAME EQU	1902
ERROR_INVALID_FORM_SIZE EQU	1903
ERROR_ALREADY_WAITING EQU	1904
ERROR_PRINTER_DELETED EQU	1905
ERROR_INVALID_PRINTER_STATE EQU	1906
ERROR_PASSWORD_MUST_CHANGE EQU	1907
ERROR_DOMAIN_CONTROLLER_NOT_FOUND EQU	1908
ERROR_ACCOUNT_LOCKED_OUT EQU	1909
ERROR_INVALID_PIXEL_FORMAT EQU	2000
ERROR_BAD_DRIVER     EQU	2001
ERROR_INVALID_WINDOW_STYLE EQU	2002
ERROR_METAFILE_NOT_SUPPORTED EQU	2003
ERROR_TRANSFORM_NOT_SUPPORTED EQU	2004
ERROR_CLIPPING_NOT_SUPPORTED EQU	2005
ERROR_UNKNOWN_PRINT_MONITOR EQU	3000
ERROR_PRINTER_DRIVER_IN_USE EQU	3001
ERROR_SPOOL_FILE_NOT_FOUND EQU	3002
ERROR_SPL_NO_STARTDOC EQU	3003
ERROR_SPL_NO_ADDJOB  EQU	3004
ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED EQU	3005
ERROR_PRINT_MONITOR_ALREADY_INSTALLED EQU	3006
ERROR_WINS_INTERNAL  EQU	4000
ERROR_CAN_NOT_DEL_LOCAL_WINS EQU	4001
ERROR_STATIC_INIT    EQU	4002
ERROR_INC_BACKUP     EQU	4003
ERROR_FULL_BACKUP    EQU	4004
ERROR_REC_NON_EXISTENT EQU	4005
ERROR_RPL_NOT_ALLOWED EQU	4006
ERROR_NO_BROWSER_SERVERS_FOUND EQU	6118


;------------------------------------------------------------------------------

; =============
; font families
; =============

FF_DONTCARE          EQU	0000h
FF_ROMAN             EQU	0010h
FF_SWISS             EQU	0020h
FF_MODERN            EQU	0030h
FF_SCRIPT            EQU	0040h
FF_DECORATIVE        EQU	0050h

;------------------------------------------------------------------------------

; ===============
; file attributes
; ===============

FILE_ATTRIBUTE_READONLY EQU	00000001h
FILE_ATTRIBUTE_HIDDEN EQU	00000002h
FILE_ATTRIBUTE_SYSTEM EQU	00000004h
FILE_ATTRIBUTE_DIRECTORY EQU	00000010h
FILE_ATTRIBUTE_ARCHIVE EQU	00000020h
FILE_ATTRIBUTE_NORMAL EQU	00000080h
FILE_ATTRIBUTE_TEMPORARY EQU	00000100h
FILE_ATTRIBUTE_COMPRESSED EQU	00000800h

;------------------------------------------------------------------------------

; ===================
; file creation flags
; ===================

FILE_FLAG_WRITE_THROUGH EQU	80000000h
FILE_FLAG_OVERLAPPED EQU	40000000h
FILE_FLAG_NO_BUFFERING EQU	20000000h
FILE_FLAG_RANDOM_ACCESS EQU	10000000h
FILE_FLAG_SEQUENTIAL_SCAN EQU	08000000h
FILE_FLAG_DELETE_ON_CLOSE EQU	04000000h
FILE_FLAG_BACKUP_SEMANTICS EQU	02000000h
FILE_FLAG_POSIX_SEMANTICS EQU	01000000h

;------------------------------------------------------------------------------

; ==================
; file notifications
; ==================

FILE_NOTIFY_CHANGE_FILE_NAME EQU	0001h
FILE_NOTIFY_CHANGE_DIR_NAME EQU	0002h
FILE_NOTIFY_CHANGE_ATTRIBUTES EQU	0004h
FILE_NOTIFY_CHANGE_SIZE EQU	0008h
FILE_NOTIFY_CHANGE_LAST_WRITE EQU	0010h
FILE_NOTIFY_CHANGE_SECURITY EQU	0100h

;------------------------------------------------------------------------------

; =================
; file access types
; =================

GENERIC_ALL          EQU	10000000h
GENERIC_EXECUTE      EQU	20000000h
GENERIC_WRITE        EQU	40000000h
GENERIC_READ         EQU	80000000h

GENERIC_READWRITE    EQU	GENERIC_READ+GENERIC_WRITE

;------------------------------------------------------------------------------

; ================
; file share modes
; ================

FILE_SHARE_NONE      EQU	0000h
FILE_SHARE_READ      EQU	0001h
FILE_SHARE_WRITE     EQU	0002h

FILE_SHARE_READWRITE EQU	FILE_SHARE_READ+FILE_SHARE_WRITE


; ======================
; File Optional Actions
; ======================

DUPLICATE_CLOSE_SOURCE EQU	0001h
DUPLICATE_SAME_ACCESS EQU	0002h

;------------------------------------------------------------------------------

; ========================
; SetFilePointer() methods
; ========================

FILE_BEGIN           EQU	0
FILE_CURRENT         EQU	1
FILE_END             EQU	2

;------------------------------------------------------------------------------

; =================
; file system flags
; =================

FILE_CASE_SENSITIVE_SEARCH EQU	00000001h
FILE_CASE_PRESERVED_NAMES EQU	00000002h
FILE_UNICODE_ON_DISK EQU	00000004h
FILE_PERSISTENT_ACLS EQU	00000008h
FILE_FILE_COMPRESSION EQU	00000010h
FILE_VOLUME_IS_COMPRESSED EQU	00008000h
;
FS_CASE_SENSITIVE    EQU	FILE_CASE_SENSITIVE_SEARCH
FS_CASE_IS_PRESERVED EQU	FILE_CASE_PRESERVED_NAMES
FS_UNICODE_STORED_ON_DISK EQU	FILE_UNICODE_ON_DISK
FS_PERSISTENT_ACLS   EQU	FILE_PERSISTENT_ACLS
FS_FILE_COMPRESSION  EQU	FILE_FILE_COMPRESSION
FS_VOL_IS_COMPRESSED EQU	FILE_VOLUME_IS_COMPRESSED

;------------------------------------------------------------------------------

; ============
; font weights
; ============

FW_DONTCARE          EQU	000
FW_THIN              EQU	100
FW_EXTRALIGHT        EQU	200
FW_LIGHT             EQU	300
FW_NORMAL            EQU	400
FW_MEDIUM            EQU	500
FW_SEMIBOLD          EQU	600
FW_BOLD              EQU	700
FW_EXTRABOLD         EQU	800
FW_HEAVY             EQU	900
;
FW_ULTRALIGHT        EQU	FW_EXTRALIGHT
FW_REGULAR           EQU	FW_NORMAL
FW_DEMIBOLD          EQU	FW_SEMIBOLD
FW_ULTRABOLD         EQU	FW_EXTRABOLD
FW_BLACK             EQU	FW_HEAVY

;------------------------------------------------------------------------------

; ======================
; GetClassLong() offsets
; ======================

GCL_MENUNAME         EQU	-08
GCL_HBRBACKGROUND    EQU	-10
GCL_HCURSOR          EQU	-12
GCL_HICON            EQU	-14
GCL_HMODULE          EQU	-16
GCL_CBWNDEXTRA       EQU	-18
GCL_CBCLSEXTRA       EQU	-20
GCL_WNDPROC          EQU	-24
GCL_STYLE            EQU	-26
GCW_ATOM             EQU	-32
GCL_HICONSM          EQU	-34
;------------------------------------------------------------------------------

; ===================
; global memory flags
; ===================

GMEM_FIXED           EQU	0000h
GMEM_MOVEABLE        EQU	0002h
GMEM_NOCOMPACT       EQU	0010h
GMEM_NODISCARD       EQU	0020h
GMEM_ZEROINIT        EQU	0040h
GMEM_MODIFY          EQU	0080h
GMEM_DISCARDABLE     EQU	0100h
GMEM_NOT_BANKED      EQU	1000h
GMEM_SHARE           EQU	2000h
GMEM_DDESHARE        EQU	2000h
GMEM_NOTIFY          EQU	4000h
GMEM_INVALID_HANDLE  EQU	8000h
;
GMEM_VALID_FLAGS     EQU	7F72h
GMEM_LOWER           EQU	GMEM_NOT_BANKED

;------------------------------------------------------------------------------
;
; ================
; GetWindow() id's
; ================

GW_HWNDFIRST         EQU	0
GW_HWNDLAST          EQU	1
GW_HWNDNEXT          EQU	2
GW_HWNDPREV          EQU	3
GW_OWNER             EQU	4
GW_CHILD             EQU	5
;
GW_MAX               EQU	5

;------------------------------------------------------------------------------

; =======================
; GetWindowLong() offsets
; =======================

GWL_WNDPROC          EQU	-04
GWL_HINSTANCE        EQU	-06
GWL_HWNDPARENT       EQU	-08
GWL_STYLE            EQU	-16
GWL_EXSTYLE          EQU	-20
GWL_USERDATA         EQU	-21
GWL_ID               EQU	-12

;------------------------------------------------------------------------------

; ==================
; WinHelp() commands
; ==================

HELP_CONTEXT         EQU	0001h
HELP_QUIT            EQU	0002h
HELP_INDEX           EQU	0003h
HELP_CONTENTS        EQU	0003h
HELP_HELPONHELP      EQU	0004h
HELP_SETINDEX        EQU	0005h
HELP_SETCONTENTS     EQU	0005h
HELP_CONTEXTPOPUP    EQU	0008h
HELP_FORCEFILE       EQU	0009h
HELP_CONTEXTMENU     EQU	000Ah
HELP_FINDER          EQU	000Bh
HELP_WM_HELP         EQU	000Ch
HELP_SETPOPUP_POS    EQU	000Dh
HELP_TCARD_DATA      EQU	0010h
HELP_TCARD_OTHER_CALLER EQU	0011h
HELP_KEY             EQU	0101h
HELP_COMMAND         EQU	0102h
HELP_PARTIALKEY      EQU	0105h
HELP_MULTIKEY        EQU	0201h
HELP_SETWINPOS       EQU	0203h
HELP_TCARD           EQU	8000h


;------------------------------------------------------------------------------

; =======================
; hit test position codes
; =======================

HTERROR              EQU	-2
HTTRANSPARENT        EQU	-1
HTNOWHERE            EQU	0
HTCLIENT             EQU	1
HTCAPTION            EQU	2
HTSYSMENU            EQU	3
HTGROWBOX            EQU	4
HTSIZE               EQU	HTGROWBOX
HTMENU               EQU	5
HTHSCROLL            EQU	6
HTVSCROLL            EQU	7
HTMINBUTTON          EQU	8
HTREDUCE             EQU	HTMINBUTTON
HTMAXBUTTON          EQU	9
HTZOOM               EQU	HTMAXBUTTON


HTLEFT               EQU	10
HTSIZEFIRST          EQU	HTLEFT
HTRIGHT              EQU	11
HTTOP                EQU	12
HTTOPLEFT            EQU	13
HTTOPRIGHT           EQU	14
HTBOTTOM             EQU	15
HTBOTTOMLEFT         EQU	16
HTBOTTOMRIGHT        EQU	17
HTSIZELAST           EQU	HTBOTTOMRIGHT

HTBORDER             EQU	18
HTOBJECT             EQU	19
HTCLOSE              EQU	20
HTHELP               EQU	21


;------------------------------------------------------------------------------

; ===================
; toolbar bitmap id's
; ===================

IDB_STD_SMALL_COLOR  EQU	0
IDB_STD_LARGE_COLOR  EQU	1
IDB_VIEW_SMALL_COLOR EQU	4
IDB_VIEW_LARGE_COLOR EQU	5

HINST_COMMCTRL       EQU	-1

;------------------------------------------------------------------------------

; ====================
; standard cursor id's
; ====================

IDC_ARROW            EQU	32512
IDC_IBEAM            EQU	32513
IDC_WAIT             EQU	32514
IDC_CROSS            EQU	32515
IDC_UPARROW          EQU	32516
IDC_SIZE             EQU	32640      ;obsolete, use IDC_SIZEALL
IDC_ICON             EQU	32641      ;obsolete, use IDC_ARROW
IDC_SIZENWSE         EQU	32642
IDC_SIZENESW         EQU	32643
IDC_SIZEWE           EQU	32644
IDC_SIZENS           EQU	32645
IDC_SIZEALL          EQU	32646
IDC_NO               EQU	32648
IDC_APPSTARTING      EQU	32650
IDC_HELP             EQU	32651

;------------------------------------------------------------------------------

; ==================
; standard icon id's
; ==================

IDI_APPLICATION      EQU	32512
IDI_HAND             EQU	32513
IDI_QUESTION         EQU	32514
IDI_EXCLAMATION      EQU	32515
IDI_ASTERISK         EQU	32516
IDI_WINLOGO          EQU	32517

;------------------------------------------------------------------------------

; =============================
; keyboard message lParam flags
; =============================

KF_EXTENDED          EQU	0100h
KF_DLGMODE           EQU	0800h
KF_MENUMODE          EQU	1000h
KF_ALTDOWN           EQU	2000h
KF_REPEAT            EQU	4000h
KF_UP                EQU	8000h

;------------------------------------------------------------------------------

; ================
; listbox messages
; ================

LB_ADDSTRING         EQU	0180h
LB_INSERTSTRING      EQU	0181h
LB_DELETESTRING      EQU	0182h
LB_SELITEMRANGEEX    EQU	0183h
LB_RESETCONTENT      EQU	0184h
LB_SETSEL            EQU	0185h
LB_SETCURSEL         EQU	0186h
LB_GETSEL            EQU	0187h
LB_GETCURSEL         EQU	0188h
LB_GETTEXT           EQU	0189h
LB_GETTEXTLEN        EQU	018Ah
LB_GETCOUNT          EQU	018Bh
LB_SELECTSTRING      EQU	018Ch
LB_DIR               EQU	018Dh
LB_GETTOPINDEX       EQU	018Eh
LB_FINDSTRING        EQU	018Fh
LB_GETSELCOUNT       EQU	0190h
LB_GETSELITEMS       EQU	0191h
LB_SETTABSTOPS       EQU	0192h
LB_GETHORIZONTALEXTENT EQU	0193h
LB_SETHORIZONTALEXTENT EQU	0194h
LB_SETCOLUMNWIDTH    EQU	0195h
LB_ADDFILE           EQU	0196h
LB_SETTOPINDEX       EQU	0197h
LB_GETITEMRECT       EQU	0198h
LB_GETITEMDATA       EQU	0199h
LB_SETITEMDATA       EQU	019Ah
LB_SELITEMRANGE      EQU	019Bh
LB_SETANCHORINDEX    EQU	019Ch
LB_GETANCHORINDEX    EQU	019Dh
LB_SETCARETINDEX     EQU	019Eh
LB_GETCARETINDEX     EQU	019Fh
LB_SETITEMHEIGHT     EQU	01A0h
LB_GETITEMHEIGHT     EQU	01A1h
LB_FINDSTRINGEXACT   EQU	01A2h
LB_SETLOCALE         EQU	01A5h
LB_GETLOCALE         EQU	01A6h
LB_SETCOUNT          EQU	01A7h
LB_INITSTORAGE       EQU	01A8h
LB_ITEMFROMPOINT     EQU	01A9h
LB_MSGMAX            EQU	01B0h

;------------------------------------------------------------------------------

; =====================
; listbox return values
; =====================

LB_OKAY              EQU	0
LB_ERR               EQU	-1
LB_ERRSPACE          EQU	-2

;------------------------------------------------------------------------------

; ==========================
; listbox notification codes
; ==========================

LBN_ERRSPACE         EQU	-2
LBN_SELCHANGE        EQU	1
LBN_DBLCLK           EQU	2
LBN_SELCANCEL        EQU	3
LBN_SETFOCUS         EQU	4
LBN_KILLFOCUS        EQU	5

;------------------------------------------------------------------------------

; ==================
; local memory flags
; ==================

LMEM_FIXED           EQU	0000h
LMEM_MOVEABLE        EQU	0002h
LMEM_NOCOMPACT       EQU	0010h
LMEM_NODISCARD       EQU	0020h
LMEM_ZEROINIT        EQU	0040h
LMEM_MODIFY          EQU	0080h
LMEM_LOCKCOUNT       EQU	00FFh
LMEM_DISCARDABLE     EQU	0F00h
LMEM_DISCARDED       EQU	4000h
LMEM_INVALID_HANDLE  EQU	8000h

LMEM_VALID_FLAGS     EQU	0F72h

NONZEROLHND          EQU	LMEM_MOVEABLE
NONZEROLPTR          EQU	LMEM_FIXED

LHND                 EQU	LMEM_ZEROINIT+LMEM_MOVEABLE
LPTR                 EQU	LMEM_ZEROINIT+LMEM_FIXED

;------------------------------------------------------------------------------

; ==================
; list view messages
; ==================

LVM_FIRST            EQU	1000h

LVM_GETBKCOLOR       EQU	LVM_FIRST+000
LVM_SETBKCOLOR       EQU	LVM_FIRST+001
LVM_GETIMAGELIST     EQU	LVM_FIRST+002
LVM_SETIMAGELIST     EQU	LVM_FIRST+003
LVM_GETITEMCOUNT     EQU	LVM_FIRST+004
LVM_GETITEMA         EQU	LVM_FIRST+005
LVM_SETITEMA         EQU	LVM_FIRST+006
LVM_INSERTITEMA      EQU	LVM_FIRST+007
LVM_DELETEITEM       EQU	LVM_FIRST+008
LVM_DELETEALLITEMS   EQU	LVM_FIRST+009
LVM_GETCALLBACKMASK  EQU	LVM_FIRST+010
LVM_SETCALLBACKMASK  EQU	LVM_FIRST+011
LVM_GETNEXTITEM      EQU	LVM_FIRST+012
LVM_FINDITEMA        EQU	LVM_FIRST+013
LVM_GETITEMRECT      EQU	LVM_FIRST+014
LVM_SETITEMPOSITION  EQU	LVM_FIRST+015
LVM_GETITEMPOSITION  EQU	LVM_FIRST+016
LVM_GETSTRINGWIDTHA  EQU	LVM_FIRST+017
LVM_HITTEST          EQU	LVM_FIRST+018
LVM_ENSUREVISIBLE    EQU	LVM_FIRST+019
LVM_SCROLL           EQU	LVM_FIRST+020
LVM_REDRAWITEMS      EQU	LVM_FIRST+021
LVM_ARRANGE          EQU	LVM_FIRST+022
LVM_EDITLABELA       EQU	LVM_FIRST+023
LVM_GETEDITCONTROL   EQU	LVM_FIRST+024
LVM_GETCOLUMNA       EQU	LVM_FIRST+025
LVM_SETCOLUMNA       EQU	LVM_FIRST+026
LVM_INSERTCOLUMNA    EQU	LVM_FIRST+027
LVM_DELETECOLUMN     EQU	LVM_FIRST+028
LVM_GETCOLUMNWIDTH   EQU	LVM_FIRST+029
LVM_SETCOLUMNWIDTH   EQU	LVM_FIRST+030
LVM_CREATEDRAGIMAGE  EQU	LVM_FIRST+033
LVM_GETVIEWRECT      EQU	LVM_FIRST+034
LVM_GETTEXTCOLOR     EQU	LVM_FIRST+035
LVM_SETTEXTCOLOR     EQU	LVM_FIRST+036
LVM_GETTEXTBKCOLOR   EQU	LVM_FIRST+037
LVM_SETTEXTBKCOLOR   EQU	LVM_FIRST+038
LVM_GETTOPINDEX      EQU	LVM_FIRST+039
LVM_GETCOUNTPERPAGE  EQU	LVM_FIRST+040
LVM_GETORIGIN        EQU	LVM_FIRST+041
LVM_UPDATE           EQU	LVM_FIRST+042
LVM_SETITEMSTATE     EQU	LVM_FIRST+043
LVM_GETITEMSTATE     EQU	LVM_FIRST+044
LVM_GETITEMTEXTA     EQU	LVM_FIRST+045
LVM_SETITEMTEXTA     EQU	LVM_FIRST+046
LVM_SETITEMCOUNT     EQU	LVM_FIRST+047
LVM_SORTITEMS        EQU	LVM_FIRST+048
LVM_SETITEMPOSITION32 EQU	LVM_FIRST+049
LVM_GETSELECTEDCOUNT EQU	LVM_FIRST+050
LVM_GETITEMSPACING   EQU	LVM_FIRST+051
LVM_GETISEARCHSTRINGA EQU	LVM_FIRST+052

LVM_GETITEMW         EQU	LVM_FIRST+075
LVM_SETITEMW         EQU	LVM_FIRST+076
LVM_INSERTITEMW      EQU	LVM_FIRST+077
LVM_FINDITEMW        EQU	LVM_FIRST+083
LVM_GETSTRINGWIDTHW  EQU	LVM_FIRST+087
LVM_GETCOLUMNW       EQU	LVM_FIRST+095
LVM_SETCOLUMNW       EQU	LVM_FIRST+096
LVM_INSERTCOLUMNW    EQU	LVM_FIRST+097
LVM_GETITEMTEXTW     EQU	LVM_FIRST+115
LVM_SETITEMTEXTW     EQU	LVM_FIRST+116
LVM_GETISEARCHSTRINGW EQU	LVM_FIRST+117
LVM_EDITLABELW       EQU	LVM_FIRST+118
;
%ifdef UniCode
LVM_GETITEM          EQU	LVM_GETITEMW
LVM_SETITEM          EQU	LVM_SETITEMW
LVM_INSERTITEM       EQU	LVM_INSERTITEMW
LVM_FINDITEM         EQU	LVM_FINDITEMW
LVM_GETSTRINGWIDTH   EQU	LVM_GETSTRINGWIDTHW
LVM_GETCOLUMN        EQU	LVM_GETCOLUMNW
LVM_SETCOLUMN        EQU	LVM_SETCOLUMNW
LVM_INSERTCOLUMN     EQU	LVM_INSERTCOLUMNW
LVM_GETITEMTEXT      EQU	LVM_GETITEMTEXTW
LVM_SETITEMTEXT      EQU	LVM_SETITEMTEXTW
LVM_GETISEARCHSTRING EQU	LVM_GETISEARCHSTRINGW
LVM_EDITLABEL        EQU	LVM_EDITLABELW
%else
LVM_GETITEM          EQU	LVM_GETITEMA
LVM_SETITEM          EQU	LVM_SETITEMA
LVM_INSERTITEM       EQU	LVM_INSERTITEMA
LVM_FINDITEM         EQU	LVM_FINDITEMA
LVM_GETSTRINGWIDTH   EQU	LVM_GETSTRINGWIDTHA
LVM_GETCOLUMN        EQU	LVM_GETCOLUMNA
LVM_SETCOLUMN        EQU	LVM_SETCOLUMNA
LVM_INSERTCOLUMN     EQU	LVM_INSERTCOLUMNA
LVM_GETITEMTEXT      EQU	LVM_GETITEMTEXTA
LVM_SETITEMTEXT      EQU	LVM_SETITEMTEXTA
LVM_GETISEARCHSTRING EQU	LVM_GETISEARCHSTRINGA
LVM_EDITLABEL        EQU	LVM_EDITLABELA
%endif

;------------------------------------------------------------------------------

; =======================
; list view notifications
; =======================

LVN_FIRST            EQU	-100
LVN_LAST             EQU	LVN_FIRST-99

LVN_ITEMCHANGING     EQU	LVN_FIRST-00
LVN_ITEMCHANGED      EQU	LVN_FIRST-01
LVN_INSERTITEM       EQU	LVN_FIRST-02
LVN_DELETEITEM       EQU	LVN_FIRST-03
LVN_DELETEALLITEMS   EQU	LVN_FIRST-04
LVN_BEGINLABELEDITA  EQU	LVN_FIRST-05
LVN_ENDLABELEDITA    EQU	LVN_FIRST-06
LVN_COLUMNCLICK      EQU	LVN_FIRST-08
LVN_BEGINDRAG        EQU	LVN_FIRST-09
LVN_BEGINRDRAG       EQU	LVN_FIRST-11
LVN_GETDISPINFOA     EQU	LVN_FIRST-50
LVN_SETDISPINFOA     EQU	LVN_FIRST-51

LVN_BEGINLABELEDITW  EQU	LVN_FIRST-75
LVN_ENDLABELEDITW    EQU	LVN_FIRST-76
LVN_GETDISPINFOW     EQU	LVN_FIRST-77
LVN_SETDISPINFOW     EQU	LVN_FIRST-78

%ifdef  UniCode
LVN_BEGINLABELEDIT   EQU	LVN_BEGINLABELEDITW
LVN_ENDLABELEDIT     EQU	LVN_ENDLABELEDITW
LVN_GETDISPINFO      EQU	LVN_GETDISPINFOW
LVN_SETDISPINFO      EQU	LVN_SETDISPINFOW
%else
LVN_BEGINLABELEDIT   EQU	LVN_BEGINLABELEDITA
LVN_ENDLABELEDIT     EQU	LVN_ENDLABELEDITA
LVN_GETDISPINFO      EQU	LVN_GETDISPINFOA
LVN_SETDISPINFO      EQU	LVN_SETDISPINFOA
%endif

;------------------------------------------------------------------------------

; ==================
; MessageBox() flags
; ==================

MB_OK                EQU	00000000h
MB_OKCANCEL          EQU	00000001h
MB_ABORTRETRYIGNORE  EQU	00000002h
MB_YESNOCANCEL       EQU	00000003h
MB_YESNO             EQU	00000004h
MB_RETRYCANCEL       EQU	00000005h

MB_ICONHAND          EQU	00000010h
MB_ICONQUESTION      EQU	00000020h
MB_ICONEXCLAMATION   EQU	00000030h
MB_ICONASTERISK      EQU	00000040h

MB_ICONWARNING       EQU	MB_ICONEXCLAMATION
MB_ICONERROR         EQU	MB_ICONHAND
MB_ICONINFORMATION   EQU	MB_ICONASTERISK
MB_ICONSTOP          EQU	MB_ICONHAND

MB_DEFBUTTON1        EQU	00000000h
MB_DEFBUTTON2        EQU	00000100h
MB_DEFBUTTON3        EQU	00000200h
MB_DEFBUTTON4        EQU	00000300h

MB_APPLMODAL         EQU	00000000h
MB_SYSTEMMODAL       EQU	00001000h
MB_TASKMODAL         EQU	00002000h
MB_HELP              EQU	00004000h
MB_TOPMOST           EQU	00040000h
MB_RIGHT             EQU	00080000h
MB_RTLREADING        EQU	00100000h


MB_NOFOCUS           EQU	00008000h
MB_SETFOREGROUND     EQU	00010000h
MB_DEFAULT_DESKTOP_ONLY EQU	00020000h
MB_SERVICE_NOTIFICATION EQU	00200000h  ;NT 4.0 and later (see MessageBox doc)

MB_TYPEMASK          EQU	0000000Fh
MB_USERICON          EQU	00000080h
MB_ICONMASK          EQU	000000F0h
MB_DEFMASK           EQU	00000F00h
MB_MODEMASK          EQU	00003000h
MB_MISCMASK          EQU	0000C000h

;------------------------------------------------------------------------------

; ==========
; mem flags
; ==========
PAGE_NOACCESS			equ	00000001h
PAGE_READONLY			equ	00000002h
PAGE_READWRITE			equ	00000004h
PAGE_WRITECOPY			equ	00000008h
PAGE_EXECUTE			equ	00000010h
PAGE_EXECUTE_READ		equ	00000020h
PAGE_EXECUTE_READWRITE		equ	00000040h
PAGE_EXECUTE_WRITECOPY		equ	00000080h
PAGE_GUARD			equ	00000100h
PAGE_NOCACHE			equ	00000200h
PAGE_WRITECOMBINE		equ 	00000400h

MEM_COMMIT			equ 	00001000h
MEM_RESERVE			equ 	00002000h
MEM_DECOMMIT			equ 	00004000h
MEM_RELEASE			equ 	00008000h
MEM_FREE			equ 	00010000h
MEM_PRIVATE			equ 	00020000h
MEM_MAPPED			equ 	00040000h
MEM_RESET			equ 	00080000h
MEM_TOP_DOWN			equ 	00100000h
MEM_WRITE_WATCH		equ 	00200000h
MEM_PHYSICAL			equ 	00400000h
MEM_4MB_PAGES			equ 	80000000h
;------------------------------------------------------------------------------

; ==========
; menu flags
; ==========

MF_INSERT            EQU	00000000h
MF_CHANGE            EQU	00000080h
MF_APPEND            EQU	00000100h
MF_DELETE            EQU	00000200h
MF_REMOVE            EQU	00001000h

MF_BYCOMMAND         EQU	00000000h
MF_BYPOSITION        EQU	00000400h

MF_SEPARATOR         EQU	00000800h

MF_ENABLED           EQU	00000000h
MF_GRAYED            EQU	00000001h
MF_DISABLED          EQU	00000002h

MF_UNCHECKED         EQU	00000000h
MF_CHECKED           EQU	00000008h
MF_USECHECKBITMAPS   EQU	00000200h

MF_STRING            EQU	00000000h
MF_BITMAP            EQU	00000004h
MF_OWNERDRAW         EQU	00000100h

MF_POPUP             EQU	00000010h
MF_MENUBARBREAK      EQU	00000020h
MF_MENUBREAK         EQU	00000040h

MF_UNHILITE          EQU	00000000h
MF_HILITE            EQU	00000080h

MF_DEFAULT           EQU	00001000h
MF_SYSMENU           EQU	00002000h
MF_HELP              EQU	00004000h
MF_RIGHTJUSTIFY      EQU	00004000h

MF_MOUSESELECT       EQU	00008000h
MF_END               EQU	00000080h  ;obsolete

MFT_STRING           EQU	MF_STRING
MFT_BITMAP           EQU	MF_BITMAP
MFT_MENUBARBREAK     EQU	MF_MENUBARBREAK
MFT_MENUBREAK        EQU	MF_MENUBREAK
MFT_OWNERDRAW        EQU	MF_OWNERDRAW
MFT_RADIOCHECK       EQU	00000200h
MFT_SEPARATOR        EQU	MF_SEPARATOR
MFT_RIGHTORDER       EQU	00002000h
MFT_RIGHTJUSTIFY     EQU	MF_RIGHTJUSTIFY

MFS_GRAYED           EQU	00000003h
MFS_DISABLED         EQU	MFS_GRAYED
MFS_CHECKED          EQU	MF_CHECKED
MFS_HILITE           EQU	MF_HILITE
MFS_ENABLED          EQU	MF_ENABLED
MFS_UNCHECKED        EQU	MF_UNCHECKED
MFS_UNHILITE         EQU	MF_UNHILITE
MFS_DEFAULT          EQU	MF_DEFAULT

;------------------------------------------------------------------------------

; ========================
; mouse message key states
; ========================

MK_LBUTTON           EQU	0001h
MK_RBUTTON           EQU	0002h
MK_SHIFT             EQU	0004h
MK_CONTROL           EQU	0008h
MK_MBUTTON           EQU	0010h

;------------------------------------------------------------------------------

; ==================
; owner draw actions
; ==================

ODA_DRAWENTIRE       EQU	0001h
ODA_SELECT           EQU	0002h
ODA_FOCUS            EQU	0004h

;------------------------------------------------------------------------------

; =================
; owner draw states
; =================

ODS_SELECTED         EQU	0001h
ODS_GRAYED           EQU	0002h
ODS_DISABLED         EQU	0004h
ODS_CHECKED          EQU	0008h
ODS_FOCUS            EQU	0010h
ODS_DEFAULT          EQU	0020h
ODS_COMBOBOXEDIT     EQU	1000h

;------------------------------------------------------------------------------

; ================
; owner draw types
; ================

ODT_MENU             EQU	1
ODT_LISTBOX          EQU	2
ODT_COMBOBOX         EQU	3
ODT_BUTTON           EQU	4
ODT_STATIC           EQU	5

;------------------------------------------------------------------------------


; ===================================
; Various Open file API access modes.
; ===================================


OF_READ              EQU	00000000h
OF_WRITE             EQU	00000001h
OF_READWRITE         EQU	00000002h
OF_SHARE_COMPAT      EQU	00000000h
OF_SHARE_EXCLUSIVE   EQU	00000010h
OF_SHARE_DENY_WRITE  EQU	00000020h
OF_SHARE_DENY_READ   EQU	00000030h
OF_SHARE_DENY_NONE   EQU	00000040h
OF_PARSE             EQU	00000100h
OF_DELETE            EQU	00000200h
OF_VERIFY            EQU	00000400h
OF_CANCEL            EQU	00000800h
OF_CREATE            EQU	00001000h
OF_PROMPT            EQU	00002000h
OF_EXIST             EQU	00004000h
OF_REOPEN            EQU	00008000h


;------------------------------------------------------------------------------

; ==================
; OPENFILENAME flags
; ==================

OFN_READONLY         EQU	00000001h
OFN_OVERWRITEPROMPT  EQU	00000002h
OFN_HIDEREADONLY     EQU	00000004h
OFN_NOCHANGEDIR      EQU	00000008h
OFN_SHOWHELP         EQU	00000010h
OFN_ENABLEHOOK       EQU	00000020h
OFN_ENABLETEMPLATE   EQU	00000040h
OFN_ENABLETEMPLATEHANDLE EQU	00000080h
OFN_NOVALIDATE       EQU	00000100h
OFN_ALLOWMULTISELECT EQU	00000200h
OFN_EXTENSIONDIFFERENT EQU	00000400h
OFN_PATHMUSTEXIST    EQU	00000800h
OFN_FILEMUSTEXIST    EQU	00001000h
OFN_CREATEPROMPT     EQU	00002000h
OFN_SHAREAWARE       EQU	00004000h
OFN_NOREADONLYRETURN EQU	00008000h
OFN_NOTESTFILECREATE EQU	00010000h
OFN_NONETWORKBUTTON  EQU	00020000h
OFN_NOLONGNAMES      EQU	00040000h
OFN_EXPLORER         EQU	00080000h
OFN_NODEREFERENCELINKS EQU	00100000h
OFN_LONGNAMES        EQU	00200000h



;------------------------------------------------------------------------------

; ==============================
; OPENFILENAME hook return codes
; ==============================

OFN_SHAREWARN        EQU	0
OFN_SHARENOWARN      EQU	1
OFN_SHAREFALLTHROUGH EQU	2



; -----------------------------------------------------------------------------

; =====================
; PRINTDLG definitions.
; =====================

PD_ALLPAGES          EQU	00000000h
PD_SELECTION         EQU	00000001h
PD_PAGENUMS          EQU	00000002h
PD_NOSELECTION       EQU	00000004h
PD_NOPAGENUMS        EQU	00000008h
PD_COLLATE           EQU	00000010h
PD_PRINTTOFILE       EQU	00000020h
PD_PRINTSETUP        EQU	00000040h
PD_NOWARNING         EQU	00000080h
PD_RETURNDC          EQU	00000100h
PD_RETURNIC          EQU	00000200h
PD_RETURNDEFAULT     EQU	00000400h
PD_SHOWHELP          EQU	00000800h
PD_ENABLEPRINTHOOK   EQU	00001000h
PD_ENABLESETUPHOOK   EQU	00002000h
PD_ENABLEPRINTTEMPLATE EQU	00004000h
PD_ENABLESETUPTEMPLATE EQU	00008000h
PD_ENABLEPRINTTEMPLATEHANDLE EQU	00010000h
PD_ENABLESETUPTEMPLATEHANDLE EQU	00020000h
PD_USEDEVMODECOPIES  EQU	00040000h
PD_USEDEVMODECOPIESANDCOLLATE EQU	00040000h
PD_DISABLEPRINTTOFILE EQU	00080000h
PD_HIDEPRINTTOFILE   EQU	00100000h
PD_NONETWORKBUTTON   EQU	00200000h


;------------------------------------------------------------------------------

; ================
; pipe definitions
; ================

PIPE_ACCESS_INBOUND  EQU	00000001h
PIPE_ACCESS_OUTBOUND EQU	00000002h
PIPE_ACCESS_DUPLEX   EQU	00000003h

PIPE_CLIENT_END      EQU	00000000h
PIPE_SERVER_END      EQU	00000001h

PIPE_WAIT            EQU	00000000h
PIPE_NOWAIT          EQU	00000001h

PIPE_READMODE_BYTE   EQU	00000000h
PIPE_READMODE_MESSAGE EQU	00000002h

PIPE_TYPE_BYTE       EQU	00000000h
PIPE_TYPE_MESSAGE    EQU	00000004h

PIPE_UNLIMITED_INSTANCES EQU	255


;------------------------------------------------------------------------------

; ========================
; binary raster operations
; ========================

R2_BLACK             EQU	1         ;0
R2_NOTMERGEPEN       EQU	2         ;DPon
R2_MASKNOTPEN        EQU	3         ;DPna
R2_NOTCOPYPEN        EQU	4         ;PN
R2_MASKPENNOT        EQU	5         ;PDna
R2_NOT               EQU	6         ;Dn
R2_XORPEN            EQU	7         ;DPx
R2_NOTMASKPEN        EQU	8         ;DPan
R2_MASKPEN           EQU	9         ;DPa
R2_NOTXORPEN         EQU	10         ;DPxn
R2_NOP               EQU	11         ;D
R2_MERGENOTPEN       EQU	12         ;DPno
R2_COPYPEN           EQU	13         ;P
R2_MERGEPENNOT       EQU	14         ;PDno
R2_MERGEPEN          EQU	15         ;DPo
R2_WHITE             EQU	16         ;1
R2_LAST              EQU	16
;
;------------------------------------------------------------------------------

; =================
; network resources
; =================

RESOURCE_CONNECTED   EQU	00000001h
RESOURCE_GLOBALNET   EQU	00000002h
RESOURCE_REMEMBERED  EQU	00000003h
RESOURCE_RECENT      EQU	00000004h
RESOURCE_CONTEXT     EQU	00000005h

RESOURCETYPE_ANY     EQU	00000000h
RESOURCETYPE_DISK    EQU	00000001h
RESOURCETYPE_PRINT   EQU	00000002h
RESOURCETYPE_RESERVED EQU	00000008h
RESOURCETYPE_UNKNOWN EQU	-1

RESOURCEUSAGE_CONNECTABLE EQU	00000001h
RESOURCEUSAGE_CONTAINER EQU	00000002h
RESOURCEUSAGE_NOLOCALDEVICE EQU	00000004h
RESOURCEUSAGE_SIBLING EQU	00000008h
RESOURCEUSAGE_RESERVED EQU	80000000h

RESOURCEUSAGE_ALL    EQU	RESOURCEUSAGE_CONNECTABLE+RESOURCEUSAGE_CONTAINER

RESOURCEDISPLAYTYPE_GENERIC EQU	00000000h
RESOURCEDISPLAYTYPE_DOMAIN EQU	00000001h
RESOURCEDISPLAYTYPE_SERVER EQU	00000002h
RESOURCEDISPLAYTYPE_SHARE EQU	00000003h
RESOURCEDISPLAYTYPE_FILE EQU	00000004h
RESOURCEDISPLAYTYPE_GROUP EQU	00000005h
RESOURCEDISPLAYTYPE_NETWORK EQU	00000006h
RESOURCEDISPLAYTYPE_ROOT EQU	00000007h
RESOURCEDISPLAYTYPE_SHAREADMIN EQU	00000008h
RESOURCEDISPLAYTYPE_DIRECTORY EQU	00000009h
RESOURCEDISPLAYTYPE_TREE EQU	0000000Ah

;------------------------------------------------------------------------------

; ==========
; rgb colors
; ==========

RGB_BLACK            EQU	00000000h
RGB_VDKGRAY32        EQU	00202020h
RGB_DKGRAY           EQU	00404040h
RGB_SOLIDGRAY        EQU	00808080h
RGB_SOLIDLTGRAY      EQU	00C0C0C0h
RGB_EBONY            EQU	00E0E0E0h
RGB_BLUE             EQU	00FF0000h
RGB_GREEN            EQU	0000FF00h
RGB_RED              EQU	000000FFh

RGB_CYAN             EQU	RGB_BLUE + RGB_GREEN
RGB_MAGENTA          EQU	RGB_BLUE               + RGB_RED
RGB_YELLOW           EQU	RGB_GREEN   + RGB_RED
RGB_WHITE            EQU	RGB_BLUE + RGB_GREEN   + RGB_RED

RGB_DKBLUE           EQU	00800000h
RGB_DKGREEN          EQU	00008000h
RGB_DKRED            EQU	00000080h

RGB_DKCYAN           EQU	RGB_DKBLUE + RGB_DKGREEN
RGB_DKMAGENTA        EQU	RGB_DKBLUE               + RGB_DKRED
RGB_DKYELLOW         EQU	RGB_DKGREEN + RGB_DKRED

;------------------------------------------------------------------------------

; ===================
; CombineRgn() styles
; ===================

RGN_AND              EQU	1
RGN_OR               EQU	2
RGN_XOR              EQU	3
RGN_DIFF             EQU	4
RGN_COPY             EQU	5
RGN_MIN              EQU	RGN_AND
RGN_MAX              EQU	RGN_COPY

;------------------------------------------------------------------------------

; ====================
; scroll bar constants
; ====================

SB_HORZ              EQU	0
SB_VERT              EQU	1
SB_CTL               EQU	2
SB_BOTH              EQU	3

;------------------------------------------------------------------------------

; ===================
; scroll bar commands
; ===================

SB_LINEUP            EQU	0
SB_LINELEFT          EQU	0
SB_LINEDOWN          EQU	1
SB_LINERIGHT         EQU	1
SB_PAGEUP            EQU	2
SB_PAGELEFT          EQU	2
SB_PAGEDOWN          EQU	3
SB_PAGERIGHT         EQU	3
SB_THUMBPOSITION     EQU	4
SB_THUMBTRACK        EQU	5
SB_TOP               EQU	6
SB_LEFT              EQU	6
SB_BOTTOM            EQU	7
SB_RIGHT             EQU	7
SB_ENDSCROLL         EQU	8

;------------------------------------------------------------------------------

; ===================
; status bar messages
; ===================

WM_USER              EQU	0400h

SB_SETTEXTA          EQU	WM_USER+01
SB_GETTEXTA          EQU	WM_USER+02
SB_GETTEXTLENGTHA    EQU	WM_USER+03
SB_SETPARTS          EQU	WM_USER+04
SB_GETPARTS          EQU	WM_USER+06
SB_GETBORDERS        EQU	WM_USER+07
SB_SETMINHEIGHT      EQU	WM_USER+08
SB_SIMPLE            EQU	WM_USER+09
SB_GETRECT           EQU	WM_USER+10
SB_SETTEXTW          EQU	WM_USER+11
SB_GETTEXTLENGTHW    EQU	WM_USER+12
SB_GETTEXTW          EQU	WM_USER+13

%ifdef  UniCode
SB_GETTEXT           EQU	SB_GETTEXTW
SB_SETTEXT           EQU	SB_SETTEXTW
SB_GETTEXTLENGTH     EQU	SB_GETTEXTLENGTHW
%else
SB_GETTEXT           EQU	SB_GETTEXTA
SB_SETTEXT           EQU	SB_SETTEXTA
SB_GETTEXTLENGTH     EQU	SB_GETTEXTLENGTHA
%endif

;------------------------------------------------------------------------------

; ===================
; scroll bar messages
; ===================

SBM_SETPOS           EQU	00E0h
SBM_GETPOS           EQU	00E1h
SBM_SETRANGE         EQU	00E2h
SBM_GETRANGE         EQU	00E3h
SBM_ENABLE_ARROWS    EQU	00E4h
SBM_SETRANGEREDRAW   EQU	00E6h
SBM_SETSCROLLINFO    EQU	00E9h
SBM_GETSCROLLINFO    EQU	00EAh

;------------------------------------------------------------------------------

; ================
; status bar types
; ================

SBT_DEFAULT          EQU	0000h
SBT_NOBORDERS        EQU	0100h
SBT_POPOUT           EQU	0200h
SBT_RTLREADING       EQU	0400h
SBT_OWNERDRAW        EQU	1000h

;------------------------------------------------------------------------------

; ===================
; security attributes
; ===================

SECURITY_ANONYMOUS   EQU	00000000h
SECURITY_IDENTIFICATION EQU	00010000h
SECURITY_IMPERSONATION EQU	00020000h
SECURITY_DELEGATION  EQU	00030000h

SECURITY_CONTEXT_TRACKING EQU	00040000h
SECURITY_EFFECTIVE_ONLY EQU	00080000h

SECURITY_SQOS_PRESENT EQU	00100000h
SECURITY_VALID_SQOS_FLAGS EQU	001F0000h

;------------------------------------------------------------------------------

; =====================
; WM_SIZE wParam values
; =====================

SIZE_RESTORED        EQU	0
SIZE_MINIMIZED       EQU	1
SIZE_MAXIMIZED       EQU	2
SIZE_MAXSHOW         EQU	3
SIZE_MAXHIDE         EQU	4

SIZENORMAL           EQU	SIZE_RESTORED
SIZEICONIC           EQU	SIZE_MINIMIZED
SIZEFULLSCREEN       EQU	SIZE_MAXIMIZED
SIZEZOOMSHOW         EQU	SIZE_MAXSHOW
SIZEZOOMHIDE         EQU	SIZE_MAXHIDE

;------------------------------------------------------------------------------

; ========================
; GetSystemMetrics() codes
; ========================

SM_CXSCREEN          EQU	0
SM_CYSCREEN          EQU	1
SM_CXVSCROLL         EQU	2
SM_CYHSCROLL         EQU	3
SM_CYCAPTION         EQU	4
SM_CXBORDER          EQU	5
SM_CYBORDER          EQU	6
SM_CXDLGFRAME        EQU	7
SM_CYDLGFRAME        EQU	8
SM_CYVTHUMB          EQU	9
SM_CXHTHUMB          EQU	10
SM_CXICON            EQU	11
SM_CYICON            EQU	12
SM_CXCURSOR          EQU	13
SM_CYCURSOR          EQU	14
SM_CYMENU            EQU	15
SM_CXFULLSCREEN      EQU	16
SM_CYFULLSCREEN      EQU	17
SM_CYKANJIWINDOW     EQU	18
SM_MOUSEPRESENT      EQU	19
SM_CYVSCROLL         EQU	20
SM_CXHSCROLL         EQU	21
SM_DEBUG             EQU	22
SM_SWAPBUTTON        EQU	23
SM_RESERVED1         EQU	24
SM_RESERVED2         EQU	25
SM_RESERVED3         EQU	26
SM_RESERVED4         EQU	27
SM_CXMIN             EQU	28
SM_CYMIN             EQU	29
SM_CXSIZE            EQU	30
SM_CYSIZE            EQU	31
SM_CXFRAME           EQU	32
SM_CYFRAME           EQU	33
SM_CXMINTRACK        EQU	34
SM_CYMINTRACK        EQU	35
SM_CXDOUBLECLK       EQU	36
SM_CYDOUBLECLK       EQU	37
SM_CXICONSPACING     EQU	38
SM_CYICONSPACING     EQU	39
SM_MENUDROPALIGNMENT EQU	40
SM_PENWINDOWS        EQU	41
SM_DBCSENABLED       EQU	42
SM_CMOUSEBUTTONS     EQU	43
SM_SECURE            EQU	44
SM_CXEDGE            EQU	45
SM_CYEDGE            EQU	46
SM_CXMINSPACING      EQU	47
SM_CYMINSPACING      EQU	48
SM_CXSMICON          EQU	49
SM_CYSMICON          EQU	50
SM_CYSMCAPTION       EQU	51
SM_CXSMSIZE          EQU	52
SM_CYSMSIZE          EQU	53
SM_CXMENUSIZE        EQU	54
SM_CYMENUSIZE        EQU	55
SM_ARRANGE           EQU	56
SM_CXMINIMIZED       EQU	57
SM_CYMINIMIZED       EQU	58
SM_CXMAXTRACK        EQU	59
SM_CYMAXTRACK        EQU	60
SM_CXMAXIMIZED       EQU	61
SM_CYMAXIMIZED       EQU	62
SM_NETWORK           EQU	63
SM_CLEANBOOT         EQU	67
SM_CXDRAG            EQU	68
SM_CYDRAG            EQU	69
SM_SHOWSOUNDS        EQU	70
SM_CXMENUCHECK       EQU	71
SM_CYMENUCHECK       EQU	72
SM_SLOWMACHINE       EQU	73
SM_MIDEASTENABLED    EQU	74

SM_CXFIXEDFRAME      EQU	SM_CXDLGFRAME
SM_CYFIXEDFRAME      EQU	SM_CYDLGFRAME
SM_CXSIZEFRAME       EQU	SM_CXFRAME
SM_CYSIZEFRAME       EQU	SM_CYFRAME



;------------------------------------------------------------------------------

; ==============
; Sound stuff.
; ==============


SND_SYNC             EQU	00000h ; play synchronously (default)
SND_ASYNC            EQU	00001h ; play asynchronously
SND_NODEFAULT        EQU	00002h ; silence (!default) if sound not found
SND_MEMORY           EQU	00004h ; pszSound points to a memory file
SND_LOOP             EQU	00008h ; loop the sound until next sndPlaySound
SND_NOSTOP           EQU	00010h ; don't stop any currently playing sound
SND_NOWAIT           EQU	000002000h ; don't wait if the driver is busy
SND_ALIAS            EQU	000010000h ; name is a registry alias
SND_ALIAS_ID         EQU	000110000h ; alias is a predefined ID
SND_FILENAME         EQU	000020000h ; name is file name
SND_RESOURCE         EQU	000040004h ; name is resource name or atom
SND_PURGE            EQU	00040h ; purge non-static events for task
SND_APPLICATION      EQU	00080h ;look for application specific association



;------------------------------------------------------------------------------

; ================
; startup commands
; ================

STARTF_USESHOWWINDOW EQU	00000001h
STARTF_USESIZE       EQU	00000002h
STARTF_USEPOSITION   EQU	00000004h
STARTF_USECOUNTCHARS EQU	00000008h
STARTF_USEFILLATTRIBUTE EQU	00000010h
STARTF_RUNFULLSCREEN EQU	00000020h  ;ignored for non-x86
STARTF_FORCEONFEEDBACK EQU	00000040h
STARTF_FORCEOFFFEEDBACK EQU	00000080h
STARTF_USESTDHANDLES EQU	00000100h
STARTF_USEHOTKEY     EQU	00000200h

;------------------------------------------------------------------------------

;------------------------------------------------------------------------------

; ========================
; toolbar standard bitmaps
; ========================

STD_CUT              EQU	0
STD_COPY             EQU	1
STD_PASTE            EQU	2
STD_UNDO             EQU	3
STD_REDOW            EQU	4
STD_DELETE           EQU	5
STD_FILENEW          EQU	6
STD_FILEOPEN         EQU	7
STD_FILESAVE         EQU	8
STD_PRINTPRE         EQU	9
STD_PROPERTIES       EQU	10
STD_HELP             EQU	11
STD_FIND             EQU	12
STD_REPLACE          EQU	13
STD_PRINT            EQU	14

;------------------------------------------------------------------------------

; =====================
; standard file handles
; =====================

STD_INPUT_HANDLE     EQU	-10
STD_OUTPUT_HANDLE    EQU	-11
STD_ERROR_HANDLE     EQU	-12

;------------------------------------------------------------------------------

; =====================
; ShowWindow() commands
; =====================

SW_HIDE              EQU	0
SW_SHOWNORMAL        EQU	1
SW_NORMAL            EQU	1
SW_SHOWMINIMIZED     EQU	2
SW_SHOWMAXIMIZED     EQU	3
SW_MAXIMIZE          EQU	3
SW_SHOWNOACTIVATE    EQU	4
SW_SHOW              EQU	5
SW_MINIMIZE          EQU	6
SW_SHOWMINNOACTIVE   EQU	7
SW_SHOWNA            EQU	8
SW_RESTORE           EQU	9
SW_SHOWDEFAULT       EQU	10
SW_MAX               EQU	10

;------------------------------------------------------------------------------

; ====================
; SetWindowPos() flags
; ====================

SWP_NOSIZE           EQU	0001h
SWP_NOMOVE           EQU	0002h
SWP_NOZORDER         EQU	0004h
SWP_NOREDRAW         EQU	0008h
SWP_NOACTIVATE       EQU	0010h
SWP_FRAMECHANGED     EQU	0020h
SWP_SHOWWINDOW       EQU	0040h
SWP_HIDEWINDOW       EQU	0080h
SWP_NOCOPYBITS       EQU	0100h
SWP_NOOWNERZORDER    EQU	0200h
SWP_NOSENDCHANGING   EQU	0400h
SWP_DEFERERASE       EQU	2000h
SWP_ASYNCWINDOWPOS   EQU	4000h

SWP_DRAWFRAME        EQU	SWP_FRAMECHANGED
SWP_NOREPOSITION     EQU	SWP_NOOWNERZORDER

;------------------------------------------------------------------------------

; ======================
; text alignment options
; ======================

TA_NOUPDATECP        EQU	0000h
TA_UPDATECP          EQU	0001h

TA_LEFT              EQU	0000h
TA_RIGHT             EQU	0002h
TA_CENTER            EQU	0006h

TA_TOP               EQU	0000h
TA_BOTTOM            EQU	0008h
TA_BASELINE          EQU	0018h
TA_RTLREADING        EQU	0100h
TA_MASK              EQU	TA_BASELINE+TA_CENTER+TA_UPDATECP+TA_RTLREADING

;------------------------------------------------------------------------------

; ================
; toolbar messages
; ================

TB_ENABLEBUTTON      EQU	WM_USER+01
TB_CHECKBUTTON       EQU	WM_USER+02
TB_PRESSBUTTON       EQU	WM_USER+03
TB_HIDEBUTTON        EQU	WM_USER+04
TB_INDETERMINATE     EQU	WM_USER+05
TB_ISBUTTONENABLED   EQU	WM_USER+09
TB_ISBUTTONCHECKED   EQU	WM_USER+10
TB_ISBUTTONPRESSED   EQU	WM_USER+11
TB_ISBUTTONHIDDEN    EQU	WM_USER+12
TB_ISBUTTONINDETERMINATE EQU	WM_USER+13
TB_SETSTATE          EQU	WM_USER+17
TB_GETSTATE          EQU	WM_USER+18
TB_ADDBITMAP         EQU	WM_USER+19
TB_ADDBUTTONS        EQU	WM_USER+20
TB_INSERTBUTTON      EQU	WM_USER+21
TB_DELETEBUTTON      EQU	WM_USER+22
TB_GETBUTTON         EQU	WM_USER+23
TB_BUTTONCOUNT       EQU	WM_USER+24
TB_COMMANDTOINDEX    EQU	WM_USER+25
TB_SAVERESTOREA      EQU	WM_USER+26
TB_CUSTOMIZE         EQU	WM_USER+27
TB_ADDSTRINGA        EQU	WM_USER+28
TB_GETITEMRECT       EQU	WM_USER+29
TB_BUTTONSTRUCTSIZE  EQU	WM_USER+30
TB_SETBUTTONSIZE     EQU	WM_USER+31
TB_SETBITMAPSIZE     EQU	WM_USER+32
TB_AUTOSIZE          EQU	WM_USER+33
TB_GETTOOLTIPS       EQU	WM_USER+35
TB_SETTOOLTIPS       EQU	WM_USER+36
TB_SETPARENT         EQU	WM_USER+37
TB_SETROWS           EQU	WM_USER+39
TB_GETROWS           EQU	WM_USER+40
TB_GETBITMAPFLAGS    EQU	WM_USER+41
TB_SETCMDID          EQU	WM_USER+42
TB_CHANGEBITMAP      EQU	WM_USER+43
TB_GETBITMAP         EQU	WM_USER+44
TB_GETBUTTONTEXTA    EQU	WM_USER+45
TB_REPLACEBITMAP     EQU	WM_USER+46
;
TB_GETBUTTONTEXTW    EQU	WM_USER+75
TB_SAVERESTOREW      EQU	WM_USER+76
TB_ADDSTRINGW        EQU	WM_USER+77

%ifdef  UniCode
TB_GETBUTTONTEXT     EQU	TB_GETBUTTONTEXTW
TB_SAVERESTORE       EQU	TB_SAVERESTOREW
TB_ADDSTRING         EQU	TB_ADDSTRINGW
%else
TB_GETBUTTONTEXT     EQU	TB_GETBUTTONTEXTA
TB_SAVERESTORE       EQU	TB_SAVERESTOREA
TB_ADDSTRING         EQU	TB_ADDSTRINGA
%endif

;------------------------------------------------------------------------------

; =====================
; toolbar notifications
; =====================

TBN_FIRST            EQU	-700
TBN_LAST             EQU	TBN_FIRST-20

TBN_GETBUTTONINFOA   EQU	TBN_FIRST-00
TBN_BEGINDRAG        EQU	TBN_FIRST-01
TBN_ENDDRAG          EQU	TBN_FIRST-02
TBN_BEGINADJUST      EQU	TBN_FIRST-03
TBN_ENDADJUST        EQU	TBN_FIRST-04
TBN_RESET            EQU	TBN_FIRST-05
TBN_QUERYINSERT      EQU	TBN_FIRST-06
TBN_QUERYDELETE      EQU	TBN_FIRST-07
TBN_TOOLBARCHANGE    EQU	TBN_FIRST-08
TBN_CUSTHELP         EQU	TBN_FIRST-09
TBN_GETBUTTONINFOW   EQU	TBN_FIRST-20

;------------------------------------------------------------------------------

; ==============
; toolbar states
; ==============

TBSTATE_CHECKED      EQU	0001h
TBSTATE_PRESSED      EQU	0002h
TBSTATE_ENABLED      EQU	0004h
TBSTATE_HIDDEN       EQU	0008h
TBSTATE_INDETERMINATE EQU	0010h
TBSTATE_WRAP         EQU	0020h

;------------------------------------------------------------------------------

; ==============
; toolbar styles
; ==============

TBSTYLE_BUTTON       EQU	0000h
TBSTYLE_SEP          EQU	0001h
TBSTYLE_CHECK        EQU	0002h
TBSTYLE_GROUP        EQU	0004h
TBSTYLE_TOOLTIPS     EQU	0100h
TBSTYLE_WRAPABLE     EQU	0200h
TBSTYLE_ALTDRAG      EQU	0400h
;
TBSTYLE_CHECKGROUP   EQU	TBSTYLE_GROUP+TBSTYLE_CHECK

;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; Sent as WM_NOTIFY messages.
; (Unicode should be implemented here. See CommCtrl.h).

TTN_FIRST            EQU	-520
TTN_LAST             EQU	-549

TTN_NEEDTEXTA        EQU	TTN_FIRST-0           ;Retrieves text for a tool
TTN_SHOW             EQU	TTN_FIRST-1           ;Tooltip about to be displayed.
TTN_POP              EQU	TTN_FIRST-2           ;Tooltip about to be hidden
TTN_NEEDTEXTW        EQU	TTN_FIRST-10          ;Retrieves text for a tool

%ifdef UniCode
TTN_NEEDTEXT         EQU	TTN_NEEDTEXTW       ;Retrieves text for a tool
%else
TTN_NEEDTEXT         EQU	TTN_NEEDTEXTA       ;Retrieves text for a tool
%endif

;------------------------------------------------------------------------------

; ==================
; tree view messages
; ==================

TVM_FIRST            EQU	1100h
TV_FIRST             EQU	TVM_FIRST

TVM_INSERTITEMA      EQU	TVM_FIRST+00
TVM_DELETEITEM       EQU	TVM_FIRST+01
TVM_EXPAND           EQU	TVM_FIRST+02
TVM_GETITEMRECT      EQU	TVM_FIRST+04
TVM_GETCOUNT         EQU	TVM_FIRST+05
TVM_GETINDENT        EQU	TVM_FIRST+06
TVM_SETINDENT        EQU	TVM_FIRST+07
TVM_GETIMAGELIST     EQU	TVM_FIRST+08
TVM_SETIMAGELIST     EQU	TVM_FIRST+09
TVM_GETNEXTITEM      EQU	TVM_FIRST+10
TVM_SELECTITEM       EQU	TVM_FIRST+11
TVM_GETITEMA         EQU	TVM_FIRST+12
TVM_SETITEMA         EQU	TVM_FIRST+13
TVM_EDITLABELA       EQU	TVM_FIRST+14
TVM_GETEDITCONTROL   EQU	TVM_FIRST+15
TVM_GETVISIBLECOUNT  EQU	TVM_FIRST+16
TVM_HITTEST          EQU	TVM_FIRST+17
TVM_CREATEDRAGIMAGE  EQU	TVM_FIRST+18
TVM_SORTCHILDREN     EQU	TVM_FIRST+19
TVM_ENSUREVISIBLE    EQU	TVM_FIRST+20
TVM_SORTCHILDRENCB   EQU	TVM_FIRST+21
TVM_ENDEDITLABELNOW  EQU	TVM_FIRST+22
TVM_GETISEARCHSTRINGA EQU	TVM_FIRST+23
;
TVM_INSERTITEMW      EQU	TVM_FIRST+50
TVM_GETITEMW         EQU	TVM_FIRST+62
TVM_SETITEMW         EQU	TVM_FIRST+63
TVM_GETISEARCHSTRINGW EQU	TVM_FIRST+64
TVM_EDITLABELW       EQU	TVM_FIRST+65

%ifdef UniCode
TVM_INSERTITEM       EQU	TVM_INSERTITEMW
TVM_GETITEM          EQU	TVM_GETITEMW
TVM_SETITEM          EQU	TVM_SETITEMW
TVM_GETISEARCHSTRING EQU	TVM_GETISEARCHSTRINGW
TVM_EDITLABEL        EQU	TVM_EDITLABELW
%else
TVM_INSERTITEM       EQU	TVM_INSERTITEMA
TVM_GETITEM          EQU	TVM_GETITEMA
TVM_SETITEM          EQU	TVM_SETITEMA
TVM_GETISEARCHSTRING EQU	TVM_GETISEARCHSTRINGA
TVM_EDITLABEL        EQU	TVM_EDITLABELA
%endif

;------------------------------------------------------------------------------

; =======================
; tree view notifications
; =======================

TVN_FIRST            EQU	-400
TVN_LAST             EQU	TVN_FIRST-99

TVN_SELCHANGINGA     EQU	TVN_FIRST-01
TVN_SELCHANGEDA      EQU	TVN_FIRST-02
TVN_GETDISPINFOA     EQU	TVN_FIRST-03
TVN_SETDISPINFOA     EQU	TVN_FIRST-04
TVN_ITEMEXPANDINGA   EQU	TVN_FIRST-05
TVN_ITEMEXPANDEDA    EQU	TVN_FIRST-06
TVN_BEGINDRAGA       EQU	TVN_FIRST-07
TVN_BEGINRDRAGA      EQU	TVN_FIRST-08
TVN_DELETEITEMA      EQU	TVN_FIRST-09
TVN_ENDLABELEDITA    EQU	TVN_FIRST-11
TVN_KEYDOWN          EQU	TVN_FIRST-12

TVN_SELCHANGINGW     EQU	TVN_FIRST-50
TVN_SELCHANGEDW      EQU	TVN_FIRST-51
TVN_GETDISPINFOW     EQU	TVN_FIRST-52
TVN_SETDISPINFOW     EQU	TVN_FIRST-53
TVN_ITEMEXPANDINGW   EQU	TVN_FIRST-54
TVN_ITEMEXPANDEDW    EQU	TVN_FIRST-55
TVN_BEGINDRAGW       EQU	TVN_FIRST-56
TVN_BEGINRDRAGW      EQU	TVN_FIRST-57
TVN_DELETEITEMW      EQU	TVN_FIRST-58
TVN_BEGINLABELEDITA  EQU	TVN_FIRST-10
TVN_BEGINLABELEDITW  EQU	TVN_FIRST-59
TVN_ENDLABELEDITW    EQU	TVN_FIRST-60

%ifdef UniCode
TVN_SELCHANGING      EQU	TVN_SELCHANGINGW
TVN_SELCHANGED       EQU	TVN_SELCHANGEDW
TVN_GETDISPINFO      EQU	TVN_GETDISPINFOW
TVN_SETDISPINFO      EQU	TVN_SETDISPINFOW
TVN_ITEMEXPANDING    EQU	TVN_ITEMEXPANDINGW
TVN_ITEMEXPANDED     EQU	TVN_ITEMEXPANDEDW
TVN_BEGINDRAG        EQU	TVN_BEGINDRAGW
TVN_BEGINRDRAG       EQU	TVN_BEGINRDRAGW
TVN_DELETEITEM       EQU	TVN_DELETEITEMW
TVN_BEGINLABELEDIT   EQU	TVN_BEGINLABELEDITW
TVN_ENDLABELEDIT     EQU	TVN_ENDLABELEDITW
%else
TVN_SELCHANGING      EQU	TVN_SELCHANGINGA
TVN_SELCHANGED       EQU	TVN_SELCHANGEDA
TVN_GETDISPINFO      EQU	TVN_GETDISPINFOA
TVN_SETDISPINFO      EQU	TVN_SETDISPINFOA
TVN_ITEMEXPANDING    EQU	TVN_ITEMEXPANDINGA
TVN_ITEMEXPANDED     EQU	TVN_ITEMEXPANDEDA
TVN_BEGINDRAG        EQU	TVN_BEGINDRAGA
TVN_BEGINRDRAG       EQU	TVN_BEGINRDRAGA
TVN_DELETEITEM       EQU	TVN_DELETEITEMA
TVN_BEGINLABELEDIT   EQU	TVN_BEGINLABELEDITA
TVN_ENDLABELEDIT     EQU	TVN_ENDLABELEDITA
%endif

;------------------------------------------------------------------------------

; ================
; os platform id's
; ================

VER_PLATFORM_WIN32s  EQU	0
VER_PLATFORM_WIN32_WINDOWS EQU	1
VER_PLATFORM_WIN32_NT EQU	2

;------------------------------------------------------------------------------

; ====================
; toolbar view bitmaps
; ====================

VIEW_LARGEICONS      EQU	0
VIEW_SMALLICONS      EQU	1
VIEW_LIST            EQU	2
VIEW_DETAILS         EQU	3
VIEW_SORTNAME        EQU	4
VIEW_SORTSIZE        EQU	5
VIEW_SORTDATE        EQU	6
VIEW_SORTTYPE        EQU	7
VIEW_PARENTFOLDER    EQU	8
VIEW_NETCONNECT      EQU	9
VIEW_NETDISCONNECT   EQU	10
VIEW_NEWFOLDER       EQU	11



;------------------------------------------------------------------------------

; ===============
; window messages
; ===============

WM_NULL              EQU	0000h
WM_CREATE            EQU	0001h
WM_DESTROY           EQU	0002h
WM_MOVE              EQU	0003h
WM_SIZE              EQU	0005h
WM_ACTIVATE          EQU	0006h
WM_SETFOCUS          EQU	0007h
WM_KILLFOCUS         EQU	0008h
WM_ENABLE            EQU	000Ah
WM_SETREDRAW         EQU	000Bh
WM_SETTEXT           EQU	000Ch
WM_GETTEXT           EQU	000Dh
WM_GETTEXTLENGTH     EQU	000Eh
WM_PAINT             EQU	000Fh
WM_CLOSE             EQU	0010h
WM_QUERYENDSESSION   EQU	0011h
WM_QUIT              EQU	0012h
WM_QUERYOPEN         EQU	0013h
WM_ERASEBKGND        EQU	0014h
WM_SYSCOLORCHANGE    EQU	0015h
WM_ENDSESSION        EQU	0016h
WM_SHOWWINDOW        EQU	0018h
WM_WININICHANGE      EQU	001Ah
WM_SETTINGCHANGE     EQU	WM_WININICHANGE
WM_DEVMODECHANGE     EQU	001Bh
WM_ACTIVATEAPP       EQU	001Ch
WM_FONTCHANGE        EQU	001Dh
WM_TIMECHANGE        EQU	001Eh
WM_CANCELMODE        EQU	001Fh
WM_SETCURSOR         EQU	0020h
WM_MOUSEACTIVATE     EQU	0021h
WM_CHILDACTIVATE     EQU	0022h
WM_QUEUESYNC         EQU	0023h
WM_GETMINMAXINFO     EQU	0024h
WM_PAINTICON         EQU	0026h
WM_ICONERASEBKGND    EQU	0027h
WM_NEXTDLGCTL        EQU	0028h
WM_SPOOLERSTATUS     EQU	002Ah
WM_DRAWITEM          EQU	002Bh
WM_MEASUREITEM       EQU	002Ch
WM_DELETEITEM        EQU	002Dh
WM_VKEYTOITEM        EQU	002Eh
WM_CHARTOITEM        EQU	002Fh
WM_SETFONT           EQU	0030h
WM_GETFONT           EQU	0031h
WM_SETHOTKEY         EQU	0032h
WM_GETHOTKEY         EQU	0033h
WM_QUERYDRAGICON     EQU	0037h
WM_COMPAREITEM       EQU	0039h
WM_COMPACTING        EQU	0041h
WM_COMMNOTIFY        EQU	0044h      ;no longer suported
WM_WINDOWPOSCHANGING EQU	0046h
WM_WINDOWPOSCHANGED  EQU	0047h
WM_POWER             EQU	0048h
WM_COPYDATA          EQU	004Ah
WM_CANCELJOURNAL     EQU	004Bh
WM_NOTIFY            EQU	004Eh
WM_INPUTLANGCHANGEREQUEST EQU	0050h
WM_INPUTLANGCHANGE   EQU	0051h
WM_TCARD             EQU	0052h
WM_HELP              EQU	0053h
WM_USERCHANGED       EQU	0054h
WM_NOTIFYFORMAT      EQU	0055h
WM_CONTEXTMENU       EQU	007Bh
WM_STYLECHANGING     EQU	007Ch
WM_STYLECHANGED      EQU	007Dh
WM_DISPLAYCHANGE     EQU	007Eh
WM_GETICON           EQU	007Fh
WM_SETICON           EQU	0080h
WM_NCCREATE          EQU	0081h
WM_NCDESTROY         EQU	0082h
WM_NCCALCSIZE        EQU	0083h
WM_NCHITTEST         EQU	0084h
WM_NCPAINT           EQU	0085h
WM_NCACTIVATE        EQU	0086h
WM_GETDLGCODE        EQU	0087h

WM_NCMOUSEMOVE       EQU	00A0h
WM_NCLBUTTONDOWN     EQU	00A1h
WM_NCLBUTTONUP       EQU	00A2h
WM_NCLBUTTONDBLCLK   EQU	00A3h
WM_NCRBUTTONDOWN     EQU	00A4h
WM_NCRBUTTONUP       EQU	00A5h
WM_NCRBUTTONDBLCLK   EQU	00A6h
WM_NCMBUTTONDOWN     EQU	00A7h
WM_NCMBUTTONUP       EQU	00A8h
WM_NCMBUTTONDBLCLK   EQU	00A9h

WM_KEYFIRST          EQU	0100h
WM_KEYDOWN           EQU	0100h
WM_KEYUP             EQU	0101h
WM_CHAR              EQU	0102h
WM_DEADCHAR          EQU	0103h
WM_SYSKEYDOWN        EQU	0104h
WM_SYSKEYUP          EQU	0105h
WM_SYSCHAR           EQU	0106h
WM_SYSDEADCHAR       EQU	0107h
WM_KEYLAST           EQU	0108h

WM_IME_STARTCOMPOSITION EQU	010Dh
WM_IME_ENDCOMPOSITION EQU	010Eh
WM_IME_COMPOSITION   EQU	010Fh
WM_IME_KEYLAST       EQU	010Fh
WM_INITDIALOG        EQU	0110h
WM_COMMAND           EQU	0111h
WM_SYSCOMMAND        EQU	0112h
WM_TIMER             EQU	0113h
WM_HSCROLL           EQU	0114h
WM_VSCROLL           EQU	0115h
WM_INITMENU          EQU	0116h
WM_INITMENUPOPUP     EQU	0117h
WM_MENUSELECT        EQU	011Fh
WM_MENUCHAR          EQU	0120h
WM_ENTERIDLE         EQU	0121h
WM_CTLCOLORMSGBOX    EQU	0132h
WM_CTLCOLOREDIT      EQU	0133h
WM_CTLCOLORLISTBOX   EQU	0134h
WM_CTLCOLORBTN       EQU	0135h
WM_CTLCOLORDLG       EQU	0136h
WM_CTLCOLORSCROLLBAR EQU	0137h
WM_CTLCOLORSTATIC    EQU	0138h

WM_MOUSEFIRST        EQU	0200h
WM_MOUSEMOVE         EQU	0200h
WM_LBUTTONDOWN       EQU	0201h
WM_LBUTTONUP         EQU	0202h
WM_LBUTTONDBLCLK     EQU	0203h
WM_RBUTTONDOWN       EQU	0204h
WM_RBUTTONUP         EQU	0205h
WM_RBUTTONDBLCLK     EQU	0206h
WM_MBUTTONDOWN       EQU	0207h
WM_MBUTTONUP         EQU	0208h
WM_MBUTTONDBLCLK     EQU	0209h
WM_MOUSELAST         EQU	0209h

WM_PARENTNOTIFY      EQU	0210h
WM_ENTERMENULOOP     EQU	0211h
WM_EXITMENULOOP      EQU	0212h
WM_NEXTMENU          EQU	0213h
WM_SIZING            EQU	0214h
WM_CAPTURECHANGED    EQU	0215h
WM_MOVING            EQU	0216h
WM_POWERBROADCAST    EQU	0218h
WM_DEVICECHANGE      EQU	0219h
WM_MDICREATE         EQU	0220h
WM_MDIDESTROY        EQU	0221h
WM_MDIACTIVATE       EQU	0222h
WM_MDIRESTORE        EQU	0223h
WM_MDINEXT           EQU	0224h
WM_MDIMAXIMIZE       EQU	0225h
WM_MDITILE           EQU	0226h
WM_MDICASCADE        EQU	0227h
WM_MDIICONARRANGE    EQU	0228h
WM_MDIGETACTIVE      EQU	0229h
WM_MDISETMENU        EQU	0230h
WM_ENTERSIZEMOVE     EQU	0231h
WM_EXITSIZEMOVE      EQU	0232h
WM_DROPFILES         EQU	0233h
WM_MDIREFRESHMENU    EQU	0234h

WM_IME_SETCONTEXT    EQU	0281h
WM_IME_NOTIFY        EQU	0282h
WM_IME_CONTROL       EQU	0283h
WM_IME_COMPOSITIONFULL EQU	0284h
WM_IME_SELECT        EQU	0285h
WM_IME_CHAR          EQU	0286h
WM_IME_KEYDOWN       EQU	0290h
WM_IME_KEYUP         EQU	0291h

WM_CUT               EQU	0300h
WM_COPY              EQU	0301h
WM_PASTE             EQU	0302h
WM_CLEAR             EQU	0303h
WM_UNDO              EQU	0304h
WM_RENDERFORMAT      EQU	0305h
WM_RENDERALLFORMATS  EQU	0306h
WM_DESTROYCLIPBOARD  EQU	0307h
WM_DRAWCLIPBOARD     EQU	0308h
WM_PAINTCLIPBOARD    EQU	0309h
WM_VSCROLLCLIPBOARD  EQU	030Ah
WM_SIZECLIPBOARD     EQU	030Bh
WM_ASKCBFORMATNAME   EQU	030Ch
WM_CHANGECBCHAIN     EQU	030Dh
WM_HSCROLLCLIPBOARD  EQU	030Eh
WM_QUERYNEWPALETTE   EQU	030Fh
WM_PALETTEISCHANGING EQU	0310h
WM_PALETTECHANGED    EQU	0311h
WM_HOTKEY            EQU	0312h
WM_PRINT             EQU	0317h
WM_PRINTCLIENT       EQU	0318h

WM_HANDHELDFIRST     EQU	0358h
WM_HANDHELDLAST      EQU	035Fh

WM_AFXFIRST          EQU	0360h
WM_AFXLAST           EQU	037Fh

WM_PENWINFIRST       EQU	0380h
WM_PENWINLAST        EQU	038Fh

WM_DDE_FIRST         EQU	03E0h
WM_DDE_INITIATE      EQU	WM_DDE_FIRST
WM_DDE_TERMINATE     EQU	WM_DDE_FIRST+1
WM_DDE_ADVISE        EQU	WM_DDE_FIRST+2
WM_DDE_UNADVISE      EQU	WM_DDE_FIRST+3
WM_DDE_ACK           EQU	WM_DDE_FIRST+4
WM_DDE_DATA          EQU	WM_DDE_FIRST+5
WM_DDE_REQUEST       EQU	WM_DDE_FIRST+6
WM_DDE_POKE          EQU	WM_DDE_FIRST+7
WM_DDE_EXECUTE       EQU	WM_DDE_FIRST+8
WM_DDE_LAST          EQU	03E8h

WM_APP               EQU	8000h

;------------------------------------------------------------------------------

; ====================
; WNet*() status codes
; ====================

WN_SUCCESS           EQU	NO_ERROR
WN_NO_ERROR          EQU	NO_ERROR

WN_NOT_SUPPORTED     EQU	ERROR_NOT_SUPPORTED
WN_CANCEL            EQU	ERROR_CANCELLED
WN_RETRY             EQU	ERROR_RETRY
WN_NET_ERROR         EQU	ERROR_UNEXP_NET_ERR
WN_MORE_DATA         EQU	ERROR_MORE_DATA
WN_BAD_POINTER       EQU	ERROR_INVALID_ADDRESS
WN_BAD_VALUE         EQU	ERROR_INVALID_PARAMETER
WN_BAD_USER          EQU	ERROR_BAD_USERNAME
WN_BAD_PASSWORD      EQU	ERROR_INVALID_PASSWORD
WN_ACCESS_DENIED     EQU	ERROR_ACCESS_DENIED
WN_FUNCTION_BUSY     EQU	ERROR_BUSY
WN_WINDOWS_ERROR     EQU	ERROR_UNEXP_NET_ERR
WN_OUT_OF_MEMORY     EQU	ERROR_NOT_ENOUGH_MEMORY
WN_NO_NETWORK        EQU	ERROR_NO_NETWORK
WN_EXTENDED_ERROR    EQU	ERROR_EXTENDED_ERROR
WN_BAD_LEVEL         EQU	ERROR_INVALID_LEVEL
WN_BAD_HANDLE        EQU	ERROR_INVALID_HANDLE
WN_NOT_INITIALIZING  EQU	ERROR_ALREADY_INITIALIZED
WN_NO_MORE_DEVICES   EQU	ERROR_NO_MORE_DEVICES

WN_NOT_CONNECTED     EQU	ERROR_NOT_CONNECTED
WN_OPEN_FILES        EQU	ERROR_OPEN_FILES
WN_DEVICE_IN_USE     EQU	ERROR_DEVICE_IN_USE
WN_BAD_NETNAME       EQU	ERROR_BAD_NET_NAME
WN_BAD_LOCALNAME     EQU	ERROR_BAD_DEVICE
WN_ALREADY_CONNECTED EQU	ERROR_ALREADY_ASSIGNED
WN_DEVICE_ERROR      EQU	ERROR_GEN_FAILURE
WN_CONNECTION_CLOSED EQU	ERROR_CONNECTION_UNAVAIL
WN_NO_NET_OR_BAD_PATH EQU	ERROR_NO_NET_OR_BAD_PATH
WN_BAD_PROVIDER      EQU	ERROR_BAD_PROVIDER
WN_CANNOT_OPEN_PROFILE EQU	ERROR_CANNOT_OPEN_PROFILE
WN_BAD_PROFILE       EQU	ERROR_BAD_PROFILE
WN_BAD_DEV_TYPE      EQU	ERROR_BAD_DEV_TYPE
WN_DEVICE_ALREADY_REMEMBERED EQU	ERROR_DEVICE_ALREADY_REMEMBERED

WN_NO_MORE_ENTRIES   EQU	ERROR_NO_MORE_ITEMS
WN_NOT_CONTAINER     EQU	ERROR_NOT_CONTAINER

WN_NOT_AUTHENTICATED EQU	ERROR_NOT_AUTHENTICATED
WN_NOT_LOGGED_ON     EQU	ERROR_NOT_LOGGED_ON
WN_NOT_VALIDATED     EQU	ERROR_NO_LOGON_SERVERS

;------------------------------------------------------------------------------

; =============
; network types
; =============

WNNC_NET_MSNET       EQU	00010000h
WNNC_NET_LANMAN      EQU	00020000h
WNNC_NET_NETWARE     EQU	00030000h
WNNC_NET_VINES       EQU	00040000h
WNNC_NET_10NET       EQU	00050000h
WNNC_NET_LOCUS       EQU	00060000h
WNNC_NET_SUN_PC_NFS  EQU	00070000h
WNNC_NET_LANSTEP     EQU	00080000h
WNNC_NET_9TILES      EQU	00090000h
WNNC_NET_LANTASTIC   EQU	000A0000h
WNNC_NET_AS400       EQU	000B0000h
WNNC_NET_FTP_NFS     EQU	000C0000h
WNNC_NET_PATHWORKS   EQU	000D0000h
WNNC_NET_LIFENET     EQU	000E0000h
WNNC_NET_POWERLAN    EQU	000F0000h
WNNC_NET_BWNFS       EQU	00100000h
WNNC_NET_COGENT      EQU	00110000h
WNNC_NET_FARALLON    EQU	00120000h
WNNC_NET_APPLETALK   EQU	00130000h

;------------------------------------------------------------------------------

; ================
; background modes
; ================

TRANSPARENT          EQU	1
OPAQUE               EQU	2
BKMODE_LAST          EQU	2

;------------------------------------------------------------------------------

; ====================
; CreateFile() actions
; ====================

CREATE_NEW           EQU	1
CREATE_ALWAYS        EQU	2
OPEN_EXISTING        EQU	3
OPEN_ALWAYS          EQU	4
TRUNCATE_EXISTING    EQU	5

;------------------------------------------------------------------------------

; =====================
; CreateProcess() flags
; =====================

DEBUG_PROCESS        EQU	00000001h
DEBUG_ONLY_THIS_PROCESS EQU	00000002h
CREATE_SUSPENDED     EQU	00000004h
DETACHED_PROCESS     EQU	00000008h
CREATE_NEW_CONSOLE   EQU	00000010h
NORMAL_PRIORITY_CLASS EQU	00000020h
IDLE_PRIORITY_CLASS  EQU	00000040h
HIGH_PRIORITY_CLASS  EQU	00000080h
REALTIME_PRIORITY_CLASS EQU	00000100h

CREATE_NEW_PROCESS_GROUP EQU	00000200h
CREATE_UNICODE_ENVIRONMENT EQU	00000400h
CREATE_SEPARATE_WOW_VDM EQU	00000800h
CREATE_SHARED_WOW_VDM EQU	00001000h
CREATE_DEFAULT_ERROR_MODE EQU	04000000h
CREATE_NO_WINDOW     EQU	08000000h

PROFILE_USER         EQU	10000000h
PROFILE_KERNEL       EQU	20000000h
PROFILE_SERVER       EQU	40000000h

SYNCHRONIZE 			EQU 00100000h;
STANDARD_RIGHTS_REQUIRED 	EQU 000F0000h;
EVENT_MODIFY_STATE 		EQU 0002h;
EVENT_ALL_ACCESS 		EQU (STANDARD_RIGHTS_REQUIRED + SYNCHRONIZE + 3h);
MUTANT_QUERY_STATE 		EQU 0001h;
MUTANT_ALL_ACCESS 		EQU (STANDARD_RIGHTS_REQUIRED + SYNCHRONIZE + MUTANT_QUERY_STATE);

PROCESS_TERMINATE         	EQU 0001h;
PROCESS_CREATE_THREAD     	EQU 0002h;
PROCESS_VM_OPERATION      	EQU 0008h;
PROCESS_VM_READ           	EQU 0010h;
PROCESS_VM_WRITE          	EQU 0020h;
PROCESS_DUP_HANDLE        	EQU 0040h;
PROCESS_CREATE_PROCESS    	EQU 0080h;
PROCESS_SET_QUOTA         	EQU 0100h;
PROCESS_SET_INFORMATION   	EQU 0200h;
PROCESS_QUERY_INFORMATION 	EQU 0400h;
PROCESS_ALL_ACCESS        	EQU (STANDARD_RIGHTS_REQUIRED + SYNCHRONIZE + 0FFFh);
;------------------------------------------------------------------------------

; ===============
; gdi error codes
; ===============

GDI_ERROR            EQU	-1
HGDI_ERROR           EQU	-1


;------------------------------------------------------------------------------

; ================
; PolyFill() modes
; ================

ALTERNATE            EQU	1
WINDING              EQU	2
POLYFILL_LAST        EQU	2

;------------------------------------------------------------------------------

; ============
; region flags
; ============

ERROR                EQU	0
NULLREGION           EQU	1
SIMPLEREGION         EQU	2
COMPLEXREGION        EQU	3
RGN_ERROR            EQU	ERROR

;------------------------------------------------------------------------------
;------------------------------------------------------------------------------

; =====================
; stock logical objects
; =====================

WHITE_BRUSH          EQU	0
LTGRAY_BRUSH         EQU	1
GRAY_BRUSH           EQU	2
DKGRAY_BRUSH         EQU	3
BLACK_BRUSH          EQU	4
NULL_BRUSH           EQU	5
WHITE_PEN            EQU	6
BLACK_PEN            EQU	7
NULL_PEN             EQU	8
OEM_FIXED_FONT       EQU	10
ANSI_FIXED_FONT      EQU	11
ANSI_VAR_FONT        EQU	12
SYSTEM_FONT          EQU	13
DEVICE_DEFAULT_FONT  EQU	14
DEFAULT_PALETTE      EQU	15
SYSTEM_FIXED_FONT    EQU	16
DEFAULT_GUI_FONT     EQU	17

HOLLOW_BRUSH         EQU	NULL_BRUSH

;------------------------------------------------------------------------------

; ==================
; StretchBlt() modes
; ==================

BLACKONWHITE         EQU	1
WHITEONBLACK         EQU	2
COLORONCOLOR         EQU	3
HALFTONE             EQU	4
MAXSTRETCHBLTMODE    EQU	4

STRETCH_ANDSCANS     EQU	BLACKONWHITE
STRETCH_ORSCANS      EQU	WHITEONBLACK
STRETCH_DELETESCANS  EQU	COLORONCOLOR
STRETCH_HALFTONE     EQU	HALFTONE

;------------------------------------------------------------------------------

; =========================
; ternary raster operations
; =========================

SRCCOPY              EQU	00CC0020h  ;dest = src
SRCPAINT             EQU	00EE0086h  ;dest = src or dest
SRCAND               EQU	008800C6h  ;dest = src and dest
SRCINVERT            EQU	00660046h  ;dest = src xor dest
SRCERASE             EQU	00440328h  ;dest = src and -dest
NOTSRCCOPY           EQU	00330008h  ;dest = -src
NOTSRCERASE          EQU	001100A6h  ;dest = -src and -dest
MERGECOPY            EQU	00C000CAh  ;dest = src and pat
MERGEPAINT           EQU	00BB0226h  ;dest = -src or dest
PATCOPY              EQU	00F00021h  ;dest = pat
PATPAINT             EQU	00FB0A09h  ;dest = DPSnoo
PATINVERT            EQU	005A0049h  ;dest = pat xor dest
DSTINVERT            EQU	00550009h  ;dest = -dest
BLACKNESS            EQU	00000042h  ;dest = black
WHITENESS            EQU	00FF0062h  ;dest = white

; Win32 Resource related equates.
;  19.JUN.96 : Philippe Auphelle.
;              Parts from from 03-14-1996 Sven B. Schreiber sbs@orgon.com
;
;  24.JUL.98 : Converted To NASM by Gij
;
; Revision 1.1  1997/09/02 09:51:12  Philippe
; Initial revision
;



; Mode indicators in status bar - these are routed like commands

ID_INDICATOR_EXT     EQU	0E700h    ; extended selection indicator
ID_INDICATOR_CAPS    EQU	0E701h    ; cap lock indicator
ID_INDICATOR_NUM     EQU	0E702h    ; num lock indicator
ID_INDICATOR_SCRL    EQU	0E703h    ; scroll lock indicator
ID_INDICATOR_OVR     EQU	0E704h    ; overtype mode indicator
ID_INDICATOR_REC     EQU	0E705h    ; record mode indicator
ID_INDICATOR_KANA    EQU	0E706h    ; kana lock indicator

ID_SEPARATOR         EQU	0         ; special separator value

; Standard Commands
; File commands

ID_FILE_NEW          EQU	0E100h
ID_FILE_OPEN         EQU	0E101h
ID_FILE_CLOSE        EQU	0E102h
ID_FILE_SAVE         EQU	0E103h
ID_FILE_SAVE_AS      EQU	0E104h
ID_FILE_PAGE_SETUP   EQU	0E105h
ID_FILE_PRINT_SETUP  EQU	0E106h
ID_FILE_PRINT        EQU	0E107h
ID_FILE_PRINT_DIRECT EQU	0E108h
ID_FILE_PRINT_PREVIEW EQU	0E109h
ID_FILE_UPDATE       EQU	0E10Ah
ID_FILE_SAVE_COPY_AS EQU	0E10Bh
ID_FILE_SEND_MAIL    EQU	0E10Ch

ID_FILE_MRU_FIRST    EQU	0E110h
ID_FILE_MRU_FILE1    EQU	0E110h    ; range - 16 max
ID_FILE_MRU_FILE2    EQU	0E111h
ID_FILE_MRU_FILE3    EQU	0E112h
ID_FILE_MRU_FILE4    EQU	0E113h
ID_FILE_MRU_FILE5    EQU	0E114h
ID_FILE_MRU_FILE6    EQU	0E115h
ID_FILE_MRU_FILE7    EQU	0E116h
ID_FILE_MRU_FILE8    EQU	0E117h
ID_FILE_MRU_FILE9    EQU	0E118h
ID_FILE_MRU_FILE10   EQU	0E119h
ID_FILE_MRU_FILE11   EQU	0E11Ah
ID_FILE_MRU_FILE12   EQU	0E11Bh
ID_FILE_MRU_FILE13   EQU	0E11Ch
ID_FILE_MRU_FILE14   EQU	0E11Dh
ID_FILE_MRU_FILE15   EQU	0E11Eh
ID_FILE_MRU_FILE16   EQU	0E11Fh
ID_FILE_MRU_LAST     EQU	0E11Fh

; Edit commands

ID_EDIT_CLEAR        EQU	0E120h
ID_EDIT_CLEAR_ALL    EQU	0E121h
ID_EDIT_COPY         EQU	0E122h
ID_EDIT_CUT          EQU	0E123h
ID_EDIT_FIND         EQU	0E124h
ID_EDIT_PASTE        EQU	0E125h
ID_EDIT_PASTE_LINK   EQU	0E126h
ID_EDIT_PASTE_SPECIAL EQU	0E127h
ID_EDIT_REPEAT       EQU	0E128h
ID_EDIT_REPLACE      EQU	0E129h
ID_EDIT_SELECT_ALL   EQU	0E12Ah
ID_EDIT_UNDO         EQU	0E12Bh
ID_EDIT_REDO         EQU	0E12Ch

; Window commands

ID_WINDOW_NEW        EQU	0E130h
ID_WINDOW_ARRANGE    EQU	0E131h
ID_WINDOW_CASCADE    EQU	0E132h
ID_WINDOW_TILE_HORZ  EQU	0E133h
ID_WINDOW_TILE_VERT  EQU	0E134h
ID_WINDOW_SPLIT      EQU	0E135h

; Help and App commands

ID_APP_ABOUT         EQU	0E140h
ID_APP_EXIT          EQU	0E141h
ID_HELP_INDEX        EQU	0E142h
ID_HELP_FINDER       EQU	0E143h
ID_HELP_USING        EQU	0E144h
ID_CONTEXT_HELP      EQU	0E145h    ; shift-F1

; special commands for processing help

ID_HELP              EQU	0E146h    ; first attempt for F1
ID_DEFAULT_HELP      EQU	0E147h    ; last attempt

; Misc

ID_NEXT_PANE         EQU	0E150h
ID_PREV_PANE         EQU	0E151h

; Format

ID_FORMAT_FONT       EQU	0E160h

; OLE commands

ID_OLE_INSERT_NEW    EQU	0E200h
ID_OLE_EDIT_LINKS    EQU	0E201h
ID_OLE_EDIT_CONVERT  EQU	0E202h
ID_OLE_EDIT_CHANGE_ICON EQU	0E203h
ID_OLE_EDIT_PROPERTIES EQU	0E204h
ID_OLE_VERB_FIRST    EQU	0E210h    ; range - 16 max
ID_OLE_VERB_LAST     EQU	0E21Fh

; View commands (same number used as IDW used for control bar)

ID_VIEW_TOOLBAR      EQU	0E800h
ID_VIEW_STATUS_BAR   EQU	0E801h
        ; -> E8FF reserved for other control bar commands

; RecordForm commands
ID_RECORD_FIRST      EQU	0E900h
ID_RECORD_LAST       EQU	0E901h
ID_RECORD_NEXT       EQU	0E902h
ID_RECORD_PREV       EQU	0E903h


VS_VERSION_INFO      EQU	1


OBM_CLOSE            EQU	32754
OBM_UPARROW          EQU	32753
OBM_DNARROW          EQU	32752
OBM_RGARROW          EQU	32751
OBM_LFARROW          EQU	32750
OBM_REDUCE           EQU	32749
OBM_ZOOM             EQU	32748
OBM_RESTORE          EQU	32747
OBM_REDUCED          EQU	32746
OBM_ZOOMD            EQU	32745
OBM_RESTORED         EQU	32744
OBM_UPARROWD         EQU	32743
OBM_DNARROWD         EQU	32742
OBM_RGARROWD         EQU	32741
OBM_LFARROWD         EQU	32740
OBM_MNARROW          EQU	32739
OBM_COMBO            EQU	32738
OBM_UPARROWI         EQU	32737
OBM_DNARROWI         EQU	32736
OBM_RGARROWI         EQU	32735
OBM_LFARROWI         EQU	32734
OBM_OLD_CLOSE        EQU	32767
OBM_SIZE             EQU	32766
OBM_OLD_UPARROW      EQU	32765
OBM_OLD_DNARROW      EQU	32764
OBM_OLD_RGARROW      EQU	32763
OBM_OLD_LFARROW      EQU	32762
OBM_BTSIZE           EQU	32761
OBM_CHECK            EQU	32760
OBM_CHECKBOXES       EQU	32759
OBM_BTNCORNERS       EQU	32758
OBM_OLD_REDUCE       EQU	32757
OBM_OLD_ZOOM         EQU	32756
OBM_OLD_RESTORE      EQU	32755
OCR_NORMAL           EQU	32512
OCR_IBEAM            EQU	32513
OCR_WAIT             EQU	32514
OCR_CROSS            EQU	32515
OCR_UP               EQU	32516
OCR_SIZE             EQU	32640
OCR_ICON             EQU	32641
OCR_SIZENWSE         EQU	32642
OCR_SIZENESW         EQU	32643
OCR_SIZEWE           EQU	32644
OCR_SIZENS           EQU	32645
OCR_SIZEALL          EQU	32646
OCR_ICOCUR           EQU	32647
OCR_NO               EQU	32648
OIC_SAMPLE           EQU	32512
OIC_HAND             EQU	32513
OIC_QUES             EQU	32514
OIC_BANG             EQU	32515
OIC_NOTE             EQU	32516

OCR_APPSTARTING      EQU	32650
OIC_WINLOGO          EQU	32517
OIC_WARNING          EQU	OIC_BANG
OIC_ERROR            EQU	OIC_HAND
OIC_INFORMATION      EQU	OIC_NOTE

WS_OVERLAPPED        EQU	000000000h
WS_TABSTOP           EQU	000010000h
WS_MAXIMIZEBOX       EQU	000010000h
WS_MINIMIZEBOX       EQU	000020000h
WS_GROUP             EQU	000020000h
WS_THICKFRAME        EQU	000040000h
WS_SYSMENU           EQU	000080000h
WS_HSCROLL           EQU	000100000h
WS_VSCROLL           EQU	000200000h
WS_DLGFRAME          EQU	000400000h
WS_BORDER            EQU	000800000h
WS_CAPTION           EQU	000C00000h
WS_MAXIMIZE          EQU	001000000h
WS_CLIPCHILDREN      EQU	002000000h
WS_CLIPSIBLINGS      EQU	004000000h
WS_DISABLED          EQU	008000000h
WS_VISIBLE           EQU	010000000h
WS_MINIMIZE          EQU	020000000h
WS_CHILD             EQU	040000000h
WS_POPUP             EQU	080000000h

WS_OVERLAPPEDWINDOW  EQU	WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_THICKFRAME | WS_MINIMIZEBOX | WS_MAXIMIZEBOX
WS_POPUPWINDOW       EQU	WS_POPUP | WS_BORDER | WS_SYSMENU
WS_CHILDWINDOW       EQU	WS_CHILD
WS_TILED             EQU	WS_OVERLAPPED
WS_ICONIC            EQU	WS_MINIMIZE
WS_SIZEBOX           EQU	WS_THICKFRAME
WS_TILEDWINDOW       EQU	WS_OVERLAPPEDWINDOW
;WS_CAPTION           EQU	WS_BORDER | WS_DLGFRAME
WS_MODAL             EQU	WS_CAPTION | WS_SYSMENU | WS_VISIBLE
WS_MODELESS          EQU	WS_CAPTION | WS_SYSMENU | WS_VISIBLE
WS_CONTROL           EQU	WS_CHILD | WS_VISIBLE

WS_EX_NONE           EQU	00000000h
WS_EX_DLGMODALFRAME  EQU	000000001h
WS_EX_NOPARENTNOTIFY EQU	000000004h
WS_EX_TOPMOST        EQU	000000008h
WS_EX_ACCEPTFILES    EQU	000000010h
WS_EX_TRANSPARENT    EQU	000000020h
WS_EX_MDICHILD       EQU	000000040h
WS_EX_TOOLWINDOW     EQU	000000080h
WS_EX_WINDOWEDGE     EQU	000000100h
WS_EX_CLIENTEDGE     EQU	000000200h
WS_EX_CONTEXTHELP    EQU	000000400h

WS_EX_RIGHT          EQU	000001000h
WS_EX_LEFT           EQU	000000000h
WS_EX_RTLREADING     EQU	000002000h
WS_EX_LTRREADING     EQU	000000000h
WS_EX_LEFTSCROLLBAR  EQU	000004000h
WS_EX_RIGHTSCROLLBAR EQU	000000000h

WS_EX_CONTROLPARENT  EQU	000010000h
WS_EX_STATICEDGE     EQU	000020000h
WS_EX_APPWINDOW      EQU	000040000h

WS_EX_OVERLAPPEDWINDOW EQU	WS_OVERLAPPEDWINDOW | WS_EX_WINDOWEDGE | WS_EX_CLIENTEDGE
WS_EX_PALETTEWINDOW  EQU	WS_EX_WINDOWEDGE  |  WS_EX_TOOLWINDOW | WS_EX_TOPMOST


VK_LBUTTON           EQU	001h
VK_RBUTTON           EQU	002h
VK_CANCEL            EQU	003h
VK_MBUTTON           EQU	004h
VK_BACK              EQU	008h
VK_TAB               EQU	009h
VK_CLEAR             EQU	00Ch
VK_RETURN            EQU	00Dh
VK_SHIFT             EQU	010h
VK_CONTROL           EQU	011h
VK_MENU              EQU	012h
VK_PAUSE             EQU	013h
VK_CAPITAL           EQU	014h
VK_ESCAPE            EQU	01Bh
VK_SPACE             EQU	020h
VK_PRIOR             EQU	021h
VK_NEXT              EQU	022h
VK_END               EQU	023h
VK_HOME              EQU	024h
VK_LEFT              EQU	025h
VK_UP                EQU	026h
VK_RIGHT             EQU	027h
VK_DOWN              EQU	028h
VK_SELECT            EQU	029h
VK_PRINT             EQU	02Ah
VK_EXECUTE           EQU	02Bh
VK_SNAPSHOT          EQU	02Ch
VK_INSERT            EQU	02Dh
VK_DELETE            EQU	02Eh
VK_HELP              EQU	02Fh
VK_NUMPAD0           EQU	060h
VK_NUMPAD1           EQU	061h
VK_NUMPAD2           EQU	062h
VK_NUMPAD3           EQU	063h
VK_NUMPAD4           EQU	064h
VK_NUMPAD5           EQU	065h
VK_NUMPAD6           EQU	066h
VK_NUMPAD7           EQU	067h
VK_NUMPAD8           EQU	068h
VK_NUMPAD9           EQU	069h
VK_MULTIPLY          EQU	06Ah
VK_ADD               EQU	06Bh
VK_SEPARATOR         EQU	06Ch
VK_SUBTRACT          EQU	06Dh
VK_DECIMAL           EQU	06Eh
VK_DIVIDE            EQU	06Fh
VK_F1                EQU	070h
VK_F2                EQU	071h
VK_F3                EQU	072h
VK_F4                EQU	073h
VK_F5                EQU	074h
VK_F6                EQU	075h
VK_F7                EQU	076h
VK_F8                EQU	077h
VK_F9                EQU	078h
VK_F10               EQU	079h
VK_F11               EQU	07Ah
VK_F12               EQU	07Bh
VK_F13               EQU	07Ch
VK_F14               EQU	07Dh
VK_F15               EQU	07Eh
VK_F16               EQU	07Fh
VK_F17               EQU	080h
VK_F18               EQU	081h
VK_F19               EQU	082h
VK_F20               EQU	083h
VK_F21               EQU	084h
VK_F22               EQU	085h
VK_F23               EQU	086h
VK_F24               EQU	087h
VK_NUMLOCK           EQU	090h
VK_SCROLL            EQU	091h

VK_LSHIFT            EQU	0A0h
VK_RSHIFT            EQU	0A1h
VK_LCONTROL          EQU	0A2h
VK_RCONTROL          EQU	0A3h
VK_LMENU             EQU	0A4h
VK_RMENU             EQU	0A5h

VK_PROCESSKEY        EQU	0E5h

VK_ATTN              EQU	0F6h
VK_CRSEL             EQU	0F7h
VK_EXSEL             EQU	0F8h
VK_EREOF             EQU	0F9h
VK_PLAY              EQU	0FAh
VK_ZOOM              EQU	0FBh
VK_NONAME            EQU	0FCh
VK_PA1               EQU	0FDh
VK_OEM_CLEAR         EQU	0FEh

SC_SIZE              EQU	0F000h
SC_MOVE              EQU	0F010h
SC_MINIMIZE          EQU	0F020h
SC_MAXIMIZE          EQU	0F030h
SC_NEXTWINDOW        EQU	0F040h
SC_PREVWINDOW        EQU	0F050h
SC_CLOSE             EQU	0F060h
SC_VSCROLL           EQU	0F070h
SC_HSCROLL           EQU	0F080h
SC_MOUSEMENU         EQU	0F090h
SC_KEYMENU           EQU	0F100h
SC_ARRANGE           EQU	0F110h
SC_RESTORE           EQU	0F120h
SC_TASKLIST          EQU	0F130h
SC_SCREENSAVE        EQU	0F140h
SC_HOTKEY            EQU	0F150h


;------------------------------------------------------------------------------

; =============
; dialog styles
; =============

DS_ABSALIGN          EQU	0001h
DS_SYSMODAL          EQU	0002h
DS_3DLOOK            EQU	0004h
DS_FIXEDSYS          EQU	0008h
DS_NOFAILCREATE      EQU	0010h
DS_LOCALEDIT         EQU	0020h
DS_SETFONT           EQU	0040h
DS_MODALFRAME        EQU	0080h
DS_NOIDLEMSG         EQU	0100h
DS_SETFOREGROUND     EQU	0200h
DS_CONTROL           EQU	0400h
DS_CENTER            EQU	0800h
DS_CENTERMOUSE       EQU	1000h
DS_CONTEXTHELP       EQU	2000h
DS_WINDOWSUI         EQU	8000h

DS_MODAL             EQU	DS_ABSALIGN | DS_MODALFRAME
DS_MODELESS          EQU	DS_ABSALIGN


;------------------------------------------------------------------------------

; =====================
; static control styles
; =====================

SS_LEFT              EQU	000000000h
SS_CENTER            EQU	000000001h
SS_RIGHT             EQU	000000002h
SS_ICON              EQU	000000003h
SS_BLACKRECT         EQU	000000004h
SS_GRAYRECT          EQU	000000005h
SS_WHITERECT         EQU	000000006h
SS_BLACKFRAME        EQU	000000007h
SS_GRAYFRAME         EQU	000000008h
SS_WHITEFRAME        EQU	000000009h
SS_USERITEM          EQU	00000000Ah
SS_SIMPLE            EQU	00000000Bh
SS_LEFTNOWORDWRAP    EQU	00000000Ch
SS_BITMAP            EQU	00000000Eh

SS_OWNERDRAW         EQU	00000000Dh
SS_ENHMETAFILE       EQU	00000000Fh
SS_ETCHEDHORZ        EQU	000000010h
SS_ETCHEDVERT        EQU	000000011h
SS_ETCHEDFRAME       EQU	000000012h
SS_TYPEMASK          EQU	00000001Fh

SS_NOPREFIX          EQU	000000080h
SS_NOTIFY            EQU	000000100h
SS_CENTERIMAGE       EQU	000000200h
SS_RIGHTJUST         EQU	000000400h
SS_REALSIZEIMAGE     EQU	000000800h
SS_SUNKEN            EQU	000001000h


;------------------------------------------------------------------------------

; =====================
; button control styles
; =====================

BS_PUSHBUTTON        EQU	000000000h
BS_DEFPUSHBUTTON     EQU	000000001h
BS_CHECKBOX          EQU	000000002h
BS_AUTOCHECKBOX      EQU	000000003h
BS_RADIOBUTTON       EQU	000000004h
BS_3STATE            EQU	000000005h
BS_AUTO3STATE        EQU	000000006h
BS_GROUPBOX          EQU	000000007h
BS_USERBUTTON        EQU	000000008h
BS_AUTORADIOBUTTON   EQU	000000009h
BS_OWNERDRAW         EQU	00000000Bh
BS_LEFTTEXT          EQU	000000020h
BS_TEXT              EQU	000000000h
BS_ICON              EQU	000000040h
BS_BITMAP            EQU	000000080h
BS_LEFT              EQU	000000100h
BS_RIGHT             EQU	000000200h
BS_CENTER            EQU	000000300h
BS_TOP               EQU	000000400h
BS_BOTTOM            EQU	000000800h
BS_VCENTER           EQU	000000C00h
BS_PUSHLIKE          EQU	000001000h
BS_MULTILINE         EQU	000002000h
BS_NOTIFY            EQU	000004000h
BS_FLAT              EQU	000008000h

BS_RIGHTBUTTON       EQU	BS_LEFTTEXT




;------------------------------------------------------------------------------

; ===================
; edit control styles
; ===================

ES_LEFT              EQU	000000000h
ES_CENTER            EQU	000000001h
ES_RIGHT             EQU	000000002h
ES_MULTILINE         EQU	000000004h
ES_UPPERCASE         EQU	000000008h
ES_LOWERCASE         EQU	000000010h
ES_PASSWORD          EQU	000000020h
ES_AUTOVSCROLL       EQU	000000040h
ES_AUTOHSCROLL       EQU	000000080h
ES_NOHIDESEL         EQU	000000100h
ES_OEMCONVERT        EQU	000000400h
ES_READONLY          EQU	000000800h
ES_WANTRETURN        EQU	000001000h
ES_NUMBER            EQU	02000h

ES_DEFAULT           EQU	ES_MULTILINE | ES_AUTOHSCROLL

;------------------------------------------------------------------------------

; =================
; scroll bar styles
; =================

SBS_HORZ             EQU	00000h
SBS_VERT             EQU	00001h
SBS_TOPALIGN         EQU	00002h
SBS_LEFTALIGN        EQU	00002h
SBS_BOTTOMALIGN      EQU	00004h
SBS_RIGHTALIGN       EQU	00004h
SBS_SIZEBOXTOPLEFTALIGN EQU	00002h
SBS_SIZEBOXBOTTOMRIGHTALIGN EQU	00004h
SBS_SIZEBOX          EQU	00008h
SBS_SIZEGRIP         EQU	00010h

;------------------------------------------------------------------------------

; ==============
; listbox styles
; ==============

LBS_NOTIFY           EQU	00001h
LBS_SORT             EQU	00002h
LBS_NOREDRAW         EQU	00004h
LBS_MULTIPLESEL      EQU	00008h
LBS_OWNERDRAWFIXED   EQU	00010h
LBS_OWNERDRAWVARIABLE EQU	00020h
LBS_HASSTRINGS       EQU	00040h
LBS_USETABSTOPS      EQU	00080h
LBS_NOINTEGRALHEIGHT EQU	00100h
LBS_MULTICOLUMN      EQU	00200h
LBS_WANTKEYBOARDINPUT EQU	00400h
LBS_EXTENDEDSEL      EQU	00800h
LBS_DISABLENOSCROLL  EQU	01000h
LBS_NODATA           EQU	02000h
LBS_NOSEL            EQU	04000h
LBS_STANDARD         EQU	(LBS_NOTIFY  |  LBS_SORT  |  WS_VSCROLL  |  WS_BORDER)

;------------------------------------------------------------------------------

; ================
; combo box styles
; ================

CBS_SIMPLE           EQU	00001h
CBS_DROPDOWN         EQU	00002h
CBS_DROPDOWNLIST     EQU	00003h
CBS_OWNERDRAWFIXED   EQU	00010h
CBS_OWNERDRAWVARIABLE EQU	00020h
CBS_AUTOHSCROLL      EQU	00040h
CBS_OEMCONVERT       EQU	00080h
CBS_SORT             EQU	00100h
CBS_HASSTRINGS       EQU	00200h
CBS_NOINTEGRALHEIGHT EQU	00400h
CBS_DISABLENOSCROLL  EQU	00800h
CBS_UPPERCASE        EQU	02000h
CBS_LOWERCASE        EQU	04000h

; operation messages sent to DLGINIT

;WM_USER              EQU	00400h
;LB_ADDSTRING         EQU	(WM_USER+1)
;CB_ADDSTRING         EQU	(WM_USER+3)


HDS_HORZ             EQU	000000000h
HDS_BUTTONS          EQU	000000002h
HDS_HIDDEN           EQU	000000008h

TTS_ALWAYSTIP        EQU	001h
TTS_NOPREFIX         EQU	002h

SBARS_SIZEGRIP       EQU	00100h

TBS_AUTOTICKS        EQU	00001h
TBS_VERT             EQU	00002h
TBS_HORZ             EQU	00000h
TBS_TOP              EQU	00004h
TBS_BOTTOM           EQU	00000h
TBS_LEFT             EQU	00004h
TBS_RIGHT            EQU	00000h
TBS_BOTH             EQU	00008h
TBS_NOTICKS          EQU	00010h
TBS_ENABLESELRANGE   EQU	00020h
TBS_FIXEDLENGTH      EQU	00040h
TBS_NOTHUMB          EQU	00080h

UDS_WRAP             EQU	00001h
UDS_SETBUDDYINT      EQU	00002h
UDS_ALIGNRIGHT       EQU	00004h
UDS_ALIGNLEFT        EQU	00008h
UDS_AUTOBUDDY        EQU	00010h
UDS_ARROWKEYS        EQU	00020h
UDS_HORZ             EQU	00040h
UDS_NOTHOUSANDS      EQU	00080h

;------------------------------------------------------------------------------

; ======================
; Common Control Styles
; ======================

CCS_TOP              EQU	000000001h
CCS_NOMOVEY          EQU	000000002h
CCS_BOTTOM           EQU	000000003h
CCS_NORESIZE         EQU	000000004h
CCS_NOPARENTALIGN    EQU	000000008h
CCS_NOHILITE         EQU	000000010h
CCS_ADJUSTABLE       EQU	000000020h
CCS_NODIVIDER        EQU	000000040h

;------------------------------------------------------------------------------

; ================
; list view styles
; ================

LVS_ICON             EQU	00000h
LVS_REPORT           EQU	00001h
LVS_SMALLICON        EQU	00002h
LVS_LIST             EQU	00003h
LVS_TYPEMASK         EQU	00003h

LVS_SINGLESEL        EQU	00004h
LVS_SHOWSELALWAYS    EQU	00008h
LVS_SORTASCENDING    EQU	00010h
LVS_SORTDESCENDING   EQU	00020h
LVS_SHAREIMAGELISTS  EQU	00040h
LVS_NOLABELWRAP      EQU	00080h
LVS_AUTOARRANGE      EQU	00100h
LVS_EDITLABELS       EQU	00200h

LVS_TYPESTYLEMASK    EQU	0000FC00h

LVS_ALIGNTOP         EQU	00000h
LVS_OWNERDRAWFIXED   EQU	00400h
LVS_ALIGNLEFT        EQU	00800h
LVS_ALIGNMASK        EQU	00c00h

LVS_NOSCROLL         EQU	02000h
LVS_NOCOLUMNHEADER   EQU	04000h
LVS_NOSORTHEADER     EQU	08000h

;------------------------------------------------------------------------------

; ================
; tree view styles
; ================

TVS_HASBUTTONS       EQU	00001h
TVS_HASLINES         EQU	00002h
TVS_LINESATROOT      EQU	00004h
TVS_EDITLABELS       EQU	00008h
TVS_DISABLEDRAGDROP  EQU	00010h
TVS_SHOWSELALWAYS    EQU	00020h

TCS_FORCEICONLEFT    EQU	00010h
TCS_FORCELABELLEFT   EQU	00020h
TCS_SHAREIMAGELISTS  EQU	00040h
TCS_TABS             EQU	00000h
TCS_BUTTONS          EQU	00100h
TCS_SINGLELINE       EQU	00000h
TCS_MULTILINE        EQU	00200h
TCS_RIGHTJUSTIFY     EQU	00000h
TCS_FIXEDWIDTH       EQU	00400h
TCS_RAGGEDRIGHT      EQU	00800h
TCS_FOCUSONBUTTONDOWN EQU	01000h
TCS_OWNERDRAWFIXED   EQU	02000h
TCS_TOOLTIPS         EQU	04000h
TCS_FOCUSNEVER       EQU	08000h

ACS_CENTER           EQU	00001h
ACS_TRANSPARENT      EQU	00002h
ACS_AUTOPLAY         EQU	00004h


; 32-bit language/sub-language identifiers

LANG_NEUTRAL         EQU	000h

LANG_BULGARIAN       EQU	002h
LANG_CHINESE         EQU	004h
LANG_CROATIAN        EQU	01ah
LANG_CZECH           EQU	005h
LANG_DANISH          EQU	006h
LANG_DUTCH           EQU	013h
LANG_ENGLISH         EQU	009h
LANG_FINNISH         EQU	00bh
LANG_FRENCH          EQU	00ch
LANG_GERMAN          EQU	007h
LANG_GREEK           EQU	008h
LANG_HUNGARIAN       EQU	00eh
LANG_ICELANDIC       EQU	00fh
LANG_ITALIAN         EQU	010h
LANG_JAPANESE        EQU	011h
LANG_KOREAN          EQU	012h
LANG_NORWEGIAN       EQU	014h
LANG_POLISH          EQU	015h
LANG_PORTUGUESE      EQU	016h
LANG_ROMANIAN        EQU	018h
LANG_RUSSIAN         EQU	019h
LANG_SLOVAK          EQU	01bh
LANG_SLOVENIAN       EQU	024h
LANG_SPANISH         EQU	00ah
LANG_SWEDISH         EQU	01dh
LANG_TURKISH         EQU	01fh

; Sublanguage IDs.
SUBLANG_NEUTRAL      EQU	000h
SUBLANG_DEFAULT      EQU	001h
SUBLANG_SYS_DEFAULT  EQU	002h

SUBLANG_CHINESE_TRADITIONAL EQU	001h
SUBLANG_CHINESE_SIMPLIFIED EQU	002h
SUBLANG_CHINESE_HONGKONG EQU	003h
SUBLANG_CHINESE_SINGAPORE EQU	004h
SUBLANG_DUTCH        EQU	001h
SUBLANG_DUTCH_BELGIAN EQU	002h
SUBLANG_ENGLISH_US   EQU	001h
SUBLANG_ENGLISH_UK   EQU	002h
SUBLANG_ENGLISH_AUS  EQU	003h
SUBLANG_ENGLISH_CAN  EQU	004h
SUBLANG_ENGLISH_NZ   EQU	005h
SUBLANG_ENGLISH_EIRE EQU	006h
SUBLANG_FRENCH       EQU	001h
SUBLANG_FRENCH_BELGIAN EQU	002h
SUBLANG_FRENCH_CANADIAN EQU	003h
SUBLANG_FRENCH_SWISS EQU	004h
SUBLANG_GERMAN       EQU	001h
SUBLANG_GERMAN_SWISS EQU	002h
SUBLANG_GERMAN_AUSTRIAN EQU	003h
SUBLANG_ITALIAN      EQU	001h
SUBLANG_ITALIAN_SWISS EQU	002h
SUBLANG_NORWEGIAN_BOKMAL EQU	001h
SUBLANG_NORWEGIAN_NYNORSK EQU	002h
SUBLANG_PORTUGUESE   EQU	002h
SUBLANG_PORTUGUESE_BRAZILIAN EQU	001h
SUBLANG_SPANISH      EQU	001h
SUBLANG_SPANISH_MEXICAN EQU	002h
SUBLANG_SPANISH_MODERN EQU	003h

;------------------------------------------------------------------------------

; ===================
; dialog command id's
; ===================

IDOK                 EQU	1
IDCANCEL             EQU	2
IDABORT              EQU	3
IDRETRY              EQU	4
IDIGNORE             EQU	5
IDYES                EQU	6
IDNO                 EQU	7
IDCLOSE              EQU	8
IDHELP               EQU	9

IDC_STATIC           EQU	(-1)



;------------------------------------------------------------------------------

; ==============================
;  Predefined cursor & icon IDs
; ==============================


IDH_NO_HELP          EQU	28440
IDH_MISSING_CONTEXT  EQU	28441
IDH_GENERIC_HELP_BUTTON EQU	28442
IDH_OK               EQU	28443
IDH_CANCEL           EQU	28444
IDH_HELP             EQU	28445

;IDC_ARROW            EQU	32512
;IDC_IBEAM            EQU	32513
;IDC_WAIT             EQU	32514
;IDC_CROSS            EQU	32515
;IDC_UPARROW          EQU	32516
;IDC_SIZE             EQU	32640
;IDC_ICON             EQU	32641
;IDC_SIZENWSE         EQU	32642
;IDC_SIZENESW         EQU	32643
;IDC_SIZEWE           EQU	32644
;IDC_SIZENS           EQU	32645

;IDI_APPLICATION      EQU	32512
;IDI_HAND             EQU	32513
;IDI_QUESTION         EQU	32514
;IDI_EXCLAMATION      EQU	32515
;IDI_ASTERISK         EQU	32516

; Various Windows structures.
;  19.JUN.96 : Philippe Auphelle.
;       Mostly derived from 03-14-1996 Sven B. Schreiber sbs@orgon.com
;
;  24.JUL.98 : Converted To NASM by Gij
;
; Revision 1.1  1997/09/02 09:51:15  Philippe
; Initial revision
;



;==============================================================================
;
;	STRUCTURES
;
;==============================================================================

STRUC CREATESTRUCT
.lpCreateParams: resd 1
.hInstance: 	 resd 1
.hMenu: 	 resd 1
.hwndParent:  resd 1
.cy: 	 resd 1
.cx: 	 resd 1
.y: 	 	 resd 1
.x:     	 resd 1
.style:  	 resd 1
.lpszName:  	 resd 1
.lpszClass: 	 resd 1
.dwExStyle: 	 resd 1
ENDSTRUC


STRUC BITMAPFILEHEADER
   .bfType:              resd	1	; WORD
   .bfSize:              resd	1	; DWORD
   .bfReserved1:         resd	1	; WORD
   .bfReserved2:         resd	1	; WORD
   .bfOffBits:           resd	1	; DWORD
ENDSTRUC

;------------------------------------------------------------------------------

STRUC BITMAPINFOHEADER
   .biSize:              resd	1	; DWORD
   .biWidth:             resd	1	; LONG
   .biHeight:            resd	1	; LONG
   .biPlanes:            resd	1	; WORD
   .biBitCount:          resd	1	; WORD
   .biCompression:       resd	1	; DWORD
   .biSizeImage:         resd	1	; DWORD
   .biXPelsPerMeter:     resd	1	; LONG
   .biYPelsPerMeter:     resd	1	; LONG
   .biClrUsed:           resd	1	; DWORD
   .biClrImportant:      resd	1	; DWORD
ENDSTRUC

;------------------------------------------------------------------------------

STRUC BITMAP
   .bmType:              resd	1	; LONG
   .bmWidth:             resd	1	; LONG
   .bmHeight:            resd	1	; LONG
   .bmWidthBytes:        resd	1	; LONG
   .bmPlanes:            resd	1	; WORD
   .bmBitsPixel:         resd	1	; WORD
   .bmBits:              resd	1	; LPVOID
ENDSTRUC

;------------------------------------------------------------------------------

STRUC COPYDATASTRUCT
   .dwData:              resd	1	; DWORD
   .cbData:              resd	1	; DWORD
   .lpData:              resd	1	; PVOID
ENDSTRUC

;------------------------------------------------------------------------------

STRUC CONTEXT
   .cx_ContextFlags:     resd	1	; DWORD ; 0x00
; CONTEXT_DEBUG_REGISTERS
   .cx_Dr0:              resd	1	; DWORD ; 0x04
   .cx_Dr1:              resd	1	; DWORD ; 0x08
   .cx_Dr2:              resd	1	; DWORD ; 0x0C
   .cx_Dr3:              resd	1	; DWORD ; 0x10
   .cx_Dr6:              resd	1	; DWORD ; 0x14
   .cx_Dr7:              resd	1	; DWORD ; 0x18
; CONTEXT_FLOATING_POINT
   .cx_ControlWord:      resd	1	; DWORD ; 0x1C
   .cx_StatusWord:       resd	1	; DWORD ; 0x20
   .cx_TagWord:          resd	1	; DWORD ; 0x24
   .cx_ErrorOffset:      resd	1	; DWORD ; 0x28
   .cx_ErrorSelector:    resd	1	; DWORD ; 0x2C
   .cx_DataOffset:       resd	1	; DWORD ; 0x30
   .cx_DataSelector:     resd	1	; DWORD ; 0x34
   .cx_RegisterArea      resb  SIZE_OF_80387_REGISTERS ; BYTE

   .cx_Cr0NpxState:      resd	1	; DWORD ; 0x88
; CONTEXT_SEGMENTS
   .cx_SegGs:            resd	1	; DWORD ; 0x8C
   .cx_SegFs:            resd	1	; DWORD ; 0x90
   .cx_SegEs:            resd	1	; DWORD ; 0x94
   .cx_SegDs:            resd	1	; DWORD ; 0x98
; CONTEXT_INTEGER
   .cx_Edi:              resd	1	; DWORD ; 0x9C
   .cx_Esi:              resd	1	; DWORD ; 0xA0
   .cx_Ebx:              resd	1	; DWORD ; 0xA4
   .cx_Edx:              resd	1	; DWORD ; 0xA8
   .cx_Ecx:              resd	1	; DWORD ; 0xAC
   .cx_Eax:              resd	1	; DWORD ; 0xB0
; CONTEXT_CONTROL
   .cx_Ebp:              resd	1	; DWORD ; 0xB4
   .cx_Eip:              resd	1	; DWORD ; 0xB8
   .cx_SegCs:            resd	1	; DWORD ; 0xBC
   .cx_EFlags:           resd	1	; DWORD ; 0xC0
   .cx_Esp:              resd	1	; DWORD ; 0xC4
   .cx_SegSs:            resd	1	; DWORD ; 0xC8
ENDSTRUC

;------------------------------------------------------------------------------

STRUC DOCINFO
   .cbSize:              resd	1	; DWORD
   .lpszDocName:         resd	1	; LPCSTR
   .lpszOutput:          resd	1	; LPCSTR
   .lpszDatatype:        resd	1	; LPCSTR
                                        ;NT: Ignored.
   .fwType:              resd	1	; DWORD
                                        ;NT: Ignored.
ENDSTRUC

;------------------------------------------------------------------------------

STRUC DIALOGATTRIBUTES
   .Palette:             resd	1	; DWORD
   .TextBox:             resd	1	; DWORD
ENDSTRUC

;------------------------------------------------------------------------------

STRUC DIALOGPALETTE
   .DlgText:             resd	1	; COLORREF
   .DlgBk:               resd	1	; COLORREF
   .StaticText:          resd	1	; COLORREF
   .StaticBk:            resd	1	; COLORREF
   .TextBoxText:         resd	1	; COLORREF
   .TextBoxBk:           resd	1	; COLORREF
   .EditText:            resd	1	; COLORREF
   .EditBk:              resd	1	; COLORREF
   .ListBoxText:         resd	1	; COLORREF
   .ListBoxBk:           resd	1	; COLORREF
ENDSTRUC

;------------------------------------------------------------------------------

STRUC DIALOGRECORD
   .hWnd:                resd	1	; HWND
   .fModeless:           resd	1	; BOOL
   .Attributes:          resd	1	; DWORD
   .Data:                resd	1	; DWORD
   .hDlgBrush:           resd	1	; HBRUSH
   .hStaticBrush:        resd	1	; HBRUSH
   .hTextBoxBrush:       resd	1	; HBRUSH
   .hEditBrush:          resd	1	; HBRUSH
   .hListBoxBrush:       resd	1	; HBRUSH
ENDSTRUC

;------------------------------------------------------------------------------

STRUC POINT
   .x:                   resd	1	; LONGINT
   .y:                   resd	1	; LONGINT
ENDSTRUC


;------------------------------------------------------------------------------

STRUC MINMAXINFO
   .ptReserved:          resd	2  ; x,y
   .ptMaxSize:           resd	2  ; x,y
   .ptMaxPosition:       resd	2  ; x,y
   .ptMinTrackSize:      resd	2  ; x,y
   .ptMaxTrackSize:      resd	2  ; x,y
ENDSTRUC

;------------------------------------------------------------------------------

STRUC MSG
   .hwnd:                resd	1	; HWND
   .message:             resd	1	; UINT
   .wParam:              resd	1	; WPARAM
   .lParam:              resd	1	; LPARAM
   .time:                resd	1	; DWORD
   .x:                   resd	1	; LONGINT
   .y:                   resd	1	; LONGINT
ENDSTRUC

;------------------------------------------------------------------------------

STRUC NETRESOURCE
   .dwScope:             resd	1	; DWORD
   .dwType:              resd	1	; DWORD
   .dwDisplayType:       resd	1	; DWORD
   .dwUsage:             resd	1	; DWORD
   .lpLocalName:         resd	1	; LPSTR
   .lpRemoteName:        resd	1	; LPSTR
   .lpComment:           resd	1	; LPSTR
   .lpProvider:          resd	1	; LPSTR
ENDSTRUC

;------------------------------------------------------------------------------

STRUC NMHDR
   .hwndFrom:            resd	1	; HWND
   .idFrom:              resd	1	; UINT
   .code:                resd	1	; UINT
ENDSTRUC

;------------------------------------------------------------------------------

STRUC OPENFILENAME
   .lStructSize:         resd	1	; DWORD
   .hwndOwner:           resd	1	; HWND
   .hInstance:           resd	1	; HINSTANCE
   .lpstrFilter:         resd	1	; LPCSTR
   .lpstrCustomFilter:   resd	1	; LPSTR
   .nMaxCustFilter:      resd	1	; DWORD
   .nFilterIndex:        resd	1	; DWORD
   .lpstrFile:           resd	1	; LPSTR
   .nMaxFile:            resd	1	; DWORD
   .lpstrFileTitle:      resd	1	; LPSTR
   .nMaxFileTitle:       resd	1	; DWORD
   .lpstrInitialDir:     resd	1	; LPCSTR
   .lpstrTitle:          resd	1	; LPCSTR
   .Flags:               resd	1	; DWORD
   .nFileOffset:         resw	1	; WORD
   .nFileExtension:      resw	1	; WORD
   .lpstrDefExt:         resd	1	; LPCSTR
   .lCustData:           resd	1	; LPARAM
   .lpfnHook:            resd	1	; LPFN
   .lpTemplateName:      resd	1	; LPCSTR
ENDSTRUC


;------------------------------------------------------------------------------

STRUC PRINTDLG
   .lStructSize:         resd	1	; DWORD
   .hwndOwner:           resd	1	; HWND
   .hDevMode:            resd	1	; HANDLE
   .hDevNames:           resd	1	; HANDLE
   .hDC:                 resd	1	; HDC
   .Flags:               resd	1	; DWORD
   .nFromPage:           resd	1	; WORD
   .nToPage:             resd	1	; WORD
   .nMinPage:            resd	1	; WORD
   .nMaxPage:            resd	1	; WORD
   .nCopies:             resd	1	; WORD
   .hInstance:           resd	1	; HINSTANCE
   .lCustData:           resd	1	; DWORD
   .lpfnPrintHook:       resd	1	; DWORD
   .lpfnSetupHook:       resd	1	; DWORD
   .lpPrintTemplateName: resd	1	; LPCTSTR
   .lpSetupTemplateName: resd	1	; LPCTSTR
   .hPrintTemplate:      resd	1	; HANDLE
   .hSetupTemplate:      resd	1	; HANDLE
ENDSTRUC

;------------------------------------------------------------------------------
STRUC OVERLAPPED
    .Internal		resd 1
    .InternalHigh	resd 1
    ._Offset		resd 1
    .OffsetHigh		RESD 1
    .hEvent		RESD 1
ENDSTRUC

;------------------------------------------------------------------------------

STRUC PAINTSTRUCT
   .hdc:                 resd	1	; HDC
   .fErase:              resd	1	; BOOL
   .leftPaint:           resd	1	; LONGINT
   .topPaint:            resd	1	; LONGINT
   .rightPaint:          resd	1	; LONGINT
   .bottomPaint:         resd	1	; LONGINT
   .fRestore:            resd	1	; BOOL
   .fIncUpdate:          resd	1	; BOOL
   .rgbReserved          resb    32 	; BYTE
ENDSTRUC

;------------------------------------------------------------------------------

STRUC RECT
   .left:                resd	1	; LONGINT
   .top:                 resd	1	; LONGINT
   .right:               resd	1	; LONGINT
   .bottom:              resd	1	; LONGINT
ENDSTRUC

%define RECTL 	RECT

STRUC SIZEL
   ._cx:                 resd	1	; LONGINT
   .cy:                  resd	1	; LONGINT
ENDSTRUC

;------------------------------------------------------------------------------

STRUC RGBQUAD
   .rgbBlue         resb 1                  ;intensity of blue component
   .rgbGreen        resb 1                  ;intensity of green component
   .rgbRed          resb 1                  ;intensity of red component
   .rgbReserved     resb 1                  ;(reserved)
ENDSTRUC

;------------------------------------------------------------------------------

STRUC SECURITY_ATTRIBUTES
   .sa_nLength:              resd	1	; DWORD
   .sa_lpSecurityDescriptor: resd	1	; LPVOID
   .sa_bInheritHandle:       resd	1	; BOOL
ENDSTRUC


;------------------------------------------------------------------------------

STRUC TBADDBITMAP
   .hInst:               resd	1	; HINSTANCE
   .nID:                 resd	1	; UINT
ENDSTRUC

;------------------------------------------------------------------------------

STRUC TBBUTTON
   .iBitmap:             resd	1	; INTEGER
   .idCommand:           resd	1	; INTEGER
   .fsState              resb  1       ; button state flags
   .fsStyle              resb  1       ; button style
   .dwData:              resd	1	; DWORD
   .iString:             resd	1	; INTEGER
ENDSTRUC

;------------------------------------------------------------------------------

STRUC TEXTMETRIC
   .tmHeight:            resd	1	; LONGINT
   .tmAscent:            resd	1	; LONGINT
   .tmDescent:           resd	1	; LONGINT
   .tmInternalLeading:   resd	1	; LONGINT
   .tmExternalLeading:   resd	1	; LONGINT
   .tmAveCharWidth:      resd	1	; LONGINT
   .tmMaxCharWidth:      resd	1	; LONGINT
   .tmWeight:            resd	1	; LONGINT
   .tmOverhang:          resd	1	; LONGINT
   .tmDigitizedAspectX:  resd	1	; LONGINT
   .tmDigitizedAspectY:  resd	1	; LONGINT
   .tmFirstChar:         resb 1          ;first font character value
   .tmLastChar:          resb 1          ;last font character value
   .tmDefaultChar:       resb 1          ;default substitution character
   .tmBreakChar:         resb 1          ;word break character
   .tmItalic:            resb 1          ;italic font
   .tmUnderlined:        resb 1          ;underline font
   .tmStruckOut:         resb 1          ;strikeout font
   .tmPitchAndFamily:    resb 1          ;font pitch/family
   .tmCharSet:           resb 1          ;font character set

ENDSTRUC

;------------------------------------------------------------------------------

STRUC TOOLTIPTEXT
   .hdr:                 resd   1       ;NMHDR structure
   .lpszText:            resd	1	; LPTSTR
   .szText:              resb   80       ;Tooltip text
   .hInst:               resd	1	; HINSTANCE
   .uFlags:              resd	1	; UINT
ENDSTRUC

;------------------------------------------------------------------------------

STRUC WNDCLASS
   .style:               resd	1	; UINT
   .lpfnWndProc:         resd	1	; WNDPROC
   .cbClsExtra:          resd	1	; INTEGER
   .cbWndExtra:          resd	1	; INTEGER
   .hInstance:           resd	1	; HINSTANCE
   .hIcon:               resd	1	; HICON
   .hCursor:             resd	1	; HCURSOR
   .hbrBackground:       resd	1	; HBRUSH
   .lpszMenuName:        resd	1	; LPCSTR
   .lpszClassName:       resd	1	; LPCSTR
ENDSTRUC
;------------------------------------------------------------------------------

STRUC WNDCLASSEX
   .cbSize:		  resd  1
   .style:               resd	1	; UINT
   .lpfnWndProc:         resd	1	; WNDPROC
   .cbClsExtra:          resd	1	; INTEGER
   .cbWndExtra:          resd	1	; INTEGER
   .hInstance:           resd	1	; HINSTANCE
   .hIcon:               resd	1	; HICON
   .hCursor:             resd	1	; HCURSOR
   .hbrBackground:       resd	1	; HBRUSH
   .lpszMenuName:        resd	1	; LPCSTR
   .lpszClassName:       resd	1	; LPCSTR
   .hIconSm:		  resd  1
ENDSTRUC

;------------------------------------------------------------------------------

STRUC WNDPARAMETERS
   .hWnd:                resd	1	; HWND
   .FontId:              resd	1	; DWORD
   .TextColor:           resd	1	; COLORREF
   .BkColor:             resd	1	; COLORREF
   .BkMode:              resd	1	; DWORD
ENDSTRUC

;==============================================================================
;
;	DDE STRUCTURES
;
;==============================================================================

STRUC DDEACK
   .ddeack_Status:       resd	1	; WORD
ENDSTRUC

;------------------------------------------------------------------------------

STRUC DDEADVISE
   .ddeadvise_Status:    resd	1	; WORD
   .ddeadvise_cfFormat:  resd	1	; WORD
ENDSTRUC

;------------------------------------------------------------------------------

STRUC DDEDATA
   .ddedata_Status:      resd	1	; WORD
   .ddedata_cfFormat:    resd	1	; WORD
   .ddedata_Value        resb   1       ; data item
ENDSTRUC

;------------------------------------------------------------------------------

STRUC DDEPOKE
   .ddepoke_Status:      resd	1	; WORD
   .ddepoke_cfFormat:    resd	1	; WORD
   .ddepoke_Value:       resb   1       ; data item
ENDSTRUC

;==============================================================================
;OSVERSIONINFO_		EQU	128+4*5
STRUC OSVERSIONINFO
   .dwOSVersionInfoSize   RESD 1
   .dwMajorVersion        RESD 1
   .dwMinorVersion        RESD 1
   .dwBuildNumber         RESD 1
   .dwPlatformId          RESD 1
   .szCSDVersion          RESB 128
ENDSTRUC

STRUC MEMINFO
 .BaseAddress	    RESD 1
 .AllocationBase    RESD 1
 .AllocationProtect RESD 1
 .RegionSize        RESD 1
 .State             RESD 1
 .Protect           RESD 1
 .Type              RESD 1
ENDSTRUC

%endif