;
; Unwrap Thunk for TE!Lock and maybe PCGuard (C) G-RoM in 2001
;
; some slots won't resolve, most likely the NULL entries, easy
; to fix by hand in any case. plugin modifies the original IAT
; slots as well, not only the copy !
;
;
;
; Hydra example Plugin
;
;
; Started on    : 25th October 2001
; Latest update : 25th October 2001
;

		BITS 32

		%include "pedata.inc" ; Structs
		%include "memio.inc"  ; Protos

;
; Public definitions.
;
global UnwrapThunk			; Our export function
global _Start@12			; Main
;
; Code definition.
;
SEGMENT .text	USE32 CLASS=CODE
;
; Detect DLL Name of given thunk [Fast mode]
;

;
;esp+4 : IAT thunk
;esp+8 : DLL List
;
;eax=1 if member.
;
IsFromDLL:
	push	ebp
	mov	ebp, esp
	push	esi
	push	edi
	push	edx
	push	ecx
	push	ebx

	mov	esi, [ebp+0ch]		; DLLList
	mov	edx, [ebp+08h]		; Thunk
	xor	eax, eax		; RetVal
.LoopScan:
	cmp	[esi+DLLList.ModPath], eax             ; DLLList finished ?
	jz	.Failure

	mov	ebx, [esi+DLLList.Base] ; Thunk must be DLL Area
	cmp	edx, ebx
	jb	.CheckNextDLL
	add	ebx, [esi+DLLList.Size]
	cmp	edx, ebx
	jbe	.Success
.CheckNextDLL:
	add	esi, DLLList_size
	jmp	short .LoopScan
.Success:
	xor	eax, eax
	inc	eax
.Failure:
	pop	ebx
	pop	ecx
	pop	edx
	pop	edi
	pop	esi
	pop	ebp
	ret	08h
;
; Load ALL IAT thunk.
;

;
;esp+4 : ThunkSlot
;esp+8 : PE Buffer.
;esp+c : PE Infos.
;esp+10: DLL List.
;
;eax=thunk on success.
;
UnwrapThunk:
	push	ebp
	mov	ebp, esp

%define ThunkSlot ebp+08h
%define PEBuffer  ebp+0ch
%define PEInfos   ebp+10h
%define DLLList   ebp+14h

	push	esi
	push	edi
	push	ecx

;
; Init. Pointers.
;
	mov	eax, [PEInfos]
	mov	esi, [ThunkSlot]
	sub	esi, [PEBuffer]
	add	esi, [eax+PEStruc.ImageBase]	; Relocate

;
; Check Thunk Range.
;
	mov	eax, [esi]

	or	eax, eax
	jz	near .ReturnEAX
	js	near .ReturnEAX

;	mov	esi, [ThunkSlot]
;
; Is this thunk a Direct DLL Member ?
;
	push	eax
	push	dword [DLLList]
	push	eax
	Call	IsFromDLL
	test	eax, eax
	pop	eax
	jnz	.ReturnEAX

;
; Check if valid memory.
;
	push	eax
	push	byte 0x30
	push	eax
	call	IsBadPtr
	or	eax,eax
	pop	eax
	jnz	.ReturnEAX
;
;
;
	mov	ecx, 0x30

.LoopMe:
	cmp	byte [eax], 0xB8
	jnz	.CheckPush

	cmp	word [eax+5], 0x20FF
	mov	edi, [eax+1]
	jz	.validate

	cmp	word [eax+5], 0x30FF
	mov	edi, [eax+1]
	jz	.validate

	cmp	byte [eax+5], 0x40
	jnz	.CheckPush

	mov	edi, [eax+1]
	inc	edi
	cmp	word [eax+6], 0x30FF
	jz	.validate

.CheckPush:
	cmp	word [eax], 0x35FF
	mov	edi, [eax+2]
	jz	.validate

.CheckNext:
	inc	eax
	dec	ecx
	jnz	.LoopMe

	sub	eax, byte 0x30
	jmp	short .ReturnEAX

.validate:
;
; Valid IAT ptr ?
;
	push	eax
	push	byte 0x4
	push	edi
	call	IsBadPtr
	or	eax,eax
	pop	eax
	jnz	.CheckNext

;
; Is that IAT a real API member ?
;
	push	eax
	push	dword [DLLList]
	push	dword [edi]
	Call	IsFromDLL
	test	eax, eax
	pop	eax
	jz	.CheckNext

	mov	eax, [edi]
	mov	[esi], eax
	mov	esi, [ThunkSlot]
	mov	[esi], eax

.ReturnEAX:
	pop	ecx
	pop	edi
	pop	esi
	pop	ebp

%undef ThunkSlot
%undef PEBuffer
%undef PEInfos
%undef DLLList

	retn	10h

;
; DLLMAIN.
;

;
;
;
_Start@12:
	push	byte 01h
	pop	eax
	retn	0ch
