;/////////////////////////////////////////////////////////////////////////////
;// vdspd.asm
;//
;// Virtual DSP Device module (link with specific DSP module)
;//
;// 24/10/1999	fOSSiL		Initial version
;// 2000/01/14	The Owl		nasm port
;// 2000/01/16	The Owl		nasm port
;// 2000/01/18	fOSSiL		new vmm macros


bits 32


%include "util.mac"
%include "vxdn.inc"
%include "dsp.inc"

%define Create_Service_Table_VDSPD
%include "vdspd.inc"


global VDSPD_Control


Declare_Virtual_Device VDSPD, 1, 0, VDSPD_Device_ID


segment _LTEXT

Begin_Control_Dispatch VDSPD
	Control_Dispatch DEVICE_INIT,VDSPD_Device_Init
	Control_Dispatch SYS_DYNAMIC_DEVICE_INIT,VDSPD_Device_Init
End_Control_Dispatch


VDSPD_Device_Init:
	call	DspDetect

%if ADD_DEBUG = 1
	Trace_OutC "Dsp not detected"
%endif

	retn


;
; Services
;
VDSPD_Get_Version:
	mov	ax,0100h
	clc
	retn


VDSPD_Get_Base:
	mov	eax, [DspBase]
	clc
	retn


VDSPD_Get_Name:
	mov	eax, DspName
	clc
	retn


VDSPD_Get_IRQ:
	movzx	eax, byte [DspIRQ]
	clc
	retn


VDSPD_Set_IRQ:
	mov	[DspIRQ], al
	clc
	retn


VDSPD_Get_DMA:
	movzx	eax, byte [DspDMA]
	clc
	retn


VDSPD_Set_DMA:
	mov	[DspDMA], al
	clc
	retn


VDSPD_Get_Rate:
	mov	eax, [DspRate]
	clc
	retn


VDSPD_Get_Dsp_Version:
	movzx	eax, word [DspVer]
	clc
	retn

VDSPD_Is_Stereo:
	movzx	eax, byte [DspStereo]
	clc
	retn


VDSPD_Is_16bit:
	movzx	eax, byte [DspIs16]
	clc
	retn


VDSPD_Play:
; EAX = sampling rate
; EBX = flags (stereo/mono + 8/16 bit)
; ECX = block size

	pushad
	shl	ebx, 16
	or	ecx, ebx
	mov	ebx, eax
	call	DspPlay
	popad
	retn


VDSPD_Stop:
	pushad
	call	DspStop
	popad
	retn


VDSPD_Check_Int:
	pushad
	call	DspCheckInt
	popad
	retn


VDSPD_Pause:
	pushad
	call	DspPause
	popad
	retn


VDSPD_Resume:
	pushad
	call	DspResume
	popad
	retn
