;
; Phoenix v2.0 Structures
;
STRUC PEStruc
 .EIP    	RESD 1  ;+00
 .ImageBase     RESD 1  ;+04
 .ImageSize     RESD 1  ;+08
 .FileSize      RESD 1  ;+0C
 .HeaderSize    RESD 1  ;+10
 .CodeStart     RESD 1  ;+14
 .CodeLen       RESD 1  ;+18
 .FAlign        RESD 1  ;+1C
 .SAlign        RESD 1  ;+20
 .CheckSum      RESD 1  ;+24
 .PEOff         RESD 1  ;+28
 .NbObj         RESD 1  ;+2C
 .ObjStart      RESD 1  ;+30
 .ExportRVA	resd 1  ;+78
 .ExportSize	resd 1  ;+7C
 .ImportRVA     resd 1  ;+80
 .ImportSize    resd 1  ;+84
 .RsrcRVA       resd 1  ;+88
 .RsrcSize      resd 1  ;+8C
 .ExceptRVA     resd 1  ;+90
 .ExceptSize    resd 1  ;+94
 .SecurityRVA   resd 1  ;+98
 .SecuritySize  resd 1  ;+9C
 .RelocRVA      resd 1  ;+A0
 .RelocSize     resd 1  ;+A4
 .DebugRVA      resd 1  ;+A8
 .DebugSize     resd 1  ;+AC
 .DescriptRVA   resd 1  ;+B0
 .DescriptSize  resd 1  ;+B4
 .GlobalPtrRVA  resd 1  ;+B8
 .GlobalPtrSize resd 1  ;+BC
 .TLSRVA        resd 1  ;+C0
 .TLSSize       resd 1  ;+C4
 .LoadCfgRVA    resd 1  ;+C8
 .LoadCfgSize   resd 1  ;+CC
 .BoundRVA      resd 1  ;+D0
 .BoundSize     resd 1  ;+D4
 .IATRVA        resd 1  ;+D8
 .IATSize       resd 1  ;+DC
 .DelayRVA      resd 1  ;+E0
 .DelaySize     resd 1  ;+E4
 .COMRTRVA      resd 1  ;+E8
 .COMRTSize     resd 1  ;+EC
 .UnkRVA        resd 1  ;+F0
 .UnkSize       resd 1  ;+F4
ENDSTRUC

STRUC DLLStruc
 .Base          resd 1	; prefered base
 .hMod          resd 1  ; Actual base
 .DLLName       resd 1  ; DLL Name pointer
 .OrdBase       resd 1  ; Ordinal Number start
 .NbOrdinals	resd 1  ; Total of Exports
 .NbName        resd 1  ; Total of Exports by name
 .ExportAddress resd 1  ; Export Address Table
 .OrdTable	resd 1  ; Function by Ord Table
 .NameTable	resd 1  ; Function by name Table
 .StartRVA	resd 1  ; Export Start RVA
 .EndRVA	resd 1  ; Export End RVA
 .Unload	resd 1	; Unload needed ?
ENDSTRUC

Struc PlugStruc
 .hMod		RESD 1
 .DLLName	RESB 256
 .Next		RESD 1
 .Prev		RESD 1
EndStruc

Struc DLLList
 .ModPath	RESB 256; Module Name [full path]
 .Base	RESD	1	; Module Image Base
 .Size	RESD	1	; Module Image Size
ENDSTRUC

Struc IATStorage
 .Module   	RESD 1  ; Module Name (pointer in DLLList)
 .IATStart	RESD 1	; RVA of IAT start
 .IATLength	RESD 1	; IAT length [in DWORD]
ENDSTRUC
;
; Phoenix v2.5 Extra Structures
;
Struc IATCall
 .RVA		resd 1
 .Filter	resd 1	; for aligment sake
EndStruc

Struc IATScan
 .Init		resd 1  ; Init signature
 .Validate      resd 1	; validate IAT reference
 .Deinit        resd 1  ; Deinit signature
 .SetThread	resd 1  ; Prepare Thread (effective access)
 .Filter	resd 1  ; Thread filter
EndStruc

Struc HandlerStruc
 .IATScan	resd 1
 .Next		resd 1
 .Prev		resd 1
EndStruc

Struc RelocTree
 .NbPages	resd 1
 .TreeTable	resd 1
EndStruc
;
; PE Structures
;
Struc Object
 .Name		RESB 8  ; 00	; Object name
 .VSize		RESD 1  ; 08    ; Virtual Size
 .RVA		RESD 1  ; 0C    ; Virtual Address
 .PSize 	RESD 1  ; 10    ; Physical Size
 .Offset	RESD 1  ; 14    ; Physical Offset
 .reserved	RESD 3  ; 18    ;
 .Flags		RESD 1  ; 24    ; Object flags
EndStruc

Struc ImportDir
 .IAT           resd 1	; IAT pointer
 .TimeStamp     resd 1  ; TimeStamp (runtime||static)
 .Major         resw 1  ; Major Version
 .Minor	  	resw 1  ; Minor Version
 .Name          resd 1  ; Import DLL Name Pointer
 .Lookup	resd 1  ; Function Table Pointer
ENDSTRUC

STRUC ExportDir
 .Flags	  	resd 1	; 00
 .TimeStamp	resd 1  ; 04
 .Major	  	resw 1  ; 08
 .Minor	  	resw 1  ; 0A
 .DLLName	resd 1  ; 0C
 .OrdBase	resd 1  ; 10
 .NbExport	resd 1  ; 14
 .NbName	resd 1  ; 18
 .ExportAddress resd 1  ; 1C
 .FuncTable	resd 1  ; 20
 .OrdTable	resd 1  ; 24
ENDSTRUC

Struc DelayDir
 .Chars	  	resd 1  ;
 .DLLName       resd 1  ;
 .hMod	  	resd 1  ;
 .IAT	  	resd 1  ; no touch
 .Lookup	resd 1  ; rebase
 .Bound   	resd 1  ;
 .Unload   	resd 1  ;
 .TimeStamp	resd 1  ;
ENDSTRUC

Struc BoundDir
 .TimeStamp	resd 1
 .ModuleName	resw 1
 .NbRefs	resw 1
EndStruc

Struc BoundRef
 .TimeStamp	resd 1
 .ModuleName	resw 1
 .reserved	resw 1
EndStruc

Struc RsrcDir
 .Flags		resd 1
 .TimeStamp	resd 1
 .Version	resd 1
 .NbName	resw 1
 .NbID		resw 1
EndStruc

Struc ResEntry
 .Identifier	resd 1
 .Pointer	resd 1
EndStruc

Struc DataEntry
 .RVA		resd 1
 .Size          resd 1
 .CodePage      resd 1
 .Reserved      resd 1
EndStruc

Struc TLSDir
 .Start		resd 1
 .End		resd 1
 .Index		resd 1
 .Callback	resd 1
 .Flags		resd 1
 .Chars		resd 1
EndStruc

Struc FixupEntry
 .Page	resd 1
 .Len	resd 1
EndStruc

STRUC MZHEADER
 .Magic         resw 1	; 0
 .Cblp          resw 1	; 2
 .Cp            resw 1	; 4
 .Crlc          resw 1	; 6
 .Cparhdr       resw 1	; 8
 .MinAlloc      resw 1	; A
 .MaxAlloc      resw 1	; C
 .ss            resw 1	; E
 .sp            resw 1	; 10
 .Checksum      resw 1	; 12
 .ip            resw 1	; 14
 .cs            resw 1	; 16
 .Reloc         resw 1	; 18
 .NbOverlay     resw 1	; 1A
 .Res           resw 4	; 1C
 .OEMId         resw 1	; 24
 .OEMInfo       resw 10	; 26
 .Res2          resw 1  ; 3A
 .NewHeader     resd 1	; 3C
ENDSTRUC

Struc PEHeader
 .Magic		resd 1	;+00
 .CPU	  	resw 1	;+04
 .NbObj	  	resw 1	;+06
 .TimeStamp	resd 1	;+08
 .PtrToSymTable	resd 1	;+0C
 .NbOfSymbols	resd 1	;+10
 .NTHeaderSize  resw 1	;+14
 .Flags	  	resw 1	;+16
 .Magic2	resw 1	;+18
 .LinkMinor     resb 1	;+1A
 .LinkMajor	resb 1	;+1B
 .CodeSize      resd 1	;+1C
 .DataSize      resd 1  ;+20
 .BSSSize       resd 1  ;+24
 .EIP           resd 1  ;+28
 .CodeStart     resd 1  ;+2C
 .DataStart     resd 1  ;+30
 .ImageBase     resd 1  ;+34
 .SAlign        resd 1  ;+38
 .FAlign        resd 1  ;+3C
 .OSMajor	resw 1  ;+3E
 .OSMinor       resw 1  ;+40
 .UserMajor	resw 1  ;+42
 .UserMinor	resw 1  ;+44
 .SubSysMajor   resw 1  ;+46
 .SubSysMinor	resw 1  ;+48
 .Win32VerValue	resd 1  ;+4A
 .ImageSize	resd 1  ;+50
 .HeaderSize	resd 1  ;+54
 .CheckSum	resd 1  ;+58
 .SubSystem	resw 1  ;+5C
 .DLLFlags	resw 1  ;+5E
 .StackMax      resd 1  ;+60
 .StackMin	resd 1  ;+64
 .HeapMax       resd 1  ;+68
 .HeapMin	resd 1  ;+6C
 .LoaderFlags	resd 1  ;+70
 .NbDir	  	resd 1  ;+74
 .ExportRVA	resd 1  ;+78
 .ExportSize	resd 1  ;+7C
 .ImportRVA     resd 1  ;+80
 .ImportSize    resd 1  ;+84
 .RsrcRVA       resd 1  ;+88
 .RsrcSize      resd 1  ;+8C
 .ExceptRVA     resd 1  ;+90
 .ExceptSize    resd 1  ;+94
 .SecurityRVA   resd 1  ;+98
 .SecuritySize  resd 1  ;+9C
 .RelocRVA      resd 1  ;+A0
 .RelocSize     resd 1  ;+A4
 .DebugRVA      resd 1  ;+A8
 .DebugSize     resd 1  ;+AC
 .DescriptRVA   resd 1  ;+B0
 .DescriptSize  resd 1  ;+B4
 .GlobalPtrRVA  resd 1  ;+B8
 .GlobalPtrSize resd 1  ;+BC
 .TLSRVA        resd 1  ;+C0
 .TLSSize       resd 1  ;+C4
 .LoadCfgRVA    resd 1  ;+C8
 .LoadCfgSize   resd 1  ;+CC
 .BoundRVA      resd 1  ;+D0
 .BoundSize     resd 1  ;+D4
 .IATRVA        resd 1  ;+D8
 .IATSize       resd 1  ;+DC
 .DelayRVA      resd 1  ;+E0
 .DelaySize     resd 1  ;+E4
 .COMRTRVA      resd 1  ;+E8
 .COMRTSize     resd 1  ;+EC
 .UnkRVA        resd 1  ;+F0
 .UnkSize       resd 1  ;+F4
EndStruc
