%include "util.mac"
%include "icedump.inc"
%include "vxdn.inc"
%include "wiat.inc"
%include "win32n.inc"
%include "common.inc"
%include "taskmod.inc"


bits 32


global GetStackHandle
global GetProcessHandle
global GetCurrentProcessID
global GetModuleHandle
global GetModuleFileName
global PageQuery
global PrintStr
global RegisterPrintCore

segment _LTEXT
GetStackHandle:
	mov	eax, [dClient_ESP]
	mov	eax, [eax]
	retn

GetProcessHandle:
	VxDCall	VWIN32_GetCurrentProcessHandle
	retn

;
; Retrieve Current Process ID.
;

;
;eax=PID.
;
GetCurrentProcessID:
	VxDCall	VWIN32_GetCurrentProcessHandle
	test	eax,eax
	jz	@F

	movzx	eax,word [eax+0x38]	; PDB.W16TDB

@@
	retn
;
; Retrieve ImageBase of given Name (Null for Main Base).
;

;
;ebp+8 : Name or 0.
;
;eax=ImageBase, 0 if failure.
;
GetModuleHandle:
	push	ebp
	mov	ebp, esp
	sub	esp, TASKENTRY_size+MAX_PATH+MODULEENTRY_size
	push	esi
	push	edi
	push	edx
	push	ecx
	push	ebx

;
; Setup registers [Name/Current PID].
;
	Call	GetCurrentProcessID

	mov	edx, eax
	mov	esi, [ebp+08h]

	test	esi, esi		; SelfBase ?
	jnz	.ScanThis

;
; Retrieve name of current PID.
;
	lea	ebx, [ebp-TASKENTRY_size]

	push	ebx
	Call	TaskFirst

.CmpTaskDB:
	test	eax, eax
	jz	.RetFailure

	cmp	[ebx+TASKENTRY.te_hTask], edx
	jz	.CopyFN

	push	ebx
	Call	TaskNext
	jmp	.CmpTaskDB

.CopyFN:
;
; Replicate name.
;
	lea	esi, [ebx+TASKENTRY.te_ProcName]
	lea	edi, [ebp-(TASKENTRY_size+MAX_PATH)]
	push	edi
	push	esi
	call	strcopy
	mov	esi, edi

.ScanThis:
	push	esi
	Call	CharUpper		; Fool Proof Measure :)

;
; Retrieve Short name of Target.
;
	push	esi
	Call	ExtractNamePos
	add	esi, eax

;
; Browse Module List.
;
	lea	ebx, [ebp-(TASKENTRY_size+MAX_PATH+MODULEENTRY_size)]

	push	edx
	push	ebx
	Call	ModFirst

.CmpModShort:
	test	eax, eax
	jz	.RetFailure

;
; Found it ?.
;
	lea	eax, [ebx+MODULEENTRY.me_ModuleName]
	push	eax
	push	esi
	call	strcmp
	test	eax, eax
	jz	.OkFoundModule

	push	ebx
	Call	ModNext
	jmp	.CmpModShort

.OkFoundModule:
;
; Return hMod.
;
	mov	eax, [ebx+MODULEENTRY.me_hModule]

.RetFailure:
	pop	ebx
	pop	ecx
	pop	edx
	pop	edi
	pop	esi
	mov	esp, ebp
	pop	ebp
	retn	4

;
; .
;

;
;ebp+8 : Base.
;ebp+C : buffer
;ebp+10: buffer size
;
;eax=ImageBase, 0 if failure.
;
GetModuleFileName:
	push	ebp
	mov	ebp, esp
	sub	esp, TASKENTRY_size+MODULEENTRY_size
	push	esi
	push	edi
	push	edx
	push	ecx
	push	ebx
;
; Setup registers [Name/Current PID].
;
	Call	GetCurrentProcessID

	mov	edx, eax
	mov	esi, [ebp+08h]

	test	esi, esi		; SelfBase ?
	jnz	.ScanThis
;
; Retrieve name of current PID.
;
	lea	ebx, [ebp-TASKENTRY_size]

	push	ebx
	Call	TaskFirst

.CmpTaskDB:
	test	eax, eax
	jz	.Return

	cmp	[ebx+TASKENTRY.te_hTask], edx
	jz	.CopyFN

	push	ebx
	Call	TaskNext
	jmp	.CmpTaskDB
.CopyFN:
;
; Replicate name.
;
	lea	esi, [ebx+TASKENTRY.te_ProcName]
.CopyModName:
	mov	edi, [ebp+0Ch]
	push	edi
	push	esi
	call	strcopy

	push	edi
	Call	CharUpper		; Fool Proof Measure :)

	push	edi
	Call	strlen
	jmp	.Return
.ScanThis:
;
; Browse Module List.
;
	lea	ebx, [ebp-(TASKENTRY_size+MODULEENTRY_size)]

	push	edx
	push	ebx
	Call	ModFirst

.CmpModShort:
	test	eax, eax
	jz	.Return
;
; Found it ?.
;
	cmp	esi, [ebx+MODULEENTRY.me_hModule]
	jz	.OkFoundModule

	push	ebx
	Call	ModNext
	jmp	.CmpModShort

.OkFoundModule:
	lea	esi, [ebx+MODULEENTRY.me_ExePath]
	jmp 	.CopyModName
;
;
;
.Return:
	pop	ebx
	pop	ecx
	pop	edx
	pop	edi
	pop	esi
	mov	esp, ebp
	pop	ebp
	retn	0ch
;
; Get Page Informations.
;

;
;ebp+8 : Page base
;ebp+C : PMEMORY_BASIC_INFORMATION
;ebp+10: PMEMORY_BASIC_INFORMATION_size
;
;eax=ImageBase, 0 if failure.
;
PageQuery:
	push	ebp
	mov	ebp, esp
	push	esi
	push	edi
	push	edx
	push	ecx
	push	ebx

	VMMCall	_PageQuery, dword [ebp+08h], dword [ebp+0Ch], dword [ebp+10h]

	pop	ebx
	pop	ecx
	pop	edx
	pop	edi
	pop	esi
	pop	ebp
	retn	0Ch

;
; Print a string.
;

;
;ebp+8 : string Zero Terminated
;
;
PrintStr:
	push	dword [esp+4]
	VMMCall	_Trace_Out_Service
	retn	04h


RegisterPrintCore:
	retn	4
