%include "util.mac"
%include "icedump.inc"
%include "wiat.inc"
%include "win32n.inc"


global Parse_Bhrama
global Bhrama_Struc


extern sdata
extern Parser.error
extern Parser.errorMsg
extern Error_V86
extern Error_PM16
extern Error_PMR0
extern API.oGetCurrentProcessID
extern API.oFindWindowA
extern API.oSendMessageA
extern CheckWCRS
extern ReinforceINT3
extern wcrs


bits 32


;-------------------------------------------------------------------------------
; BHRAMA <Bhrama window name>
;-------------------------------------------------------------------------------
segment _LTEXT
Parse_Bhrama:
	mov	edi,Error_V86
	mov	ebp,[dClient_EFLAGS]
	test	byte [ebp+2],2		; is client in V86 mode?
	jnz	near Parser.errorMsg

	mov	edi,Error_PM16
	mov	ebp,[dClient_CS]
	lar	eax,[ebp]		; is client 32 bit?
	bt	eax,22
	jnc	near Parser.errorMsg

	mov	edi,Error_PMR0
	test	byte [ebp],3		; is client in ring-0?
	jz	near Parser.errorMsg

	call	[pSkipWhiteSpace]	; skip to <Bhrama window name>
	jz	near Parser.error

	mov	ebp,[dClient_ESI]	; bhrama server's window name
	mov	[ebp],esi

	mov	ebp,[dClient_EIP]	; use current EIP
	mov	eax,[ebp]
	mov	[Bhrama_Struc+BhramaComStruc.EIP],eax

	mov	ebp,[dClient_EIP]	; set client (E)IP
	mov	dword [ebp],Procdump

	call	CheckWCRS
	call	ReinforceINT3

	mov	dword [wcrs+WCRS.oINT3],Procdump.return
	mov	dword [wcrs+WCRS.valid],1

	mov	ebp,[fExecuteMoreCommands]	; set internal Winice flag to 0
	mov	byte [ebp],0

	popad
	retn


; ------------------------------------------------------------------------------
; this is where we call Procdump based on Stone's example
; ------------------------------------------------------------------------------
Procdump:
	call	[API.oGetCurrentProcessID]
	mov	[Bhrama_Struc+BhramaComStruc.PID],eax
;	mov	[Bhrama_Struc+BhramaComStruc.EIP],0x0
;	mov	[Bhrama_Struc+BhramaComStruc.OptL1],0x00000000
;	mov	[Bhrama_Struc+BhramaComStruc.OptL2],0x01000001
;	mov	[Bhrama_Struc+BhramaComStruc.OptL3],0x01010001
;	mov	[Bhrama_Struc+BhramaComStruc.OptL4],0x00010000
;	mov	[Bhrama_Struc+BhramaComStruc.OptL5],0x00000000

; LookUp for ProcDump Server.
	push	esi
	push	byte 0
	call	[API.oFindWindowA]
	test	eax,eax
	jnz	.sendmsg

	mov	esi,msgNoWindow
	mov	ax,0x02			; DS_Out_Str
	int	0x41
	jmp	short .return

; Send Dump Message to ProcDump Server.
.sendmsg:
	push	dword .Service
	push	byte 0
	push	byte WM_COPYDATA
	push	eax			; ProcDump's hwnd
	call	[API.oSendMessageA]

.return:
	int3


segment _LDATA
	align 4
.Service:	dd 1
.DataLength:	dd BhramaComStruc_size
.DataPointer:	dd Bhrama_Struc

Bhrama_Struc:
istruc BhramaComStruc
  at BhramaComStruc.version,	dd 3
  at BhramaComStruc.PID,	dd 0
  at BhramaComStruc.EIP,	dd 0
  at BhramaComStruc.OptL1,	dd 0x00000000
  at BhramaComStruc.OptL2,	dd 0x01000101
  at BhramaComStruc.OptL3,	dd 0x01010001
  at BhramaComStruc.OptL4,	dd 0x00030000
  at BhramaComStruc.OptL5,	dd 0x00000000
iend

msgNoWindow:	db 'Failed to find Bhrama window',13,10,0
