; for v3.22, v3.23, v3.24, v3.25,
;     v4.00, v4.01,
;     v4.05.334, v4.05.526,
;     v4.21.53, v4.25.785, v4.25.824, v4.26.922, v4.27.562
; some symbols to make the code more readable

%ifndef INCLUDED_NTICE_INC
%define INCLUDED_NTICE_INC

NTICEDUMP_BUILD EQU 0x0014

%define NTICEDUMP_ID 'IDMP'

%ifndef NTICE_VERSION
%error please %define NTICE_VERSION
%endif

%if NTICE_VERSION <= 0xFFF
%define VERSION_TO_ASCII(v) '0'+((v) >> 8),'.','0'+(((v) >> 4) & 0xf),'0'+((v) & 0xf)
%elif NTICE_VERSION >= 0x100000
%define VERSION_TO_ASCII(v) '0'+((v) >> 20),'.','0'+(((v) >> 16) & 0xf),'0'+(((v) >> 12) & 0xf),'.','0'+(((v) >> 8) & 0xf),'0'+(((v) >> 4) & 0xf),'0'+((v) & 0xf)
%else
%define VERSION_TO_ASCII(v) '0'+((v) >> 16),'.','0'+(((v) >> 12) & 0xf),'0'+(((v) >> 8) & 0xf),'.','0'+(((v) >> 4) & 0xf),'0'+((v) & 0xf)
%endif


%if NTICE_VERSION = 0x322

	%assign PAGEIN_PATCH_ORIGIN 0xE3C14

	PAGEIN_CMDLINE	EQU 0x1F124
	PAGEIN_PARSER	EQU 0x1F129

	dIGNOREFAULTS1	EQU 0x8E583
	dIGNOREFAULTS2	EQU 0x8E587

	PCI_VENDORS	EQU 0x60388
        SELF_REF        EQU 0x38E9B      
	CRS_END		EQU 0x37AE9

	pNticeInit	EQU 0x3AE8D
	pSaveRegs	EQU 0x37AD6
	pRestoreRegs	EQU 0x37B6D

	%include "ntice3.22.inc"

%elif NTICE_VERSION = 0x323

	%assign PAGEIN_PATCH_ORIGIN 0xE9F8C

	PAGEIN_CMDLINE	EQU 0x1F6A0
	PAGEIN_PARSER	EQU 0x1F6A5

	dIGNOREFAULTS1	EQU 0x90AAB
	dIGNOREFAULTS2	EQU 0x90AAF

	PCI_VENDORS	EQU 0x62D28
        SELF_REF        EQU 0x39908
	CRS_END		EQU 0x38529

	pNticeInit	EQU 0x3B91B
	pSaveRegs	EQU 0x38516
	pRestoreRegs	EQU 0x385AD

	%include "ntice3.23.inc"

%elif NTICE_VERSION = 0x324

	%assign PAGEIN_PATCH_ORIGIN 0xE87E4

	PAGEIN_CMDLINE	EQU 0x1F6E0
	PAGEIN_PARSER	EQU 0x1F6E5

	dIGNOREFAULTS1	EQU 0x90B8B
	dIGNOREFAULTS2	EQU 0x90B8F

	PCI_VENDORS	EQU 0x62E50

	CRS_END		EQU 0x38631

	pNticeInit	EQU 0xF2BA0
	pSaveRegs	EQU 0x3861E
	pRestoreRegs	EQU 0x386B5

	%include "ntice3.24.inc"

%elif NTICE_VERSION = 0x325

	%assign PAGEIN_PATCH_ORIGIN 0xF8624

	PAGEIN_CMDLINE	EQU 0x1F6CB
	PAGEIN_PARSER	EQU 0x1F6D0

	dIGNOREFAULTS1	EQU 0x9DC8E
	dIGNOREFAULTS2	EQU 0x9DC92

	PCI_VENDORS	EQU 0x66C90

	CRS_END		EQU 0x3868D

	pNticeInit	EQU 0x102E20
	pSaveRegs	EQU 0x3867A
	pRestoreRegs	EQU 0x38711

	%include "ntice3.25.inc"

%elif NTICE_VERSION = 0x400

	%assign PAGEIN_PATCH_ORIGIN 0x1209F8

	PAGEIN_CMDLINE	EQU 0x203F7
	PAGEIN_PARSER	EQU 0x203FC

	dIGNOREFAULTS1	EQU 0xBD502
	dIGNOREFAULTS2	EQU 0xBD506

	PCI_VENDORS	EQU 0x74408

	CRS_END		EQU 0x394FD

	pNticeInit	EQU 0x12BE40
	pSaveRegs	EQU 0x394EA
	pRestoreRegs	EQU 0x39581

	%include "ntice4.00.inc"

%elif NTICE_VERSION = 0x401

	%assign PAGEIN_PATCH_ORIGIN 0x120A58

	PAGEIN_CMDLINE	EQU 0x20427
	PAGEIN_PARSER	EQU 0x2042C

	dIGNOREFAULTS1	EQU 0xBD562
	dIGNOREFAULTS2	EQU 0xBD566

	PCI_VENDORS	EQU 0x74458

	CRS_END		EQU 0x39541

	pNticeInit	EQU 0x12BEA0
	pSaveRegs	EQU 0x3952E
	pRestoreRegs	EQU 0x395C5

	%include "ntice4.01.inc"

%elif NTICE_VERSION = 0x405334

	%assign PAGEIN_PATCH_ORIGIN 0x201F4

	PAGEIN_CMDLINE	EQU 0x37EA3
	PAGEIN_PARSER	EQU 0x37EA8

	dIGNOREFAULTS1	EQU 0x9C8C3
	dIGNOREFAULTS2	EQU 0x9C8C7

	PCI_VENDORS	EQU 0x1CF28

	CRS_END		EQU 0x5103B

	pNticeInit	EQU 0x131B64
	pSaveRegs	EQU 0x51028
	pRestoreRegs	EQU 0x510BF

	%include "ntice4.05.334.inc"

%elif NTICE_VERSION = 0x405526

	%assign PAGEIN_PATCH_ORIGIN 0x20354

	PAGEIN_CMDLINE	EQU 0x3DE38
	PAGEIN_PARSER	EQU 0x3DE3D

	dIGNOREFAULTS1	EQU 0xACDF0
	dIGNOREFAULTS2	EQU 0xACDF4

	PCI_VENDORS	EQU 0x1D088

	CRS_END		EQU 0x55DDB

	pNticeInit	EQU 0x133760
	pSaveRegs	EQU 0x55DC8
	pRestoreRegs	EQU 0x55E5F

	%include "ntice4.05.526.inc"

%elif NTICE_VERSION = 0x42153

	%assign PAGEIN_PATCH_ORIGIN 0x20C9C

	PAGEIN_CMDLINE	EQU 0x3E7DF
	PAGEIN_PARSER	EQU 0x3E7E4

	dIGNOREFAULTS1	EQU 0xAE4F4
	dIGNOREFAULTS2	EQU 0xAE4F8

	PCI_VENDORS	EQU 0x1D9D0

	CRS_END		EQU 0x56933

	pNticeInit	EQU 0x1377A0
	pSaveRegs	EQU 0x56920
	pRestoreRegs	EQU 0x569B7

	%include "ntice4.21.53.inc"

%elif NTICE_VERSION = 0x425785

	%assign PAGEIN_PATCH_ORIGIN 0x22168

	PAGEIN_CMDLINE	EQU 0x4075C
	PAGEIN_PARSER	EQU 0x40761

	dIGNOREFAULTS1	EQU 0xB6A58
	dIGNOREFAULTS2	EQU 0xB6A5C

	PCI_VENDORS	EQU 0x1D6B8

	CRS_END		EQU 0x58AEF

	pNticeInit	EQU 0x145EC0
	pSaveRegs	EQU 0x58ADC
	pRestoreRegs	EQU 0x58B73

	%include "ntice4.25.785.inc"

%elif NTICE_VERSION = 0x425824

	%assign PAGEIN_PATCH_ORIGIN 0x22168

	PAGEIN_CMDLINE	EQU 0x406A8
	PAGEIN_PARSER	EQU 0x406AD

	dIGNOREFAULTS1	EQU 0xB6D18
	dIGNOREFAULTS2	EQU 0xB6D1C

	PCI_VENDORS	EQU 0x1D6B8

	CRS_END		EQU 0x58C53

	pNticeInit	EQU 0x146120
	pSaveRegs	EQU 0x58C40
	pRestoreRegs	EQU 0x58CD7

	%include "ntice4.25.824.inc"

%elif NTICE_VERSION = 0x426922

	%assign PAGEIN_PATCH_ORIGIN 0x22180

	PAGEIN_CMDLINE	EQU 0x4074D
	PAGEIN_PARSER	EQU 0x40752

	dIGNOREFAULTS1	EQU 0xB83B8
	dIGNOREFAULTS2	EQU 0xB83BC

	PCI_VENDORS	EQU 0x1D6D0

	CRS_END		EQU 0x58D1F

	pNticeInit	EQU 0x148300
	pSaveRegs	EQU 0x58D0C
	pRestoreRegs	EQU 0x58DA3

	%include "ntice4.26.922.inc"

%elif NTICE_VERSION = 0x427562

	%assign PAGEIN_PATCH_ORIGIN 0x231F0

	PAGEIN_CMDLINE	EQU 0x42DFC
	PAGEIN_PARSER	EQU 0x42E01

	dIGNOREFAULTS1	EQU 0xBEF01
	dIGNOREFAULTS2	EQU 0xBEF05

	PCI_VENDORS	EQU 0x1E740

	CRS_END		EQU 0x5C1AE

	pNticeInit	EQU 0x1522E0
	pSaveRegs	EQU 0x5C19B
	pRestoreRegs	EQU 0x5C232

	%include "ntice4.27.562.inc"

%else
%error unsupported version: NTICE_VERSION
%endif

struc BhramaComStruc
.version	resd 1	; Internal Check (03h)
.PID		resd 1	; Target PID
.EIP		resd 1	; EntryPoint to Set after DUMP
.OptL1		resd 1	; Internal ProcDump Options Dword1
.OptL2		resd 1	; Internal ProcDump Options Dword2
.OptL3		resd 1	; Internal ProcDump Options Dword3
.OptL4		resd 1	; Internal ProcDump Options Dword4
.OptL5		resd 1	; Internal ProcDump Options Dword5
endstruc

WM_COPYDATA	EQU 004Ah

; Client Register Structure as passed to debug services ... Not NT standard
struc CRS
Client_EDI	resd 1		; 0
Client_ESI	resd 1		; 4
Client_EBP	resd 1		; 8
Client_res0	resd 1		; C
Client_EBX	resd 1		; 10
Client_EDX	resd 1		; 14
Client_ECX	resd 1		; 18
Client_EAX	resd 1		; 1C
Client_Error	resd 1		; 20
Client_EIP	resd 1		; 24
Client_CS	resw 1		; 28
Client_res1	resw 1		; 2C
Client_EFlags	resd 1		; 30
Client_ESP	resd 1		; 34
Client_SS	resw 1		; 38
Client_res2	resw 1
Client_ES	resw 1		; 3C
Client_res3	resw 1
Client_DS	resw 1		; 40
Client_res4	resw 1
Client_FS	resw 1		; 44
Client_res5	resw 1
Client_GS	resw 1		; 48
Client_res6	resw 1
Client_Alt_EIP	resd 1		; 4C
Client_Alt_CS	resw 1		; 50
Client_res7	resw 1
Client_Alt_EFlags	resd 1
Client_Alt_ESP	resd 1
Client_Alt_SS	resw 1
Client_res8	resw 1
Client_Alt_ES	resw 1
Client_res9	resw 1
Client_Alt_DS	resw 1
Client_res10	resw 1
Client_Alt_FS	resw 1
Client_res11	resw 1
Client_Alt_GS	resw 1
Client_res12	resw 1
endstruc

struc NTIcedumpHdr
.ID		resd 1	; nticedump patch ID
.Len		resw 1	; header size
.PatchVer	resw 1	; nticedump patcher version
.Ver		resd 1	; nticedump version
.SiVer		resd 1	; target SoftIce version
.VA     	resd 1	; RVA of Call to Init
endstruc

%define		ZwCreateFile			0
%define		ZwReadFile			4
%define		ZwWriteFile			2*4
%define		ZwClose				3*4
%define		RtlAnsiStringToUnicodeString	4*4
%define		RtlInitAnsiString		5*4
%define		DbgPrint			6*4
%define		RtlFreeUnicodeString		7*4
%define		MmIsAddressValid		8*4
%define		ZwSetInformationFile		9*4
%define		KeAttachProcess			0xA*4
%define		KeDetachProcess			0xB*4
%define		KeInitializeDpc			0xC*4
%define		KeInsertQueueDpc		0xD*4

%define		MaxImportId		0xE

%define		NtSuspendThread		5
%define		NtResumeThread		6

%define		Srv_Version	0
%define		Srv_Dump	1
%define		Srv_Suspend	2
%define		Srv_Resume	3
%define		Srv_Bhrama	4
%define		Srv_DumpX	5
%define		Srv_Load	6
%define		MaxSrv		7

%define		CRLF_0			13,10,0

%endif
