using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

// needed namespaces
using System.IO;
using System.Globalization;
using System.Threading;

namespace Example
{
	/// <summary>
	/// Working process:
	/// 1. Check if Form.Localizable == true
	/// 2. Build this project
	/// 3. Run Localize.Net.exe (Localizator)
	/// 4. Select a target language
	/// 5. Open this project; press OK in Select dictionary form if is
	/// 6. Translate anything
	/// 7. Press Build button and close the Localizator
	/// 8. Run this Example
	/// </summary>
	public partial class Form1 : Form
	{
		public Form1()
		{
			// initialize selected language
			// set language culture; must be before InitializeComponent
			Thread.CurrentThread.CurrentUICulture = new CultureInfo(Properties.Settings.Default.LangName, true);

			InitializeComponent();
		}

		private void Form1_Load(object sender, EventArgs e)
		{
			bool IsLang = false;
			string runDirectory = AppDomain.CurrentDomain.BaseDirectory;
			// proprietary file name:
			string runFile = "Example.resources.dll";
			// if you want universal solving, you use next code instead of above:
			/*
			string runFile = AppDomain.CurrentDomain.FriendlyName;
			runFile = Path.GetFileNameWithoutExtension(runFile) + ".resources.dll";
			*/
			string[] subdirectoryEntries = Directory.GetDirectories(runDirectory);
			foreach (string subdirectory in subdirectoryEntries)
				// name of localize directory and file
				if (File.Exists(Path.Combine(subdirectory, runFile)))
				{
					DirectoryInfo di = new DirectoryInfo(subdirectory);
					ToolStripMenuItem langMenuItem = new ToolStripMenuItem(di.Name, null, 
						new EventHandler(menuLang_Click));
					this.languageMenuItem.DropDownItems.Add(langMenuItem);
					if (Properties.Settings.Default.LangName.CompareTo(di.Name) == 0)
					{
						langMenuItem.Enabled = false;
						IsLang = true;
					}
				}
			if (!IsLang)
			{
				Properties.Settings.Default.LangName = "";
				defaultMenuItem.Enabled = false;
			}
		}

		/// <summary>
		/// Select language in menu.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void menuLang_Click(object sender, System.EventArgs e)
		{
			// defaultMenuItem is name of [Default] menu item
			if ((ToolStripMenuItem)sender == defaultMenuItem)
				Properties.Settings.Default.LangName = "";
			else
				Properties.Settings.Default.LangName = ((ToolStripMenuItem)sender).Text;
			Properties.Settings.Default.Save();
			MessageBox.Show(Properties.Resources.RestartApp);
		}

		private void button1_Click(object sender, EventArgs e)
		{
			Form2 form = new Form2();
			form.ShowDialog(this);
			form.Dispose();
		}

		private void button3_Click(object sender, EventArgs e)
		{
			Close();
		}
	}
}