#
# $Id: Base64.pm,v 2.16 2001/02/24 06:28:10 gisle Exp $

package Base64;

use strict;
use vars qw(@ISA @EXPORT $VERSION $OLD_CODE);

require Exporter;
require DynaLoader;
@ISA = qw(Exporter DynaLoader);
@EXPORT = qw(encode_base64 decode_base64);

$VERSION = '2.12';

eval { bootstrap Base64 $VERSION; };
if ($@) {
  # can't bootstrap XS implementation, use perl implementation
  *encode_base64 = \&old_encode_base64;
  *decode_base64 = \&old_decode_base64;

  $OLD_CODE = $@;
  #warn $@ if $^W;
}

use integer;

sub old_encode_base64 ($;$)
{
  my $res = "";
  my $eol = $_[1];
  $eol = "\n" unless defined $eol;
  pos($_[0]) = 0;              # ensure start at the beginning

  $res = join '', map( pack('u',$_)=~ /^.(\S*)/, ($_[0]=~/(.{1,45})/gs));

  $res =~ tr|` -_|AA-Za-z0-9+/|;         # `# help emacs
  # fix padding at the end
  my $padding = (3 - length($_[0]) % 3) % 3;
  $res =~ s/.{$padding}$/'=' x $padding/e if $padding;
  # break encoded string into lines of no more than 76 characters each
  if (length $eol) {
	$res =~ s/(.{1,76})/$1$eol/g;
  }
  return $res;
}

sub old_decode_base64 ($)
{
  local($^W) = 0; # unpack("u",...) gives bogus warning in 5.00[123]

  my $str = shift;
  $str =~ tr|A-Za-z0-9+=/||cd;      # remove non-base64 chars
  if (length($str) % 4) {
	require Carp;
	Carp::carp("Length of base64 data not a multiple of 4")
  }
  $str =~ s/=+$//;            # remove padding
  $str =~ tr|A-Za-z0-9+/| -_|;      # convert to uuencoded format

  return join'', map( unpack("u", chr(32 + length($_)*3/4) . $_),
	        $str =~ /(.{1,60})/gs);
}

*encode = \&encode_base64;
*decode = \&decode_base64;

1;
