<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="/">
		<table id="listing" style="width:100%; table-layout:fixed;">
			<tr>
				<th align="left" onclick="check_all(this)" class="td_download_title" style="width:25%;">
					<input type="checkbox" name="title_all" value="checkbox">
						<a href="#" style="color:#fcfcfc;" title="Sortuj wg nazwy" onclick="sort('@title','text')">
							<xsl:value-of select="/ItemTemplate/DispName/@title"/>
						</a>
					</input>
				</th>
				<th align="left" class="td_download_title" style="width:10%;">
					<a href="#" style="color:#fcfcfc;" title="Sortuj wg liczby odwiedzin" onclick="sort('@visit_count','number')">
						<xsl:value-of select="/ItemTemplate/DispName/@visit_count"/>
					</a>
				</th>
				<th align="left" class="td_download_title" style="width:50%;">
					<a href="#" style="color:#fcfcfc;" title="Sortuj wg adresu URL" onclick="sort('@URL','text')">
						<xsl:value-of select="/ItemTemplate/DispName/@URL"/>
					</a>
				</th>
				<th align="left" class="td_download_title" style="width:50%;">
					<a href="#" style="color:#fcfcfc;" title="Sortuj wg nazwy pliku" onclick="sort('@local_file','text')">
						<xsl:value-of select="/ItemTemplate/DispName/@FileName"/>
					</a>
				</th>

			</tr>
			<xsl:apply-templates select="ItemTemplate/Item">
				<xsl:sort select="@title" data-type="text" order="ascending"/>
			</xsl:apply-templates>
		</table>
	</xsl:template>
	<xsl:template match="Item">
		<tr>
			<xsl:apply-templates select="@title"/>
			<xsl:apply-templates select="@visit_count"/>
			<xsl:apply-templates select="@URL"/>
			<xsl:apply-templates select="@local_file"/>
		</tr>
	</xsl:template>
	<xsl:template match="@title">
		<td id="col1" class="td_download_main">
			<input type="checkbox" id="check_item" value="checkbox">
				<xsl:if test="../@icon">
					<img align="middle" hspace="3">
						<xsl:attribute name="src"><xsl:value-of select="../@icon"/></xsl:attribute>
					</img>
				</xsl:if>
				<a id="url" target="blank">
					<xsl:attribute name="href"><xsl:value-of select="../@URL"/></xsl:attribute>
					<xsl:attribute name="title"><xsl:value-of select="../@URL"/></xsl:attribute>
					<xsl:value-of select="."/>
				</a>
			</input>
			<input type="hidden" id="local_file">
				<xsl:attribute name="value"><xsl:value-of select="../@local_file"/></xsl:attribute>
			</input>
		</td>
	</xsl:template>
	<xsl:template match="@visit_count">
		<td class="td_download_main">
			<xsl:value-of select="."/>
		</td>
	</xsl:template>
	<xsl:template match="@URL">
		<td class="td_download_main">
			<xsl:value-of select="."/>
		</td>
	</xsl:template>
		<xsl:template match="@local_file">
		<td class="td_download_main">
			<xsl:value-of select="."/>
		</td>
	</xsl:template>
</xsl:stylesheet>
