; languages.nsi
;
; This is an example of a multilingual installer
; The user can select the language on startup

;--------------------------------

OutFile languages.exe

XPStyle on

;--------------------------------

; First is default
LoadLanguageFile "${NSISDIR}\Contrib\Language files\English.nlf"
Name English
LoadLanguageFile "${NSISDIR}\Contrib\Language files\Dutch.nlf"
Name Dutch
LoadLanguageFile "${NSISDIR}\Contrib\Language files\French.nlf"
Name French
LoadLanguageFile "${NSISDIR}\Contrib\Language files\German.nlf"
Name German
LoadLanguageFile "${NSISDIR}\Contrib\Language files\Korean.nlf"
Name Korean
LoadLanguageFile "${NSISDIR}\Contrib\Language files\Russian.nlf"
Name Russian
LoadLanguageFile "${NSISDIR}\Contrib\Language files\Spanish.nlf"
Name Spanish
LoadLanguageFile "${NSISDIR}\Contrib\Language files\Swedish.nlf"
Name Swedish
LoadLanguageFile "${NSISDIR}\Contrib\Language files\TradChinese.nlf"
Name "Traditional Chinese"
LoadLanguageFile "${NSISDIR}\Contrib\Language files\SimpChinese.nlf"
Name "Simplified Chinese"
LoadLanguageFile "${NSISDIR}\Contrib\Language files\Slovak.nlf"
Name Slovak

; The language can be the last used language like above, but it can be defined using /LANG
ComponentText /LANG=${LANG_ENGLISH} "English component page"
ComponentText /LANG=${LANG_DUTCH} "Dutch component page"
ComponentText /LANG=${LANG_FRENCH} "French component page"
ComponentText /LANG=${LANG_GERMAN} "German component page"
ComponentText /LANG=${LANG_KOREAN} "Korean component page"
ComponentText /LANG=${LANG_RUSSIAN} "Russian component page"
ComponentText /LANG=${LANG_SPANISH} "Spanish component page"
ComponentText /LANG=${LANG_SWEDISH} "Swedish component page"
ComponentText /LANG=${LANG_TRADCHINESE} "Traditional Chinese component page"
ComponentText /LANG=${LANG_SIMPCHINESE} "Simplified Chinese component page"
ComponentText /LANG=${LANG_SLOVAK} "Slovak component page"

LangString Sec1Name ${LANG_ENGLISH} "English section #1"
LangString Sec1Name ${LANG_DUTCH} "Dutch section #1"
LangString Sec1Name ${LANG_FRENCH} "French section #1"
LangString Sec1Name ${LANG_GERMAN} "German section #1"
LangString Sec1Name ${LANG_KOREAN} "Korean section #1"
LangString Sec1Name ${LANG_RUSSIAN} "Russian section #1"
LangString Sec1Name ${LANG_SPANISH} "Spanish section #1"
LangString Sec1Name ${LANG_SWEDISH} "Swedish section #1"
LangString Sec1Name ${LANG_TRADCHINESE} "Trandional Chinese section #1"
LangString Sec1Name ${LANG_SIMPCHINESE} "Simplified Chinese section #1"
LangString Sec1Name ${LANG_SLOVAK} "Slovak section #1"

LangString Message ${LANG_ENGLISH} "English message"
LangString Message ${LANG_DUTCH} "Dutch message"
LangString Message ${LANG_FRENCH} "French message"
LangString Message ${LANG_GERMAN} "German message"
LangString Message ${LANG_KOREAN} "Korean message"
LangString Message ${LANG_RUSSIAN} "Russian message"
LangString Message ${LANG_SPANISH} "Spanish message"
LangString Message ${LANG_SWEDISH} "Swedish message"
LangString Message ${LANG_TRADCHINESE} "Trandional Chinese message"
LangString Message ${LANG_SIMPCHINESE} "Simplified Chinese message"
LangString Message ${LANG_SLOVAK} "Slovak message"

;--------------------------------

;Section names set by Language strings
;It works with ! too
Section !$(Sec1Name) sec1
	MessageBox MB_OK $(Message)
SectionEnd

Section "Section number two"
	StrCmp $LANGUAGE ${LANG_ENGLISH} 0 +2
		MessageBox MB_OK "Installing English stuff"
	StrCmp $LANGUAGE ${LANG_DUTCH} 0 +2
		MessageBox MB_OK "Installing Dutch stuff"
	StrCmp $LANGUAGE ${LANG_FRENCH} 0 +2
		MessageBox MB_OK "Installing French stuff"
	StrCmp $LANGUAGE ${LANG_GERMAN} 0 +2
		MessageBox MB_OK "Installing German stuff"
	StrCmp $LANGUAGE ${LANG_KOREAN} 0 +2
		MessageBox MB_OK "Installing Korean stuff"
	StrCmp $LANGUAGE ${LANG_RUSSIAN} 0 +2
		MessageBox MB_OK "Installing Russian stuff"
	StrCmp $LANGUAGE ${LANG_SPANISH} 0 +2
		MessageBox MB_OK "Installing Spanish stuff"
	StrCmp $LANGUAGE ${LANG_SWEDISH} 0 +2
		MessageBox MB_OK "Installing Swedish stuff"
	StrCmp $LANGUAGE ${LANG_TRADCHINESE} 0 +2
		MessageBox MB_OK "Installing Traditional Chinese stuff"
	StrCmp $LANGUAGE ${LANG_SIMPCHINESE} 0 +2
		MessageBox MB_OK "Installing Simplified Chinese stuff"
	StrCmp $LANGUAGE ${LANG_SLOVAK} 0 +2
		MessageBox MB_OK "Installing Slovak stuff"
SectionEnd

;--------------------------------

Function .onInit

	;Language selection dialog

	Push ""
	Push ${LANG_ENGLISH}
	Push English
	Push ${LANG_DUTCH}
	Push Dutch
	Push ${LANG_FRENCH}
	Push French
	Push ${LANG_GERMAN}
	Push German
	Push ${LANG_KOREAN}
	Push Korean
	Push ${LANG_RUSSIAN}
	Push Russian
	Push ${LANG_SPANISH}
	Push Spanish
	Push ${LANG_SWEDISH}
	Push Swedish
	Push ${LANG_TRADCHINESE}
	Push "Traditional Chinese"
	Push ${LANG_SIMPCHINESE}
	Push "Simplified Chinese"
	Push ${LANG_SLOVAK}
	Push Slovak
	Push A ; A means auto count languages
	       ; for the auto count to work the first empty push (Push "") must remain
	LangDLL::LangDialog "Installer Language" "Please select the language of the installer"

	Pop $LANGUAGE
	StrCmp $LANGUAGE "cancel" 0 +2
		Abort
FunctionEnd