//
//  Copyright (c) 1999,2000 by Network TeleSystems, Inc.
//  All rights reserved.
//  Internet http://www.nts.com
//
//	Please direct all support-related calls to your licensed Internet Service 
//	Provider.  NTS does not provide direct support.  NTS works through Internet 
//	Service Providers that have licensed our software.
//
typedef unsigned char UInt8;
typedef unsigned short UInt16;
typedef unsigned long UInt32;

#define FALSE (0)
#define TRUE (!FALSE)
typedef char boolean;

typedef struct _Ether_Frame {
  u_char dest[6];
  u_char src[6];
  unsigned short etype;
  u_char data[1];
} EtherFrame, *PEtherFrame;


struct ethheader
{
#ifndef ETHER_ADDR_LEN
#define ETHER_ADDR_LEN 6
#endif
    u_char  ether_dhost[ETHER_ADDR_LEN];    /* destination ethernet address */
    u_char  ether_shost[ETHER_ADDR_LEN];    /* source ethernet address */
    u_short ether_type;                     /* packet type ID */
};

#ifndef ETH_H
#define ETH_H (sizeof(struct ethheader))
#endif

#if (!__GLIBC__)
struct ether_addr
{
    u_char  ether_addr_octet[6];
};
#endif

#define FRAME_METHOD_AUTO 0
#define FRAME_METHOD_ASYNC 1
#define FRAME_METHOD_SYNC 2

#define MIN_SYNC_PPP_FRAME 7
