/*
 * Decompiled with CFR 0.152.
 */
package com.opera;

import com.opera.ConsoleOStream;
import com.opera.PluginPanel;
import java.awt.Button;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.PrintStream;

public class JavaConsole
extends Frame
implements WindowListener,
ActionListener,
KeyListener {
    private TextArea output_area = new TextArea();
    private Button but;

    public JavaConsole() {
        super("Opera Java console");
        this.add(this.output_area);
        this.but = new Button("Clear");
        this.but.addActionListener(this);
        this.add("South", this.but);
        this.pack();
        this.output_area.setVisible(true);
        this.output_area.setEditable(false);
        this.setSize(300, 250);
        PrintStream printStream = new PrintStream(new ConsoleOStream(this.output_area));
        System.setOut(printStream);
        System.setErr(printStream);
        this.addWindowListener(this);
        this.output_area.addKeyListener(this);
        this.but.addKeyListener(this);
        this.printInfo();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getModifiers() != 0) {
            return;
        }
        switch (keyEvent.getKeyCode()) {
            case 67: {
                this.output_area.setText(null);
                this.printInfo();
                break;
            }
            case 70: {
                System.out.print("Running finalization ... ");
                System.runFinalization();
                System.out.println("finished.");
                break;
            }
            case 71: {
                System.out.print("Running garbage collection ... ");
                System.gc();
                System.out.println("finished.");
                break;
            }
            case 72: {
                this.printHelp();
                break;
            }
            case 76: {
                PluginPanel.printClassLoaders();
                break;
            }
            case 77: {
                long l = Runtime.getRuntime().freeMemory() / 1024L;
                long l2 = Runtime.getRuntime().totalMemory() / 1024L;
                System.out.println("Total memory: " + l2 + "K  Free memory: " + l + "K");
                break;
            }
            case 88: {
                PluginPanel.clearClassLoaderCache();
                break;
            }
        }
    }

    private void printInfo() {
        System.out.println("-- Opera Java Console --\n");
        System.out.println("Java vendor: " + System.getProperty("java.vendor"));
        System.out.println("Java version: " + System.getProperty("java.version"));
        System.out.println("\ntype 'h' for help\n\n--");
    }

    private void printHelp() {
        System.out.println("\nCommands:\n----------------------------------------");
        System.out.println("c - clear console");
        System.out.println("f - run finalization");
        System.out.println("g - run garbage collection");
        System.out.println("h - help");
        System.out.println("l - list cached classloaders");
        System.out.println("m - memory usage");
        System.out.println("x - clear classloader cache\n");
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.but) {
            this.output_area.setText(null);
            this.printInfo();
        }
    }
}

