/*
 * Decompiled with CFR 0.152.
 */
package com.opera;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

class OperaOutputStream
extends OutputStream {
    private static final int BUFFER_SIZE = 16384;
    private static Hashtable stream_map = new Hashtable();
    private static int next_stream_id = 0;
    private byte[] buffer = new byte[16384];
    private int next_write_byte = 0;
    private int stream_id = -1;
    protected int istream_id = -1;
    private boolean is_closed = false;
    protected Hashtable req_props = new Hashtable();

    protected OperaOutputStream() {
    }

    public void write(int n) throws IOException {
        if (this.buffer == null) {
            throw new IOException();
        }
        this.buffer[this.next_write_byte++] = (byte)n;
        if (this.next_write_byte == 16384) {
            this.flushBuffer();
        }
    }

    public void flush() throws IOException {
        if (this.buffer == null) {
            return;
        }
        this.flushBuffer();
    }

    public void close() throws IOException {
        if (this.buffer != null) {
            this.flushBuffer();
            this.postData(this.istream_id, this.makeExtraHeaders());
            this.buffer = null;
            this.is_closed = true;
        }
    }

    boolean isClosed() {
        return this.is_closed;
    }

    private void flushBuffer() {
        if (this.next_write_byte > 0) {
            this.addData(this.buffer, this.next_write_byte);
            this.next_write_byte = 0;
        }
    }

    private native void postData(int var1, String var2);

    private native void addData(byte[] var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int addStream(OperaOutputStream operaOutputStream) {
        Hashtable hashtable = stream_map;
        synchronized (hashtable) {
            stream_map.put(new Integer(next_stream_id), operaOutputStream);
            operaOutputStream.stream_id = next_stream_id++;
        }
        return operaOutputStream.stream_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeStream(int n) {
        Hashtable hashtable = stream_map;
        synchronized (hashtable) {
            stream_map.remove(new Integer(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static OperaOutputStream getStream(int n) {
        Hashtable hashtable = stream_map;
        synchronized (hashtable) {
            return (OperaOutputStream)stream_map.get(new Integer(n));
        }
    }

    private String makeExtraHeaders() {
        String string = "";
        Enumeration enumeration = this.req_props.keys();
        Enumeration enumeration2 = this.req_props.elements();
        while (enumeration.hasMoreElements()) {
            string = string.concat((String)enumeration.nextElement());
            String string2 = (String)enumeration2.nextElement();
            string = string2 != null ? string.concat(": " + string2 + "\r\n") : string.concat("\r\n");
        }
        return string;
    }
}

