/*
 * Decompiled with CFR 0.152.
 */
package com.opera;

import com.opera.AppletContext;
import com.opera.AppletContextManager;
import com.opera.AppletEvent;
import com.opera.AppletPanel;
import com.opera.CPointer;
import com.opera.JavaConsole;
import com.opera.StreamHandlerFactory;
import java.awt.Dimension;
import java.awt.Frame;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AllPermission;

class AppletManager {
    private static AppletManager instance;
    private String audioClipClassName;
    private String embedFrameClassName;
    private JavaConsole console;
    private Thread mainThread;
    private Thread profilerServerThread;

    private AppletManager() {
    }

    private void stopSoundDispatcher() {
        ThreadGroup root = Thread.currentThread().getThreadGroup();
        while (root.getParent() != null) {
            root = root.getParent();
        }
        Thread[] threads = new Thread[root.activeCount()];
        int count = root.enumerate(threads);
        for (int iThread = 0; iThread < count; ++iThread) {
            Thread thread = threads[iThread];
            if (!thread.getName().equals("Java Sound event dispatcher")) continue;
            thread.interrupt();
            break;
        }
    }

    private void destroy() {
        this.stopSoundDispatcher();
        if (this.console != null) {
            this.console.dispose();
            this.console = null;
        }
        if (this.profilerServerThread != null) {
            this.profilerServerThread.interrupt();
            this.profilerServerThread = null;
        }
    }

    static AppletManager getInstance() {
        if (instance == null) {
            instance = new AppletManager();
        }
        return instance;
    }

    static void destroyInstance() {
        instance.destroy();
        instance = null;
    }

    protected String getAudioClipClassName() {
        return this.audioClipClassName;
    }

    protected String getEmbeddedFrameClassName() {
        return this.embedFrameClassName;
    }

    void showConsole(boolean show) {
        if (this.console != null) {
            this.console.setVisible(show);
        }
    }

    boolean isInMainThread() {
        return Thread.currentThread() == this.mainThread;
    }

    void initialiseAppletEnv(String[] props) throws SecurityException {
        for (int i = 0; i < props.length / 2; ++i) {
            System.setProperty(props[i * 2], props[i * 2 + 1]);
        }
        this.mainThread = Thread.currentThread();
        String title = System.getProperty("browser.opera.consoleString");
        if (title == null) {
            title = "Opera - Java Console";
        }
        this.console = new JavaConsole(title);
        String runProfiler = System.getProperty("browser.opera.runprofiler");
        if (runProfiler != null && runProfiler.equals("true")) {
            try {
                Class<?> cls = Class.forName("com.opera.ProfilerServer");
                Constructor<?> cons = cls.getConstructor(null);
                Runnable server = (Runnable)cons.newInstance(null);
                this.profilerServerThread = new Thread(server);
                this.profilerServerThread.start();
            }
            catch (Throwable ex) {
                System.err.println("Couldn't start profiler server due to following exception:");
                ex.printStackTrace(System.err);
            }
        }
        try {
            Class<?> clz = Class.forName("sun.plugin.security.JDK11ClassFileTransformer");
            Method method = clz.getMethod("init", null);
            method.invoke(null, (Object[])null);
        }
        catch (Throwable e) {
            // empty catch block
        }
        SecurityManager newMgr = new SecurityManager();
        System.setSecurityManager(newMgr);
        SecurityManager mgr = System.getSecurityManager();
        if (mgr != null) {
            mgr.checkPermission(new AllPermission());
        }
        if (System.getProperty("browser.opera.useStreamHandler").equals("true")) {
            URL.setURLStreamHandlerFactory(new StreamHandlerFactory());
        }
        boolean imgCache = Boolean.valueOf(System.getProperty("browser.opera.useImageCache", "true"));
        boolean audioCache = Boolean.valueOf(System.getProperty("browser.opera.useAudioCache", "true"));
        AppletContext.setCachePolicy(imgCache, audioCache);
        try {
            AppletPanel.setClassLoaderCacheSize(Integer.parseInt(System.getProperty("browser.opera.classLoaderCacheSize", "10")));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.audioClipClassName = System.getProperty("browser.opera.audioClipClassName");
        this.embedFrameClassName = System.getProperty("browser.opera.frameClassName");
        if (this.embedFrameClassName != null) {
            this.embedFrameClassName = this.embedFrameClassName.replace('.', '/');
        }
    }

    AppletPanel newApplet(CPointer nativeWindowHandle, String[] attrKeys, String[] attrValues, String[] paramKeys, String[] paramValues, String documentBase, CPointer docPtr, CPointer inlineElm, boolean suppress) {
        Frame frame = this.createNewFrame(this.embedFrameClassName, nativeWindowHandle);
        if (frame == null) {
            return null;
        }
        AppletPanel newPanel = new AppletPanel(attrKeys, attrValues, paramKeys, paramValues, documentBase, docPtr, inlineElm, suppress);
        frame.add(newPanel);
        frame.setVisible(true);
        newPanel.setFrame(frame);
        newPanel.setVisible(true);
        newPanel.startHandler();
        newPanel.sendEvent(new AppletEvent(1));
        newPanel.sendEvent(new AppletEvent(2));
        newPanel.sendEvent(new AppletEvent(3));
        return newPanel;
    }

    void resizeApplet(AppletPanel panel, int width, int height) {
        Dimension dim = panel.getSize();
        if (dim.getWidth() != (double)width || dim.getHeight() != (double)height) {
            panel.sendEvent(new AppletEvent(6, new Dimension(width, height)));
        }
    }

    void destroyApplet(AppletPanel panel) {
        try {
            panel.destroy();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    void deleteDocument(CPointer docPtr) {
        AppletContextManager.deleteDocument(docPtr);
    }

    private native Frame createNewFrame(String var1, CPointer var2);
}

