/*
 * Decompiled with CFR 0.152.
 */
package com.opera;

import com.opera.AppletContext;
import com.opera.AppletContextManager;
import com.opera.CPointer;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Frame;
import java.awt.peer.ComponentPeer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Hashtable;

class MacUtil {
    private static Class jeViewerClass;
    private static Field panelField;
    private static int APPLET_ERROR;
    private static Method isActive;
    private static boolean reflectInited;
    private static Method embeddingPaintImmediately;
    private static Constructor peerEventCons;
    private static Method postEventForComponent;
    private static Hashtable appletContextMap;

    MacUtil() {
    }

    static void initReflection() {
        if (reflectInited) {
            return;
        }
        reflectInited = true;
        try {
            jeViewerClass = Class.forName("com.apple.mrj.JavaEmbedding.JE_AppletViewer");
            panelField = jeViewerClass.getField("panel");
            Class<?> appletPanel = Class.forName("sun.applet.AppletPanel");
            APPLET_ERROR = appletPanel.getField("APPLET_ERROR").getInt(null);
            isActive = appletPanel.getMethod("isActive", null);
            Class<?> framePeer = Class.forName("com.apple.mrj.internal.awt.frames.VFramePeer");
            embeddingPaintImmediately = framePeer.getMethod("embeddingPaintImmediately", null);
            Class[] args = new Class[]{Class.forName("java.awt.AWTEvent")};
            postEventForComponent = framePeer.getMethod("postEventForComponent", args);
            Class[] args2 = new Class[]{Class.forName("java.lang.Object"), Class.forName("java.lang.Runnable"), Long.TYPE};
            peerEventCons = Class.forName("sun.awt.PeerEvent").getConstructor(args2);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    static AppletContext getAppletContext(Applet applet) {
        try {
            MacUtil.initReflection();
            if (applet != null) {
                return (AppletContext)appletContextMap.get(applet);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static void newMacApplet(Object appletViewer, CPointer docPtr) {
        AppletContext ctx = AppletContextManager.getContext(docPtr);
        ctx.incRefMac();
        appletContextMap.put(appletViewer, ctx);
    }

    static void deleteMacApplet(Object appletViewer) {
        AppletContext ctx = (AppletContext)appletContextMap.remove(appletViewer);
        if (ctx != null) {
            ctx.decRefMac();
        }
    }

    static boolean macAppletCheckLoadingFinished(Object appletViewer) {
        try {
            MacUtil.initReflection();
            return (Boolean)isActive.invoke(panelField.get(appletViewer), (Object[])null) != false || MacUtil.getPanelStatus(panelField.get(appletViewer)) == APPLET_ERROR;
        }
        catch (Exception ex) {
            return true;
        }
    }

    static void macAsyncDrawJavaControl(Component obj) {
        Frame frame = (Frame)obj;
        ComponentPeer vframepeer = frame.getPeer();
        if (vframepeer != null) {
            try {
                MacUtil.initReflection();
                Object[] parms = new Object[]{vframepeer, new EmbedPaintRunnable(vframepeer), new Long(1L)};
                Object peerevent = peerEventCons.newInstance(parms);
                Object[] parms2 = new Object[]{peerevent};
                postEventForComponent.invoke((Object)vframepeer, parms2);
            }
            catch (Exception ex) {
                System.err.println("This exception should not have happened:");
                ex.printStackTrace(System.err);
            }
        }
    }

    private static native int getPanelStatus(Object var0);

    static {
        reflectInited = false;
        appletContextMap = new Hashtable();
    }

    static class EmbedPaintRunnable
    implements Runnable {
        Object peer;

        public void run() {
            try {
                if (this.peer != null) {
                    embeddingPaintImmediately.invoke(this.peer, (Object[])null);
                }
            }
            catch (Exception ex) {
                System.err.println("This exception should not have happened:");
                ex.printStackTrace(System.err);
            }
        }

        EmbedPaintRunnable(Object vframepeer) {
            this.peer = vframepeer;
        }
    }
}

