/*
 * Decompiled with CFR 0.152.
 */
package com.opera;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;

class LC3Resolver {
    static Class jsobjectClass;
    static Class objectClass;
    static Class stringClass;
    static Class classClass;
    static Class doubleClass;
    static Class booleanClass;

    LC3Resolver() {
    }

    static Method resolveMethod(Class clazz, String string, String string2, Object[] objectArray, boolean bl) {
        HashSet hashSet = new HashSet();
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!string.equals(methodArray[i].getName()) || bl && !Modifier.isStatic(methodArray[i].getModifiers()) || !LC3Resolver.isApplicable(methodArray[i].getParameterTypes(), string2, objectArray)) continue;
            LC3Resolver.addMethod(hashSet, methodArray[i], string2, objectArray);
        }
        if (hashSet.size() == 1) {
            return (Method)hashSet.iterator().next();
        }
        return null;
    }

    static Constructor resolveConstructor(Class clazz, String string, Object[] objectArray, boolean bl) {
        HashSet hashSet = new HashSet();
        Constructor<?>[] constructorArray = clazz.getConstructors();
        for (int i = 0; i < constructorArray.length; ++i) {
            if (bl && !Modifier.isStatic(constructorArray[i].getModifiers()) || !LC3Resolver.isApplicable(constructorArray[i].getParameterTypes(), string, objectArray)) continue;
            LC3Resolver.addConstructor(hashSet, constructorArray[i], string, objectArray);
        }
        if (hashSet.size() == 1) {
            return (Constructor)hashSet.iterator().next();
        }
        return null;
    }

    private static void addMethod(HashSet hashSet, Method method, String string, Object[] objectArray) {
        Class[] classArray = method.getParameterTypes();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Method method2 = (Method)iterator.next();
            Class[] classArray2 = method2.getParameterTypes();
            int n = LC3Resolver.computePreferred(classArray, classArray2, string, objectArray);
            if (n < 0) {
                iterator.remove();
                continue;
            }
            if (n <= 0) continue;
            return;
        }
        hashSet.add(method);
    }

    private static void addConstructor(HashSet hashSet, Constructor constructor, String string, Object[] objectArray) {
        Class[] classArray = constructor.getParameterTypes();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Constructor constructor2 = (Constructor)iterator.next();
            Class[] classArray2 = constructor2.getParameterTypes();
            int n = LC3Resolver.computePreferred(classArray, classArray2, string, objectArray);
            if (n < 0) {
                iterator.remove();
                continue;
            }
            if (n <= 0) continue;
            return;
        }
        hashSet.add(constructor);
    }

    private static boolean isApplicable(Class[] classArray, String string, Object[] objectArray) {
        if (classArray.length != string.length()) {
            return false;
        }
        block12: for (int i = 0; i < classArray.length; ++i) {
            switch (string.charAt(i)) {
                case 'u': {
                    if (classArray[i].equals(objectClass) || classArray[i].equals(stringClass)) continue block12;
                    return false;
                }
                case 'b': {
                    if (classArray[i].equals(Boolean.TYPE) || classArray[i].equals(booleanClass) || classArray[i].equals(objectClass) || classArray[i].equals(stringClass)) continue block12;
                    return false;
                }
                case 'n': {
                    if (classArray[i].equals(Double.TYPE) || classArray[i].equals(doubleClass) || classArray[i].equals(objectClass) || classArray[i].equals(Float.TYPE) || classArray[i].equals(Long.TYPE) || classArray[i].equals(Integer.TYPE) || classArray[i].equals(Short.TYPE) || classArray[i].equals(Byte.TYPE) || classArray[i].equals(Character.TYPE) || classArray[i].equals(stringClass)) continue block12;
                    return false;
                }
                case 's': {
                    if (classArray[i].equals(stringClass) || classArray[i].equals(objectClass) || classArray[i].equals(Double.TYPE) || classArray[i].equals(Float.TYPE) || classArray[i].equals(Long.TYPE) || classArray[i].equals(Integer.TYPE) || classArray[i].equals(Short.TYPE) || classArray[i].equals(Byte.TYPE) || classArray[i].equals(Character.TYPE)) continue block12;
                    return false;
                }
                case 'z': {
                    if (!classArray[i].isPrimitive()) continue block12;
                    return false;
                }
                case 'j': {
                    if (objectArray == null || classArray[i].isInstance(objectArray[i]) || classArray[i].equals(stringClass) || classArray[i].equals(Double.TYPE) || classArray[i].equals(Float.TYPE) || classArray[i].equals(Long.TYPE) || classArray[i].equals(Integer.TYPE) || classArray[i].equals(Short.TYPE) || classArray[i].equals(Byte.TYPE) || classArray[i].equals(Character.TYPE)) continue block12;
                    return false;
                }
                case 'a': {
                    if (objectArray == null || classArray[i].isInstance(objectArray[i]) || classArray[i].equals(stringClass)) continue block12;
                    return false;
                }
                case 'c': {
                    if (classArray[i].equals(classClass) || classArray[i].equals(jsobjectClass) || classArray[i].equals(objectClass) || classArray[i].equals(stringClass)) continue block12;
                    return false;
                }
                case 'A': {
                    if (classArray[i].equals(jsobjectClass) || classArray[i].equals(objectClass) || classArray[i].equals(stringClass) || classArray[i].isArray()) continue block12;
                    return false;
                }
                case 'o': {
                    if (classArray[i].equals(jsobjectClass) || classArray[i].equals(objectClass) || classArray[i].equals(stringClass) || classArray[i].equals(Double.TYPE) || classArray[i].equals(Float.TYPE) || classArray[i].equals(Long.TYPE) || classArray[i].equals(Integer.TYPE) || classArray[i].equals(Short.TYPE) || classArray[i].equals(Byte.TYPE) || classArray[i].equals(Character.TYPE)) continue block12;
                    return false;
                }
            }
        }
        return true;
    }

    private static int computePreferred(Class[] classArray, Class[] classArray2, String string, Object[] objectArray) {
        int[] nArray = LC3Resolver.computeWeightArray(classArray, string, objectArray);
        int[] nArray2 = LC3Resolver.computeWeightArray(classArray2, string, objectArray);
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] > nArray2[i]) {
                bl = true;
                continue;
            }
            if (nArray[i] < nArray2[i]) {
                bl2 = true;
                continue;
            }
            if (string.charAt(i) != 'a' && string.charAt(i) != 'j' || nArray[i] != 9 || nArray2[i] != 9 || classArray[i].equals(classArray2[i])) continue;
            if (classArray2[i].isAssignableFrom(classArray[i])) {
                bl = true;
                continue;
            }
            if (!classArray[i].isAssignableFrom(classArray2[i])) continue;
            bl2 = true;
        }
        if (bl && !bl2) {
            return -1;
        }
        if (!bl && bl2) {
            return 1;
        }
        return 0;
    }

    private static int[] computeWeightArray(Class[] classArray, String string, Object[] objectArray) {
        int n = classArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = LC3Resolver.getWeight(classArray[i], string.charAt(i), objectArray[i]);
        }
        return nArray;
    }

    private static int getWeight(Class clazz, char c, Object object) {
        switch (c) {
            case 'u': {
                return 1;
            }
            case 'b': {
                if (clazz.equals(Boolean.TYPE)) {
                    return 4;
                }
                if (clazz.equals(booleanClass)) {
                    return 3;
                }
                if (clazz.equals(objectClass)) {
                    return 2;
                }
                return 1;
            }
            case 'n': {
                if (clazz.equals(Double.TYPE)) {
                    return 10;
                }
                if (clazz.equals(doubleClass)) {
                    return 9;
                }
                if (clazz.equals(Float.TYPE)) {
                    return 8;
                }
                if (clazz.equals(Long.TYPE)) {
                    return 7;
                }
                if (clazz.equals(Integer.TYPE)) {
                    return 6;
                }
                if (clazz.equals(Short.TYPE)) {
                    return 5;
                }
                if (clazz.equals(Character.TYPE)) {
                    return 4;
                }
                if (clazz.equals(Byte.TYPE)) {
                    return 3;
                }
                if (clazz.equals(stringClass)) {
                    return 2;
                }
                return 1;
            }
            case 's': {
                if (clazz.equals(stringClass)) {
                    return 4;
                }
                if (clazz.equals(objectClass)) {
                    return 3;
                }
                if (clazz.equals(Character.TYPE)) {
                    return 2;
                }
                return 1;
            }
            case 'z': {
                return 1;
            }
            case 'j': {
                if (clazz.equals(stringClass) && !(object instanceof String)) {
                    return 8;
                }
                if (clazz.equals(Double.TYPE)) {
                    return 7;
                }
                if (clazz.equals(Float.TYPE)) {
                    return 6;
                }
                if (clazz.equals(Long.TYPE)) {
                    return 5;
                }
                if (clazz.equals(Integer.TYPE)) {
                    return 4;
                }
                if (clazz.equals(Short.TYPE)) {
                    return 3;
                }
                if (clazz.equals(Character.TYPE)) {
                    return 2;
                }
                if (clazz.equals(Byte.TYPE)) {
                    return 1;
                }
                return 9;
            }
            case 'a': {
                if (clazz.equals(stringClass)) {
                    return 1;
                }
                return 9;
            }
            case 'c': {
                if (clazz.equals(classClass)) {
                    return 4;
                }
                if (clazz.equals(jsobjectClass)) {
                    return 3;
                }
                if (clazz.equals(objectClass)) {
                    return 2;
                }
                return 1;
            }
            case 'A': {
                if (clazz.isArray()) {
                    return 4;
                }
                if (clazz.equals(jsobjectClass)) {
                    return 3;
                }
                if (clazz.equals(objectClass)) {
                    return 2;
                }
                return 1;
            }
            case 'o': {
                if (clazz.equals(jsobjectClass)) {
                    return 10;
                }
                if (clazz.equals(objectClass)) {
                    return 9;
                }
                if (clazz.equals(stringClass)) {
                    return 8;
                }
                if (clazz.equals(Double.TYPE)) {
                    return 7;
                }
                if (clazz.equals(Float.TYPE)) {
                    return 6;
                }
                if (clazz.equals(Long.TYPE)) {
                    return 5;
                }
                if (clazz.equals(Integer.TYPE)) {
                    return 4;
                }
                if (clazz.equals(Short.TYPE)) {
                    return 3;
                }
                if (clazz.equals(Character.TYPE)) {
                    return 2;
                }
                return 1;
            }
        }
        return 0;
    }

    static {
        try {
            jsobjectClass = Class.forName("netscape.javascript.JSObject");
            objectClass = Class.forName("java.lang.Object");
            stringClass = Class.forName("java.lang.String");
            classClass = Class.forName("java.lang.Class");
            doubleClass = Class.forName("java.lang.Double");
            booleanClass = Class.forName("java.lang.Boolean");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

