<?php

function ipboard_topics_show($options) {
	global $sid_bb, $meminfo, $std;
	$db =& Database::getInstance();
	$myts =& MyTextSanitizer::getInstance();
    	$block = array();
	switch($options[2]) {
	case 'views':
		$order = 't.views';
		break;
	case 'replies':
		$order = 't.posts';
		break;
	case 'time':
	default:
		$order = 't.last_post';
		break;
	}
	//-----------------------
	// Load skin image dir
	//-----------------------
	$sql = $db->query("SELECT * FROM ".$db->prefix('ipb_skins')." WHERE sid=".$meminfo['skin']."");
	$skin = $db->fetchArray($sql);

	if (empty($skin['img_dir']) or $skin['img_dir']==""){
		$skin['img_dir'] = 1;
	}
	$query="SELECT t.tid, t.title, t.start_date, t.last_post, t.views, t.posts, t.forum_id, p.author_name, p.author_id, p.icon_id, f.id, f.name, f.read_perms
		FROM ".$db->prefix("ipb_topics")." t, ".$db->prefix("ipb_posts")." p, ".$db->prefix("ipb_forums")." f
		WHERE f.id = t.forum_id
			AND (t.last_post = p.post_date)
			AND (t.tid = p.topic_id)
			ORDER BY ".$order." DESC";

	if (!$result = $db->query($query,$options[0],0)) {
		return false;
	}
	if ( $options[1] != 0 ) {
		$block['full_view'] = true;
	} else {
		$block['full_view'] = false;
	}
	$block['lang_forum'] = _MB_IPBOARD_FORUM;
	$block['lang_topic'] = _MB_IPBOARD_TOPIC;
	$block['lang_replies'] = _MB_IPBOARD_RPLS;
	$block['lang_views'] = _MB_IPBOARD_VIEWS;
	$block['lang_by'] = _MB_IPBOARD_BY;
	$block['lang_lastpost'] = _MB_IPBOARD_LPOST;
	$block['lang_visitforums'] = _MB_IPBOARD_VSTFRMS;

	while ($arr = $db->fetchArray($result)) {
		if ($arr['read_perms'] == '*' or (preg_match( "/(^|,)".$meminfo['mgroup']."(,|$)/", $arr['read_perms']) ) ) {
			$topic['forum_id'] = $arr['id'];
			$topic['forum_name'] = $myts->makeTboxData4Show($arr['name']);
			$topic['id'] = $arr['tid'];
			$topic['title'] = $myts->makeTboxData4Show($arr['title']);
			$topic['replies'] = $arr['posts'];
			$topic['views'] = $arr['views'];
			$topic['time'] = formatTimestamp($arr['last_post'],'m');
			$topic['sess_id'] = $sid_bb;
			$topic['last_post_name'] = $arr['author_name'];
			$topic['last_post_id'] = $arr['author_id'];
			$topic['pages'] = show_page($arr['posts'],$arr['id'],$arr['tid']);
			if ($arr['icon_id'] == 0) $arr['icon_id'] = 1;
			$topic['img_dir'] = XOOPS_URL."/modules/ipboard/style_images/".$skin['img_dir']."/icon".$arr['icon_id'].".gif";
			$block['topics'][] =& $topic;
			unset($topic);
		}
	}
   	return $block;
}

function ipboard_topics_edit($options) {
	$inputtag = "<input type='text' name='options[0]' value='".$options[0]."' />";
	$form = sprintf(_MB_IPBOARD_DISPLAY,$inputtag);
	$form .= "<br />"._MB_IPBOARD_DISPLAYF."&nbsp;<input type='radio' name='options[1]' value='1'";
	if ( $options[1] == 1 ) {
		$form .= " checked='checked'";
	}
	$form .= " />&nbsp;"._YES."<input type='radio' name='options[1]' value='0'";
	if ( $options[1] == 0 ) {
		$form .= " checked='checked'";
	}
	$form .= " />&nbsp;"._NO;
	$form .= '<input type="hidden" name="options[2]" value="'.$options[2].'">';
	return $form;
}

function show_page ($data,$f,$t)
{
	global $sid_bb;
		include ("".XOOPS_ROOT_PATH."/modules/ipboard/conf_global.php");
 		$pages = 1;

		if ( (($data + 1) % $INFO['display_max_posts']) == 0 )
		{
			$pages = ($data + 1) / $INFO['display_max_posts'];
		}
		else
		{
			$number = ( ($data + 1) / $INFO['display_max_posts'] );
			$pages = ceil( $number);
		}
		$pages_link = '';
		if ($pages > 1) {
			$pages_link = "<span style='font-size:11px; font-weight:bold; font-family:verdana,tahoma;'>("._MB_IPBOARD_PAGES." ";
			for ($i = 0 ; $i < $pages ; ++$i ) {
				$real_no = $i * $INFO['display_max_posts'];
				$page_no = $i + 1;
				if ($page_no == 4) {
					$pages_link .= "<a href='".XOOPS_URL."/modules/ipboard/index.php?s=$sid_bb&act=ST&f=$f&t=$t&st=" . ($pages - 1) * $INFO['display_max_posts'] . "'>...$pages </a>";
					break;
				} else {
					$pages_link .= "<a href='".XOOPS_URL."/modules/ipboard/index.php?s=$sid_bb&act=ST&f=$f&t=$t&st=$real_no'>$page_no </a>";
				}
			}
			$pages_link .= ")</span>";
		}
		return $pages_link;
}

function ipboard_bday_show($options) {
	global $uid_bb, $sid_bb, $meminfo;

        $db =& Database::getInstance();
        $myts =& MyTextSanitizer::getInstance();

        $block = array();

        switch($options[2]) {
        case 'ages':
                $order = 'bday_year';
                break;
        case 'name':
        default:
                $order = 'uname';
                break;
        }

		$user_time = time() + ($meminfo['timezone_offset'] * 3600 );

		$date = getdate($user_time);

		$day   = $date['mday'];
		$month = $date['mon'];
		$year  = $date['year'];

		$query = "SELECT user_avatar, uid, uname, bday_day as DAY, bday_month as MONTH, bday_year as YEAR FROM ".$db->prefix("users")."
				WHERE bday_day=$day
				AND bday_month=$month
				ORDER BY ".$order." DESC";

		if (!$result = $db->query($query,$options[0],0)) {
		        return false;
		}

		if ( $options[1] != 0 ) {
		        $block['avatar'] = true;
		} else {
		        $block['avatar'] = false;
		}
		$block['lang_mem'] = _MB_IPBOARD_BDAY_MEM;
		$block['lang_ages'] = _MB_IPBOARD_BDAY_AGES;
		$count = 0;
    while ($arr = $db->fetchArray($result)) {
				$pyear = $year - $arr['YEAR'];  // $year = 2002 and $user['YEAR'] = 1976
        $bday['name'] = $arr['uname'];
        $bday['sess_id'] = $sid_bb;
        $bday['user_link'] = XOOPS_URL."/userinfo.php?uid=".$arr['uid'];
        $bday['avatar'] = XOOPS_URL."/uploads/".$arr['user_avatar'];
        $bday['ages'] = $pyear;
        $block['bday'][] =& $bday;
        unset($bday);
        $count++;
        }
    if ($count == 0) {
				$block['no_bday'] = true;
				$block['lang_no_bday'] = _MB_IPBOARD_BDAY_NONE;
		}

    return $block;
}

function ipboard_bday_edit($options) {
        $inputtag = "<input type='text' name='options[0]' value='".$options[0]."' />";
        $form = sprintf(_MB_IPBOARD_BDAY_DISP,$inputtag);
//Option 2
        $form .= "<br />"._MB_IPBOARD_DISPLAY_AVT."&nbsp;<input type='radio' name='options[1]' value='1'";
        if ( $options[1] == 1 ) {
                $form .= " checked='checked'";
        }
        $form .= " />&nbsp;"._YES."&nbsp;<input type='radio' name='options[1]' value='0'";
        if ( $options[1] == 0 ) {
                $form .= " checked='checked'";
        }
        $form .= " />&nbsp;"._NO;
//Option 3
        $form .= "<br />"._MB_IPBOARD_BDAY_ORDER."&nbsp;<input type='radio' name='options[2]' value='name'";
        if ( $options[2] == "name" ) {
                $form .= " checked='checked'";
        }
        $form .= " />&nbsp;"._MB_IPBOARD_BDAY_ORDER_NAME."<input type='radio' name='options[2]' value='ages'";
        if ( $options[2] == "ages" ) {
                $form .= " checked='checked'";
        }
        $form .= " />&nbsp;"._MB_IPBOARD_BDAY_ORDER_AGES;

        return $form;
}

$offset_set = 0;
$offset = "";

function get_date($date, $type=0) {
    global $offset_set, $offset, $meminfo;
    
	include ("".XOOPS_ROOT_PATH."/modules/ipboard/conf_global.php");

    if (!$date)
    {
        return '--';
    }

    if ($offset_set == 0)
    {
    	// Save redoing this code for each call, only do once per page load
    	
		$offset = (($meminfo['timezone_offset'] != "") ? $meminfo['timezone_offset'] : $INFO['time_offset']) * 3600;
		
		if ($INFO['time_adjust'] != "" and $INFO['time_adjust'] != 0)
		{
			$offset += ($INFO['time_adjust'] * 60);
		}
		
		if ($meminfo['dst_in_use'])
		{
			$offset += 3600;
		}
		
		$offset_set = 1;
    }
    if ($type)
    {
    	$method = "jS F, h:i A";
    }
    else
    {
    	$method = "j M, H:i";
    }
    return gmdate($method, ($date + $offset) );
}

function ipboard_welcome_show($options) {
	global $uid_bb, $sid_bb, $meminfo;

    $db =& Database::getInstance();
    $myts =& MyTextSanitizer::getInstance();

//Topics
	$top_topic 	  = $db->fetchArray($db->query("SELECT `starter_id` AS id, `starter_name` AS name, COUNT(*) AS `num`
					FROM ".$db->prefix("ipb_topics")." WHERE starter_id > 0 GROUP BY id ORDER BY num DESC LIMIT 1"));

	$top_post 	  = $db->fetchArray($db->query("SELECT `uid`,`uname`,`posts`
					FROM ".$db->prefix("users")." WHERE 1 AND uid > 0 ORDER BY `posts` DESC LIMIT 1"));

//Last visit
	$since = $db->fetchArray($db->query("SELECT COUNT(DISTINCT(t.tid)) as topics, COUNT(DISTINCT(p.pid)) as posts
		 	 FROM ".$db->prefix("ipb_posts")." p, ".$db->prefix("ipb_topics")." t
			 WHERE p.post_date < ".time()."
			 AND p.post_date > ".$meminfo['last_visit']."
			 AND p.topic_id=t.tid"));

//Posts + time
	$stats = $db->fetchArray($db->query("SELECT * FROM ".$db->prefix("ipb_stats").""));

	$most_online = $stats['MOST_COUNT'];
	$total_posts = $stats['TOTAL_TOPICS'] + $stats['TOTAL_REPLIES'];

	$ctime = time();
	$time = get_date ($ctime,1);
	$time_s = get_date ($ctime,0);
	$lastvisit = get_date ($meminfo['last_visit'],1);
	$lastvisit_s = get_date ($meminfo['last_visit'],0);
	$most_time = get_date ($stats['MOST_DATE'],1);


	if ( $options[0] != 0 ) {
        $block['is_avatar'] = true;
	} else {
        $block['is_avatar'] = false;
	}

	if ( $options[1] != 0 ) {
		$block['full_view'] = true;
		$block['lang_now'] 		 	 = sprintf(_MB_IPBOARD_WCOME_NOW, $time);
		$block['lang_lastvisit'] 	 = sprintf(_MB_IPBOARD_WCOME_LASTVISIT, $lastvisit);
		$block['lang_new_user']	 	 = _MB_IPBOARD_WCOME_NEW_USER;
	} else {
		$block['full_view'] = false;
		$block['lang_now'] 			 = sprintf(_MB_IPBOARD_WCOME_NOW_S, $time_s);
		$block['lang_lastvisit'] 	 = sprintf(_MB_IPBOARD_WCOME_LASTVISIT_S, $lastvisit_s);
		$block['lang_new_user']	 	 = _MB_IPBOARD_WCOME_NEW_USER_S;
	}
// Language
	$block['lang_welcome']   	 = sprintf(_MB_IPBOARD_WCOME_HELLO, "&nbsp;".$meminfo['uname']);
	$block['lang_sum'] 		 	 = sprintf(_MB_IPBOARD_WCOME_SUM, $since['posts'], $since['topics']);
	$block['lang_most_online']   = sprintf(_MB_IPBOARD_WCOME_ONLINE, $most_online, $most_time);
//user lang
	$block['lang_users'] 	 	 = sprintf(_MB_IPBOARD_WCOME_USERS, $stats['MEM_COUNT']);
	$block['lang_new_uname'] 	 = $stats['LAST_MEM_NAME'];
//topic lang
	$block['lang_top_topic'] 	 = _MB_IPBOARD_WCOME_TOP_TOPIC;
	$block['lang_topics']	 	 = sprintf(_MB_IPBOARD_WCOME_TOPICS, $stats['TOTAL_TOPICS']);
	$block['lang_top_topic_uname']= $top_topic['name'];
	$block['lang_view_topics'] 	 = _MB_IPBOARD_WCOME_VIEW_TOPICS;
	$block['lang_new_topics'] 	 = _MB_IPBOARD_WCOME_NEW_TOPICS;
//post lang
	$block['lang_top_post']	 	 = _MB_IPBOARD_WCOME_TOP_POST;
	$block['lang_posts'] 	 	 = sprintf(_MB_IPBOARD_WCOME_POSTS, $total_posts);
	$block['lang_top_post_uname']= $top_post['uname'];
	$block['lang_view_posts'] 	 = _MB_IPBOARD_WCOME_VIEW_POSTS;
	$block['lang_new_posts'] 	 = _MB_IPBOARD_WCOME_NEW_POSTS;
//replies lang
	$block['lang_replies']	 	 = sprintf(_MB_IPBOARD_WCOME_REPLIES,$stats['TOTAL_REPLIES']);

// Others
    $block['vposts_link'] 		= XOOPS_URL."/modules/ipboard/index.php?s=".$sid_bb."&act=Search&CODE=getnew";
    $block['vtopics_link'] 		= XOOPS_URL."/modules/ipboard/index.php?s=".$sid_bb."&act=Search&CODE=getactive";

/*IPBM profile link
    $block['nuser_link'] 		= XOOPS_URL."/modules/ipboard/index.php?s=".$sid_bb."&act=Profile&CODE=03&MID=".$stats['LAST_MEM_ID'];
    $block['top_topic_id_link']	= XOOPS_URL."/modules/ipboard/index.php?s=".$sid_bb."&act=Profile&CODE=03&MID=".$top_topic['id'];
    $block['top_post_id_link']	= XOOPS_URL."/modules/ipboard/index.php?s=".$sid_bb."&act=Profile&CODE=03&MID=".$top_post['uid'];
*/
//XOOPS profile link
    $block['nuser_link'] 		= XOOPS_URL."/userinfo.php?uid=".$stats['LAST_MEM_ID'];
    $block['top_topic_id_link']	= XOOPS_URL."/userinfo.php?uid=".$top_topic['id'];
    $block['top_post_id_link']	= XOOPS_URL."/userinfo.php?uid=".$top_post['uid'];

    $block['new_topics']		= $since['topics'];
    $block['new_posts']			= $since['posts'];

    $block['top_topic']			= $top_topic['num'];
    $block['top_post']			= $top_post['posts'];

    if ($uid_bb)
    {
    	$block['user_link'] = XOOPS_URL."/modules/ipboard/index.php?s=$sid_bb&act=Profile&CODE=03&MID=".$uid_bb;
    	$block['avatar'] = XOOPS_URL."/uploads/".$meminfo['user_avatar'];
    }
    else
    {
    	$block['user_link'] = XOOPS_URL."/modules/ipboard/index.php";
    	$block['avatar'] = XOOPS_URL."/uploads/blank.gif";
    }

    return $block;
}

function ipboard_welcome_edit($options) {
//Option 1
        $form = ""._MB_IPBOARD_DISPLAY_AVT."&nbsp;<input type='radio' name='options[0]' value='1'";
        if ( $options[0] == 1 ) {
                $form .= " checked='checked'";
        }
        $form .= " />&nbsp;"._YES."&nbsp;<input type='radio' name='options[0]' value='0'";
        if ( $options[0] == 0 ) {
                $form .= " checked='checked'";
        }
        $form .= " />&nbsp;"._NO;
//Option 2
        $form .= "<br />"._MB_IPBOARD_DISPLAYF."&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input type='radio' name='options[1]' value='1'";
        if ( $options[1] == 1 ) {
                $form .= " checked='checked'";
        }
        $form .= " />&nbsp;"._YES."&nbsp;<input type='radio' name='options[1]' value='0'";
        if ( $options[1] == 0 ) {
                $form .= " checked='checked'";
        }
        $form .= " />&nbsp;"._NO;

        return $form;
}
?>
