<?PHP
    //
    // LMO-Spielplan
    //
    // Copyright etc. spare ich mir.
    // Bitte eMehl an mich, wer's einsetzt.
    // Fr Verbesserungsvorschlge immer offen, Script ist noch nicht perfekt.
    //
    // LMO_SPIELPLAN.PHH
    // *********
    // Funktion:
    // *********
    // Anzeige des kompletten Spielplans
    // Liga-Manager Online von Frank Hollwitz
    // http://www.hollwitz.de
    // by: Peter Scherb, 11/2002
    // Anschauen: www.peterscherb.de/svj
	// bearbeitet fr e-xoops und xoops
	// by: Hans Marx, 07/2003
	// webmaster@service.bama-webdesign.de
	//  http://www.service.bama-webdesign.de
	// webmaster@bama-webdesign.de
	//  http://www.bama-webdesign.de
    // *************
    // Beschreibung:
    // *************
    // Anzeige und Ausdruck des kompletten Spielplans mit Einstellmglichkeiten
    // (siehe Einstellungsbereich)
    //
    // ***********************************************************************************
    // Aufruf:
    // -----------------------------------------------------------------------------------
    // lmo_spielplan.php
    // Sucht im ligen-Verzeichnis nach vorhandenen Ligen
    //
    // oder
    //
    // lmo_spielplan.php?file=[Pfad_zur_Liga/Liga_File][Mannschaften](optional)
    // Bsp.: lmo_spielplan.php?file=../ligen/testliga.l98
    // Bsp.: lmo_spielplan.php?file=../ligen/testliga.l98&mann=9;1
    //
    // ******************************************************
    // Wen's interessiert, hier der Aufbau des Ergebnis-Array
    // ******************************************************
    //  [0] : Name der Liga
    //  [1] : Anzahl Mannschaften
    //  [2] : Anzahl Spieltage
    //  [3] : Spiele / Spieltag
    //  [4] : Nr. des Favoriten
    //  [5] bis [5]+[1]-1: Mannschaften
    //  [5] + [1]    : Beginn Spieltag     $spStart
    //  [5] + [1] + 1: Nr. Spieltag
    //  [5] + [1] + 2: Datum1
    //  [5] + [1] + 3: Datum2
    //  [5] + [1] + 4: Heimmannschaft   --
    //  [5] + [1] + 5: Gastmannschaft     |
    //  [5] + [1] + 6: Heimtore           |
    //  [5] + [1] + 7: Gasttore           |-- Multiplizert mit [3], $spAnzDaten
    //  [5] + [1] + 8: Notiz              |
    //  [5] + [1] + 9: Anstozeit       --
    //
    // Daraus ergibt sich die Formel fr die Berechnung eines beliebigen Spieltags:
    // 5 + [1] + (NrSpTag - 1) * (3 + (6 * [3])) : Beginn des nchsten Spieltages
    // |         |                |    |
    // |         |                |    Heim-, Gastmannsch., Heim-, Gasttore, Notiz, Anstozeit
    // |         |                Nr, Datum1, Datum2
    // |         Nr. des Spieltags
    // Anfang 1. Spieltag
    //
    // Bsp: [1] : Anzahl Mannschaften  =  9
    //      [2] : Anzahl Spieltage     = 18
    //      [3] : Spiele / Spieltag    =  4
    // 5 + 9 +  (2 - 1) * (3 + (6 *4)) =  41 : Beginn des 2. Spieltages
    // 5 + 9 + (18 - 1) * (3 + (6 *4)) = 473 : Beginn des 18. Spieltages

    // -------------------------------------------------------------------------------------------------
    // Einstellungsbereich
    $pfadLiga = "../lmo/ligen/";      // Pfad zu den Ligen (MIT / am Ende)! ...
                                      // ... relativ zum Script der dies aufruft
    $anzNotiz       = 1;              // Notiz-Anzeige: 0=nein, 1=ja
    $anzKeineTore   = "-";            // Zeichen fr keine Tore
    $anzFavorit     = 1;              // Favorit-Anzeige: 0=nein, 1=ja
    $anzVerlSpiele  = 1;              // Hervorhebung der verlegten Spiele
    $anzSpielfrei   = 1;              // Anzeige der spielfreien Mannschaften: 0=nein, 1=ja
    $colorVerlSp    = "#0000FF";      // Farbe fr Hervorhebung der verlegten Spiele
    $fontSizeNum    = 10;             // Schriftgre der Anzeige
    $spTagBackColor = "#D7D7D7";      // Hintergrundfarbe fr Spieltagshervorhebung,
                                      // #FFFFFF wenn nicht gewnscht
    // Ende Einstellungsbereich
    // -------------------------------------------------------------------------------------------------

    // ----------------------------------------------------------------------------
    // Allgemeine Variablen
    $designFile     = $PfadLMO . "lmo-style.css";
    $design         = '<link rel=stylesheet type="text/css" href="' . $designFile.'">';
    $pedSP          = "0.87a";
	$tabBreite      = 8 + $anzNotiz;
	$fontSize       = $fontSizeNum . "pt";
	$fontSizeHeader = ($fontSizeNum + 2) . "pt";
	$fontSizeCopy   = ($fontSizeNum > 10 ? 10 : $fontSizeNum - 1) . "pt";
	$arrWeekDay     = array("Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag");
    // Ende allgemeine Variablen
    // ----------------------------------------------------------------------------
    if ($file == "")
    {
        $verz = opendir(substr($pfadLiga, 0, -1));
        $arrLiga = array("");
        while($files = readdir($verz))
        {
            if(strtolower(substr($files, -4)) == ".l98")
            {
                array_push($arrLiga, $files);
            }
        }
        closedir($verz);
        array_shift($arrLiga);
        sort($arrLiga);

        // Ausgabe
    	echo $design;
        echo "<body topmargin='0' leftmargin='0'><div align='center'><center>";
        echo "<table>";
            echo "<tr>";
                echo "<th colspan=" . $tabBreite . " class=lmomain0>";
                    echo "Vorhandene Spielplne";
                echo "</th>";
            echo "</tr>";

            $noLiga = 0;
            for ($i = 0; $i < sizeof($arrLiga); $i++)
            {
                $files = $arrLiga[$i];
                $sekt = "";
                $ligaName = "";
                $actual = "";
                $datei = fopen($pfadLiga . $files, "r");
                while (!feof($datei))
                {
                    $zeile = fgets($datei, 1000);
                    $zeile = trim(chop($zeile));
                    if((substr($zeile, 0, 1)== "[") && (substr($zeile, -1) == "]"))
                    {
                        $sekt = substr($zeile, 1, -1);
                    }
                    elseif((strpos($zeile,"=")!=false) && (substr($zeile,0,1)!=";") && ($sekt=="Options"))
                    {
                        $schl = substr($zeile, 0, strpos($zeile, "="));
                        $wert = substr($zeile, strpos($zeile, "=") + 1);
                        if($schl=="Name")   { $ligaName = $wert; }
                        if($schl=="Actual") { $actual   = $wert; }
                        if($schl=="Type")   { $type     = $wert; }

                        if(($ligaName != "") && ($actual != ""))
                        {
                            break;
                        }
                    }
                }
                fclose ($datei);
                if($ligaName == "")
                {
                    $noLiga++;
                    $ligaName = "Unbenannte Liga " . $noLiga;
                }

                if($actual != "")
                {
                    $ausgabe = " / ". $actual . ". Spieltag";
                }
                else
                {
                    $ausgabe = "";
                }

                // Ausgabe
                echo "<tr>";
                    echo "<td  colspan=" . $tabBreite . " class=lmost4>";
                        echo "<ul>";
                            echo "<li><a href=\"lmo_spielplan.php?file=" . $pfadLiga . $files . "&mann=0" . "\">" . $ligaName. "<br><small>".date("d.m.Y H:i",filectime($pfadLiga.$files)).$ausgabe."</small></a></li>";
                        echo "</td>";
                    echo "</ul>";
                echo "</tr>";
            }
            // Fuzeile
            echo "<tr>";
                echo "<td class=lmomain2 colspan='8' align=center>";
                    echo "<style='font-size:2px'>";
                    echo "<a href='http://www.peterscherb.de/svj' target='_blank'>";
                    echo "Peter Scherb V " . $pedSP;
                    echo "</a> &copy; " . date("m") . "/" . date("Y") . " <a href='mailto:Peter.Scherb@PeterScherb.de'>";
                    echo "eMehl an Ped</a>";
                echo "</td>";
            echo "</tr>";
        echo "</table>";
    }
    else
    {
        $arrSP = GetSPData($file);

        // Variablen
        $spStart    = 5 + $arrSP[1];    // Ende Header
        $spAnzDaten = 6;                // Erklrung siehe oben
        $spOffset   = (3 + ($spAnzDaten * $arrSP[3]));
                                        // Erklrung siehe oben
        $verlegt    = 0;
        $designFile = $PfadLMO . "lmo-style.css";
        $design     = '<link rel=stylesheet type="text/css" href="' . $designFile.'">';
        $arrMann    = explode(";", $mann);

        // Ausgabe
        echo "<p align='center' style='font-family:Verdana,arial,helvetica;font-size:$fontSizeHeader'>";
//            echo "<strong>";
                echo $arrSP[0];
            echo "</strong><br>";
//        echo "</p>";

//        echo "<p align='center' style='font-family:Verdana,arial,helvetica;font-size:10pt'>";
        echo "<p align='center' style='font-family:Verdana;font-size:10pt'>";
            echo "<table border= '0' cellspacing='0' align='center'>";
                // Hauptschleife
                for($i = $spStart; $i < sizeof($arrSP); $i += $spOffset)
                {
                    echo "<td colspan=$tabBreite style='font-size=$fontSize;background-color=$spTagBackColor;border-top-style:solid;border-bottom-style:solid;border-width:1px;border-color:#000000';>";
//                    echo "<strong>";
                    echo $arrSP[$i] . ". Spieltag - " . $arrWeekDay[(int)date("w", DateSPToUnix($arrSP[$i + 1]))] . ", " . $arrSP[$i + 1];
                    // 2. Datum
                    if (chop($arrSP[$i + 2]) != "")
                    {
                        echo " bis " . $arrWeekDay[(int)date("w", DateSPToUnix($arrSP[$i + 2]))] . ", " . $arrSP[$i + 2];
                    }  // Ende if ... ( 2. Datum)
//                    echo "</strong>";
                    echo "</td>";
                        // Spielfrei-Template vorbelegen
                        for ($k = 1; $k <= $arrSP[1]; $k++)
                        {
                            $arrFreiTemplate[$k] = 1;
                        } // Ende for ... (Spielfrei-Template vorbelegen)

                        // Spieltagdurchlauf
                        for ($j = 0; $j < $arrSP[3]; $j++)
                        {
                            $index = $i + 2 + ($j * $spAnzDaten);
                            $arrFreiTemplate[(int)$arrSP[$index + 1]] = 0;
                            $arrFreiTemplate[(int)$arrSP[$index + 2]] = 0;
                            $flHeim   = array_seek($arrSP[$index + 1], $arrMann);
                            $flGast   = array_seek($arrSP[$index + 2], $arrMann);
                            $flVorbei = $mann != 0 && $arrSP[$index + 3] != -1;
                            $kennVorbei = "&radic;";
                            // Anzeige alle ($mann == "0")
                            if ($mann == "0" || $flHeim != -1 || $flGast != -1)
                            {
                                echo "<tr>";
                                    // Anstozeit
                                    echo "<td style='font-size=$fontSize;'>";
                                        $dummy = chop((string)date("d.m.Y", $arrSP[$index + 6])) != chop((string)$arrSP[$i + 1]) && $anzVerlSpiele == 1 && $arrSP[$index + 3] == -1 && $arrSP[$index + 4] == -1 && isVerlegtSP($arrSP[$i + 1], $arrSP[$index + 6]);
                                        if ($dummy)
                                        {
                                            echo "<font color=$colorVerlSp>";
                                            $verlegt = 1;
                                        }

                                        // Anstozeit nicht leer
                                        if (chop($arrSP[$index + 6]) != "")
                                        {
//                                            if ($flVorbei) { echo "<$kennVorbei>"; }
                                            echo date("d.m.Y H:i", $arrSP[$index + 6]);
//                                            if ($flVorbei) { echo "</$kennVorbei>"; }
                                        }
                                        else
                                        {
                                            echo "nicht bekannt";
                                        }
                                        if ($dummy)
                                        {
                                            echo "*</font>";
                                        } // Ende if ... (Anstozeit nicht leer)
                                    echo "</td>";
                                    // Heimmannschaft
                                    echo "<td style='font-size=$fontSize;'>";
                                        if ($anzFavorit && (int)$arrSP[$index + 1] == (int)$arrSP[4]) { echo "<b>"; }
//                                        if ($flVorbei) { echo "<$kennVorbei>"; }
                                        echo $arrSP[4 + $arrSP[$index + 1]];
//                                        if ($flVorbei) { echo "</$kennVorbei>"; }
                                        if ($anzFavorit && (int)$arrSP[$index + 1] == (int)$arrSP[4]) { echo "</b>"; }
                                    echo "</td>";
                                    // -
                                    echo "<td style='font-size=$fontSize;'>";
                                        echo "-";
                                    echo "</td>";
                                    // Gastmannschaft
                                    echo "<td style='font-size=$fontSize;'>";
                                        if ($anzFavorit && (int)$arrSP[$index + 2] == (int)$arrSP[4]) { echo "<b>"; }
//                                        if ($flVorbei) { echo "<$kennVorbei>"; }
                                        echo $arrSP[4 + $arrSP[$index + 2]];
//                                        if ($flVorbei) { echo "</$kennVorbei>"; }
                                        if ($anzFavorit && (int)$arrSP[$index + 2] == (int)$arrSP[4]) { echo "</b>"; }
                                    echo "</td>";
                                    if ($mann == 0 || $ergeb == 1)
                                    {
                                        // Heimtore
                                        echo "<td align='right' style='font-size=$fontSize;'>";
                                            if ($arrSP[$index + 3] != -1)
                                            {
                                                echo $arrSP[$index + 3];
                                            }
                                            else
                                            {
                                                echo $anzKeineTore;
                                            }
                                        echo "</td>";
                                        // :
                                        echo "<td style='font-size=$fontSize;'>";
                                            echo ":";
                                        echo "</td>";
                                        // Gasttore
                                        echo "<td align='left' style='font-size=$fontSize;'>";
                                            if ($arrSP[$index + 4] != -1)
                                            {
                                                echo $arrSP[$index + 4];
                                            }
                                            else
                                            {
                                                echo $anzKeineTore;
                                            }
                                        echo "</td>";
                                        // Notiz
                                        if ($anzNotiz == 1)
                                        {
                                            echo "<td style='font-size=$fontSize;'>";
                                                echo $arrSP[$index + 5];
                                            echo "</td>";
                                        } // Ende if ... (Notiz)
                                    }
                                    else
                                    {
                                        if ($flVorbei)
                                        {
                                            echo "<td>";
                                                echo "&radic;";
                                            echo "</td>";
                                        }
                                    }
                                echo "</tr>";
                            } // Ende if ... (Anzeige alle ($mann == "0"))
                        } // Ende for ... (Spieltagdurchlauf)

                        // Anzeige spielfreier Mannschaften
                        if ($anzSpielfrei == 1 || $mann != "0")
                        {
                            // Spielfrei - Schleife
                            for ($k = 1; $k <= $arrSP[1]; $k++)
                            {
                                if ($arrFreiTemplate[$k] == 1 && ($mann == "0" ? 1 : array_seek((string)$k, $arrMann) != -1))
                                {
                                    echo "<tr>";
                                        echo "<td colspan='4' style='font-size=$fontSize;'>";
                                            echo "Spielfrei: ";
                                            if ($k == (int)$arrSP[4])  { echo "<b>"; }
//                                            if ($flVorbei) { echo "<$kennVorbei>"; }
                                            echo $arrSP[4 + $k];
//                                            if ($flVorbei) { echo "</$kennVorbei>"; }
                                            if ($k == (int)$arrSP[4])  { echo "</b>"; }
                                        if ($flVorbei)
                                        {
                                            echo "<td>";
                                                echo "&radic;";
                                            echo "</td>";
                                        }
                                        echo "</td>";
                                    echo "</tr>";
                                 //   break;
                                }
                            } // Ende for ... (Spielfrei - Schleife)
                        } // Ende if ... (Anzeige spielfreier Mannschaften)
                        // Leerzeile
                        echo "<tr>";
                            echo "<td style='font-size=$fontSize;'>";
                                //echo "&nbsp;";
                            echo "</td>";
                        echo "</tr>";

                    }  // Ende for ... (Hauptschleife)

                // Anzeige verlegter Spiele ?
                if ($anzVerlSpiele == 1 && $verlegt == 1)
                {
                    echo "<tr>";
                        echo "<td style='font-size=$fontSize;'>";
                            echo "<font color=$colorVerlSp>";
                                echo "* verlegte Spiele";
                            echo "</font>";
                        echo "</td>";
                    echo "</tr>";
                } // Ende if ... (Anzeige verlegter Spiele ?)
                echo "</table>";
                // Copyrights
                echo "<br>";
                echo "<p align='center' style='font-family:Verdana,arial,helvetica;font-size:$fontSizeCopy'>";
                    echo "<a href='http://www.peterscherb.de/svj' target='_blank'>";
                    echo "LMO-Spielplan V " . $pedSP;
                    echo "</a> &copy; " . date("m") . "/" . date("Y") . " <a href='mailto:Peter.Scherb@PeterScherb.de'>";
                    echo "eMehl an Ped</a>";
                    echo "<br>";
                    echo "www.peterscherb.de/svj";
					echo "<br>";
                    echo "powered for e-xoops and xoops by <a href='http://service.bama-webdesign.de' target='_blank'>bama-webdesign.de</a> &copy; Hans Marx 07/2003";
                echo "</p>";
            echo "</p>";
    }



    // ------------------------------------------------------------------------------------------------
    function GetSPData($LigaFile)
    {
        // Datei komplett einlesen
    	$arrFile       = file($LigaFile);
        $sizeOfArrFile = sizeof($arrFile);
        $spCounter     = 5;                    // laufender Zhler des Ergebnis-Arrays
        $SpielTag      = 1;                    // laufender Zhler der Spieltage
        $arrSP         = array("", 0, 0, 0, 0);
                                               // Vorbelegung des Ergebnis-Arrays

        // "Header" einlesen
    	for ($i = 0; $i < $sizeOfArrFile; $i++)
        {
            $arrFile[$i] = chop($arrFile[$i]);
    		
    		// Name der Liga merken
    		if (GetSPKey($arrFile[$i]) == "Name")
            {
                $arrSP[0] = GetSPValue($arrFile[$i]);
            } // Ende if ... (Name der Liga merken)

    		// Art der Liga merken: 0 = Liag, 1 = KO-Turnier
    		if (GetSPKey($arrFile[$i]) == "Type")
            {
                $flType = GetSPValue($arrFile[$i]);
                if ($flType == 1)
                {
                    $arrSP[$spCounter - 1] .= " (Turnier)";
                }
            } // Ende if ... (Name der Liga merken)
    		
            // Anzahl der Mannschaften
    		if (GetSPKey($arrFile[$i]) == "Teams")
    		{
                $arrSP[1] = GetSPValue($arrFile[$i]);
            } // Ende if ... (Anzahl der Mannschaften)
            
            // Anzahl der Spieltage
    		if (GetSPKey($arrFile[$i]) == "Rounds")
    		{
                $arrSP[2] = GetSPValue($arrFile[$i]);
            }
            // Ende if ... (Anzahl der Spieltage)
            
            // Anzahl der Begegnungen / Spieltage
    		if (GetSPKey($arrFile[$i]) == "Matches")
    		{
                $arrSP[3] = GetSPValue($arrFile[$i]);
            }
            // Ende if ... (Anzahl Begegnungen / Spieltage)

            // favTeam merken
    		if (GetSPKey($arrFile[$i]) == "favTeam")
    		{
                $arrSP[4] = GetSPValue($arrFile[$i]);
            } // Ende if ... (favTeam merken)

            // Teams einlesen
            if ($arrFile[$i] == "[Teams]")
            {
                $i++;
                for ($j = 1; $j <= $arrSP[1]; $j++)
                {
                    $arrSP[$spCounter++] = GetSPValue($arrFile[$i++]);
                }
            } // Ende if ... (Teams einlesen)

    		// hat die Spieltag-Sektion erreicht -> raus
            if ($arrFile[$i] == "[Round1]")
            {
                break;
            } // Ende if ... (hat die Spieltag-Sektion erreicht -> raus)

        } // Ende for ... ("Header" einlesen)

        $counAT = 1;            // Anzahl der Spiele/Spieltag bei Turnieren
        $flLeer = false;
        // Schleife Spieltage
        for ($spTag = $i; $spTag < $sizeOfArrFile; $spTag++)
        {
    		// Nchste Runde erreicht ?
			if (substr($arrFile[$spTag], 0, 6) == "[Round")
            {
                // Nur bei Turnieren
                if ($flType == 1)
                {
                    if ($countAT > $arSP[3])
                    {
                        $arrSP[3] = $countAT;
                    }
                    $counAT = 1;            // Anzahl der Spiele/Spieltag bei Turnieren
                } // Ende if ... (Nur bei Turnieren)

                // Ist das Datum leer -> nicht eintragen
        		$value = substr($arrFile[$spTag + 1], strpos($arrFile[$spTag + 1], "=") + 1);
                if (chop($value) != "")
                {
				    $flLeer = false;
				    $arrSP[$spCounter++] = $SpielTag++;
        			$spTag++;
     			}
     			else
     			{
     			    $flLeer = true;
                }
			} // Ende if ... (Nchste Runde erreicht ?)

            // Schlel
    		$key = substr($arrFile[$spTag], 0, 2);
    		// Wert
    		$value = substr($arrFile[$spTag], strpos($arrFile[$spTag], "=") + 1);

            // Keys, die bersprungen werden
			if (!(strpos($arrFile[$spTag], "=") == 0 || $key == "HS" || $key == "MO" || $key == "ET" || $key == "SP" || $key == "BE" || $key == "TI"))
			{
                if (!$flLeer)
                {
                    $arrSP[$spCounter++] = chop($value);
                    // Nur bei Turnieren
                    if ($flType == 1)
                    {
                        // $countAT bei $key="AT" hochzhlen
                        if ($key == "AT")
                        {
                            $countAT++;
                        } // Ende if ... ($countAT bei $key="AT" hochzhlen)
                    } // Ende if ... (Nur bei Turnieren)
                } // Ende if ... (Leere Spieltage berspringen)
            } // Ende if ... (Keys, die bersprungen werden)

        } // Ende for ... (Schleife Spieltage)
        
        return $arrSP;
    }


    function GetSPKey($xVar)
    {
        return (substr($xVar, 0, strpos($xVar, "=")));
    }


    function GetSPValue($xVar)
    {
        return (substr($xVar, strpos($xVar, "=") + 1));
    }
    
    function DateSPToUnix($dateString)
    {
        $arr = explode(".", $dateString);
        return mktime(0, 0, 0, $arr[1], $arr[0], $arr[2]);
    }


    // Checkt, ob Spielverlegt wurde, Algorithmus aus lmo_spieleverlegung.php
    function isVerlegtSP($dateString, $anStZeit)
    {
        // $dateString zerlegen und umwandeln
        $arrDate    = explode(".", chop($dateString));
        $arrGetDate = getdate(mktime(0, 0, 0, $arrDate[1], $arrDate[0], $arrDate[2]));
        // Kalenderwoche von $dateString
        $week1 = strftime("%W", mktime(0, 0, 0, $arrDate[1], $arrDate[0], $arrDate[2]));
        // Wochentag von $dateString
        $weekDay1 = $arrGetDate[wday];
        // Woche des AT-Datums
        $week2 = strftime("%W", $anStZeit);
        // Wochentag des AT-Datums
        $weekDay2 = date("w", $anStZeit);

        $flVerlegt = false;
        if (chop($dateString) != (string)chop(date("d.m.Y", $anStZeit)))
        {
            if ($week1 != $week2)
            {
                $flVerlegt = true;
            }
            else if ($week1 == $week2)
            {
                if (($weekDay1 >= 5 || $weekDay1 == 0) && $weekDay2 < 5 && $weekDay2 !=0)
                {
                    $flVerlegt = true;
                }
                else if ($weekDay1 < 5 &&  $weekDay1 !=0)
                {
                    $flVerlegt = true;
                }
            }
        }
        return $flVerlegt;
    }


    function array_seek($item, $arr)
    {
        for ($i = 0; $i < sizeof($arr); $i++)
        {
            if ($item == $arr[$i])
            {
                return $i;
            }
        }
        return -1;
    }
?>