<?php

/***************************************************************************
 *
 *   GoogleStats
 *
 * Author:   Olivier Duffez, WebRankInfo ( http://www.webrankinfo.com )
 * Version:  2.0
 * Date:     2003-02-23
 * Homepage: http://www.googlestats.com    
 *
 ***************************************************************************/

include("../../mainfile.php");
include(XOOPS_ROOT_PATH."/modules/googlestats/cache/config.php");
global $xoopsDB; 

function debug1($x)
{
//  echo "|$x|<br>";
}

function sendErrorMySQL($sql)
{
  global $ADRESSE_EMAIL, $LANG;

  if ($SEND_ERROR_MYSQL == 'y')
  {
    @mail($ADRESSE_EMAIL, $LANG["MySQLErrorSubject"],
      $LANG["MySQLErrorBody1"].$sql."\n".$LANG["MySQLErrorBody2"],
      "From: $ADRESSE_EMAIL");
  }
}

// pour compatibilit avec les anciennes versions de PHP
if (!isset($_SERVER))
  $_SERVER = $HTTP_SERVER_VARS;

// pour chaque robot (sauf ceux qui sont dsactivs)
$sql  = "SELECT *";
$sql .= " FROM ".$xoopsDB->prefix("gs_robots");
$sql .= " WHERE actif=1";
$res  = $xoopsDB->query($sql) or sendErrorMySQL($sql);

while ($enr = $xoopsDB->FetchArray($res))
{
  // par defaut le robot n'est pas dtect
  $detecte = false;

  // selon le mode de dtection du robot :
  if ($enr["detection"] == $DETECTION_USER_AGENT)
  {
    // on dtecte le robot en regardant son User Agent
    $pos = strpos(strtolower($_SERVER["HTTP_USER_AGENT"]), strtolower($enr["user_agent"]));
//    $detecte = (is_string($pos) && !$pos));
    $detecte = ($pos !== false);
//echo "|".$enr["nom"]."|".$_SERVER["HTTP_USER_AGENT"]."|".$enr["user_agent"]."|".$pos."|".$detecte."|<br>";
  }
  else if ($enr["detection"] == $DETECTION_IP)
  {
    // on dtecte le robot par son adresse IP
    if ( ($enr["ip1"] != "") && ($enr["ip2"] != "") )
      $detecte = ( (strpos($_SERVER["REMOTE_ADDR"], $enr["ip1"]) !== false) ||
                   (strpos($_SERVER["REMOTE_ADDR"], $enr["ip2"]) !== false) );
  }

  // si le robot a t dtect, on enregistre sa visite
  if ($detecte)
  {
    // date, adresse IP du robot et nom de domaine
    $robot_ = $enr["id"];
    $date_  = date("Y-m-d H:i");
    $ip_    = $_SERVER["REMOTE_ADDR"];
    $dns_   = @gethostbyaddr($ip_);

    // rcupration de l'URL (situe aprs le nom de domaine)
    if ($URL_REWRITING == 'y')
    {
      $url_ = $_SERVER['REQUEST_URI'];
    }
    else
    {
      $url_ = $_SERVER["SCRIPT_NAME"];
      if ($_SERVER["QUERY_STRING"] != "")
        $url_ .= "?".$_SERVER["QUERY_STRING"];
    }

    // requete MySQL d'insertion de la visite
    $sql2  = "INSERT INTO ".$xoopsDB->prefix("gs_log");
    $sql2 .= " (robot, url, date, ip, dns) VALUES ('$robot_', '$url_', '$date_', '$ip_', '$dns_')";
    $res2  = $xoopsDB->query($sql2) or sendErrorMySQL($sql2);

    // test du debut du Full Crawl
    if ($TEST_FULL_CRAWL == 'y')
    {
      // si le robot est le GoogleBot Full Crawl
      if ( strpos($_SERVER["REMOTE_ADDR"], $FULL_CRAWL_IP) !== false )
      {
        // on va chercher s'il est dj venu dans les $NB_J_DET_FULL_CRAWL
        // derniers jours
        $sql3  = "SELECT id";
        $sql3 .= " FROM ".$xoopsDB->prefix("gs_log");
        $sql3 .= " WHERE ip LIKE '".$FULL_CRAWL_IP."%')";
        $sql3 .= " AND TO_DAYS(NOW()) - TO_DAYS(date)) < $NB_J_DET_FULL_CRAWL";
        $res3  = $xoopsDB->query($sql3) or sendErrorMySQL($sql3);

        // si la requete n'a donn aucun rsultat, c'est sans doute le
        // dbut du Full Crawl : on envoie un mail
        if ($xoopsDB->getRowsNum($res3) == 0)
        {
          @mail($ADRESSE_EMAIL,
            $LANG["FullCrawlBeginSubject"],
            $LANG["FullCrawlBeginBody"],
            "From: $ADRESSE_EMAIL");
        }
      }

    } // fin du test sur le Full Crawl

  } // fin du cas o un robot a t dtect

} // fin de la boucle sur les robots

?>