<?php
// -------------------------------------------------------------------------
//           Quote for Xoops v1.00
//        Module for
//      XOOPS V2 - PHP Content Management System
//       <http://www.xoops.org/>
// -------------------------------------------------------------------------
// Author: Eric Houze
// Purpose: Module to display the quote of the day into Xoops V2.
// email: eric.houze@free.fr
// Site: http://eric.houze.free.fr
// -------------------------------------------------------------------------
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
// -------------------------------------------------------------------------

function q4x_getToDayID(){
// Return the ID of the quote of the day
	global $xoopsDB;

	$todayID=0; // Init
	// Get the actual time stamp
	$tsnow=strtotime("now");
	// Compute the time stamp of today for 0 hours 0 minutes 0 seconds
   $today = getdate($tsnow);
   $m = $today['mon'];
   $d = $today['mday'];
   $y = $today['year'];
	$tsday=mktime (0,0,0,$m,$d,$y);
   //query Database (returns an array)
   $result = $xoopsDB->queryF("SELECT id FROM ".$xoopsDB->prefix()."_quote4xoops WHERE showed=".$tsday."",1);
	$q4x_item=$xoopsDB->fetchArray($result);
   //$id found?
   if( isset($q4x_item['id']) && $q4x_item['id'] != "0" ){
		$todayID=$q4x_item['id'];    	
	}
	else {
	   // All quotes are already been showed ?
		$max=0;
		$result = $xoopsDB->queryF("SELECT count(id) as tot FROM ".$xoopsDB->prefix()."_quote4xoops WHERE showed=0",1);
	  	$q4x_item=$xoopsDB->fetchArray($result);
     	if( isset($q4x_item['tot']) && $q4x_item['tot'] != "0" ){
     		$max=$q4x_item['tot'];    	
   	}
		else {
		   // if all quotes have been showed, reinit
         $q = "UPDATE ".$xoopsDB->prefix()."_quote4xoops SET showed=0";
         $res=$xoopsDB->queryF($q);
			
			$result = $xoopsDB->queryF("SELECT count(id) as tot FROM ".$xoopsDB->prefix()."_quote4xoops WHERE showed=0",1);
  			$q4x_item=$xoopsDB->fetchArray($result);
	     	if (isset($q4x_item['tot']) && $q4x_item['tot'] != "0" ){
  				$max=$q4x_item['tot'];    	
         }
		}
		// Take  random unshowedquote
		// get  random number into all unshowed quote
		srand((float) microtime()*1000000);
      $randval = rand(0,$max);
		// Get the corresponding ID
	   $result = $xoopsDB->queryF("SELECT id FROM ".$xoopsDB->prefix()."_quote4xoops WHERE showed=0",1,$randval);
		$q4x_item=$xoopsDB->fetchArray($result);
     	if (isset($q4x_item['id']) && $q4x_item['id'] != "0" ){
     		$todayID=$q4x_item['id'];
			// update the selected quote
			// set showed at todays timestamp;    	
         $q = "UPDATE ".$xoopsDB->prefix()."_quote4xoops SET showed=".$tsday." WHERE id=".$todayID."";
         $res=$xoopsDB->queryF($q);
   	}
	}
//   $q4x_quote=q4x_getQuoteOfTheDay($todayID);
	return $todayID;
}

function q4x_getRandomID(){
// Return a random ID of a quote
	global $xoopsDB;
	$randomID=0;
	$max=0;
	$result = $xoopsDB->queryF("SELECT count(id) as tot FROM ".$xoopsDB->prefix()."_quote4xoops WHERE showed=0",1);
	$q4x_item=$xoopsDB->fetchArray($result);
  	if (isset($q4x_item['tot']) && $q4x_item['tot'] != "0" ){
		$max=$q4x_item['tot'];    	
   }	
	// Take random 
	// get  random number into quote
	srand((float) microtime()*1000000);
   $randval = rand(0,$max);
   // Get the corresponding ID
	$result = $xoopsDB->queryF("SELECT id FROM ".$xoopsDB->prefix()."_quote4xoops WHERE showed=0",1,$randval);
	$q4x_item=$xoopsDB->fetchArray($result);
   if (isset($q4x_item['id']) && $q4x_item['id'] != "0" ){
   	$randomID=$q4x_item['id'];	
   }
	return $randomID;
}

function q4x_getQuoteOfTheDay($id,$author,$quote) {
// Return the quote of the day corresponding of $id
// When return $author conains the author of the quote
// and $quote contains the quote
  global $xoopsDB;

  // init var
  $quote=_Q4X_QUOTENOTFOUND;
  $author="";
  
  $result = $xoopsDB->queryF("SELECT author,quote FROM ".$xoopsDB->prefix()."_quote4xoops WHERE id=".$id."",1);
  $q4x_quote=$xoopsDB->fetchArray($result);
  if( isset($q4x_quote['author']) && $q4x_quote['author'] != "" ){
      $myts =& MyTextSanitizer::getInstance();		
		$author=$myts->makeTboxData4Show($q4x_quote['author']);
		$quote=$myts->makeTboxData4Show($q4x_quote['quote']);
	}
}

?>