<?php
// $Id: treemenuxl.php,v 1.9 2003/03/12 21:51:37 ruby Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
// Author: Ruby Willemsen (AKA dAWiLbY)                                      //
// URL: http://www.winkie.nl/, http://hcw.winterswijk.org/                   //
// Project: The XOOPS Project                                                //
// ------------------------------------------------------------------------- //
	function b_show_treemenuxl($options)
  {
    include_once(XOOPS_ROOT_PATH."/modules/treemenuxl/include/treemenuxl.php");

    global $xoopsUser,$xoopsModule;

    $block = array();

    $block['tree_root'] = new HTML_TreeMenuXL();
    $block['homepage']  = array("icon"=>"homepage.gif");
    $block['folder']    = array("icon"=>"folder.gif");
    $block['document']  = array("icon"=>"document.gif");
    $block['admin']     = array("icon"=>"editicon.gif");

    $block['tree_start'] = new HTML_TreeNodeXL(_TM_HOME, XOOPS_URL.'/index.php', $block['homepage']);
    $block['tree_root']->addItem($block['tree_start']);

    $module_handler =& xoops_gethandler('module');
    $criteria = new CriteriaCompo(new Criteria('hasmain', 1));
    $criteria->add(new Criteria('isactive', 1));
    $criteria->add(new Criteria('weight', 0, '>'));
    $modules =& $module_handler->getObjects($criteria, true);
    $moduleperm_handler =& xoops_gethandler('groupperm');
    $groups = is_object($xoopsUser) ? $xoopsUser->getGroups() : XOOPS_GROUP_ANONYMOUS;
    $read_allowed =& $moduleperm_handler->getItemIds('module_read', $groups);
    foreach (array_keys($modules) as $i) {
      if (in_array($modules[$i]->getVar('mid'), $read_allowed)) {
        $block['tree_link'][$i] = new HTML_TreeNodeXL($modules[$i]->getVar('name'), XOOPS_URL.'/modules/'.$modules[$i]->getVar('dirname'), $block['folder']);
        $sublinks =& $modules[$i]->subLink();
//        if (count($sublinks) > 0) { // Use this if statement to show all the links.
        if ((count($sublinks) > 0) && (isset($xoopsModule)) && ($i == $xoopsModule->getVar('mid'))) {
          foreach($sublinks as $sublink) {
            $block['tree_link'][$i]->addItem(new HTML_TreeNodeXL($sublink['name'], XOOPS_URL.'/modules/'.$modules[$i]->getVar('dirname').'/'.$sublink['url'], $block['document']));
          }
        } else {
          $block['modules'][$i]['sublinks'] = array();
        }
        $block['tree_root']->addItem($block['tree_link'][$i]);
      }
    }
    $block['treemenuxl'] = &new HTML_TreeMenu_DHTMLXL($block['tree_root'], array("images"=>XOOPS_URL."/modules/treemenuxl/images/".$options[0].""));
    $block['treemenuxl'] = $block['treemenuxl']->toHTML();
    return $block;
  }

  function b_edit_treemenuxl($options)
  {
    $form  = "<table style=\"border: 1px outset;\" cellspacing=\"3\" cellpadding=\"1\">";
    $form .= "<tr><td colspan=\"3\"align=\"center\"><b><i>TreemenuXL for Xoops</i></b></td></tr>";
    if ($options[0]=="explorer") {$checked = " checked='checked'";} else {$checked = "";}
    $form .= "<tr><td align=\"right\">"._TM_EXPLORER."</td><td><input type=\"radio\" name=\"options[0]\" value=\"explorer\"".$checked." /></td></tr>";
    if ($options[0]=="extra") {$checked = " checked='checked'";} else {$checked = "";}
    $form .= "<tr><td align=\"right\">"._TM_EXTRA."</td><td><input type=\"radio\" name=\"options[0]\" value=\"extra\"".$checked." /></td></tr>";
    if ($options[0]=="round") {$checked = " checked='checked'";} else {$checked = "";}
    $form .= "<tr><td align=\"right\">"._TM_ROUND."</td><td><input type=\"radio\" name=\"options[0]\" value=\"round\"".$checked." /></td></tr>";
    if ($options[0]=="small") {$checked = " checked='checked'";} else {$checked = "";}
    $form .= "<tr><td align=\"right\">"._TM_SMALL."</td><td><input type=\"radio\" name=\"options[0]\" value=\"small\"".$checked." /></td></tr>";
    if ($options[0]=="standard") {$checked = " checked='checked'";} else {$checked = "";}
    $form .= "<tr><td align=\"right\">"._TM_STANDARD."</td><td><input type=\"radio\" name=\"options[0]\" value=\"standard\"".$checked." /></td></tr>";
    $form .= "<tr><td colspan=\"3\"align=\"center\"><b><i><font color=\"red\">"._TM_SHOWADMIN."</font></i></b></td></tr>";
/* Temporarely disabled...
    if ($options[1]=="yes") {$checked = " checked='checked'";} else {$checked = "";}
    $form .= "<tr><td align=\"right\">"._TM_YES."</td><td><input type=\"radio\" name=\"options[1]\" value=\"yes\"".$checked." /></td></tr>";
    if ($options[1]=="no") {$checked = " checked='checked'";} else {$checked = "";}
    $form .= "<tr><td align=\"right\">"._TM_NO."</td><td><input type=\"radio\" name=\"options[1]\" value=\"no\"".$checked." /></td></tr>";
    $form .= "</table>";
*/
    return $form;
  }
?>