#!/usr/bin/env python

from selenium import webdriver
import argparse
import time
import os

# set up for url input from command line argument
parser = argparse.ArgumentParser(description='Web Crawler for 國史館')
parser.add_argument('url', metavar='url', type=str, 
                    help='the url of the first page of one book')

current_url = next_url = parser.parse_args().url

# specify download path
chromeOptions = webdriver.ChromeOptions()
# prefs = {"download.default_directory" : "/Users/Administrator/Downloads"}
# chromeOptions.add_experimental_option("prefs",prefs)

# open up chrome
driver = webdriver.Chrome(chrome_options=chromeOptions)
driver.get(current_url)

# loop until get total page
total_page = None
while not total_page:
	total_page = driver.find_element_by_id("img_num").text
total_page = int(total_page)


for page in range(total_page):
    time.sleep(5)
    print('downloading page {}/{}'.format(page+1, total_page))
    # click download button
    driver.find_element_by_css_selector("#act_image_saved").click()
    
    # click next page button, if still on same page, reclick  
    while current_url == next_url:
    	# break if last page
    	if page == total_page - 1:
    		break
    	driver.find_element_by_css_selector("#onimg_dw").click()
    	next_url = driver.current_url

    current_url = next_url


# give last file 10 sec to wrap up download process
time.sleep(10)
driver.close()
