@echo off
rem cwpdf.bat/cwps.bat/cwpdf-tw.bat/cwps-tw.bat
rem
rem   2013.3:  generating cwrun.chk for debugging
rem   2013.2:  cwpdf-tw and cwps-tw supports both TeXworks and TeXstudio
rem   2012.10: bug fixes
rem   2012.08: bug fixes: synctex for .tex
rem   2012.05: bug fixes + handing biblatex2.0 and biber 1.0
rem            add option for preview
rem   2011.11: bug fixes;
rem            cwbibtex.exe (not file extension, version 3.3 )
rem            use %1.synctex instead of %1.synctex.gz
rem   2011.07: handle both c:\xtemp\ and c:/xtemp/ (32 bit vs 64 bit?)
rem   2011.06: Sumatrapdf 1.6 can display .ps, so no more GSview
rem   2011.06: set cwsys and gst via gst.bat
rem   2011.05: 7z ver. 9.20
rem   2011.05: bug fix for index generating
rem   2011.02: new version for Winedt forward search, and fix bug for cwbiblatex
rem   2010.09: bug fixed for runpspdf
rem   2010.05: Some computer system does not allow to write to c:\ or d:\
rem   2010.05: search for current directory and all the sub-directory
rem   2010.05: support mylatexformat, and also drive for xtemp disk (for ramdisk)
rem   2010.04: add synctex option to texify and bug fixes
rem   2010.03: Support cwbiblatex with biber and bibtex8
rem   2010.01: Generalized for cwps and cwpdf
rem            Introduce sumatraPDF and synctex
rem            Now use the current directory as the working directory
rem            search currcd, currcd\graph, one-up, and one-up\graph.
rem            Using \graphicspath{{graph/}} is inefficient.
rem   2009.9:  Add support for cwbiblatex
rem   2008.12: fix bugs and add cwidx.bat
rem   2008.7:  vista does not read autoexec.bat!
rem   2008.3:  simplified and check toc
rem   2007.12: set texinputs and bibinputs in the beginning
rem   2007.9:  Win64
rem   2007.6:  check if .bib is in the current directory
rem            use gsar to search/replace
rem
chcp 950

rem set gsv=1           if you want to view .ps output
rem set runonce=1       if you just want to run latex/pdflatex once, otherwise =0
rem set texworks=1      if used in texwork, also rename as cwps-tw.bat
rem                     texwokrs=1 means processing .pdf in the current directory
rem set previwer=0      if not preview, good for batch job
rem set cwver=4         for cwtex4, cwver= for cwtex34

set xdrv=C
set runonce=0
set previewer=1
set texworks=1
set gsv=0
rem set tps=latex
rem set tps=xelatex
set tps=pdflatex
set cwver=

rem NB. batch file has to use double quotes around filename,
rem     eg., cwpdf.bat "ab c"
rem     However, this trick does not work under WinEdt (2013.3.13)
rem
set cwfile=%1

rem search for cwtex system and ghostscript path,
rem   and generating cwrun.chk

call gst.bat

if not exist %xdrv%:\xtemp\nul md %xdrv%:\xtemp

rem %curd% is current directory
if exist setcdr.bat del setcdr.bat
echo set curd=>setcdr.bat
cd>>setcdr.bat
gsar -s:x3d:x0d:x0a -r:x3d -o setcdr.bat
call setcdr.bat

copy cwrun.chk+setcdr.bat cwrun.chk
del setcdr.bat

if exist %xdrv%:\xtemp\setcwpath.bat del %xdrv%:\xtemp\setcwpath.bat
echo SET TEXINPUTS=%%TEXINPUTS%%;%%curd%%>%xdrv%:\xtemp\setcwpath.bat
dir /ad/b>>%xdrv%:\xtemp\setcwpath.bat
echo xxx>>%xdrv%:\xtemp\setcwpath.bat
gsar -s:x0d:x0a -r;:x0d:x0a -o %xdrv%:\xtemp\setcwpath.bat
gsar -s;:x0d:x0axxx; -r:x0d:x0aSET:x20BIBINPUTS:x3d:x25BIBINPUTS:x25;:x25curd:x25 -o %xdrv%:\xtemp\setcwpath.bat
gsar -s;:x0d:x0a -r:x0d:x0aSET:x20TEXINPUTS:x3D:x25TEXINPUTS:x25;:x25curd:x25:x5c -o %xdrv%:\xtemp\setcwpath.bat
gsar -s:x0d:x0a -r;:x0d:x0a -o %xdrv%:\xtemp\setcwpath.bat

move cwrun.chk %xdrv%:\xtemp\cwrun.chk

if exist currdir.bat del currdir.bat
echo cd /d>currdir.bat
cd>>currdir.bat
gsar -sd:x0d:x0a -rd:x20 -o currdir.bat

move /y currdir.bat %xdrv%:\xtemp\
call %xdrv%:\xtemp\setcwpath.bat

:start
rem checking SumatraPDF.exe
rem
set SMT="%cwsys%:\Program Files\SumatraPDF\SumatraPDF.exe"
if exist %SMT% goto begin
set SMT="%cwsys%:\Program Files (x86)\SumatraPDF\SumatraPDF.exe"
if not exist %SMT% goto nosmt

:begin
rem check if %xdrv%:\xtemp is the current directory
if exist ctx.xtc del ctx.xtc
echo test>%xdrv%:\xtemp\ctx.xtc
if exist ctx.xtc echo current directory is %xdrv%:\xtemp>>%xdrv%:\xtemp\cwrun.chk
if exist ctx.xtc goto xtemp

rem Check file name with .tex extension (ie., no Chinese characters.)
if not exist %cwfile%.ctx if exist %cwfile%.tex echo file name: %cwfile%.tex>>%xdrv%:\xtemp\cwrun.chk
if not exist %cwfile%.ctx if exist %cwfile%.tex goto latex

echo file name: "%cwfile%.ctx">>%xdrv%:\xtemp\cwrun.chk

cwtex%cwver% -c -+ -d=%xdrv%:\xtemp %cwfile%.ctx
rem cwtex%cwver% -c -d=%xdrv%:\xtemp %cwfile%.ctx
if exist %cwfile%.tex move %cwfile%.tex %cwfile%_ori.tex
if exist cinput.tex move cinput.tex cinput_ori.tex
if exist %cwfile%.fmt if not exist %xdrv%:\xtemp\%cwfile%.fmt copy %cwfile%.fmt %xdrv%:\xtemp\%cwfile%.fmt
if exist %cwfile%.fmt gsar -s:x5cinput:x20cinput -r:x25:x26:x22"%cwfile%":x22:x20:x5cinput:x20cinput -o %xdrv%:\xtemp\%cwfile%.tex
rem %tps% -synctex=1 -enable-write18 -font-mem-size=2500000 -include-directory=%xdrv%:\xtemp -output-directory=%xdrv%:\xtemp %cwfile%.tex
%tps% -synctex=1 -enable-write18 -stack-size=10000 -include-directory=%xdrv%:\xtemp -output-directory=%xdrv%:\xtemp %cwfile%.tex
if exist %cwfile%_ori.tex move %cwfile%_ori.tex %cwfile%.tex
if exist cinput_ori.tex move cinput_ori.tex cinput.tex

rem check if cwbibtex or cwbiblatex is needed, if yes move file.ctx to %xdrv%:\xtemp
rem for biblatex, there will be a file %cwfile%-blx.bib
rem for biblatex with biber, there will be a file %cwfile%.bcf; cwbiblatex can handle both case
rem   requires cwbibtex29.exe
rem cwbibtex/cwbiblatex has to be run in the current directory because
rem .bib maybe in the current directory, and also the main .ctx may input other .ctx
rem grep ERRORLEVEL 0 if found; ERRORLEVEL 1 if not found
rem ERRORLEVEL 1 means equal to or greater than 1
rem
rem The warning message from bibtex+natbib contains "undefined citations";
rem The message from biblatex is "undefined references", also %cwfile%-blx.bib is generated
rem "undefined references" also occurs with \label and \ref commands
rem
rem    grep produce 0 if found; 1 if not found
rem

grep -c -q "undefined citations" %xdrv%:\xtemp\%cwfile%.log
IF %ERRORLEVEL% EQU 0 goto bibtex

grep -c -q "undefined references" %xdrv%:\xtemp\%cwfile%.log
IF %ERRORLEVEL% EQU 1 goto cwidx

if exist %xdrv%:\xtemp\%cwfile%-blx.bib goto biblatex
if exist %xdrv%:\xtemp\%cwfile%.bcf goto biblatex
goto cwidx

:bibtex
copy %cwfile%.ctx %xdrv%:\xtemp
cd /d %xdrv%:\xtemp

rem requires cwtex4 (??)
rem
cwbibtex%cwver%.exe -s2 -n %cwfile%

rem if %runonce%==1 goto cwidx
%tps% -synctex=1 -enable-write18 -stack-size=10000 -font-mem-size=2500000 %cwfile%.tex
%tps% -synctex=1 -enable-write18 -stack-size=10000 -font-mem-size=2500000 %cwfile%.tex
goto cwidx

:biblatex
copy %cwfile%.ctx %xdrv%:\xtemp
cd /d %xdrv%:\xtemp

grep -c -q "(re)run BibTeX" %xdrv%:\xtemp\%cwfile%.log
IF %ERRORLEVEL% EQU 1 grep -c -q "(re)run Biber" %xdrv%:\xtemp\%cwfile%.log
IF %ERRORLEVEL% EQU 1 goto cwidx

cwbiblatex%cwver%.exe %cwfile%

rem if %runonce%==1 goto cwidx
%tps% -synctex=1 -enable-write18 -stack-size=10000 -font-mem-size=2500000 %cwfile%.tex
%tps% -synctex=1 -enable-write18 -stack-size=10000 -font-mem-size=2500000 %cwfile%.tex
goto cwidx

:cwidx
cd /d %xdrv%:\xtemp
if not exist %cwfile%.idx if not exist %cwfile%.ind goto preview
fc %cwfile%.idx %cwfile%_bak.idx

call cwidx%cwver%.bat %cwfile%
copy %cwfile%.idx %cwfile%_bak.idx
IF %ERRORLEVEL% EQU 0 goto preview
%tps% -synctex=1 -enable-write18 -stack-size=10000 -font-mem-size=2500000  %cwfile%.tex
goto preview

:latex
copy %cwfile%.tex %xdrv%:\xtemp
cd /d %xdrv%:\xtemp
if %tps%==latex texify --tex-option=--synctex="1" --tex-option=--enable-write18 %cwfile%.tex
if %tps%==pdflatex texify -p --tex-option=--synctex="1" --tex-option=--enable-write18 %cwfile%.tex
goto preview

rem
rem The case that file.ctx or file.tex is in %xdrv%:\xtemp
rem

:xtemp
if not exist %cwfile%.ctx if exist %cwfile%.tex goto xlatex
rem cwtex%cwver% -c -+ %cwfile%.ctx
cwtex%cwver% -c %cwfile%.ctx
if exist %cwfile%.fmt gsar -s:x5cinput:x20cinput -r:x25:x26:x22"%cwfile%":x22:x20:x5cinput:x20cinput -o %xdrv%:\xtemp\%cwfile%.tex
%tps% -synctex=1 -enable-write18 -stack-size=10000 -font-mem-size=2500000 %cwfile%.tex


grep -c -q "undefined references" %xdrv%:\xtemp\%cwfile%.log

IF %ERRORLEVEL% EQU 1 goto xcwidx
if exist %cwfile%-blx.bib goto xbiblatex
if exist %cwfile%.bcf goto xbiblatex

rem requires cwtex34 (??)
rem
cwbibtex%cwver%.exe -s2 -n %cwfile%

rem if %runonce%==1 goto xcwidx
%tps% -synctex=1 -enable-write18 -stack-size=10000 -font-mem-size=2500000 %cwfile%.tex
%tps% -synctex=1 -enable-write18 -stack-size=10000 -font-mem-size=2500000 %cwfile%.tex
goto xcwidx

:xbiblatex
cwbiblatex%cwver%.exe %cwfile%

rem if %runonce%==1 goto xcwidx
%tps% -synctex=1 -enable-write18 -stack-size=10000 -font-mem-size=2500000 %cwfile%.tex
goto xcwidx

:xrunlatex
:xcwidx
if not exist %cwfile%.idx goto preview
grep -c -q "No file "%cwfile%".ind" %cwfile%.log
IF %ERRORLEVEL% NEQ 0 goto xcwidx
call cwidx%cwver%.bat %cwfile%

rem after index is generated, we need two runs for TOC
if %runonce%==1 goto preview
%tps% -synctex=1 -enable-write18 -stack-size=10000 -font-mem-size=2500000 %cwfile%.tex
%tps% -synctex=1 -enable-write18 -stack-size=10000 -font-mem-size=2500000 %cwfile%.tex
goto preview

:xlatex
if %tps%==latex texify --tex-option=--synctex="1" --tex-option=--enable-write18 %cwfile%.tex
if %tps%==pdflatex texify -p --tex-option=--synctex="1" --tex-option=--enable-write18 %cwfile%.tex

:preview
rem check is there is TOC, if yes, maybe re-run one more time
rem    grep produce 0 if found; 1 if not found
rem
grep -c -q "No file %cwfile%.toc" %xdrv%:\xtemp\%cwfile%.log
IF %ERRORLEVEL% EQU 0 %tps% -synctex=1 -enable-write18 -stack-size=10000 -font-mem-size=2500000 %cwfile%.tex

rem Finally check if need there are still undefined references
rem
grep -c -q "undefined references" %xdrv%:\xtemp\%cwfile%.log
IF %ERRORLEVEL% EQU 0 %tps% -synctex=1 -enable-write18 -stack-size=10000 -font-mem-size=2500000 %cwfile%.tex

if %previewer%==0 call %xdrv%:\xtemp\currdir.bat
if %previewer%==0 copy %xdrv%:\xtemp\%cwfile%.pdf
if %previewer%==0 goto end

if %tps%==latex goto dvips
if %tps%==pdflatex goto viewpdf
if %tps%==xelatex goto viewpdf

:dvips
cls
rem If specify -t a4, then beamer will be in troubles
dvips -I 3crf8 %cwfile%.dvi
if exist ctx.xtc del ctx.xtc
if exist cwbib.bat del cwbib.bat

if %gsv%==0 goto pspdf
if exist %xdrv%:\xtemp\setcwpath.bat del %xdrv%:\xtemp\setcwpath.bat
if exist %xdrv%:\xtemp\currdir.bat del %xdrv%:\xtemp\currdir.bat
%SMT% %cwfile%.ps
goto end

:pspdf

rem gst.bat has been called called in the beginning
rem call gst.bat

:runpspdf
%gst% -q -dNOPAUSE -dBATCH -sPAPERSIZE=a4 -dCompatibilityLevel=1.5 -sDEVICE=pdfwrite -sOutputFile=%cwfile%.pdf %cwfile%.ps

rem To use SumatraPDF to view pdf, we need to revise the .synctex file a little bit
rem

:viewpdf
rem For WinEdt, processing PDF in %xdrv%:\xtemp,
rem if TeXworks, processing PDF in the current directory
rem Note that gsar syntax is different, so need to adjust a little bit.
rem set curdgsar=currdir
rem
rem 2011.02: However, for forward search, pdf has to be in the
rem          current directory, so this is abandoned.
rem

call %xdrv%:\xtemp\currdir.bat
copy %xdrv%:\xtemp\%cwfile%.pdf
if %texworks%==1 copy %xdrv%:\xtemp\%cwfile%.log

if exist %xdrv%:\xtemp\%cwfile%.synctex.gz copy /y %xdrv%:\xtemp\%cwfile%.synctex.gz
7z e -y %cwfile%.synctex.gz
if not exist %cwfile%.ctx if exist %cwfile%.tex goto syncview


gsar -s.tex -r.ctx -o %cwfile%.synctex
gsar -s%xdrv%:::x5cxtemp:x5c -r -o %cwfile%.synctex
rem In some system the output is c:/xtemp/
gsar -s%xdrv%:::x2Fxtemp:x2F -r -o %cwfile%.synctex
gsar -scinput.ctx -r%xdrv%:::x5cxtemp:x5ccinput.tex -o %cwfile%.synctex
del %cwfile%.synctex.gz

:syncview
if %texworks%==1 goto end
%SMT% -reuse-instance %cwfile%.pdf
goto end

:nosmt
cls
echo.
echo.
echo     我在電腦裡找不到 SumatraPDF 程式,
echo.
echo     請確認你已安裝 SumatraPDF 程式在硬碟 C:
echo.
echo.
pause

:end
