# -*- coding: utf-8 -*-

"""
cwtex 4.1
(cwtex41.py, tex2xtc41.py, cwbiblatex41.py, cwmkidx41.py)

Copyright (C) 2016 Tsong-Min Wu and Tsong-Huey Wu
  with support of ...

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, see <http://www.gnu.org/licenses/>
"""


import os, sys, logging, unicodedata, argparse, re
import shutil
from cwfont_decode import *


parser = argparse.ArgumentParser(description="cwmkgls processor version 4.1")
parser.add_argument("infile")

"""
parser.add_argument("-s", "--style", help="speccify style filename")

parser.add_argument("-cwe", "--cjklast", action="store_true", help="Print English index before Chinese")
parser.add_argument("-cwp", "--phonetic", action="store_true", help="Sort cjk index by phonetic characters")
"""

args = parser.parse_args()

if args.infile:
    inputfile = args.infile

# Default: inputfile has file extension .gls,

if inputfile.split(".")[0] == inputfile:  # No file extension
    temp = inputfile
else :
    temp = inputfile.split(".")[0]

inputfile = temp + ".gls"
#glofile = temp + ".glo"
ctxfile = temp + ".ctx"

logging.basicConfig(format='%(lineno)d %(message)s')

glssym = re.compile(r'\\glsgroupheading{glssymbols}')
glseng = re.compile(r'\\glsgroupheading{[a-zA-Z0-9]}')
glsentr = re.compile(r'\\glossentry{')
glspage = re.compile(r'{page}\\glsnumberformat{')
loadgls = re.compile(r'\\loadglsentries{')

file = open(inputfile, encoding='utf-8')
file_eng = open("glseng.tmp", 'w', encoding='utf-8')


chinese = 0
glslist = []
glslabel = ""

lines = file.readlines()
for linei in range(len(lines)):
    str1 = lines[linei]
    i = 0

    # ith char in current line
    linelength = len(str1)
    while i != linelength:
        if glssym.match(str1[i:]):
            chinese = 1
            break
        elif glseng.match(str1[i:]):
            file_eng.write(str1)
            chinese = 2
            break
        elif glsentr.match(str1[i:]) and chinese == 1:
            i = i + 12
            glslabel = ""
            while str1[i] != '}':
                glslabel = glslabel + str1[i]
                i = i + 1

            break
        elif glspage.match(str1[i:]) and chinese == 1:
            i = i + 22
            while str1[i] != '}':
                glslabel = glslabel + str1[i]
                i = i + 1

            glslist.append(glslabel)
            break
        else:
            if chinese == 2:
                file_eng.write(str1)
                break
        i = i + 1

file.close()
file_eng.close()

#for i in range(len(glslist)):
#    print(glslist[i])

glsload = ""
file = open(ctxfile, encoding='utf-8')
lines = file.readlines()
for linei in range(len(lines)):
    str1 = lines[linei]
    i = 0
    # ith char in current line
    linelength = len(str1)
    while i != linelength:
        if loadgls.match(str1[i:]):
            i = i + 16

            while str1[i] != '}':
                glsload = glsload + str1[i]
                i = i + 1

            break
        i = i + 1
    if glsload != "":
        break
file.close()
glsload = glsload + ".ctx"

#for i in range(len(glslist)):
#    print(glslist[i])

#glsname = re.compile(r'name = {')
cjk = re.compile(u'[\u3041-\u30ff\u4e00-\u9fff]+', re.UNICODE)

file = open(glsload, encoding='utf-8')
lines = file.readlines()

nameon = 0
chinlist = []
sorton = 1  # 1: strokes, 2:zhuyin

for i in range(len(glslist)):
    nameon = 0
    fn = glslist[i].split('{')
    f = "\\newglossaryentry{" + fn[0] + "}\n"
    glsstr = glslist[i]
    for linei in range(len(lines)):
        str1 = lines[linei]
        if str1 == f :
            nameon = 1

        elif str1[0:9] == " name = {" and nameon == 1:
            m = 8
            k = 0
            chinstr = ""
            while str1[m] != '}':
                if cjk.match(str1[m]):

                    utf8,j = uni2utf8(ord(str1[m]),sorton)
                    if j > 26:
                        jstr = "ZZ"+chr(j-26+64)
                    else :
                        jstr = chr(j+64)

                    if k == 0:
                        chinstr = jstr + str(ord(str1[m])) + "{" +str(j) + "{"
                    else :
                        chinstr = chinstr + str(ord(str1[m]))
                    k = k + 1
                m = m + 1
            if k != 0:
                chinstr = chinstr + "{" + glsstr
                chinlist.append(chinstr)
                break
        else:
            nameon = nameon

file.close()

sorted(chinlist)

aprej = -2


file_glo = open("glsall.tmp", 'w', encoding='utf-8')

file_glo.write("\\providecommand{\\cwglsgroupheading}[1]{\\par #1\\par}\n")
file_glo.write("\\glossarysection[\\glossarytoctitle]{\\glossarytitle}\\glossarypreamble\n")
file_glo.write("\\begin{theglossary}\\glossaryheader\n")

for i in range(len(chinlist)):
    fn = chinlist[i].split('{')
    #print(fn[1] + "," +fn[3] + "," + fn[4])
    j = int(fn[1])
    if j != aprej :
        if aprej != -2:
            file_glo.write("\\glsgroupskip\n")
        aprej = j
        file_glo.write("\\cwglsgroupheading{" + fn[1] + "}\\relax \\glsresetentrylist %\n")
    else :
        file_glo.write("%\n")
    file_glo.write("\\glossentry{" + fn[3] + "}{\\glossaryentrynumbers{\\relax\n")
    file_glo.write("		\\setentrycounter[]{page}\\glsnumberformat{" + fn[4] + "}}}")

file_glo.close()

file = open("glseng.tmp", encoding='utf-8')
file_glo = open("glsall.tmp", 'a', encoding='utf-8')
file_glo.write("\\glsgroupskip\n")

lines = file.readlines()
for linei in range(len(lines)):
    str1 = lines[linei]
    file_glo.write(str1)

file_glo.close()
file.close()

"""
file = open(ctxfile, encoding='utf-8')
file_ctx = open("glsctx.tmp", 'w', encoding='utf-8')

lines = file.readlines()
for linei in range(len(lines)):
    str1 = lines[linei]
    file_ctx.write(str1)

file_ctx.close()


ctxback = "gls_backup_" + ctxfile
shutil.copy(ctxfile, ctxback)

ctxtmp = "glsctx.tmp"
shutil.copy(ctxtmp, ctxfile)
"""

inputfile = temp + ".gls"
glsback = "gls_backup_" + inputfile
shutil.copy(inputfile, glsback)

gls_new = "glsall.tmp"
shutil.copy(gls_new, inputfile)

os.remove("glsall.tmp")
os.remove("glseng.tmp")
os.remove(glsback)

