# -*- coding: utf-8 -*-

import os
import sys
import shutil
import configparser
import logging
import fileinput
import re

import time
start_time_cwpdf = time.time()

def replace_str(source, str_ori, str_new):
    f = open(source, 'r', encoding='utf-8')
    filedata = f.read()
    f.close()
    newdata = filedata.replace(str_ori, str_new)
    f = open(source, 'w', encoding='utf-8')
    f.write(newdata)
    f.close()

# from sys import argv
# script, editor, inputfile = argv

    # set up logging to file
#     logging.basicConfig(
#          filename="cwpdf.xlg",
#          level=logging.INFO,
#          format= '%(message)s',
#          datefmt='%H:%M:%S'
#      )
    # set up logging to console
    console = logging.StreamHandler()
    console.setLevel(logging.DEBUG)
    # set a format which is simpler for console use
    formatter = logging.Formatter('%(message)s')
    console.setFormatter(formatter)
    # add the handler to the root logger
    logging.getLogger('').addHandler(console)
    logger = logging.getLogger(__name__)

import argparse
parser = argparse.ArgumentParser(description="cwtex preprocessor version 4.1")
parser.add_argument("infile")

parser.add_argument("-winedt", "--winedt", action="store_true", help="using winedt")
parser.add_argument("-ts_win", "--ts_win", action="store_true", help="using texstudio (Windows)")
parser.add_argument("-texshop", "--texshop", action="store_true", help="using texshop")
parser.add_argument("-ps", "--ps", action="store_true", help="typesetting with latex, dvips, and ps2pdf")

# parser.add_argument("-o", "--outputname", help="speccify output filename")

args = parser.parse_args()

if args.infile:
    inputfile = args.infile

# editor = winedt, texstudio_win, texshop, ...
#

if inputfile.split(".")[0] == inputfile:               # there is no file extension
    file = open(inputfile, encoding='utf-8')
    outputfile = inputfile + ".tex"
    xlogfile = inputfile + ".xlg"
    outputpdf = inputfile + ".pdf"
elif inputfile.split(".")[1] == "tex":
    sys.exit("Error: file extension is .tex, can not continue!")
else:
    file = open(inputfile, encoding='utf-8')
    outputfile = inputfile.split(".")[0] + ".tex"
    outputpdf = inputfile.split(".")[0] + ".pdf"
    xlogfile = inputfile.split(".")[0] + ".xlg"

curdir = os.getcwd()
config = configparser.ConfigParser()
config.sections()
cwtexini = os.path.join(sys.path[0], "cwtex.ini")

if config.read(cwtexini):
    destdir = config['paths']['xtemp']
else:
    destdir = curdir

# TEXINPUTS= 加入 current dir and immediate subdirectories
#
# texlive is TEXINPUTS=/path/to/the/local/folder//:
# where // means subdirectory. Note that path seperator is : instead of ;
# miktex also use //
# in texlive, you have to add .: in the beginning, and use capital letter
# for TEXINPUTS

if args.winedt or args.ts_win:
    if os.environ.get('TEXINPUTS') is None:
        new_env = curdir + "//"
    else:
        new_env = os.environ.get('TEXINPUTS') + ';' + curdir + "//"

    if config.read(cwtexini):
        if config['paths']['TEXINPUTS'] != "":
            new_env = config['paths']['TEXINPUTS'] + ';' + new_env
elif args.texshop:
    if os.environ.get('TEXINPUTS') is None:
        new_env = ".:" + curdir + "//:"
    else:
        new_env = os.environ.get('TEXINPUTS') + ':' + curdir + "//"
    if config.read(cwtexini):
        if config['paths']['TEXINPUTS'] != "":
            new_env = config['paths']['TEXINPUTS'] + ':' + new_env

os.environ['TEXINPUTS'] = new_env

curxcinput = os.path.join(curdir, "xcinput" + "." + "tex")
destxcinput = os.path.join(destdir, "xcinput" + "." + "tex")

if destdir != '' and destdir != curdir:                         # copy xcinput to curdir if exists
    try:
        shutil.copyfile(destxcinput, curxcinput)
    except OSError:
        pass

cwtexpy = os.path.join(sys.path[0], "cwtex41b.py")

from subprocess import call
try:
    call(["python3", cwtexpy, "-a", "-c", inputfile])
except OSError:
    call(["python", cwtexpy, "-a", "-c", inputfile])

if destdir != '':                                                # Move files if \xtemp defined
    if destdir != curdir:                                        # xtemp is defined, and .ctx not in xtemp directory
        if curdir.lower() != destdir.lower():
            if not os.path.exists(destdir):
                os.mkdir(destdir)
            for file in os.listdir(curdir):
                if file.endswith(".ctx"):                        # it is possible that .tex exists, but not .ctx
                    texfile = file.split(".")[0] + ".tex"        # so copy all the .tex, and
                    curtex = os.path.join(curdir, texfile)
                    if os.path.exists(curtex):
                        curctx = os.path.join(curdir, file)
                        destctx = os.path.join(destdir, file)
                        shutil.copyfile(curctx, destctx)
                        desttex = os.path.join(destdir, texfile)
                        shutil.copyfile(curtex, desttex)
                        os.remove(curtex)
                if file.endswith(".ctx_xbackup"):
                    texfile = file.split(".")[0] + ".tex"
                    curtex = os.path.join(curdir, texfile)       # it is possible that .tex exists, but not .ctx
                    if os.path.exists(curtex):                   # so copy all the .tex, and
                        desttex = os.path.join(destdir, texfile)
                        shutil.copyfile(curtex, desttex)
                        os.remove(curtex)
                    os.remove(file)                              # .ctx_xbackup means .ctx was copied from somewhere,
                    ctxcopyfile = file.split(".")[0] + ".ctx"    # so we should remove .ctx as well
                    os.remove(ctxcopyfile)
                if file.endswith(".xlg"):
                    curxlog = os.path.join(curdir, xlogfile)
                    if os.path.exists(curxlog):
                        destxlog = os.path.join(destdir, xlogfile)
                        shutil.copyfile(curxlog, destxlog)
                        os.remove(curxlog)

#            curxcinput = os.path.join(curdir, "xcinput" + "." + "tex")
#            destxcinput = os.path.join(destdir, "xcinput" + "." + "tex")

            shutil.copyfile(curxcinput, destxcinput)
            os.remove(curxcinput)
            os.chdir(destdir)
    else:
        for file in os.listdir(curdir):
            if file.endswith(".ctx_xbackup"):
                os.remove(file)
                ctxcopyfile = file.split(".")[0] + ".ctx"
                os.remove(ctxcopyfile)
else:                                                             # xtemp is not defined
    for file in os.listdir(curdir):                               # if .ctx was copied from somewhere, we have to remove them
        if file.endswith(".ctx_xbackup"):
            os.remove(file)
            ctxcopyfile = file.split(".")[0] + ".ctx"
            os.remove(ctxcopyfile)

#
# First run of pdflatex, may already in c:\xtemp
#
if args.winedt or args.ts_win:
    if args.ps:
        call(["latex", "-synctex=1", "-enable-write18", "-stack-size=10000", outputfile])
    else:
        call(["pdflatex", "-synctex=1", "-enable-write18", "-stack-size=10000", outputfile])
elif args.texshop:
    if args.ps:
        call(["latex", "-synctex=1", "-enable-write18", outputfile])
    else:
        call(["pdflatex", "-synctex=1", "-enable-write18", outputfile])

# check if cwbibtex or cwbiblatex is needed:
#
# If backend=biber, there would be .bcf, get .bib from the file
# If backend=bibtex, in examp5a.aux, there will be \bibdata{examp5a-blx,tmwu-blx,abc}
# If backend=biber, there is examp5a.aux, but not \bibdata{examp5a-blx,tmwu-blx,abc}
#
# for biblatex with bibtex, there will be a file %cwfile%-blx.bib
# for biblatex with biber, there will be a file %cwfile%.bcf; cwbiblatex can handle both case
#
# cwbibtex/cwbiblatex has to be run in the current directory because
# .bib maybe in the current directory, and also the main .ctx may input other .ctx
# grep ERRORLEVEL 0 if found; ERRORLEVEL 1 if not found
# ERRORLEVEL 1 means equal to or greater than 1
#
# The warning message from bibtex+natbib contains "undefined citations";
# The message from biblatex is "undefined references", also %cwfile%-blx.bib is generated
#
# "undefined references" also occurs with \label and \ref commands
#
# grep produce 0 if found; 1 if not found
#
# :checkbibtex
# grep -c -q "undefined citations" %xdrv%:\xtemp\%cwfile%.log
# IF %ERRORLEVEL% EQU 0 goto bibtex
#
# grep -c -q "undefined references" %xdrv%:\xtemp\%cwfile%.log
# IF %ERRORLEVEL% EQU 1 goto cwidx
#
# if exist %xdrv%:\xtemp\%cwfile%-blx.bib goto biblatex
# if exist %xdrv%:\xtemp\%cwfile%.bcf goto biblatex

# Package biblatex Warning: Please (re)run Biber
# Package biblatex Warning: Please (re)run BibTeX

input_base = inputfile.split(".")[0]
input_log = inputfile.split(".")[0] + ".log"
bib_biber = input_base + ".bcf" # biblatex with biber backend

logfile = open(input_log, 'r', encoding='latin-1')

backend = ""
bib = 0

if '(re)run Biber' in open(input_log, 'r', encoding='latin-1').read():
    backend = "biber"
    bib = 1
elif '(re)run BibTeX' in open(input_log, 'r', encoding='latin-1').read():
    backend = "bibtex"
    bib = 1

cwbiblatexpy = os.path.join(sys.path[0], "cwbiblatex41b.py")

# At this point, if xtemp not defined, we are already in destdir.
# input directories list is computed here, and sent to BIBINPUTS
# cwbiblatex will then get expanded version of BIBINPUTS

if args.winedt or args.ts_win:
    if os.environ.get('BIBINPUTS') is None:
        bib_env = curdir + "//"
    else:
        bib_env = os.environ.get('BIBINPUTS') + ';' + curdir + "//"

    if config.read(cwtexini):
        if config['paths']['BIBINPUTS'] != "":
            bib_env = config['paths']['BIBINPUTS'] + ';' + bib_env
elif args.texshop:
    if os.environ.get('BIBINPUTS') is None:
        bib_env = ".:" + curdir + "//:"
    else:
        bib_env = os.environ.get('BIBINPUTS') + ':' + curdir    # mac cannot use "//" ?

    if config.read(cwtexini):
        if config['paths']['BIBINPUTS'] != "":
            bib_env = config['paths']['BIBINPUTS'] + ':' + bib_env

os.environ['BIBINPUTS'] = bib_env

if bib == 1:
    if backend == "biber":
        try:
            call(["python3", cwbiblatexpy, "biber", inputfile])
        except OSError:
            call(["python", cwbiblatexpy, "biber", inputfile])
    elif backend == "bibtex":
        try:
            call(["python3", cwbiblatexpy, "bibtex", inputfile])
        except OSError:
            call(["python", cwbiblatexpy, "bibtex", inputfile])

    # after cwbiblatex, xcinput.tex in destdir contains more def than in curdir, so copy it back
    if destdir != '':
        shutil.copyfile(destxcinput, curxcinput)

#
# check if  glossaries  package is used
#
#   makeindex -l -s examp7.ist -o examp7.gls examp7.glo
#   python "c:\Program Files (x86)\cwtex4\bin\cwmkgls41b.py" examp7.ctx
#

gloss = 0
input_glo = inputfile.split(".")[0] + ".glo"

if os.path.isfile(input_glo):
    gloss = 1
    input_ist = inputfile.split(".")[0] + ".ist"
    input_gls = inputfile.split(".")[0] + ".gls"
    cwtex_gloss = os.path.join(sys.path[0], "cwmkgls41b.py")

    from subprocess import call
    call(["makeindex", "-l", "-s", input_ist, "-o", input_gls, input_glo])
    try:
        call(["python3", cwtex_gloss, inputfile])
    except OSError:
        call(["python", cwtex_gloss, inputfile])


index = 0
input_idx = inputfile.split(".")[0] + ".idx"

if os.path.isfile(input_idx):
    index = 1

    input_ind = inputfile.split(".")[0] + ".ind"
    input_xtc = inputfile.split(".")[0] + ".xtc"
    destdir_idx = os.path.join(destdir, input_idx)
    destdir_ind = os.path.join(destdir, input_ind)
    destdir_tmpind = os.path.join(destdir, "cwtemp.ind")
    destdir_tmptex = os.path.join(destdir, "cwtemp.tex")

    cwtex_tex2xtc = os.path.join(sys.path[0], "tex2xtc41b.py")
    cwtex_mkidx = os.path.join(sys.path[0], "cwmkidx41b.py")

    if os.path.exists(destdir_idx):
        try:
            call(["python3", cwtex_tex2xtc, "-s", input_idx])
        except OSError:
            call(["python", cwtex_tex2xtc, "-s", input_idx])

    # options: -cwe : English first, cjk last
    #          -cwp : sort cjk by phonetic
        try:
            call(["python3", cwtex_mkidx, input_xtc])
        except OSError:
            call(["python", cwtex_mkidx, input_xtc])

        shutil.copyfile(destdir_ind, destdir_tmpind)

        try:
            call(["python3", cwtexpy, "-a", "-x", "cwtemp.ind"])
        except OSError:
            call(["python", cwtexpy, "-a", "-x", "cwtemp.ind"])
        shutil.copyfile(destdir_tmptex, destdir_ind)

#
# After checking biblatex/glossaries/index, now the second run of pdflatex
#

if (bib == 1 or gloss == 1 or index == 1):
    if args.winedt or args.ts_win:
        if args.ps:
            call(["latex", "-synctex=1", "-enable-write18", "-stack-size=10000", outputfile])
        else:
            call(["pdflatex", "-synctex=1", "-enable-write18", "-stack-size=10000", outputfile])
    elif args.texshop:
        if args.ps:
            call(["latex", "-synctex=1", "-enable-write18", outputfile])
        else:
            call(["pdflatex", "-synctex=1", "-enable-write18", outputfile])

#     if args.winedt or args.ts_win:
#         if args.ps:
#             call(["latex", "-synctex=1", "-enable-write18", "-stack-size=10000", outputfile])
#         else:
#             call(["pdflatex", "-synctex=1", "-enable-write18", "-stack-size=10000", outputfile])
#     elif args.texshop:
#         if args.ps:
#             call(["latex", "-synctex=1", "-enable-write18", outputfile])
#         else:
#             call(["pdflatex", "-synctex=1", "-enable-write18", outputfile])


if args.ps:
    output_dvi = inputfile.split(".")[0] + ".dvi"
    output_ps = inputfile.split(".")[0] + ".ps"
    output_pdf = inputfile.split(".")[0] + ".pdf"
    call(["dvips", output_dvi])
    if args.winedt or args.ts_win:
      call(["gswin64c", "-q", "-dNOPAUSE", "-dBATCH", "-sPAPERSIZE=a4", "-dCompatibilityLevel=1.5", "-sDEVICE=pdfwrite", "-sOutputFile=output.pdf", output_ps])
      shutil.copyfile("output.pdf", output_pdf)
    elif args.texshop:
      call(["gs", "-q", "-dNOPAUSE", "-dBATCH", "-sPAPERSIZE=a4", "-dCompatibilityLevel=1.5", "-sDEVICE=pdfwrite", "-sOutputFile=output.pdf", output_ps])
      shutil.copyfile("output.pdf", output_pdf)

# "-q", "-dNOPAUSE", "-dBATCH", "-sPAPERSIZE=a4", "-dCompatibilityLevel=1.5", "-sDEVICE=pdfwrite", "-sOutputFile=output.pdf", output_ps
# %gst% -q -dNOPAUSE -dBATCH -sPAPERSIZE=a4 -dCompatibilityLevel=1.5 -sDEVICE=pdfwrite -sOutputFile=%cwfile%.pdf %cwfile%.ps
# c:\Program Files\gs\gs9.15\bin\gswin64c.exe
#
# unpack .synctex.gz, and copy to the current directory
# make sure that 7z.exe exists in your system
#

syncfile = inputfile.split(".")[0] + ".synctex"
syncgzfile = inputfile.split(".")[0] + ".synctex.gz"

if os.path.isfile(syncgzfile):
    if args.winedt or args.ts_win:
        call(["7z", "e", "-y", syncgzfile])
    elif args.texshop:
        call(["gunzip", "-d", "-q", syncgzfile])
    if destdir != "":
        if curdir.lower() != destdir.lower():
            if os.path.isfile(syncfile):
                curdir_sync = os.path.join(curdir, syncfile)
                destdir_sync = os.path.join(destdir, syncfile)
                shutil.copyfile(destdir_sync, curdir_sync)
                curdir_pdf = os.path.join(curdir, outputpdf)
                destdir_pdf = os.path.join(destdir, outputpdf)
                shutil.copyfile(destdir_pdf, curdir_pdf)
            os.chdir(curdir)

# Replace .tex by .ctx
# Mac will add dir to the filename, Win may/may not add,
# if add, the first dir name is, eg., g:/xtemp\ ... or g:\xtemp\ ...
#

replace_str(syncfile, ".tex", ".ctx")
print("cwpdf run: %f seconds" % (time.time() - start_time_cwpdf))

# logging.info("cwpdf run: %f seconds" % (time.time() - start_time_cwpdf))

# if destdir != "":
#     destdir_xlg = os.path.join(destdir, "cwpdf.xlg")
#     if os.path.isfile(destdir_xlg):
#         os.remove(destdir_xlg)
#     shutil.copyfile("cwpdf.xlg", destdir_xlg)    
#     os.remove("cwpdf.xlg")    
    

# If winedt, SumatraPDF is used to view PDF,
# and SumatraPDF has to be in the path
# Don't know why, but with biblatex, it would be g:/xtemp\examp5.tex
#
# Texshop uses own previewer, and needs additional processing
#

if args.winedt or args.ts_win:
    if destdir != "":
        d_destdir = destdir.replace('\\', '/')
        replace_str(syncfile, d_destdir, curdir)
        replace_str(syncfile, destdir, curdir)

    pdfview = shutil.which("SumatraPDF")
    call([pdfview, "-reuse-instance", outputpdf])
elif args.texshop:
    if destdir != "":
        replace_str(syncfile, destdir, curdir)






