# -*- coding: utf-8 -*-

# Change log
#
#   20180303:
#      * htlatex use pdflatex, so have to configure cwtex51b to output latin-1,
#        adding -l option when call cwtex51b
#
#   20180301:
#      * First version to combine luatex and pdflatex into one file
#      * svg = 1 for generating svg file
#

import os
import sys
import shutil
import configparser
import logging
import fileinput
import re

import time
start_time_cwpdf = time.time()

def replace_str(source, str_ori, str_new):
    f = open(source, 'r', encoding='utf-8')
    filedata = f.read()
    f.close()
    newdata = filedata.replace(str_ori, str_new)
    f = open(source, 'w', encoding='utf-8')
    f.write(newdata)
    f.close()

# from sys import argv
# script, editor, inputfile = argv

    # set up logging to file
#     logging.basicConfig(
#          filename="cwpdf.xlg",
#          level=logging.INFO,
#          format= '%(message)s',
#          datefmt='%H:%M:%S'
#      )
    # set up logging to console
    console = logging.StreamHandler()
    console.setLevel(logging.DEBUG)
    # set a format which is simpler for console use
    formatter = logging.Formatter('%(message)s')
    console.setFormatter(formatter)
    # add the handler to the root logger
    logging.getLogger('').addHandler(console)
    logger = logging.getLogger(__name__)

import argparse
parser = argparse.ArgumentParser(description="cwtex preprocessor version 5.1")
parser.add_argument("infile")

parser.add_argument("-winedt", "--winedt", action="store_true", help="using winedt")
parser.add_argument("-ts_win", "--ts_win", action="store_true", help="using texstudio (Windows)")
parser.add_argument("-texshop", "--texshop", action="store_true", help="using texshop")
parser.add_argument("-ps", "--ps", action="store_true", help="typesetting with latex, dvips, and ps2pdf")

# parser.add_argument("-o", "--outputname", help="speccify output filename")

luatex = 1    # luatex = 1 is the default, and cwtex will output utf8 
              # luatex = 0, cwtex will add "-l" option to output latin1
              # This only affect \verb and verbatim

svg = 1                                                ### svg = 1 for svg

args = parser.parse_args()

if args.infile:
    inputfile = args.infile

# editor = winedt, texstudio_win, texshop, ...
#

if inputfile.split(".")[0] == inputfile:               # there is no file extension
    file = open(inputfile, encoding='utf-8')
    outputfile = inputfile + ".tex"
    xlogfile = inputfile + ".xlg"
    outputpdf = inputfile + ".pdf"
elif inputfile.split(".")[1] == "tex":
    sys.exit("Error: file extension is .tex, can not continue!")
else:
    file = open(inputfile, encoding='utf-8')
    outputfile = inputfile.split(".")[0] + ".tex"
    outputpdf = inputfile.split(".")[0] + ".pdf"
    xlogfile = inputfile.split(".")[0] + ".xlg"

curdir = os.getcwd()
config = configparser.ConfigParser()
config.sections()
cwtexini = os.path.join(sys.path[0], "cwtex.ini")

if config.read(cwtexini):
    destdir = config['paths']['xtemp']
else:
    destdir = curdir

# TEXINPUTS= 加入 current dir and immediate subdirectories
#
# texlive is TEXINPUTS=/path/to/the/local/folder//:
# where // means subdirectory. Note that path seperator is : instead of ;
# miktex also use //
# in texlive, you have to add .: in the beginning, and use capital letter
# for TEXINPUTS

if args.winedt or args.ts_win:
    if os.environ.get('TEXINPUTS') is None:
        new_env = curdir + "//"
    else:
        new_env = os.environ.get('TEXINPUTS') + ';' + curdir + "//"

    if config.read(cwtexini):
        if config['paths']['TEXINPUTS'] != "":
            new_env = config['paths']['TEXINPUTS'] + ';' + new_env
elif args.texshop:
    if os.environ.get('TEXINPUTS') is None:
        new_env = ".:" + curdir + "//:"
    else:
        new_env = os.environ.get('TEXINPUTS') + ':' + curdir + "//"
    if config.read(cwtexini):
        if config['paths']['TEXINPUTS'] != "":
            new_env = config['paths']['TEXINPUTS'] + ':' + new_env

os.environ['TEXINPUTS'] = new_env

curxcinput = os.path.join(curdir, "xcinput" + "." + "tex")
destxcinput = os.path.join(destdir, "xcinput" + "." + "tex")

if destdir != '' and destdir != curdir:                         # copy xcinput to curdir if exists
    if os.path.isfile(destxcinput):
        shutil.copyfile(destxcinput, curxcinput)

# cwtexpy = os.path.join(sys.path[0], "cwtex41b.py")
cwtexpy = os.path.join(sys.path[0], "cwtex51b.py")              
                                                                
# tex4ht does not insert \z between Chinese characters,
# hence use -z option

from subprocess import call                                      
try:                                                             
    call(["pypy3", cwtexpy, "-a", "-z", "-l", inputfile])        # cwtex51b default output is utf-8        
except OSError:                                                  # needs to add -l option,                 
    call(["pypy", cwtexpy, "-a", "-z", "-l", inputfile])         # otherwise, errors in \verb and verbatim 
except OSError:
    call(["python3", cwtexpy, "-a", "-z", "-l", inputfile])
except OSError:
    call(["python", cwtexpy, "-a", "-z", "-l", inputfile])
   

if destdir != '':                                                # Move files if \xtemp defined
    if destdir != curdir:                                        # xtemp is defined, and .ctx not in xtemp directory
        if curdir.lower() != destdir.lower():
            if not os.path.exists(destdir):
                os.mkdir(destdir)
            for file in os.listdir(curdir):
                if file.endswith(".ctx"):                        # it is possible that .tex exists, but not .ctx
                    texfile = file.split(".")[0] + ".tex"        # so copy all the .tex, and
                    curtex = os.path.join(curdir, texfile)
                    if os.path.exists(curtex):
                        curctx = os.path.join(curdir, file)
                        destctx = os.path.join(destdir, file)
                        shutil.copyfile(curctx, destctx)
                        desttex = os.path.join(destdir, texfile)
                        shutil.copyfile(curtex, desttex)
                        os.remove(curtex)
                if file.endswith(".ctx_xbackup"):
                    texfile = file.split(".")[0] + ".tex"
                    curtex = os.path.join(curdir, texfile)       # it is possible that .tex exists, but not .ctx
                    if os.path.exists(curtex):                   # so copy all the .tex, and
                        desttex = os.path.join(destdir, texfile)
                        shutil.copyfile(curtex, desttex)
                        os.remove(curtex)
                    os.remove(file)                              # .ctx_xbackup means .ctx was copied from somewhere,
                    ctxcopyfile = file.split(".")[0] + ".ctx"    # so we should remove .ctx as well
                    os.remove(ctxcopyfile)
                if file.endswith(".xlg"):
                    curxlog = os.path.join(curdir, xlogfile)
                    if os.path.exists(curxlog):
                        destxlog = os.path.join(destdir, xlogfile)
                        shutil.copyfile(curxlog, destxlog)
                        os.remove(curxlog)

#            curxcinput = os.path.join(curdir, "xcinput" + "." + "tex")
#            destxcinput = os.path.join(destdir, "xcinput" + "." + "tex")

            shutil.copyfile(curxcinput, destxcinput)
            os.remove(curxcinput)
            os.chdir(destdir)
    else:
        for file in os.listdir(curdir):
            if file.endswith(".ctx_xbackup"):
                os.remove(file)
                ctxcopyfile = file.split(".")[0] + ".ctx"
                os.remove(ctxcopyfile)
else:                                                             # xtemp is not defined
    for file in os.listdir(curdir):                               # if .ctx was copied from somewhere, we have to remove them
        if file.endswith(".ctx_xbackup"):
            os.remove(file)
            ctxcopyfile = file.split(".")[0] + ".ctx"
            os.remove(ctxcopyfile)

#
# NoFonts options: to disable span command in .html, and hence reduce file size.
# p-width: for p{.} in tabular

if args.winedt or args.ts_win:
    if svg == 0:
        call(["make4ht", "-l", "-c", "ht-cwtex.cfg", outputfile, "html,p-width,charset=utf-8,NoFonts", " -cunihtf -utf8"])
    elif svg == 1:    
        call(["make4ht", "-l", "-c", "ht-cwtex.cfg", outputfile, "ht-cwtex,xhtml,html5,p-width,charset=utf-8,NoFonts", " -cunihtf -utf8"])
elif args.texshop:
    if svg == 0:
        call(["htlatex", outputfile, "html,p-width,charset=utf-8,NoFonts", " -cunihtf -utf8"])
    elif svg == 1:    
        call(["htlatex", outputfile, "ht-cwtex,xhtml,html5,p-width,charset=utf-8,NoFonts", " -cunihtf -utf8"])

# check if cwbibtex or cwbiblatex is needed:
#
# If backend=biber, there would be .bcf, get .bib from the file
# If backend=bibtex, in examp5a.aux, there will be \bibdata{examp5a-blx,tmwu-blx,abc}
# If backend=biber, there is examp5a.aux, but not \bibdata{examp5a-blx,tmwu-blx,abc}
#
# for biblatex with bibtex, there will be a file %cwfile%-blx.bib
# for biblatex with biber, there will be a file %cwfile%.bcf; cwbiblatex can handle both case
#
# cwbibtex/cwbiblatex has to be run in the current directory because
# .bib maybe in the current directory, and also the main .ctx may input other .ctx
# grep ERRORLEVEL 0 if found; ERRORLEVEL 1 if not found
# ERRORLEVEL 1 means equal to or greater than 1
#
# The warning message from bibtex+natbib contains "undefined citations";
# The message from biblatex is "undefined references", also %cwfile%-blx.bib is generated
#
# "undefined references" also occurs with \label and \ref commands
#
# grep produce 0 if found; 1 if not found
#
# :checkbibtex
# grep -c -q "undefined citations" %xdrv%:\xtemp\%cwfile%.log
# IF %ERRORLEVEL% EQU 0 goto bibtex
#
# grep -c -q "undefined references" %xdrv%:\xtemp\%cwfile%.log
# IF %ERRORLEVEL% EQU 1 goto cwidx
#
# if exist %xdrv%:\xtemp\%cwfile%-blx.bib goto biblatex
# if exist %xdrv%:\xtemp\%cwfile%.bcf goto biblatex

# Package biblatex Warning: Please (re)run Biber
# Package biblatex Warning: Please (re)run BibTeX

input_base = inputfile.split(".")[0]
input_log = inputfile.split(".")[0] + ".log"
input_html = inputfile.split(".")[0] + ".html"
bib_biber = input_base + ".bcf" # biblatex with biber backend

logfile = open(input_log, 'r', encoding='latin-1')

backend = ""
bib = 0

if '(re)run Biber' in open(input_log, 'r', encoding='latin-1').read():
    backend = "biber"
    bib = 1
elif '(re)run BibTeX' in open(input_log, 'r', encoding='latin-1').read():
    backend = "bibtex"
    bib = 1

# cwbiblatexpy = os.path.join(sys.path[0], "cwbiblatex41b.py")
cwbiblatexpy = os.path.join(sys.path[0], "cwbiblatex51b.py")

# At this point, if xtemp not defined, we are already in destdir.
# input directories list is computed here, and sent to BIBINPUTS
# cwbiblatex will then get expanded version of BIBINPUTS

if args.winedt or args.ts_win:
    if os.environ.get('BIBINPUTS') is None:
        bib_env = curdir + "//"
    else:
        bib_env = os.environ.get('BIBINPUTS') + ';' + curdir + "//"

    if config.read(cwtexini):
        if config['paths']['BIBINPUTS'] != "":
            bib_env = config['paths']['BIBINPUTS'] + ';' + bib_env
elif args.texshop:
    if os.environ.get('BIBINPUTS') is None:
        bib_env = ".:" + curdir + "//:"
    else:
        bib_env = os.environ.get('BIBINPUTS') + ':' + curdir    # mac cannot use "//" ?

    if config.read(cwtexini):
        if config['paths']['BIBINPUTS'] != "":
            bib_env = config['paths']['BIBINPUTS'] + ':' + bib_env

os.environ['BIBINPUTS'] = bib_env

if bib == 1:
    if luatex == 1:
        if backend == "biber":                                       
            if args.winedt or args.ts_win:                           
                call(["pypy", cwbiblatexpy, "biber", "luatex", inputfile])     
            else:                                                    
                call(["python3", cwbiblatexpy, "biber", "luatex", inputfile])  
        elif backend == "bibtex":                                    
            if args.winedt or args.ts_win:                           
                call(["pypy", cwbiblatexpy, "bibtex", "luatex", inputfile])    
            else:                                                    
                call(["python3", cwbiblatexpy, "bibtex", "luatex", inputfile]) 
    elif luatex == 0:
        if backend == "biber":                                       
            if args.winedt or args.ts_win:                           
                call(["pypy", cwbiblatexpy, "biber", "pdftex", inputfile])     
            else:                                                    
                call(["python3", cwbiblatexpy, "biber", "pdftex", inputfile])  
        elif backend == "bibtex":                                    
            if args.winedt or args.ts_win:                           
                call(["pypy", cwbiblatexpy, "bibtex", "pdftex", inputfile])    
            else:                                                    
                call(["python3", cwbiblatexpy, "bibtex", "pdftex", inputfile]) 

    # after cwbiblatex, xcinput.tex in destdir contains more def than in curdir, so copy it back
    if destdir != '':
        try:
            shutil.copyfile(destxcinput, curxcinput)
        except OSError:
            pass

#
# check if  glossaries  package is used
#
#   makeindex -l -s examp7.ist -o examp7.gls examp7.glo
#   python "c:\Program Files (x86)\cwtex4\bin\cwmkgls41b.py" examp7.ctx
#

gloss = 0
input_glo = inputfile.split(".")[0] + ".glo"

if os.path.isfile(input_glo):
    gloss = 1
    input_ist = inputfile.split(".")[0] + ".ist"
    input_gls = inputfile.split(".")[0] + ".gls"
#    cwtex_gloss = os.path.join(sys.path[0], "cwmkgls41b.py")
    cwtex_gloss = os.path.join(sys.path[0], "cwmkgls51b.py")

    from subprocess import call
    call(["makeindex", "-l", "-s", input_ist, "-o", input_gls, input_glo])
    try:
        call(["pypy3", cwtex_gloss, inputfile])
    except OSError:
        call(["pypy", cwtex_gloss, inputfile])
    except OSError:
        call(["python3", cwtex_gloss, inputfile])
    except OSError:
        call(["python", cwtex_gloss, inputfile])


index = 0
input_idx = inputfile.split(".")[0] + ".idx"

if os.path.isfile(input_idx):
    index = 1

    input_ind = inputfile.split(".")[0] + ".ind"
    input_xtc = inputfile.split(".")[0] + ".xtc"
    destdir_idx = os.path.join(destdir, input_idx)
    destdir_ind = os.path.join(destdir, input_ind)
    destdir_tmpind = os.path.join(destdir, "cwtemp.ind")
    destdir_tmptex = os.path.join(destdir, "cwtemp.tex")

#     cwtex_tex2xtc = os.path.join(sys.path[0], "tex2xtc41b.py")
#     cwtex_mkidx = os.path.join(sys.path[0], "cwmkidx41b.py")

    cwtex_tex2xtc = os.path.join(sys.path[0], "tex2xtc51b.py")
    cwtex_mkidx = os.path.join(sys.path[0], "cwmkidx51b.py")

    if os.path.exists(destdir_idx):
        try:
            call(["pypy3", cwtex_tex2xtc, "-s", input_idx])
        except OSError:
            call(["pypy", cwtex_tex2xtc, "-s", input_idx])
        except OSError:
            call(["python3", cwtex_tex2xtc, "-s", input_idx])
        except OSError:
            call(["python", cwtex_tex2xtc, "-s", input_idx])

    # options: -cwe : English first, cjk last
    #          -cwp : sort cjk by phonetic
        try:
            call(["pypy3", cwtex_mkidx, input_xtc])
        except OSError:
            call(["pypy", cwtex_mkidx, input_xtc])
        except OSError:
            call(["python3", cwtex_mkidx, input_xtc])
        except OSError:
            call(["python", cwtex_mkidx, input_xtc])

        shutil.copyfile(destdir_ind, destdir_tmpind)

        try:
            call(["pypy3", cwtexpy, "-a", "-z", "cwtemp.ind"])
        except OSError:
            call(["pypy", cwtexpy, "-a", "-z", "cwtemp.ind"])
        except OSError:
            call(["python3", cwtexpy, "-a", "-z", "cwtemp.ind"])
        except OSError:
            call(["python", cwtexpy, "-a", "-z", "cwtemp.ind"])
        shutil.copyfile(destdir_tmptex, destdir_ind)
        
        

#
# After checking biblatex/glossaries/index, now the second run of htlatex
#

if (bib == 1 or gloss == 1 or index == 1):
    if svg == 0:
        call(["make4ht", "-l", "-c", "ht-cwtex.cfg", outputfile, "html,p-width,charset=utf-8,NoFonts", " -cunihtf -utf8"])
    elif svg == 1:    
        call(["make4ht", "-l", "-c", "ht-cwtex.cfg", outputfile, "xhtml,html5,p-width,charset=utf-8,NoFonts", " -cunihtf -utf8"])

import webbrowser
webbrowser.open('file://' + os.path.realpath(input_html))






