/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.generator.layout.Floorplan;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.Router;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.Tech;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

class TiledCell {
    private static final int VERT_EXTERIOR = 0;
    private static final int HORI_EXTERIOR = 1;
    private static final int INTERIOR = 2;
    private int vddNum;
    private int gndNum;
    private final String vddNm;
    private final String gndNm;

    private String vddName() {
        int n;
        return (n = this.vddNum++) == 0 ? this.vddNm : this.vddNm + "_" + n;
    }

    private String gndName() {
        int n;
        return (n = this.gndNum++) == 0 ? this.gndNm : this.gndNm + "_" + n;
    }

    private ArrayList getAllPortInsts(Cell cell) {
        ArrayList<PortInst> ports = new ArrayList<PortInst>();
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            Iterator pIt = ni.getPortInsts();
            while (pIt.hasNext()) {
                PortInst pi = (PortInst)pIt.next();
                ports.add(pi);
            }
        }
        return ports;
    }

    private int orientation(Rectangle2D bounds, PortInst pi) {
        double portX = pi.getBounds().getCenterX();
        double portY = pi.getBounds().getCenterY();
        double minX = bounds.getMinX();
        double maxX = bounds.getMaxX();
        double minY = bounds.getMinY();
        double maxY = bounds.getMaxY();
        if (portX == minX || portX == maxX) {
            return 0;
        }
        if (portY == minY || portY == maxY) {
            return 1;
        }
        return 2;
    }

    private ArrayList getUnconnectedPortInsts(int orientation, NodeInst ni) {
        Rectangle2D bounds = ni.findEssentialBounds();
        ArrayList<PortInst> ports = new ArrayList<PortInst>();
        Iterator it = ni.getPortInsts();
        while (it.hasNext()) {
            PortInst pi = (PortInst)it.next();
            Iterator conns = pi.getConnections();
            if (conns.hasNext() || this.orientation(bounds, pi) != orientation) continue;
            ports.add(pi);
        }
        return ports;
    }

    private void exportPortInsts(List ports, Cell tiled, StdCellParams stdCell) {
        Collections.sort(ports, new OrderPortInstsByName());
        Iterator it = ports.iterator();
        while (it.hasNext()) {
            Export e;
            PortInst pi = (PortInst)it.next();
            PortProto pp = pi.getPortProto();
            PortProto.Characteristic role = pp.getCharacteristic();
            if (role == stdCell.getVddExportRole()) {
                e = Export.newInstance(tiled, pi, this.vddName());
                e.setCharacteristic(role);
                continue;
            }
            if (role == stdCell.getGndExportRole()) {
                e = Export.newInstance(tiled, pi, this.gndName());
                e.setCharacteristic(role);
                continue;
            }
            LayoutLib.error(true, "unrecognized Characteristic");
        }
    }

    private void exportUnconnectedPortInsts(NodeInst[][] rows, Floorplan[] plans, Cell tiled, StdCellParams stdCell) {
        Floorplan topPlan = plans[plans.length - 1];
        int[] orientations = topPlan.horizontal ? new int[]{0, 1, 2} : new int[]{1, 0, 2};
        for (int o = 0; o < 3; ++o) {
            int orientation = orientations[o];
            for (int row = 0; row < rows.length; ++row) {
                for (int col = 0; col < rows[row].length; ++col) {
                    if (orientation == 2 && row != col) continue;
                    ArrayList ports = this.getUnconnectedPortInsts(orientation, rows[row][col]);
                    this.exportPortInsts(ports, tiled, stdCell);
                }
            }
        }
    }

    private NodeInst[][] newRows(int numX, int numY) {
        NodeInst[][] rows = new NodeInst[numY][];
        for (int row = 0; row < numX; ++row) {
            rows[row] = new NodeInst[numX];
        }
        return rows;
    }

    private void addEssentialBounds(double cellW, double cellH, int numX, int numY, Cell tiled) {
        double blX = -cellW / 2.0;
        double blY = -cellH / 2.0;
        double tlX = cellW / 2.0 + (double)(numX - 1) * cellW;
        double tlY = cellH / 2.0 + (double)(numY - 1) * cellH;
        LayoutLib.newNodeInst(Tech.essentialBounds, blX, blY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 180.0, tiled);
        LayoutLib.newNodeInst(Tech.essentialBounds, tlX, tlY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, tiled);
    }

    private TiledCell(int numX, int numY, Cell cell, Floorplan[] plans, Library lib, StdCellParams stdCell) {
        this.vddNm = stdCell.getVddExportName();
        this.gndNm = stdCell.getGndExportName();
        String tiledName = "t" + cell.getName() + "_" + numX + "x" + numY + "{lay}";
        Cell tiled = Cell.newInstance(lib, tiledName);
        Rectangle2D bounds = cell.findEssentialBounds();
        LayoutLib.error(bounds == null, "missing Essential Bounds");
        double cellW = bounds.getWidth();
        double cellH = bounds.getHeight();
        double y = 0.0;
        NodeInst[][] rows = this.newRows(numX, numY);
        for (int row = 0; row < numY; ++row) {
            double x = 0.0;
            for (int col = 0; col < numX; ++col) {
                rows[row][col] = LayoutLib.newNodeInst(cell, x, y, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, tiled);
                x += cellW;
            }
            y += cellH;
        }
        ArrayList portInsts = this.getAllPortInsts(tiled);
        Router.connectCoincident(portInsts);
        this.exportUnconnectedPortInsts(rows, plans, tiled, stdCell);
        this.addEssentialBounds(cellW, cellH, numX, numY, tiled);
    }

    public static void makeTiledCell(int numX, int numY, Cell cell, Floorplan[] plans, Library lib, StdCellParams stdCell) {
        new TiledCell(numX, numY, cell, plans, lib, stdCell);
    }

    private static class OrderPortInstsByName
    implements Comparator {
        private OrderPortInstsByName() {
        }

        private String base(String s) {
            int under = s.indexOf("_");
            if (under == -1) {
                return s;
            }
            return s.substring(0, under);
        }

        private int subscript(String s) {
            int under = s.indexOf("_");
            if (under == -1) {
                return 0;
            }
            String num = s.substring(under + 1, s.length());
            return Integer.parseInt(num);
        }

        public int compare(Object o1, Object o2) {
            String base2;
            PortInst p1 = (PortInst)o1;
            PortInst p2 = (PortInst)o2;
            String n1 = p1.getPortProto().getName();
            String n2 = p2.getPortProto().getName();
            String base1 = this.base(n1);
            if (!base1.equals(base2 = this.base(n2))) {
                return n1.compareTo(n2);
            }
            int sub1 = this.subscript(n1);
            int sub2 = this.subscript(n2);
            return sub1 - sub2;
        }
    }
}

