/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.Tech;
import java.awt.geom.Rectangle2D;

public abstract class FoldedMos {
    private static final GateSpace useMinSp = new GateSpace(){

        public double getExtraSpace(double requiredExtraSpace, int foldNdx, int nbFolds, int spaceNdx, int nbGates) {
            return requiredExtraSpace;
        }
    };
    private PortInst[] diffVias;
    private Tech.MosInst[] moss;
    private PortInst[] internalDiffs;
    private double difContWid;
    private double gateWidth;
    private double physWidth;
    private double mosY;

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    private boolean isPmos() {
        return this instanceof FoldedPmos;
    }

    private void newDiffArc(ArcProto diff, double y, PortInst p1, PortInst p2) {
        double x1 = Tech.roundToGrid(LayoutLib.roundCenterX(p1));
        double x2 = Tech.roundToGrid(LayoutLib.roundCenterX(p2));
        NodeInst ni1 = p1.getNodeInst();
        NodeInst ni2 = p2.getNodeInst();
        Poly poly1 = ni1.getShapeOfPort(p1.getPortProto());
        Poly poly2 = ni2.getShapeOfPort(p2.getPortProto());
        if (!poly1.contains(x1, y) || !poly2.contains(x2, y)) {
            LayoutLib.newArcInst(diff, Double.POSITIVE_INFINITY, p1, p2);
        } else {
            LayoutLib.newArcInst(diff, Double.POSITIVE_INFINITY, p1, x1, y, p2, x2, y);
        }
    }

    FoldedMos(char type, double x, double y, int nbFolds, int nbSeries, double gateWidth, GateSpace gateSpace, char justifyDiffCont, Cell f, StdCellParams stdCell) {
        FoldedMos.error(type != 'P' && type != 'N', "FoldedMos: type must be 'P' or 'N': " + type);
        this.gateWidth = gateWidth;
        this.physWidth = Math.max(stdCell.getMinDifContWid(), gateWidth);
        this.diffVias = new PortInst[nbFolds + 1];
        this.moss = new Tech.MosInst[nbFolds * nbSeries];
        this.internalDiffs = new PortInst[nbFolds * (nbSeries - 1)];
        if (gateSpace == null) {
            gateSpace = useMinSp;
        }
        PrimitiveNode diffCont = this.isPmos() ? Tech.pdm1 : Tech.ndm1;
        PrimitiveArc diff = this.isPmos() ? Tech.pdiff : Tech.ndiff;
        PrimitiveNode difNod = this.isPmos() ? Tech.pdNode : Tech.ndNode;
        double foldPitch = 8 + (nbSeries - 1) * 5;
        int diffNdx = 0;
        int mosNdx = 0;
        int internalDiffNdx = 0;
        double difConIncr = stdCell.getDifConIncr();
        this.difContWid = Math.max(stdCell.getMinDifContWid(), (double)((int)(gateWidth / difConIncr)) * difConIncr);
        double difContSlop = Math.max(0.0, (gateWidth - this.difContWid) / 2.0);
        double difContY = y;
        switch (justifyDiffCont) {
            case 'T': {
                difContY += difContSlop;
                break;
            }
            case 'B': {
                difContY -= difContSlop;
                break;
            }
            default: {
                FoldedMos.error(true, "FoldedMos: justifyDiffCont must be 'T', or 'B'");
            }
        }
        this.mosY = y;
        if (gateWidth < stdCell.getMinDifContWid()) {
            double mosBotY = y - gateWidth / 2.0;
            double misAlign = Math.IEEEremainder(mosBotY, 0.5);
            this.mosY -= misAlign;
        }
        double extraDiffPolySpace = gateWidth >= stdCell.getMinDifContWid() ? 0.0 : 0.5;
        double viaToMosPitch = stdCell.getViaToMosPitch();
        double mosToMosPitch = stdCell.getMosToMosPitch();
        PortInst prevPort = null;
        int i = 0;
        while (true) {
            PortInst newPort = LayoutLib.newNodeInst(diffCont, x, difContY, Double.POSITIVE_INFINITY, this.difContWid, 0.0, f).getOnlyPortInst();
            LayoutLib.newArcInst(diff, stdCell.getDifWidHint(), newPort, newPort);
            this.diffVias[diffNdx++] = newPort;
            if (prevPort != null) {
                this.newDiffArc(diff, difContY, prevPort, newPort);
            }
            prevPort = newPort;
            if (i >= nbFolds) break;
            for (int j = 0; j < nbSeries; ++j) {
                double extraSp = gateSpace.getExtraSpace(j == 0 ? extraDiffPolySpace : 0.0, i, nbFolds, j, nbSeries);
                if (j == 0 && extraSp != 0.0) {
                    double w = Math.ceil(extraSp);
                    NodeInst dn = LayoutLib.newNodeInst(difNod, x + w / 2.0, this.mosY, w, gateWidth, 0.0, f);
                    this.newDiffArc(diff, difContY, prevPort, dn.getOnlyPortInst());
                }
                Tech.MosInst m = this.isPmos() ? Tech.newPmosInst(x, this.mosY, gateWidth, 2.0, f) : Tech.newNmosInst(x += (j == 0 ? viaToMosPitch : mosToMosPitch) + extraSp, this.mosY, gateWidth, 2.0, f);
                this.moss[mosNdx++] = m;
                this.newDiffArc(diff, difContY, prevPort, m.leftDiff());
                prevPort = m.rightDiff();
                if (j == 0) continue;
                this.internalDiffs[internalDiffNdx++] = m.leftDiff();
            }
            double extraSp = gateSpace.getExtraSpace(extraDiffPolySpace, i, nbFolds, nbSeries, nbSeries);
            x += viaToMosPitch + extraSp;
            if (extraSp != 0.0) {
                double w = Math.ceil(extraSp);
                NodeInst dn = LayoutLib.newNodeInst(difNod, x - w / 2.0, this.mosY, w, gateWidth, 0.0, f);
                this.newDiffArc(diff, difContY, prevPort, dn.getOnlyPortInst());
            }
            ++i;
        }
    }

    public double getGateWidth() {
        return this.gateWidth;
    }

    public double getPhysWidth() {
        return this.physWidth;
    }

    public double getMosCenterY() {
        return this.mosY;
    }

    public double getDiffContWidth() {
        return this.difContWid;
    }

    public int nbSrcDrns() {
        return this.diffVias.length;
    }

    public PortInst getSrcDrn(int col) {
        return this.diffVias[col];
    }

    public int nbGates() {
        return this.moss.length;
    }

    public PortInst getGate(int mosNdx, char pos) {
        FoldedMos.error(pos != 'T' && pos != 'B', "pos must be 'T' or 'B': " + pos);
        return pos == 'T' ? this.moss[mosNdx].topPoly() : this.moss[mosNdx].botPoly();
    }

    public int nbInternalSrcDrns() {
        return this.internalDiffs.length;
    }

    public PortInst getInternalSrcDrn(int col) {
        return this.internalDiffs[col];
    }

    public Rectangle2D getSelectExtents(StdCellParams stdCell) {
        return null;
    }

    public static interface GateSpace {
        public double getExtraSpace(double var1, int var3, int var4, int var5, int var6);
    }
}

