/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.tool.user.dialogs.EditKeyBinding;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.tool.user.menus.MenuBar;
import com.sun.electric.tool.user.ui.KeyBindings;
import com.sun.electric.tool.user.ui.KeyStrokePair;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EtchedBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class EditKeyBindings
extends PreferencePanel
implements TreeSelectionListener {
    MenuBar menuBar;
    private JButton add;
    private JList bindingsJList;
    private JTree commandsTree;
    private JPanel editKeyBindingsPanel;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JButton remove;
    private JButton reset;
    private JButton resetitem;

    public EditKeyBindings(MenuBar menuBar, Frame parent, boolean modal) {
        super(parent, modal);
        this.menuBar = menuBar;
        this.initComponents();
        this.buildCommandsTree();
    }

    public JPanel getPanel() {
        return this.editKeyBindingsPanel;
    }

    public String getName() {
        return "Key Bindings";
    }

    private void initComponents() {
        this.editKeyBindingsPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.commandsTree = new JTree();
        this.jPanel2 = new JPanel();
        this.add = new JButton();
        this.remove = new JButton();
        this.resetitem = new JButton();
        this.jPanel4 = new JPanel();
        this.jLabel1 = new JLabel();
        this.bindingsJList = new JList();
        this.jPanel3 = new JPanel();
        this.reset = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Edit Key Bindings");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                EditKeyBindings.this.exitForm(evt);
            }
        });
        this.editKeyBindingsPanel.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridLayout(1, 0));
        this.jPanel1.setPreferredSize(new Dimension(350, 363));
        this.jScrollPane1.setViewportView(this.commandsTree);
        this.jPanel1.add(this.jScrollPane1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.editKeyBindingsPanel.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(new EtchedBorder());
        this.add.setText("Add");
        this.add.setToolTipText("add a shortcut");
        this.add.setPreferredSize(new Dimension(68, 28));
        this.add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditKeyBindings.this.addActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel2.add((Component)this.add, gridBagConstraints);
        this.remove.setText("Remove");
        this.remove.setToolTipText("remove a shortcut");
        this.remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditKeyBindings.this.removeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel2.add((Component)this.remove, gridBagConstraints);
        this.resetitem.setText("Reset");
        this.resetitem.setToolTipText("reset to default setting");
        this.resetitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditKeyBindings.this.resetitemActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel2.add((Component)this.resetitem, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabel1.setText("Shortcuts:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel4.add((Component)this.jLabel1, gridBagConstraints);
        this.bindingsJList.setBorder(new EtchedBorder());
        this.bindingsJList.setSelectionMode(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.bindingsJList, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.editKeyBindingsPanel.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.reset.setText("Reset All to Defaults");
        this.reset.setToolTipText("reset all to default settings");
        this.reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditKeyBindings.this.resetActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 0, 8);
        this.jPanel3.add((Component)this.reset, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.editKeyBindingsPanel.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.editKeyBindingsPanel, gridBagConstraints);
        this.pack();
    }

    private void resetitemActionPerformed(ActionEvent evt) {
        JMenuItem item = this.getSelectedMenuItem();
        if (item == null) {
            return;
        }
        this.menuBar.resetKeyBindings(item);
        DefaultTreeModel model = (DefaultTreeModel)this.commandsTree.getModel();
        model.reload(this.getSelectedTreeNode());
        this.updateListBox(item);
    }

    private void removeActionPerformed(ActionEvent evt) {
        JMenuItem item = this.getSelectedMenuItem();
        if (item == null) {
            JOptionPane.showMessageDialog(this, "Please select a menu item first", "Error", 0);
            return;
        }
        KeyStrokePair pair = this.getListBoxSelected();
        if (pair == null) {
            JOptionPane.showMessageDialog(this, "Please select the shortcut from the list to remove", "Error", 0);
            return;
        }
        this.menuBar.removeKeyBinding(((MenuBar.MenuItemInterface)((Object)item)).getDescription(), pair);
        DefaultTreeModel model = (DefaultTreeModel)this.commandsTree.getModel();
        model.reload(this.getSelectedTreeNode());
        this.updateListBox(item);
    }

    private void resetActionPerformed(ActionEvent evt) {
        if (!this.confirmResetAll()) {
            return;
        }
        this.menuBar.resetAllKeyBindings();
        DefaultTreeModel model = (DefaultTreeModel)this.commandsTree.getModel();
        model.reload();
        JMenuItem item = this.getSelectedMenuItem();
        this.updateListBox(item);
    }

    private void addActionPerformed(ActionEvent evt) {
        JMenuItem item = this.getSelectedMenuItem();
        if (item == null) {
            return;
        }
        EditKeyBinding dialog = new EditKeyBinding(item, this.menuBar, TopLevel.getCurrentJFrame(), true);
        dialog.setVisible(true);
        DefaultTreeModel model = (DefaultTreeModel)this.commandsTree.getModel();
        model.reload(this.getSelectedTreeNode());
        this.updateListBox(item);
    }

    private void exitForm(WindowEvent evt) {
    }

    private void buildCommandsTree() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        for (int i = 0; i < this.menuBar.getMenuCount(); ++i) {
            MenuBar.Menu menu = (MenuBar.Menu)this.menuBar.getMenu(i);
            DefaultMutableTreeNode menuNode = new DefaultMutableTreeNode(new KeyBoundTreeNode(menu));
            rootNode.add(menuNode);
            this.addMenu(menuNode, menu);
        }
        this.commandsTree.setModel(new DefaultTreeModel(rootNode));
        this.commandsTree.getSelectionModel().setSelectionMode(1);
        this.commandsTree.setRootVisible(false);
        this.commandsTree.setShowsRootHandles(true);
        this.commandsTree.setToggleClickCount(3);
        this.commandsTree.addTreeSelectionListener(this);
    }

    private void addMenu(DefaultMutableTreeNode parentNode, MenuBar.Menu menu) {
        for (int i = 0; i < menu.getItemCount(); ++i) {
            JMenuItem menuItem = menu.getItem(i);
            DefaultMutableTreeNode menuItemNode = new DefaultMutableTreeNode(new KeyBoundTreeNode(menuItem));
            parentNode.add(menuItemNode);
            if (!(menuItem instanceof JMenu)) continue;
            this.addMenu(menuItemNode, (MenuBar.Menu)menuItem);
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        TreePath path = e.getPath();
        if (path == null) {
            return;
        }
        Object obj = path.getLastPathComponent();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
        Object n = node.getUserObject();
        if (!(n instanceof KeyBoundTreeNode)) {
            return;
        }
        KeyBoundTreeNode treeNode = (KeyBoundTreeNode)n;
        this.updateListBox(treeNode.getMenuItem());
    }

    private void updateListBox(JMenuItem item) {
        if (item == null) {
            this.bindingsJList.setListData(new Object[0]);
            return;
        }
        KeyBindings bindings = this.menuBar.getKeyBindings(item);
        if (bindings == null) {
            this.bindingsJList.setListData(new Object[0]);
            return;
        }
        ArrayList<KeyStrokePair> list = new ArrayList<KeyStrokePair>();
        Iterator it = bindings.getKeyStrokePairs();
        while (it.hasNext()) {
            KeyStrokePair pair = (KeyStrokePair)it.next();
            list.add(pair);
        }
        this.bindingsJList.setListData(list.toArray());
    }

    private KeyStrokePair getListBoxSelected() {
        Object value = this.bindingsJList.getSelectedValue();
        if (value == null) {
            return null;
        }
        return (KeyStrokePair)value;
    }

    private boolean confirmResetAll() {
        Object[] options = new Object[]{"Reset All", "Do Nothing"};
        int n = JOptionPane.showOptionDialog(this, "This will delete ***ALL*** your user key bindings.\n  Are you really sure you want to do that??", "You sure about that?", -1, 2, null, options, options[1]);
        return n == 0;
    }

    private JMenuItem getSelectedMenuItem() {
        DefaultMutableTreeNode node = this.getSelectedTreeNode();
        if (node == null) {
            return null;
        }
        Object obj = node.getUserObject();
        if (!(obj instanceof KeyBoundTreeNode)) {
            return null;
        }
        KeyBoundTreeNode treeNode = (KeyBoundTreeNode)obj;
        JMenuItem item = treeNode.getMenuItem();
        return item;
    }

    private DefaultMutableTreeNode getSelectedTreeNode() {
        TreePath path = this.commandsTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        return node;
    }

    private class KeyBoundTreeNode {
        private JMenuItem menuItem;

        KeyBoundTreeNode(JMenuItem menuItem) {
            this.menuItem = menuItem;
        }

        public JMenuItem getMenuItem() {
            return this.menuItem;
        }

        public String toString() {
            if (this.menuItem != null) {
                StringBuffer buf = new StringBuffer(((MenuBar.MenuItemInterface)((Object)this.menuItem)).getDescription());
                KeyBindings bindings = EditKeyBindings.this.menuBar.getKeyBindings(this.menuItem);
                if (bindings == null) {
                    return buf.toString();
                }
                Iterator it = bindings.getKeyStrokePairs();
                if (!it.hasNext()) {
                    return buf.toString();
                }
                buf.append("   [ " + bindings.bindingsToString() + " ]");
                return buf.toString();
            }
            return "---------------";
        }
    }
}

