/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.menus.MenuBar;
import com.sun.electric.tool.user.ui.ElectricPrinter;
import com.sun.electric.tool.user.ui.ExplorerTree;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.tree.DefaultMutableTreeNode;

public class TextWindow
implements WindowContent {
    private Cell cell;
    private WindowFrame wf;
    private JPanel overall;
    private boolean dirty;
    private boolean finishing;
    private JTextArea textArea;
    private JScrollPane scrollPane;
    private String searchString = null;
    private boolean searchCaseSensitive = false;

    public TextWindow(Cell cell, WindowFrame wf) {
        this.wf = wf;
        this.finishing = false;
        this.textArea = new JTextArea();
        this.scrollPane = new JScrollPane(this.textArea);
        this.overall = new JPanel();
        this.overall.setLayout(new BorderLayout());
        this.overall.add((Component)this.scrollPane, "Center");
        this.setCell(cell, VarContext.globalContext);
        TextWindowDocumentListener twDocumentListener = new TextWindowDocumentListener(this);
        this.textArea.getDocument().addDocumentListener(twDocumentListener);
        this.textArea.addFocusListener(twDocumentListener);
    }

    public void paint(Graphics g) {
        if (this.cell != null && this.cell == WindowFrame.getCurrentCell()) {
            this.textArea.requestFocus();
        }
        this.textArea.paint(g);
    }

    private void textWindowContentChanged() {
        if (this.cell != null) {
            this.cell.getLibrary().setChangedMajor();
        }
        this.dirty = true;
    }

    public void loadExplorerTree(DefaultMutableTreeNode rootNode) {
        this.wf.libraryExplorerNode = ExplorerTree.makeLibraryTree();
        this.wf.jobExplorerNode = Job.getExplorerTree();
        this.wf.errorExplorerNode = ErrorLogger.getExplorerTree();
        this.wf.signalExplorerNode = null;
        rootNode.add(this.wf.libraryExplorerNode);
        rootNode.add(this.wf.jobExplorerNode);
        rootNode.add(this.wf.errorExplorerNode);
    }

    public JPanel getPanel() {
        return this.overall;
    }

    public void finished() {
        if (this.dirty) {
            this.finishing = true;
            SaveCellText saveCellText = new SaveCellText(this);
        }
    }

    public static void saveAllTextWindows() {
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof TextWindow)) continue;
            TextWindow tw = (TextWindow)content;
            if (!tw.dirty) continue;
            Cell cell = tw.getCell();
            String[] strings = tw.convertToStrings();
            cell.setTextViewContents(strings);
            tw.dirty = false;
        }
    }

    public void setWindowTitle() {
        if (this.wf == null) {
            return;
        }
        this.wf.setTitle(this.wf.composeTitle(this.cell, "", 0));
    }

    public Cell getCell() {
        return this.cell;
    }

    public Highlighter getHighlighter() {
        return null;
    }

    public void setCell(Cell cell, VarContext context) {
        String oneLine;
        this.cell = cell;
        String[] lines = cell != null ? cell.getTextViewContents() : null;
        oneLine = lines != null ? (oneLine = TextWindow.makeOneString(lines)) : "";
        this.textArea.setText(oneLine);
        this.textArea.setSelectionStart(0);
        this.textArea.setSelectionEnd(0);
        this.dirty = false;
        this.setWindowTitle();
    }

    public static void readTextCell() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        WindowContent content = wf.getContent();
        if (content instanceof TextWindow) {
            TextWindow tw = (TextWindow)content;
            String fileName = OpenFile.chooseInputFile(FileType.TEXT, null);
            tw.readTextCell(fileName);
        }
    }

    public void readTextCell(String fileName) {
        if (fileName == null) {
            System.out.println("Bad file name: " + fileName);
        }
        URL fileURL = TextUtils.makeURLToFile(fileName);
        InputStream stream = TextUtils.getURLStream(fileURL);
        URLConnection urlCon = null;
        try {
            urlCon = fileURL.openConnection();
        }
        catch (IOException e) {
            System.out.println("Could not find file: " + fileURL.getFile());
            return;
        }
        this.textArea.setText("");
        int READ_BUFFER_SIZE = 65536;
        char[] buf = new char[65536];
        BufferedInputStream bufStrm = new BufferedInputStream(stream, 65536);
        InputStreamReader is = new InputStreamReader(stream);
        try {
            int amtRead;
            while ((amtRead = is.read(buf, 0, 65536)) > 0) {
                String addString = new String(buf, 0, amtRead);
                this.textArea.append(addString);
            }
            stream.close();
        }
        catch (IOException e) {
            System.out.println("Error reading the file");
        }
    }

    public static void writeTextCell() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        WindowContent content = wf.getContent();
        if (content instanceof TextWindow) {
            TextWindow tw = (TextWindow)content;
            String fileName = OpenFile.chooseOutputFile(FileType.TEXT, "Text file", content.getCell().getName() + ".txt");
            tw.writeTextCell(fileName);
        }
    }

    public void writeTextCell(String fileName) {
        if (fileName == null) {
            System.out.println("Bad filename: " + fileName);
        }
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            Document doc = this.textArea.getDocument();
            Element paragraph = doc.getDefaultRootElement();
            int lines = paragraph.getElementCount();
            for (int i = 0; i < lines; ++i) {
                Element e = paragraph.getElement(i);
                int startPos = e.getStartOffset();
                int endPos = e.getEndOffset();
                try {
                    String line = this.textArea.getText(startPos, endPos - startPos);
                    printWriter.print(line);
                    continue;
                }
                catch (BadLocationException ex) {
                    // empty catch block
                }
            }
            printWriter.close();
        }
        catch (IOException e) {
            System.out.println("Error saving " + fileName);
            return;
        }
        System.out.println("Wrote " + fileName);
    }

    public void goToLineNumber(int lineNumber) {
        Document doc = this.textArea.getDocument();
        Element paragraph = doc.getDefaultRootElement();
        int lines = paragraph.getElementCount();
        if (lineNumber <= 0 || lineNumber > lines) {
            System.out.println("Line numbers must be between 1 and " + lines);
            return;
        }
        Element e = paragraph.getElement(lineNumber - 1);
        int startPos = e.getStartOffset();
        int endPos = e.getEndOffset();
        this.textArea.setSelectionStart(startPos);
        this.textArea.setSelectionEnd(endPos);
    }

    public static String[] getEditedText(Cell cell) {
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof TextWindow) || content.getCell() != cell) continue;
            TextWindow tw = (TextWindow)content;
            if (!tw.dirty) continue;
            String[] strings = tw.convertToStrings();
            return strings;
        }
        return null;
    }

    private void updateText(String[] strings) {
        this.textArea.setText(TextWindow.makeOneString(strings));
        this.dirty = false;
    }

    public static void updateText(Cell cell, String[] strings) {
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof TextWindow) || content.getCell() != cell) continue;
            TextWindow tw = (TextWindow)content;
            if (tw.finishing) continue;
            tw.updateText(strings);
        }
    }

    private static String makeOneString(String[] strings) {
        StringBuffer sb = new StringBuffer();
        int len = strings.length;
        for (int i = 0; i < len; ++i) {
            sb.append(strings[i]);
            sb.append("\n");
        }
        return sb.toString();
    }

    private String[] convertToStrings() {
        Document doc = this.textArea.getDocument();
        Element paragraph = doc.getDefaultRootElement();
        int lines = paragraph.getElementCount();
        String[] strings = new String[lines];
        for (int i = 0; i < lines; ++i) {
            Element e = paragraph.getElement(i);
            int startPos = e.getStartOffset();
            int endPos = e.getEndOffset();
            try {
                strings[i] = this.textArea.getText(startPos, endPos - startPos - 1);
                continue;
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
        }
        return strings;
    }

    public void rightScrollChanged(int value) {
    }

    public void bottomScrollChanged(int value) {
    }

    public void repaint() {
    }

    public void fullRepaint() {
    }

    public boolean cellHistoryCanGoBack() {
        return false;
    }

    public boolean cellHistoryCanGoForward() {
        return false;
    }

    public void cellHistoryGoBack() {
    }

    public void cellHistoryGoForward() {
    }

    public void fillScreen() {
    }

    public void zoomOutContents() {
    }

    public void zoomInContents() {
    }

    public void focusOnHighlighted() {
    }

    public void fireCellHistoryStatus() {
    }

    public void initTextSearch(String search, boolean caseSensitive, boolean regExp, Set whatToSearch) {
        if (regExp) {
            System.out.println("Text windows don't yet implement Regular Expression matching");
        }
        this.searchString = search;
        this.searchCaseSensitive = caseSensitive;
    }

    public boolean findNextText(boolean reverse) {
        Document doc = this.textArea.getDocument();
        Element paragraph = doc.getDefaultRootElement();
        int lines = paragraph.getElementCount();
        int lineNo = 0;
        int searchPoint = this.textArea.getSelectionEnd();
        if (reverse) {
            searchPoint = this.textArea.getSelectionStart();
        }
        try {
            lineNo = this.textArea.getLineOfOffset(searchPoint);
        }
        catch (BadLocationException e) {
            return false;
        }
        for (int i = 0; i <= lines; ++i) {
            int index = lineNo + i;
            if (reverse) {
                index = lineNo - i + lines;
            }
            Element e = paragraph.getElement(index % lines);
            int startPos = e.getStartOffset();
            int endPos = e.getEndOffset();
            if (i == 0) {
                if (reverse) {
                    endPos = searchPoint + 1;
                } else {
                    startPos = searchPoint;
                }
            }
            String theLine = null;
            try {
                theLine = this.textArea.getText(startPos, endPos - startPos - 1);
            }
            catch (BadLocationException ex) {
                return false;
            }
            int foundPos = TextUtils.findStringInString(theLine, this.searchString, 0, this.searchCaseSensitive, reverse);
            if (foundPos < 0) continue;
            this.textArea.setSelectionStart(startPos + foundPos);
            this.textArea.setSelectionEnd(startPos + foundPos + this.searchString.length());
            return true;
        }
        return false;
    }

    public void replaceText(String replace) {
        int startSelection = this.textArea.getSelectionStart();
        int endSelection = this.textArea.getSelectionEnd();
        this.textArea.replaceRange(replace, startSelection, endSelection);
    }

    public void replaceAllText(String replace) {
        Document doc = this.textArea.getDocument();
        Element paragraph = doc.getDefaultRootElement();
        int lines = paragraph.getElementCount();
        for (int i = 0; i < lines; ++i) {
            int foundPos;
            Element e = paragraph.getElement(i);
            int startPos = e.getStartOffset();
            int endPos = e.getEndOffset() - 1;
            String theLine = null;
            try {
                theLine = this.textArea.getText(startPos, endPos - startPos);
            }
            catch (BadLocationException ex) {
                return;
            }
            boolean found = false;
            int scanPos = 0;
            while ((foundPos = TextUtils.findStringInString(theLine, this.searchString, scanPos, this.searchCaseSensitive, false)) >= 0) {
                theLine = theLine.substring(0, foundPos) + replace + theLine.substring(foundPos + this.searchString.length());
                scanPos = foundPos + replace.length();
                found = true;
            }
            if (!found) continue;
            this.textArea.replaceRange(theLine, startPos, endPos);
        }
    }

    public void writeImage(ElectricPrinter ep, String filePath) {
        System.out.println("TextWindow:writeImage not implemented");
    }

    public BufferedImage getOffScreenImage(ElectricPrinter ep) {
        return null;
    }

    public void panXOrY(int direction, double[] panningAmounts, int ticks) {
    }

    private static class SaveCellText
    extends Job {
        private TextWindow tw;

        private SaveCellText(TextWindow tw) {
            super("Save Cell Text", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.tw = tw;
            this.startJob();
        }

        public boolean doIt() {
            Cell cell = this.tw.getCell();
            if (cell == null) {
                return false;
            }
            cell.setTextViewContents(this.tw.convertToStrings());
            this.tw.dirty = false;
            return true;
        }
    }

    private static class TextWindowDocumentListener
    implements DocumentListener,
    FocusListener {
        TextWindow tw;

        TextWindowDocumentListener(TextWindow tw) {
            this.tw = tw;
        }

        public void changedUpdate(DocumentEvent e) {
            this.tw.textWindowContentChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.tw.textWindowContentChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.tw.textWindowContentChanged();
        }

        public void focusGained(FocusEvent e) {
            TopLevel top = TopLevel.getCurrentJFrame();
            MenuBar mb = top.getTheMenuBar();
            mb.setIgnoreTextEditKeys(true);
        }

        public void focusLost(FocusEvent e) {
            TopLevel top = TopLevel.getCurrentJFrame();
            MenuBar mb = top.getTheMenuBar();
            mb.setIgnoreTextEditKeys(false);
        }
    }
}

