/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.cvspm;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.cvspm.CVS;
import com.sun.electric.tool.user.User;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Edit {
    private static final String hostName;
    private static final String userName;

    public static boolean edit(Cell cell) {
        File file = CVS.getCellFile(cell);
        if (!CVS.isDELIB(cell.getLibrary())) {
            return false;
        }
        if (!CVS.isFileInCVS(CVS.getCellFile(cell))) {
            return false;
        }
        String dir = file.getParent();
        String c = file.getName();
        boolean success = Edit.edit(c, dir);
        return success;
    }

    public static boolean edit(String file, String dir) {
        CVS.runCVSCommand("edit -a none " + file, "Edit", dir, System.out);
        return true;
    }

    public static void listEditorsProject() {
        ArrayList<Library> allLibs = new ArrayList<Library>();
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = it.next();
            if (lib.isHidden() || !lib.isFromDisk()) continue;
            allLibs.add(lib);
        }
        new ListEditorsJob(allLibs, null, true).startJob();
    }

    public static void listEditorsOpenLibraries() {
        ArrayList<Library> allLibs = new ArrayList<Library>();
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = it.next();
            if (lib.isHidden() || !lib.isFromDisk()) continue;
            allLibs.add(lib);
        }
        Edit.listEditors(allLibs, null);
    }

    public static void listEditors(Library lib) {
        ArrayList<Library> libs = new ArrayList<Library>();
        libs.add(lib);
        Edit.listEditors(libs, null);
    }

    public static void listEditors(Cell cell) {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        cells.add(cell);
        Edit.listEditors(null, cells);
    }

    public static void listEditors(List<Library> libs, List<Cell> cells) {
        new ListEditorsJob(libs, cells, false).startJob();
    }

    public static List<Editor> parseOutput(LineNumberReader result) {
        ArrayList<Editor> editors = new ArrayList<Editor>();
        while (true) {
            Editor editor;
            String line;
            try {
                line = result.readLine();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                break;
            }
            if (line == null) break;
            if (line.equals("") || (editor = Editor.parse(line)) == null) continue;
            editors.add(editor);
        }
        return editors;
    }

    static boolean isMe(Editor editor) {
        return editor.getUser().equals(Edit.getUserName()) && editor.getHostname().equals(Edit.getHostName());
    }

    public static final String getHostName() {
        return hostName;
    }

    public static final String getUserName() {
        return userName;
    }

    static {
        String name = "unknownHost";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            name = addr.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        hostName = name;
        userName = System.getProperty("user.name", "unknownUser");
    }

    public static class Editor {
        private final String file;
        private final String user;
        private final Date date;
        private final String hostname;
        private final String dir;
        private final File FD;

        private Editor(String file, String user, Date date, String hostname, String dir) {
            this.file = file;
            this.user = user;
            this.date = date;
            this.hostname = hostname;
            this.dir = dir;
            this.FD = new File(dir, file);
        }

        static Editor parse(String editorResultLine) {
            String[] parts = editorResultLine.split("\\t");
            if (parts.length == 5) {
                Date date;
                String abbreviatedFile = parts[0];
                String user = parts[1];
                DateFormat df = DateFormat.getDateInstance();
                try {
                    date = df.parse(parts[2]);
                }
                catch (ParseException e) {
                    date = new Date(0L);
                }
                String computer = parts[3];
                String dir = parts[4];
                return new Editor(abbreviatedFile, user, date, computer, dir);
            }
            System.out.println("Bad Editor result line format: " + editorResultLine);
            return null;
        }

        public String getAbbrevFile() {
            return this.file;
        }

        public String getUser() {
            return this.user;
        }

        public Date getDate() {
            return this.date;
        }

        public String getHostname() {
            return this.hostname;
        }

        public File getFile() {
            return this.FD;
        }

        public String getDir() {
            return this.dir;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListEditorsJob
    extends Job {
        private List<Library> libs;
        private List<Cell> cells;
        private boolean forProject;

        public ListEditorsJob(List<Library> libs, List<Cell> cells, boolean forProject) {
            super("List CVS Editors", User.getUserTool(), Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.libs = libs;
            this.cells = cells;
            this.forProject = forProject;
            if (this.libs == null) {
                this.libs = new ArrayList<Library>();
            }
            if (this.cells == null) {
                this.cells = new ArrayList<Cell>();
            }
        }

        @Override
        public boolean doIt() {
            String useDir = CVS.getUseDir(this.libs, this.cells);
            StringBuffer libsBuf = CVS.getLibraryFiles(this.libs, useDir);
            StringBuffer cellsBuf = CVS.getCellFiles(this.cells, useDir);
            String args = libsBuf + " " + cellsBuf;
            if (args.trim().equals("")) {
                return true;
            }
            if (this.forProject) {
                args = "";
            }
            CVS.runCVSCommand("editors " + args, "List CVS Editors", useDir, System.out);
            System.out.println("List CVS Editors complete.");
            return true;
        }
    }
}

