/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellId;
import com.sun.electric.database.CellUsage;
import com.sun.electric.database.ExportId;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.ImmutablePortInst;
import com.sun.electric.database.prototype.PortProtoId;
import com.sun.electric.database.text.ImmutableArrayList;
import com.sun.electric.technology.PrimitivePort;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;

class UsageCollector {
    static final BitSet EMPTY_BITSET = new BitSet();
    private HashMap<CellId, CellUsageInfoBuilder> cellIndices = new HashMap(16, 0.5f);

    UsageCollector(ImmutableCell d, ImmutableArrayList<ImmutableNodeInst> nodes, ImmutableArrayList<ImmutableArcInst> arcs, ImmutableArrayList<ImmutableExport> exports) {
        for (int nodeIndex = 0; nodeIndex < nodes.size(); ++nodeIndex) {
            ImmutableNodeInst n = (ImmutableNodeInst)nodes.get(nodeIndex);
            if (n.protoId instanceof CellId) {
                this.add((CellId)n.protoId, true);
            }
            for (int chronIndex = 0; chronIndex < n.ports.length; ++chronIndex) {
                ImmutablePortInst pi = n.ports[chronIndex];
                if (pi == ImmutablePortInst.EMPTY) continue;
                PortProtoId pp = n.protoId.getPortId(chronIndex);
                this.add(pp);
            }
        }
        for (int arcIndex = 0; arcIndex < arcs.size(); ++arcIndex) {
            ImmutableArcInst a = (ImmutableArcInst)arcs.get(arcIndex);
            this.add(a.tailPortId);
            this.add(a.headPortId);
        }
        for (int portIndex = 0; portIndex < exports.size(); ++portIndex) {
            ImmutableExport e = (ImmutableExport)exports.get(portIndex);
            this.add(e.originalPortId);
        }
    }

    private void add(PortProtoId portId) {
        if (portId instanceof PrimitivePort) {
            return;
        }
        ExportId eId = (ExportId)portId;
        this.add(eId.parentId, false).set(eId.chronIndex);
    }

    private BitSet add(CellId cellId, boolean isInstance) {
        CellUsageInfoBuilder cellCount = this.cellIndices.get(cellId);
        if (cellCount == null) {
            cellCount = new CellUsageInfoBuilder();
            this.cellIndices.put(cellId, cellCount);
        }
        if (isInstance) {
            ++cellCount.instCount;
        }
        return cellCount.usedExports;
    }

    CellBackup.CellUsageInfo[] getCellUsages(CellId parentId, CellBackup.CellUsageInfo[] oldCellUsages) {
        if (this.cellIndices.isEmpty()) {
            return CellBackup.NULL_CELL_USAGE_INFO_ARRAY;
        }
        int length = 0;
        for (CellId cellId : this.cellIndices.keySet()) {
            length = Math.max(length, parentId.getUsageIn((CellId)cellId).indexInParent + 1);
        }
        Object[] newCellUsages = new CellBackup.CellUsageInfo[length];
        for (CellId cellId : this.cellIndices.keySet()) {
            CellUsage u = parentId.getUsageIn(cellId);
            int indexInParent = u.indexInParent;
            CellBackup.CellUsageInfo newC = null;
            CellUsageInfoBuilder cellCount = this.cellIndices.get(cellId);
            if (cellCount != null) {
                CellBackup.CellUsageInfo oldC = indexInParent < oldCellUsages.length ? oldCellUsages[indexInParent] : null;
                newC = oldC != null ? oldC.with(cellCount.instCount, cellCount.usedExports) : new CellBackup.CellUsageInfo(cellCount.instCount, cellCount.usedExports);
            }
            newCellUsages[indexInParent] = newC;
        }
        return Arrays.equals(newCellUsages, oldCellUsages) ? oldCellUsages : newCellUsages;
    }

    static BitSet bitSetWith(BitSet oldBitSet, BitSet newBitSet) {
        if (newBitSet.isEmpty()) {
            return EMPTY_BITSET;
        }
        return newBitSet.equals(oldBitSet) ? oldBitSet : newBitSet;
    }

    private static class CellUsageInfoBuilder {
        int instCount;
        BitSet usedExports = new BitSet();

        private CellUsageInfoBuilder() {
        }
    }
}

